/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cpmm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.cpmm.BillTypeEnum;
import com.kingdee.eas.cp.cpmm.CharacterEnum;
import com.kingdee.eas.cp.cpmm.IInventoryChangeBill;
import com.kingdee.eas.cp.cpmm.IItemDetail;
import com.kingdee.eas.cp.cpmm.IMaterialsPurchasingBill;
import com.kingdee.eas.cp.cpmm.IMaterialsRecord;
import com.kingdee.eas.cp.cpmm.IWarehousingBill;
import com.kingdee.eas.cp.cpmm.InOutTypeInfo;
import com.kingdee.eas.cp.cpmm.InventoryChangeBillFactory;
import com.kingdee.eas.cp.cpmm.ItemDetailCollection;
import com.kingdee.eas.cp.cpmm.ItemDetailFactory;
import com.kingdee.eas.cp.cpmm.ItemDetailInfo;
import com.kingdee.eas.cp.cpmm.ItemStateEnum;
import com.kingdee.eas.cp.cpmm.MMBillStateEnum;
import com.kingdee.eas.cp.cpmm.MaterialsPurchasingBillFactory;
import com.kingdee.eas.cp.cpmm.MaterialsRecordFactory;
import com.kingdee.eas.cp.cpmm.MaterialsRecordInfo;
import com.kingdee.eas.cp.cpmm.WarehousingBillEntryCollection;
import com.kingdee.eas.cp.cpmm.WarehousingBillEntryInfo;
import com.kingdee.eas.cp.cpmm.WarehousingBillFactory;
import com.kingdee.eas.cp.cpmm.WarehousingBillInfo;
import com.kingdee.eas.cp.cpmm.app.AbstractWarehousingBillControllerBean;
import com.kingdee.eas.cp.cpmm.app.ArticlePoolHelper;
import com.kingdee.eas.cp.cpmm.app.BillPoolHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class WarehousingBillControllerBean
extends AbstractWarehousingBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.cpmm.app.WarehousingBillControllerBean");
    IWarehousingBill service = null;
    IMaterialsRecord mService = null;
    IItemDetail itemService = null;
    IMaterialsPurchasingBill pService = null;
    IInventoryChangeBill changeService = null;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this.isEixtRule(ctx, model)) {
            this.setNumberFromCodingRule(ctx, model);
            this._checkNumberBlank(ctx, model);
        }
        this.pService = MaterialsPurchasingBillFactory.getLocalInstance(ctx);
        this.changeService = InventoryChangeBillFactory.getLocalInstance(ctx);
        WarehousingBillInfo wbInfo = this.initNewModel(ctx, model);
        String sourceBillId = wbInfo.getSourceBillId();
        boolean isReturn = false;
        if (sourceBillId != null && !"".equals(sourceBillId.toString().trim()) && BillTypeEnum.RETURNBACK.equals((Object)wbInfo.getSourceBillType())) {
            isReturn = true;
            wbInfo.setSourceBillId(null);
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)wbInfo);
        BillPoolHelper.addNew(ctx, model, 0);
        if (isReturn) {
            ArticlePoolHelper.upDate(ctx, BOSUuid.read((String)pk.toString()), wbInfo.getNumber(), sourceBillId);
        }
        this.writeBackSourceBill((IObjectValue)wbInfo, 7);
        return pk;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (this.isEixtRule(ctx, model)) {
            this.setNumberFromCodingRule(ctx, model);
            this._checkNumberBlank(ctx, model);
        }
        this.pService = MaterialsPurchasingBillFactory.getLocalInstance(ctx);
        this.changeService = InventoryChangeBillFactory.getLocalInstance(ctx);
        WarehousingBillInfo info = this.initNewModel(ctx, model);
        super._addnew(ctx, pk, (IObjectValue)info);
        BillPoolHelper.addNew(ctx, (IObjectValue)info, 0);
        this.writeBackSourceBill((IObjectValue)info, 7);
    }

    private WarehousingBillInfo initNewModel(Context ctx, IObjectValue model) {
        WarehousingBillInfo info = (WarehousingBillInfo)model;
        if (info.getCompany() == null) {
            CompanyOrgUnitInfo currentCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            info.setCompany(currentCompanyOrgUnitInfo);
        }
        if (info.getAppPerson() == null) {
            PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            info.setAppPerson(person);
        }
        if (info.getAppDate() == null) {
            info.setAppDate(DateTimeUtils.truncateDate((Date)new Date()));
        }
        if (info.getState() == null) {
            info.setState(MMBillStateEnum.TEMPORARY);
        }
        return info;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        BillPoolHelper.update(ctx, model, 0);
        if (BillTypeEnum.RETURNBACK.equals((Object)((WarehousingBillInfo)model).getSourceBillType())) {
            ArticlePoolHelper.upDate(ctx, model);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BillPoolHelper.delete(ctx, pk);
        ArticlePoolHelper.delete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WarehousingBillInfo value = (WarehousingBillInfo)model;
        MMBillStateEnum state = value.getState();
        IObjectPK pk = super._submit(ctx, model);
        BillTypeEnum sourceBillType = value.getSourceBillType();
        if (sourceBillType != null && sourceBillType.equals((Object)BillTypeEnum.INVENTORYCHANGE) && (state.equals((Object)MMBillStateEnum.TEMPORARY) || state.equals((Object)MMBillStateEnum.UNAUDITED))) {
            this.changeService = InventoryChangeBillFactory.getLocalInstance(ctx);
            if (value.getSourceBillId() != null && !value.getSourceBillId().equals("")) {
                BOSUuid sourcebillID = BOSUuid.read((String)value.getSourceBillId());
                this.changeService.setChangeState(sourcebillID, "WAREHOUSINGBILL", 8);
            }
        }
        return pk;
    }

    protected void _setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        BillPoolHelper.updateState(ctx, billID, MMBillStateEnum.AUDITING);
        super._setAuditing(ctx, billID);
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        BillPoolHelper.updateState(ctx, billID, MMBillStateEnum.AUDITED);
        super._setAudited(ctx, billID);
    }

    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        BillPoolHelper.updateState(ctx, billID, MMBillStateEnum.UNAUDITED);
        super._setAuditEnd(ctx, billID);
    }

    protected void _setAbandoned(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        BillPoolHelper.updateState(ctx, billID, MMBillStateEnum.ABANDONED);
        super._setAbandoned(ctx, billID);
    }

    protected void _confirm(Context ctx, BOSUuid billID) throws BOSException {
        try {
            this._setFinished(ctx, billID);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    protected void _setFinished(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.service = WarehousingBillFactory.getLocalInstance(ctx);
        this.pService = MaterialsPurchasingBillFactory.getLocalInstance(ctx);
        this.changeService = InventoryChangeBillFactory.getLocalInstance(ctx);
        this.itemService = ItemDetailFactory.getLocalInstance(ctx);
        this.mService = MaterialsRecordFactory.getLocalInstance(ctx);
        this.updateInvenTories(billID);
        BillPoolHelper.updateState(ctx, billID, MMBillStateEnum.FINISHED);
        ArticlePoolHelper.upDate(ctx, billID);
        super._setFinished(ctx, billID);
    }

    private void updateInvenTories(BOSUuid billID) throws BOSException, EASBizException {
        WarehousingBillInfo model = this.service.getWarehousingBillInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelector());
        InOutTypeInfo inOutType = model.getInOutType();
        CharacterEnum character = inOutType.getCharacter();
        WarehousingBillEntryCollection entries = model.getEntrys();
        CoreBaseCollection itemCol = new CoreBaseCollection();
        CoreBaseCollection materialCol = new CoreBaseCollection();
        if (entries != null) {
            if (character != null && character.equals((Object)CharacterEnum.ADD)) {
                for (int i = 0; i < entries.size(); ++i) {
                    if (entries.get(i).getIsInStorage() == null || !entries.get(i).getIsInStorage().getValue().equals("1")) continue;
                    MaterialsRecordInfo material = entries.get(i).getMaterialsRecord();
                    int maxItemNum = material.getItemMaxNum();
                    CoreBaseCollection cbCol = this.getNewItemCol(maxItemNum, model, entries.get(i));
                    int itemCount = cbCol.size();
                    material.setItemMaxNum(maxItemNum + itemCount);
                    materialCol.add((CoreBaseInfo)this.updateMInfo(material, entries.get(i)));
                    itemCol.addCollection(cbCol);
                }
                this.itemService.addnew(itemCol);
                this.mService.update(materialCol);
            } else if (character != null && character.equals((Object)CharacterEnum.UNCHANG)) {
                for (int i = 0; i < entries.size(); ++i) {
                    if (entries.get(i).getIsInStorage() == null || !entries.get(i).getIsInStorage().getValue().equals("1")) continue;
                    CoreBaseCollection cbCol = this.getUpdateItemCol(model, entries.get(i));
                    materialCol.add((CoreBaseInfo)this.updateMInfo2(entries.get(i)));
                    itemCol.addCollection(cbCol);
                }
                this.itemService.update(itemCol);
                this.mService.update(materialCol);
            }
        }
        this.writeBackSourceBill((IObjectValue)model, 5);
    }

    private CoreBaseCollection getUpdateItemCol(WarehousingBillInfo model, WarehousingBillEntryInfo entryInfo) throws BOSException {
        CoreBaseCollection col = new CoreBaseCollection();
        MaterialsRecordInfo material = entryInfo.getMaterialsRecord();
        ItemDetailCollection itemCol = new ItemDetailCollection();
        String modelType = "";
        if (material.getModelType() != null) {
            modelType = material.getModelType().getValue();
        }
        if (modelType.equals("device") || modelType.equals("books")) {
            int size = entryInfo.getNum();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("materialsRecord.id", (Object)material.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
            view.setFilter(filter);
            itemCol = this.itemService.getItemDetailCollection(view);
            for (int i = 0; i < size; ++i) {
                ItemDetailInfo itemInfo = itemCol.get(i);
                if (itemInfo == null) continue;
                itemInfo.setState(ItemStateEnum.ONHAND);
                col.add((CoreBaseInfo)itemInfo);
            }
        }
        return col;
    }

    private CoreBaseCollection getNewItemCol(int maxItemNum, WarehousingBillInfo billInfo, WarehousingBillEntryInfo entryInfo) {
        CoreBaseCollection col = new CoreBaseCollection();
        MaterialsRecordInfo material = entryInfo.getMaterialsRecord();
        String modelType = "";
        if (material.getModelType() != null) {
            modelType = material.getModelType().getValue();
        }
        if (modelType.equals("device") || modelType.equals("books")) {
            int size = entryInfo.getNum();
            for (int i = 0; i < size; ++i) {
                ItemDetailInfo itemInfo = new ItemDetailInfo();
                itemInfo.setNumber(material.getNumber() + this.getSerialNumByInt(maxItemNum + 1 + i));
                itemInfo.setUnitPrice(entryInfo.getUnitPrice());
                itemInfo.setInStorageDate(billInfo.getInStorageDate());
                itemInfo.setInStoragePerson(billInfo.getInStoragePerson());
                itemInfo.setState(ItemStateEnum.ONHAND);
                itemInfo.setDescription(billInfo.getDescription());
                itemInfo.setMaterialsRecord(material);
                col.add((CoreBaseInfo)itemInfo);
            }
        }
        return col;
    }

    private MaterialsRecordInfo updateMInfo2(WarehousingBillEntryInfo entryInfo) throws EASBizException, BOSException {
        MaterialsRecordInfo material = entryInfo.getMaterialsRecord();
        int oldAvailableAmount = material.getAvailableAmount();
        int num = entryInfo.getNum();
        int newAvailableAmount = oldAvailableAmount + num;
        material.setAvailableAmount(newAvailableAmount);
        return material;
    }

    private MaterialsRecordInfo updateMInfo(MaterialsRecordInfo material, WarehousingBillEntryInfo entryInfo) throws EASBizException, BOSException {
        BigDecimal oldSinglePrice = new BigDecimal(0.0);
        BigDecimal singlePrice = new BigDecimal(0.0);
        int oldAvailableAmount = material.getAvailableAmount();
        int num = entryInfo.getNum();
        int newAvailableAmount = oldAvailableAmount + num;
        material.setAvailableAmount(newAvailableAmount);
        int oldAmount = material.getAmount();
        int newAmount = oldAmount + num;
        BigDecimal newSinglePrice = new BigDecimal(0.0);
        BigDecimal sumPrice = new BigDecimal(0.0);
        BigDecimal sumNum = new BigDecimal(0.0);
        if (entryInfo.getUnitPrice() != null) {
            singlePrice = entryInfo.getUnitPrice();
        }
        if (material.getSinglePrice() != null) {
            oldSinglePrice = material.getSinglePrice();
        }
        sumPrice = singlePrice.multiply(new BigDecimal(num)).add(oldSinglePrice.multiply(new BigDecimal(oldAmount)));
        sumNum = new BigDecimal(num + oldAmount);
        newSinglePrice = sumPrice.divide(sumNum, 2, 5);
        material.setAmount(newAmount);
        material.setSinglePrice(newSinglePrice);
        return material;
    }

    private String getSerialNumByInt(int count) {
        StringBuffer buf = new StringBuffer();
        for (int i = this.getDigits(count); i < 5; ++i) {
            buf.append("0");
        }
        buf.append(count);
        return buf.toString();
    }

    private int getDigits(int count) {
        int dig = 1;
        int temp = count;
        while (temp / 10 > 0) {
            ++dig;
            temp /= 10;
        }
        return dig;
    }

    private void writeBackSourceBill(IObjectValue value, int changeState) throws EASBizException, BOSException {
        WarehousingBillInfo model = (WarehousingBillInfo)value;
        if (model.getSourceBillId() != null && !model.getSourceBillId().equals("")) {
            BOSUuid sourcebillID = BOSUuid.read((String)model.getSourceBillId());
            BillTypeEnum sourceBillType = model.getSourceBillType();
            if (sourceBillType != null && sourceBillType.equals((Object)BillTypeEnum.PURCHASINGBILL)) {
                if (changeState == 5) {
                    this.pService.setFinished(sourcebillID);
                } else {
                    this.pService.setWareHousing(sourcebillID);
                }
            }
            if (sourceBillType != null && sourceBillType.equals((Object)BillTypeEnum.INVENTORYCHANGE)) {
                this.changeService.setChangeState(sourcebillID, "WAREHOUSINGBILL", changeState);
            }
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("warehouse.*"));
        sic.add(new SelectorItemInfo("inOutType.*"));
        sic.add(new SelectorItemInfo("appPerson.*"));
        sic.add(new SelectorItemInfo("inStoragePerson.*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.materialsRecord.*"));
        return sic;
    }

    protected void setNumberFromCodingRule(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WarehousingBillInfo wareHousingInfo = (WarehousingBillInfo)model;
        if (wareHousingInfo.getNumber() == null || "".equals(wareHousingInfo.getNumber())) {
            String orgId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
            String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)wareHousingInfo, orgId);
            if (number != null) {
                wareHousingInfo.setNumber(number);
            }
        }
    }

    protected boolean isEixtRule(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean flag = false;
        String orgId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        WarehousingBillInfo wareHousingInfo = (WarehousingBillInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)wareHousingInfo, orgId)) {
            flag = true;
        }
        return flag;
    }
}

