/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cpmm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.cpmm.IInventoryWarnningSetting;
import com.kingdee.eas.cp.cpmm.IOfficeSupplies;
import com.kingdee.eas.cp.cpmm.IOutboundBillEntry;
import com.kingdee.eas.cp.cpmm.InventoryWarnningSettingCollection;
import com.kingdee.eas.cp.cpmm.InventoryWarnningSettingFactory;
import com.kingdee.eas.cp.cpmm.InventoryWarnningSettingInfo;
import com.kingdee.eas.cp.cpmm.OfficeSuppliesCollection;
import com.kingdee.eas.cp.cpmm.OfficeSuppliesFactory;
import com.kingdee.eas.cp.cpmm.OutboundBillEntryCollection;
import com.kingdee.eas.cp.cpmm.OutboundBillEntryFactory;
import com.kingdee.eas.cp.cpmm.WarehouseManagerCollection;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.SendMessageParamInfo;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.ResourceBase;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class WarnningSettingUtils {
    public static OfficeSuppliesCollection getOfficeSuppliesFromBill(Context ctx, String billId) throws BOSException {
        OfficeSuppliesCollection coll = null;
        if (billId != null) {
            IOutboundBillEntry iobe = OutboundBillEntryFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bill", (Object)billId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("material.modelType", (Object)"supplies", CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo("material.extRecordID"));
            view.setSelector(sic);
            OutboundBillEntryCollection collBillEntry = iobe.getOutboundBillEntryCollection(view);
            if (collBillEntry != null && collBillEntry.size() > 0) {
                HashSet<String> idSet = new HashSet<String>();
                int size = collBillEntry.size();
                for (int i = 0; i < size; ++i) {
                    idSet.add(collBillEntry.get(i).getMaterial().getExtRecordID());
                }
                if (idSet.size() > 0) {
                    IOfficeSupplies ios = OfficeSuppliesFactory.getLocalInstance(ctx);
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("warningValue"));
                    sic.add(new SelectorItemInfo("materialsRecord.id"));
                    sic.add(new SelectorItemInfo("materialsRecord.warehouse.id"));
                    sic.add(new SelectorItemInfo("materialsRecord.warehouse.manager.id"));
                    sic.add(new SelectorItemInfo("materialsRecord.warehouse.manager.person.id"));
                    sic.add(new SelectorItemInfo("materialsRecord.warehouse.manager.person.name"));
                    sic.add(new SelectorItemInfo("materialsRecord.availableAmount"));
                    sic.add(new SelectorItemInfo("materialsRecord.name"));
                    view.setSelector(sic);
                    coll = ios.getOfficeSuppliesCollection(view);
                }
            }
        }
        return coll;
    }

    public static void notice(Context ctx, String billId, String senderName) throws BOSException, SQLException, EASBizException {
        IInventoryWarnningSetting iiws = InventoryWarnningSettingFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("informWay"));
        sic.add(new SelectorItemInfo("returnInformWay"));
        view.setSelector(sic);
        InventoryWarnningSettingInfo settingModel = new InventoryWarnningSettingInfo();
        InventoryWarnningSettingCollection settingColl = iiws.getInventoryWarnningSettingCollection(view);
        if (settingColl != null && settingColl.size() == 1) {
            settingModel = settingColl.get(0);
        }
        String informWay = settingModel.getInformWay();
        WarnningSettingUtils.warnningInformWay(ctx, informWay, billId, senderName);
    }

    private static void warnningInformWay(Context ctx, String informWay, String billId, String senderName) throws BOSException, SQLException, EASBizException {
        if (informWay != null && !informWay.trim().equals("")) {
            char[] informwayArr = informWay.toCharArray();
            if (informwayArr[0] == '1') {
                WarnningSettingUtils.sendSMSToPerson(ctx, billId, senderName);
            }
            if (informwayArr[1] == '1') {
                WarnningSettingUtils.sendMessageToUsers(ctx, billId, senderName);
            }
            if (informwayArr[2] == '1') {
                WarnningSettingUtils.sendMailToPerson(ctx, billId, senderName);
            }
        }
    }

    public static void sendMessage(Context ctx, List idList, String titleStr, String senderName, String bodyStr) {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = WarnningSettingUtils.getContextLocales(ctx);
        Locale locale2 = null;
        String userId = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 20);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", titleStr, locale2);
            message.setLocaleStringHeader("sender", senderName, locale2);
            message.setLocaleStringHeader("body", bodyStr, locale2);
        }
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            userId = (String)idList.get(i);
            message.setStringHeader("receiver", userId);
            senderAgent.sendMessage(message);
        }
    }

    private static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    public static void sendMessageToUsers(Context ctx, String billId, String senderName) throws BOSException {
        OfficeSuppliesCollection coll;
        if (billId != null && (coll = WarnningSettingUtils.getOfficeSuppliesFromBill(ctx, billId)) != null && coll.size() > 0) {
            WarehouseManagerCollection wmcoll = null;
            ArrayList<String> idList = null;
            String materialName = null;
            Integer availableAmount = null;
            Integer warnningValue = null;
            String bodyStr = null;
            String titleStr = null;
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                availableAmount = new Integer(coll.get(i).getMaterialsRecord().getAvailableAmount());
                warnningValue = new Integer(coll.get(i).getWarningValue());
                if (availableAmount > warnningValue) continue;
                materialName = coll.get(i).getMaterialsRecord().getName();
                wmcoll = coll.get(i).getMaterialsRecord().getWarehouse().getManager();
                if (wmcoll == null) continue;
                idList = new ArrayList<String>();
                int size = wmcoll.size();
                for (int k = 0; k < size; ++k) {
                    idList.add(wmcoll.get(k).getPerson().getId().toString());
                }
                Locale locale = SysContext.getSysContext().getLocale();
                titleStr = bodyStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.cp.cpmm.CPMMResource", (String)"IVENTORY_WARNING", (Locale)locale), materialName, availableAmount, warnningValue);
                WarnningSettingUtils.sendMessage(ctx, WarnningSettingUtils.getUserIds(ctx, idList), titleStr, senderName, bodyStr);
            }
        }
    }

    public static void warnningNotcieByBill(Context ctx, String billId, String senderName) throws BOSException, SQLException, EASBizException {
        if (billId != null) {
            WarnningSettingUtils.notice(ctx, billId, senderName);
        }
    }

    public static void sendMailToPerson(Context ctx, String billId, String senderName) throws BOSException, EASBizException {
        OfficeSuppliesCollection coll;
        if (billId != null && (coll = WarnningSettingUtils.getOfficeSuppliesFromBill(ctx, billId)) != null && coll.size() > 0) {
            KDMessageAttachment[] attachment = null;
            String secretReceiver = null;
            String copyReceiver = null;
            String materialName = null;
            Integer availableAmount = null;
            Integer warnningValue = null;
            String content = null;
            String title = null;
            String receiver = null;
            PersonInfo managerInfo = null;
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                WarehouseManagerCollection wmcoll = coll.get(i).getMaterialsRecord().getWarehouse().getManager();
                materialName = coll.get(i).getMaterialsRecord().getName();
                availableAmount = new Integer(coll.get(i).getMaterialsRecord().getAvailableAmount());
                warnningValue = new Integer(coll.get(i).getWarningValue());
                if (availableAmount > warnningValue || wmcoll == null || wmcoll.size() <= 0) continue;
                int size = wmcoll.size();
                for (int k = 0; k < size; ++k) {
                    managerInfo = new PersonInfo();
                    managerInfo = wmcoll.get(k).getPerson();
                    receiver = WarnningSettingUtils.getMailPersonStr(ctx, managerInfo);
                    if (receiver == null || "".equals(receiver.trim())) continue;
                    Locale locale = SysContext.getSysContext().getLocale();
                    title = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.cp.cpmm.CPMMResource", (String)"titleStr", (Locale)locale), materialName);
                    content = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.cp.cpmm.CPMMResource", (String)"IVENTORY_WARNING", (Locale)locale), materialName, availableAmount, warnningValue);
                    WarnningSettingUtils.sendMail(ctx, title, content, receiver, secretReceiver, copyReceiver, attachment);
                }
            }
        }
    }

    public static void sendMail(Context ctx, String title, String content, String receiver, String secretReceiver, String copyReceiver, KDMessageAttachment[] attachment) throws BOSException, EASBizException {
        MsgUtil.msgMailDerect((Context)ctx, (String)title, (String)content, (String)receiver, (String)secretReceiver, (String)copyReceiver, (KDMessageAttachment[])attachment);
    }

    public static void sendSMSToPerson(Context ctx, String billId, String senderName) throws BOSException, EASBizException {
        OfficeSuppliesCollection coll;
        if (billId != null && (coll = WarnningSettingUtils.getOfficeSuppliesFromBill(ctx, billId)) != null && coll.size() > 0) {
            WarehouseManagerCollection wmcoll = null;
            String receiver = null;
            String materialName = null;
            Integer availableAmount = null;
            Integer warnningValue = null;
            String content = null;
            PersonInfo managerInfo = null;
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                wmcoll = coll.get(i).getMaterialsRecord().getWarehouse().getManager();
                materialName = coll.get(i).getMaterialsRecord().getName();
                availableAmount = new Integer(coll.get(i).getMaterialsRecord().getAvailableAmount());
                warnningValue = new Integer(coll.get(i).getWarningValue());
                if (availableAmount > warnningValue || wmcoll == null || wmcoll.size() <= 0) continue;
                int size = wmcoll.size();
                for (int k = 0; k < size; ++k) {
                    managerInfo = new PersonInfo();
                    managerInfo = wmcoll.get(k).getPerson();
                    receiver = WarnningSettingUtils.getCellNumberStr(ctx, managerInfo);
                    if (receiver == null || "".equals(receiver.trim())) continue;
                    Locale locale = SysContext.getSysContext().getLocale();
                    content = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.cp.cpmm.CPMMResource", (String)"IVENTORY_WARNING", (Locale)locale), materialName, availableAmount, warnningValue);
                    WarnningSettingUtils.sendSMS(ctx, content, receiver);
                }
            }
        }
    }

    public static void sendSMS(Context ctx, String content, String receiver) throws EASBizException, BOSException {
        SendMessageParamInfo paramInfo = new SendMessageParamInfo();
        paramInfo.setAppendCompanyName(false);
        paramInfo.setAppendNumber(false);
        paramInfo.setAppendPersonName(false);
        paramInfo.setAppendRevert(false);
        paramInfo.setAppendUserName(false);
        paramInfo.setContent(content);
        paramInfo.setReceiver(receiver);
        paramInfo.setCanback(false);
        IMsgFacade iMsgFacade = MsgFacadeFactory.getLocalInstance((Context)ctx);
        iMsgFacade.sendMsg(paramInfo);
    }

    public static String getMailPersonStr(Context ctx, PersonInfo pInfo) throws BOSException {
        String retStr = "";
        StringBuffer sb = new StringBuffer();
        if (pInfo != null) {
            IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
            evi.setFilter(filter);
            evi.getSelector().add(new SelectorItemInfo("email"));
            PersonCollection pc = ip.getPersonCollection(evi);
            int size = pc.size();
            for (int i = 0; i < size; ++i) {
                String mail = pc.get(i).getEmail();
                if (mail == null || mail.trim().length() == 0) continue;
                sb.append(mail).append(",");
            }
        }
        return (retStr = sb.toString()).length() <= 0 ? retStr : retStr.substring(0, retStr.length() - 1);
    }

    public static String getCellNumberStr(Context ctx, PersonInfo pInfo) throws EASBizException, BOSException {
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("email"));
        evi.getSelector().add(new SelectorItemInfo("cell"));
        PersonCollection pc = ip.getPersonCollection(evi);
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        PersonInfo person = null;
        int size = pc.size();
        for (int i = 0; i < size; ++i) {
            person = pc.get(i);
            if (person.getCell() == null || person.getCell().trim().length() == 0) continue;
            map.put(person.getCell(), person.getCell());
        }
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append(iter.next().toString());
        }
        return sb.toString();
    }

    public static List getUserIds(Context ctx, List pIds) {
        ArrayList<String> uIds = new ArrayList<String>();
        if (pIds != null) {
            HashSet idSet = new HashSet();
            int len = pIds.size();
            for (int i = 0; i < len; ++i) {
                idSet.add(pIds.get(i));
            }
            if (idSet.size() != 0) {
                try {
                    IUser iu = UserFactory.getLocalInstance((Context)ctx);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("person", idSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    view.setSelector(sic);
                    UserCollection coll = iu.getUserCollection(view);
                    if (coll != null) {
                        int len2 = coll.size();
                        for (int i = 0; i < len2; ++i) {
                            uIds.add(coll.get(i).getId().toString());
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        return uIds;
    }
}

