/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.pem.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.pem.AssignPermAdminOrgCollection;
import com.kingdee.eas.cp.pem.AssignPermAdminOrgFactory;
import com.kingdee.eas.cp.pem.AssignPermAdminOrgInfo;
import com.kingdee.eas.cp.pem.AssignPermCollection;
import com.kingdee.eas.cp.pem.AssignPermEmployeeCollection;
import com.kingdee.eas.cp.pem.AssignPermEmployeeFactory;
import com.kingdee.eas.cp.pem.AssignPermFactory;
import com.kingdee.eas.cp.pem.EventRegFactory;
import com.kingdee.eas.cp.pem.EventRegInfo;
import com.kingdee.eas.cp.pem.ForwardCollection;
import com.kingdee.eas.cp.pem.ForwardFactory;
import com.kingdee.eas.cp.pem.ForwardInfo;
import com.kingdee.eas.cp.pem.IPemAdmin;
import com.kingdee.eas.cp.pem.PemAdminCollection;
import com.kingdee.eas.cp.pem.PemAdminFactory;
import com.kingdee.eas.cp.pem.PemPersonCollection;
import com.kingdee.eas.cp.pem.PemPersonFactory;
import com.kingdee.eas.cp.pem.ReplyCollection;
import com.kingdee.eas.cp.pem.ReplyFactory;
import com.kingdee.eas.cp.pem.ReplyInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Locale;

public class PemUtils {
    public static ForwardInfo getChildForwardInfo(Context ctx, String forwardId, String eventRegId) throws BOSException {
        ForwardInfo childForwardInfo = null;
        try {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection itemCollection = filterInfo.getFilterItems();
            FilterItemInfo item = new FilterItemInfo("ParentForward.id", (Object)forwardId, CompareType.EQUALS);
            itemCollection.add(item);
            item = new FilterItemInfo("EventReg.id", (Object)eventRegId, CompareType.EQUALS);
            itemCollection.add(item);
            ev.setFilter(filterInfo);
            ForwardCollection forwardCollection = ForwardFactory.getRemoteInstance().getForwardCollection(ev);
            if (forwardCollection != null && forwardCollection.size() > 0) {
                childForwardInfo = forwardCollection.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException("\u67e5\u8be2\u5f53\u524d\u4fe1\u8bbf\u8f6c\u529e\u7b7e\u662f\u5426\u5b58\u5728\u4e0b\u7ea7\u8f6c\u529e\u7b7e\u5f02\u5e38\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return childForwardInfo;
    }

    public static boolean getEventRegForwardTagetDep(Context ctx, String eventRegId, String targetDepId) throws BOSException {
        boolean flag = false;
        StringBuffer sql = new StringBuffer();
        sql.append(" select CFTargetDepID from CT_PEM_Forward where CFEventRegID = ? and CFTargetDepID = ?");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{eventRegId, targetDepId});
            if (rs != null && rs.next()) {
                flag = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException("\u67e5\u8be2\u8f6c\u529e\u7b7e\u627f\u529e\u5355\u4f4d\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u5f02\u5e38\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException("\u67e5\u8be2\u8f6c\u529e\u7b7e\u627f\u529e\u5355\u4f4d\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u5f02\u5e38\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return flag;
    }

    public static void updateEventRegIsForward(Context ctx, EventRegInfo eventRegInfo, boolean isForward) throws BOSException {
        if (eventRegInfo != null && eventRegInfo.getId() != null) {
            eventRegInfo.setIsForward(isForward);
            PemUtils.updateEventRegState(ctx, eventRegInfo);
        }
    }

    public static void updateForwardIsForward(Context ctx, ForwardInfo forwardInfo, boolean isForward) throws BOSException {
        if (forwardInfo != null && forwardInfo.getId() != null) {
            forwardInfo.setIsForward(isForward);
            PemUtils.updateForwardState(ctx, forwardInfo);
        }
    }

    public static void updateEventRegStateTrue(Context ctx, EventRegInfo eventRegInfo) throws BOSException {
        if (eventRegInfo != null && eventRegInfo.getId() != null) {
            eventRegInfo.setState(Boolean.TRUE);
            PemUtils.updateEventRegState(ctx, eventRegInfo);
        }
    }

    public static void updateForwardStateTrue(Context ctx, ForwardInfo forwardInfo) throws BOSException {
        if (forwardInfo != null && forwardInfo.getId() != null) {
            forwardInfo.setState(Boolean.TRUE);
            PemUtils.updateForwardState(ctx, forwardInfo);
        }
    }

    public static void updateEventRegState(Context ctx, EventRegInfo eventRegInfo) throws BOSException {
        if (eventRegInfo != null && eventRegInfo.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(eventRegInfo.getId());
            try {
                EventRegFactory.getRemoteInstance().update((IObjectPK)pk, (CoreBaseInfo)eventRegInfo);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new BOSException("\u66f4\u65b0\u4fe1\u8bbf\u4e8b\u9879\u5f02\u5e38\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw new BOSException("\u66f4\u65b0\u4fe1\u8bbf\u4e8b\u9879\u5f02\u5e38\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
            }
        }
    }

    public static void updateForwardState(Context ctx, ForwardInfo forwardInfo) throws BOSException {
        if (forwardInfo != null && forwardInfo.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(forwardInfo.getId());
            try {
                ForwardFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)forwardInfo);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new BOSException("\u66f4\u65b0\u4fe1\u8bbf\u8f6c\u529e\u7b7e\u5f02\u5e38\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw new BOSException("\u66f4\u65b0\u4fe1\u8bbf\u8f6c\u529e\u7b7e\u5f02\u5e38\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
            }
        }
    }

    public static ReplyInfo getReplyInfo(Context ctx, String forwardId) throws BOSException {
        ReplyInfo replyInfo = null;
        if (forwardId != null && !"".equalsIgnoreCase(forwardId)) {
            try {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                FilterItemCollection itemCollection = filterInfo.getFilterItems();
                FilterItemInfo item = new FilterItemInfo("Forward.id", (Object)forwardId, CompareType.EQUALS);
                itemCollection.add(item);
                ev.setFilter(filterInfo);
                ReplyCollection replyCollection = ReplyFactory.getLocalInstance(ctx).getReplyCollection(ev);
                if (replyCollection != null && replyCollection.size() > 0) {
                    replyInfo = replyCollection.get(0);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw new BOSException("\u67e5\u8be2\u4fe1\u8bbf\u56de\u590d\u4fe1\u606f\u9519\u8bef\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
            }
        }
        return replyInfo;
    }

    public static EventRegInfo getEventRegInfo(Context ctx, String eventRegId) throws BOSException {
        EventRegInfo eventRegInfo = null;
        try {
            if (eventRegId != null && !"".equalsIgnoreCase(eventRegId)) {
                ObjectUuidPK pk = new ObjectUuidPK(eventRegId);
                eventRegInfo = EventRegFactory.getLocalInstance(ctx).getEventRegInfo((IObjectPK)pk);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException("\u67e5\u8be2\u4fe1\u8bbf\u767b\u8bb0\u9879\u9519\u8bef\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException("\u67e5\u8be2\u4fe1\u8bbf\u767b\u8bb0\u9879\u9519\u8bef\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return eventRegInfo;
    }

    public static PemPersonCollection getPemPerson(Context ctx, String currentDepId) throws BOSException {
        return PemUtils.getPemPerson(ctx, currentDepId, null);
    }

    public static PemPersonCollection getPemPerson(Context ctx, String currentDepId, String currentPensonId) throws BOSException {
        PemPersonCollection pemPersonCollection = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo item = null;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("person.number"));
            sic.add(new SelectorItemInfo("person.name"));
            sic.add(new SelectorItemInfo("person.email"));
            sic.add(new SelectorItemInfo("person.cell"));
            item = new FilterItemInfo("parent.pemOrg.id", (Object)currentDepId, CompareType.EQUALS);
            itemCollection.add(item);
            if (currentPensonId != null && !"".equalsIgnoreCase(currentPensonId)) {
                item = new FilterItemInfo("person.id", (Object)currentPensonId, CompareType.EQUALS);
                itemCollection.add(item);
            }
            ev.setFilter(filterInfo);
            ev.setSelector(sic);
            pemPersonCollection = PemPersonFactory.getLocalInstance(ctx).getPemPersonCollection(ev);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException("\u67e5\u8be2\u4fe1\u8bbf\u804c\u5458\u9519\u8bef\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return pemPersonCollection;
    }

    public static String[] getUserIds(Context ctx, String personid) throws BOSException, EASBizException {
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personid, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        UserCollection uc = iuser.getUserCollection(evi);
        if (uc.size() == 0) {
            return new String[0];
        }
        String[] userIds = new String[uc.size()];
        int size = userIds.length;
        for (int i = 0; i < size; ++i) {
            userIds[i] = uc.get(i).getId().toString();
        }
        return userIds;
    }

    public static String getUserId(Context ctx, String personid) {
        try {
            IUser iuser = UserFactory.getLocalInstance((Context)ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personid, CompareType.EQUALS));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.getSelector().add(new SelectorItemInfo("id"));
            UserCollection uc = iuser.getUserCollection(evi);
            if (uc != null && uc.size() > 0) {
                return uc.get(0).getId().toString();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static AssignPermAdminOrgCollection getAssignPermAdminOrgCollection(Context ctx, String currentPersonId, String currentAdminOrgUnitId) throws BOSException {
        AssignPermAdminOrgCollection assignPermAdminOrgCollection = null;
        try {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection itemCollection = filterInfo.getFilterItems();
            FilterItemInfo item = null;
            item = new FilterItemInfo("parent.personed.id", (Object)currentPersonId, CompareType.EQUALS);
            itemCollection.add(item);
            item = new FilterItemInfo("adminOrgUnit.id", (Object)currentAdminOrgUnitId, CompareType.EQUALS);
            itemCollection.add(item);
            ev.setFilter(filterInfo);
            String parentID = null;
            AssignPermAdminOrgInfo assignPermAdminOrgInfo = null;
            AssignPermAdminOrgCollection currentAssignPermAdminOrgCollection = AssignPermAdminOrgFactory.getLocalInstance(ctx).getAssignPermAdminOrgCollection(ev);
            if (currentAssignPermAdminOrgCollection != null && currentAssignPermAdminOrgCollection.size() > 0 && (assignPermAdminOrgInfo = currentAssignPermAdminOrgCollection.get(0)) != null && assignPermAdminOrgInfo.getParent() != null && assignPermAdminOrgInfo.getParent().getId() != null) {
                parentID = assignPermAdminOrgInfo.getParent().getId().toString();
            }
            if (parentID == null || "".equalsIgnoreCase(parentID)) {
                return null;
            }
            StringBuffer viewPersonParentIdSql = new StringBuffer();
            viewPersonParentIdSql.append(" select fid from CT_PEM_AssignPerm where CFPersonedID in( ");
            viewPersonParentIdSql.append("  \tselect CFPersonID from T_PEM_AssignPermEmployee where CFParentID = '");
            viewPersonParentIdSql.append(parentID);
            viewPersonParentIdSql.append("') ");
            viewPersonParentIdSql.append("");
            ev = new EntityViewInfo();
            filterInfo = new FilterInfo();
            itemCollection = filterInfo.getFilterItems();
            item = new FilterItemInfo("parent.id", (Object)viewPersonParentIdSql.toString(), CompareType.INNER);
            itemCollection.add(item);
            ev.setFilter(filterInfo);
            assignPermAdminOrgCollection = AssignPermAdminOrgFactory.getLocalInstance(ctx).getAssignPermAdminOrgCollection(ev);
            if (assignPermAdminOrgCollection == null) {
                assignPermAdminOrgCollection = new AssignPermAdminOrgCollection();
            }
            for (int i = 0; currentAssignPermAdminOrgCollection != null && i < currentAssignPermAdminOrgCollection.size(); ++i) {
                assignPermAdminOrgInfo = currentAssignPermAdminOrgCollection.get(i);
                assignPermAdminOrgCollection.add(assignPermAdminOrgInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException("\u67e5\u8be2\u5f53\u524d\u804c\u5458\u53ef\u67e5\u770b\u4fe1\u8bbf\u4e8b\u9879\u7ec4\u7ec7\u5f02\u5e38\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return assignPermAdminOrgCollection;
    }

    public static AssignPermEmployeeCollection getAssignPermViewPersonCollection(Context ctx, String currentPersonId, String currentAdminOrgUnitId) throws BOSException {
        AssignPermEmployeeCollection assignPermEmployeeCollection = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo item = null;
        try {
            item = new FilterItemInfo("parent.personed.id", (Object)currentPersonId, CompareType.EQUALS);
            itemCollection.add(item);
            ev.setFilter(filterInfo);
            assignPermEmployeeCollection = AssignPermEmployeeFactory.getLocalInstance(ctx).getAssignPermEmployeeCollection(ev);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException("\u67e5\u8be2\u5f53\u524d\u804c\u5458\u53ef\u67e5\u770b\u4e8b\u9879\u6388\u6743\u7684\u804c\u5458\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
        }
        return assignPermEmployeeCollection;
    }

    public static AssignPermCollection getAssignPerm(Context ctx, String currentPersonId, String currentAdminOrgUnitId) {
        AssignPermCollection assignPermCollection = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo item = null;
        try {
            item = new FilterItemInfo("personed.id", (Object)currentPersonId, CompareType.EQUALS);
            itemCollection.add(item);
            StringBuffer currentPersonParentIdSql = new StringBuffer();
            currentPersonParentIdSql.append("  select fid from CT_PEM_AssignPerm where CFPersonedID ='");
            currentPersonParentIdSql.append(currentPersonId);
            currentPersonParentIdSql.append("'");
            StringBuffer viewPersonParentIdSql = new StringBuffer();
            viewPersonParentIdSql.append("  select fid from CT_PEM_AssignPerm where CFPersonedID ='");
            viewPersonParentIdSql.append(currentPersonId);
            viewPersonParentIdSql.append("'");
            viewPersonParentIdSql.append("  and fid in(select fparentId from T_PEM_AssignPermEmployee where CFPersonID in) ");
            viewPersonParentIdSql.append("");
            StringBuffer currentPersonDepSql = new StringBuffer();
            currentPersonDepSql.append(" select CFParentID from T_PEM_AssignPermAdminOrg where CFParentID in(");
            currentPersonDepSql.append(" ) ");
            currentPersonDepSql.append(" ");
            currentPersonDepSql.append(" and CFAdminOrgUnitID='");
            currentPersonDepSql.append(currentAdminOrgUnitId);
            currentPersonDepSql.append("' ");
            item = new FilterItemInfo("id", (Object)currentPersonDepSql.toString(), CompareType.INCLUDE);
            itemCollection.add(item);
            filterInfo.setMaskString("(#0 and #1) or (#2 and #3)");
            ev.setFilter(filterInfo);
            assignPermCollection = AssignPermFactory.getLocalInstance(ctx).getAssignPermCollection(ev);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return assignPermCollection;
    }

    public static ForwardInfo getForwardInfo(Context ctx, String forwardId, SelectorItemCollection sic) throws BOSException {
        ForwardInfo forwardInfo = null;
        if (forwardId != null && !"".equalsIgnoreCase(forwardId)) {
            ObjectUuidPK pk = new ObjectUuidPK(forwardId);
            try {
                if (sic == null) {
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("ParentForward.*"));
                    sic.add(new SelectorItemInfo("EventReg.*"));
                }
                forwardInfo = ForwardFactory.getLocalInstance(ctx).getForwardInfo((IObjectPK)pk, sic);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new BOSException("\u67e5\u8be2\u4fe1\u8bbf\u8f6c\u529e\u7b7einfo\u5bf9\u8c61\u9519\u8bef\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw new BOSException("\u67e5\u8be2\u4fe1\u8bbf\u8f6c\u529e\u7b7einfo\u5bf9\u8c61\u9519\u8bef\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a" + e.getMessage());
            }
        }
        return forwardInfo;
    }

    public static ForwardInfo getForwardInfo(Context ctx, String forwardId) throws BOSException {
        return PemUtils.getForwardInfo(ctx, forwardId, null);
    }

    public static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    public static boolean isExistsTargetDep(Context ctx, String targetDepId) throws BOSException {
        boolean flag = false;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo item = new FilterItemInfo("pemOrg.id", (Object)targetDepId, CompareType.EQUALS);
        itemCollection.add(item);
        view.setFilter(filterInfo);
        IPemAdmin iPemAdmin = PemAdminFactory.getRemoteInstance();
        PemAdminCollection coll = iPemAdmin.getPemAdminCollection(view);
        if (coll != null && coll.size() > 0) {
            flag = true;
        }
        return flag;
    }

    public static String ConverEventRegContentToString(Context ctx, String id) throws BOSException, SQLException {
        if (StringUtils.isEmpty((String)id)) {
            return "";
        }
        String sql = "select CFContent from CT_PEM_EventReg where fid ='" + id.trim() + "'";
        InputStream in = PemUtils.getInputStreamBySql(ctx, sql);
        return PemUtils.ConvertInputStreamToString(ctx, in);
    }

    public static String ConverReplayContentToString(Context ctx, String id) throws BOSException, SQLException {
        if (StringUtils.isEmpty((String)id)) {
            return "";
        }
        String sql = "select CFContent from CT_PEM_Reply where fid ='" + id.trim() + "'";
        InputStream in = PemUtils.getInputStreamBySql(ctx, sql);
        return PemUtils.ConvertInputStreamToString(ctx, in);
    }

    private static InputStream getInputStreamBySql(Context ctx, String sql) throws SQLException, BOSException {
        if (StringUtils.isEmpty((String)sql)) {
            return null;
        }
        Blob blob = null;
        IRowSet rows = null;
        InputStream in = null;
        rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rows != null && rows.next()) {
            blob = rows.getBlob(1);
            in = blob.getBinaryStream();
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String ConvertInputStreamToString(Context ctx, InputStream in) {
        if (in == null) {
            return "";
        }
        Object blob = null;
        Object rows = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = -1;
        try {
            while ((i = in.read()) != -1) {
                baos.write(i);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return baos.toString();
    }
}

