/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.fme.bo.DocumentBO;
import com.kingdee.eas.base.fme.service.FMEServiceFactory;
import com.kingdee.eas.base.fme.service.IFMEConsoleService;
import com.kingdee.eas.base.fme.service.IFMEService;
import com.kingdee.eas.base.fme.service.ServiceResult;
import com.kingdee.eas.base.fme.service.WebFMEServiceImpl;
import com.kingdee.eas.base.fme.uimodel.FMEParameter;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.app.FMEPathInfo;
import com.kingdee.eas.cp.wfs.BaseSettingCollection;
import com.kingdee.eas.cp.wfs.BaseSettingFactory;
import com.kingdee.eas.cp.wfs.FormConfigInfo;
import com.kingdee.eas.cp.wfs.IPushReceiverEntry;
import com.kingdee.eas.cp.wfs.PushReceiverEntryCollection;
import com.kingdee.eas.cp.wfs.PushReceiverEntryFactory;
import com.kingdee.eas.cp.wfs.PushReceiverEntryInfo;
import com.kingdee.eas.cp.wfs.utils.ExcelExportHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class FtpUtils {
    public static final boolean checkFtpConn(Context ctx, String pathId) {
        IFMEConsoleService service = FMEServiceFactory.getConsoleServiceInstance((Context)ctx);
        if (pathId == null || pathId.trim().length() == 0) {
            return false;
        }
        try {
            String[] re = service.checkFtpLinks(pathId);
            return "0".equals(re[0]);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static List getFmePathCollection(Context ctx) {
        IFMEConsoleService service = FMEServiceFactory.getConsoleServiceInstance((Context)ctx);
        List availablePathList = null;
        try {
            availablePathList = service.getAvailablePathList();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return availablePathList;
    }

    public static List getFmePaths(Context ctx) {
        ArrayList<FMEPathInfo> tempList = new ArrayList<FMEPathInfo>();
        List list = FtpUtils.getFmePathCollection(ctx);
        if (list == null) {
            return tempList;
        }
        int size = list.size();
        if (size <= 0) {
            return tempList;
        }
        for (int i = 0; i < size; ++i) {
            Map map = (Map)list.get(i);
            FMEPathInfo pathInfo = new FMEPathInfo();
            pathInfo.setKey((String)map.get("pathID"));
            pathInfo.setName((String)map.get("pathName"));
            tempList.add(pathInfo);
        }
        return tempList;
    }

    public static ServiceResult uploadFile(IFMEService service, InputStream is, String fileName, PushReceiverEntryInfo prei, FMEParameter param) {
        param.setNewCategoryInfo(prei.getUserID());
        return service.uploadFile(is, fileName, prei.getId().toString(), param);
    }

    public static ServiceResult uploadFile(IFMEService service, InputStream[] is, String[] fileName, String businessID, FMEParameter param) {
        return service.uploadFile(is, fileName, businessID, param);
    }

    public static InputStream convertInputStream(HSSFWorkbook workbook) throws IOException {
        if (workbook != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            workbook.write((OutputStream)os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        return null;
    }

    public static PushReceiverEntryInfo saveReceiveEntryInfo(Context ctx, String porletEntryId, String userId, String ftpPathId) throws EASBizException, BOSException {
        IPushReceiverEntry ipre = PushReceiverEntryFactory.getLocalInstance(ctx);
        if (ipre != null) {
            PushReceiverEntryInfo entryInfo = new PushReceiverEntryInfo();
            entryInfo.setPorletEntryID(porletEntryId);
            entryInfo.setUserID(userId);
            entryInfo.setQueryPathID(ftpPathId);
            System.out.print("wfs - Send to Porlet,QueryPathID:" + entryInfo.getQueryPathID());
            ipre.addnew(entryInfo);
            return entryInfo;
        }
        return null;
    }

    public static void pushToFtp(Context ctx, String porletEntryId, String personId, String ftpPathId, FormConfigInfo config) {
        HSSFWorkbook workBook = null;
        if (personId != null) {
            UserCollection coll = null;
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("person", (Object)personId, CompareType.EQUALS));
            try {
                coll = UserFactory.getLocalInstance((Context)ctx).getUserCollection(view);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (coll != null && coll.size() > 0) {
                ExcelExportHandler handler = null;
                handler = new ExcelExportHandler(ctx, config);
                PushReceiverEntryInfo prei = null;
                FMEParameter param = null;
                if (handler != null) {
                    try {
                        int size = coll.size();
                        for (int i = 0; i < size; ++i) {
                            workBook = handler.getReportDatas(coll.get(i));
                            prei = FtpUtils.saveReceiveEntryInfo(ctx, porletEntryId, coll.get(i).getId().toString(), ftpPathId);
                            param = new FMEParameter();
                            param.setNewPathID(ftpPathId);
                            FtpUtils.uploadFile((IFMEService)new WebFMEServiceImpl(ctx), FtpUtils.convertInputStream(workBook), config.getName() + ".xls", prei, param);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static String getCurrentFtpSetting(Context ctx) {
        try {
            BaseSettingCollection coll = BaseSettingFactory.getLocalInstance(ctx).getBaseSettingCollection();
            if (coll != null && coll.size() == 1) {
                return coll.get(0).getQueryPathID();
            }
            return null;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DocumentBO[] getRptInfo(IFMEService service, String receiverEntryId) {
        DocumentBO[] data = null;
        if (service != null) {
            data = service.getFileInfo(receiverEntryId);
        }
        return data;
    }

    public static DocumentBO[] getRptInfo(Context ctx, String receiverEntryId) {
        return FtpUtils.getRptInfo((IFMEService)new WebFMEServiceImpl(ctx), receiverEntryId);
    }

    public static DocumentBO[] getRptInfo(Context ctx, String porletEntryId, String userId) throws BOSException {
        IPushReceiverEntry ipre = PushReceiverEntryFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("porletEntryID", (Object)porletEntryId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("userID", (Object)userId, CompareType.EQUALS));
        PushReceiverEntryCollection coll = ipre.getPushReceiverEntryCollection(view);
        DocumentBO[] data = null;
        if (coll != null && coll.size() == 1) {
            data = FtpUtils.getRptInfo(ctx, coll.get(0).getId().toString());
        }
        return data;
    }

    public static void downloadRpt(Context ctx, HttpServletRequest request, String porletEntryId, String userId) throws BOSException {
    }
}

