/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.DataSubmitModeEnum;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.log.ExcelTaskLog;
import com.kingdee.eas.tools.datatask.log.ILog;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.RecordUtils;
import com.kingdee.eas.tools.datatask.runtime.SqlInfo;
import com.kingdee.eas.tools.datatask.task.ITaskRunner;
import com.kingdee.eas.tools.datatask.task.MultitaskImportExcelRunner;
import com.kingdee.eas.tools.datatask.task.SuccessInfo;
import com.kingdee.eas.tools.datatask.task.TaskBlockDataRunner;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.util.client.EASResource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BlockDataTransmission
extends AbstractDataTransmission {
    private static Logger logger = SysLog.getLogger(BlockDataTransmission.class);
    private TaskBlockDataRunner runner = null;
    protected ErrorHandleModeEnum errHandleMode = null;
    protected int blockBeginRowNum = 0;
    protected TaskExternalCode importTask = null;
    protected RecordCollection recColl = new RecordCollection();
    private ILog log;
    private Map<Integer, String> sheetId2Name;
    private ITaskRunner taskRuner;

    public void importFile(Context ctx, TaskExternalCode task) throws TaskExternalException {
        try {
            this.runner = new TaskBlockDataRunner(task, this, ctx);
            this.importTask = task;
            this.setLog(this.runner.getTaskLog());
            this.initErrorHandleMode();
            this.runner.run();
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void initErrorHandleMode() {
        TaskExternalCode taskCode = this.importTask;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        if (dp.getContextParam().get("errorHandleMode") != null) {
            this.errHandleMode = (ErrorHandleModeEnum)((Object)dp.getContextParam().get("errorHandleMode"));
        }
    }

    private void exportFile(Context ctx, DatataskParameter param) throws TaskExternalException {
    }

    @Override
    public int getSubmitType() {
        return 1;
    }

    public ILog getLog() {
        return this.log;
    }

    public void setLog(ILog log) {
        this.log = log;
    }

    public Map<Integer, String> getSheetId2Name() {
        return this.sheetId2Name;
    }

    public void setSheetId2Name(Map<Integer, String> sheetId2Name) {
        this.sheetId2Name = sheetId2Name;
    }

    public void setTaskRuner(ITaskRunner taskRuner) {
        this.taskRuner = taskRuner;
    }

    protected CoreBaseCollection transToCoreBaseCollection(Context ctx, RecordCollection coll) throws TaskExternalException {
        CoreBaseCollection cbColl = new CoreBaseCollection();
        if (coll != null) {
            int size = coll.size();
            this.blockBeginRowNum = coll.get(0).getRowNum();
            for (int i = 0; i < size; ++i) {
                IRecord rec = coll.get(i);
                if (rec == null) continue;
                this.recColl.add(rec);
                try {
                    CoreBaseInfo cb = this.toCoreBaseInfo(ctx, rec);
                    if (cb == null) continue;
                    cbColl.add(cb);
                    continue;
                }
                catch (Exception e) {
                    this.writeLog(rec.getRowNum(), e, this.blockBeginRowNum);
                    this.recColl.remove(rec);
                    if (this.errHandleMode != ErrorHandleModeEnum.ReturnRightnow) continue;
                    throw new TaskExternalException("", (Throwable)e);
                }
            }
        }
        return cbColl;
    }

    protected CoreBaseInfo toCoreBaseInfo(Context ctx, IRecord rec) throws TaskExternalException {
        return null;
    }

    protected SqlInfo[] transToSQL(Context ctx, RecordCollection coll) throws TaskExternalException {
        ArrayList<SqlInfo> sqls = new ArrayList<SqlInfo>();
        if (coll != null) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                IRecord record = coll.get(i);
                try {
                    SqlInfo sInfo = this.toSQL(ctx, record);
                    if (sInfo == null || sInfo.getSql() == null) continue;
                    sInfo.setRecord(record);
                    sqls.add(sInfo);
                    continue;
                }
                catch (Exception e) {
                    this.writeLog(record.getRowNum(), e);
                    logger.error((Object)e);
                    if (this.errHandleMode == null || this.errHandleMode.getValue() != 1) continue;
                    throw new TaskExternalException("NEWBLOCK");
                }
            }
        }
        return sqls.toArray(new SqlInfo[0]);
    }

    protected SqlInfo toSQL(Context ctx, IRecord rec) throws TaskExternalException {
        return null;
    }

    public Object transform(Context ctx, RecordCollection coll) throws TaskExternalException {
        DataSubmitModeEnum mode = this.getDataSubmitMode();
        if (mode.equals((Object)DataSubmitModeEnum.ORMAPPING)) {
            return this.transToCoreBaseCollection(ctx, coll);
        }
        if (mode.equals((Object)DataSubmitModeEnum.SQL)) {
            return this.transToSQL(ctx, coll);
        }
        return coll;
    }

    protected DataSubmitModeEnum getDataSubmitMode() {
        return DataSubmitModeEnum.SQL;
    }

    public void verifyBlockData(Context ctx, Object o) throws TaskExternalException {
        DataSubmitModeEnum mode = this.getDataSubmitMode();
        if (mode.equals((Object)DataSubmitModeEnum.ORMAPPING)) {
            CoreBaseCollection coll = (CoreBaseCollection)o;
            this.verifyCoreBaseCollection(ctx, coll);
        }
    }

    protected void verifyCoreBaseCollection(Context ctx, CoreBaseCollection coll) throws TaskExternalException {
        if (coll != null) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                CoreBaseInfo cbInfo = coll.get(i);
                try {
                    this.verifyCoreBaseInfo(ctx, cbInfo);
                    continue;
                }
                catch (Exception e) {
                    this.writeLog(e);
                }
            }
        }
    }

    protected void verifyCoreBaseInfo(Context ctx, CoreBaseInfo info) throws TaskExternalException {
    }

    public void beforeSubmitBlockData(Context ctx, Object o) throws TaskExternalException {
        DataSubmitModeEnum mode = this.getDataSubmitMode();
        if (mode.equals((Object)DataSubmitModeEnum.ORMAPPING)) {
            CoreBaseCollection coll = (CoreBaseCollection)o;
            this.beforeSubmitCoreBaseCollection(ctx, coll);
        } else if (mode.equals((Object)DataSubmitModeEnum.SQL)) {
            SqlInfo[] sql = (SqlInfo[])o;
            this.beforeSubmitSql(ctx, sql);
        }
    }

    protected void beforeSubmitCoreBaseCollection(Context ctx, CoreBaseCollection coll) throws TaskExternalException {
    }

    protected void beforeSubmitSql(Context ctx, SqlInfo[] sqls) throws TaskExternalException {
    }

    public void submitBlock(Context ctx, Object o) throws TaskExternalException {
        DataSubmitModeEnum mode = this.getDataSubmitMode();
        if (mode.equals((Object)DataSubmitModeEnum.ORMAPPING)) {
            CoreBaseCollection coll = (CoreBaseCollection)o;
            this.submitCoreBaseCollection(ctx, coll);
        } else if (mode.equals((Object)DataSubmitModeEnum.SQL)) {
            SqlInfo[] sqls = (SqlInfo[])o;
            try {
                int[] nArray = this.submitSql(ctx, sqls);
            }
            catch (SQLException e) {
                this.writeLog(sqls[0].getRecord().getRowNum(), sqls[sqls.length].getRecord().getRowNum(), e);
            }
        }
    }

    protected Result submitCoreBaseCollection(Context ctx, CoreBaseCollection coll) throws TaskExternalException {
        ICoreBase cb = this.getController(ctx);
        if (cb == null) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"4_BlockDataTransmission"));
        }
        if (!this.isSltImportUpdate()) {
            for (int i = 0; i < coll.size(); ++i) {
                try {
                    cb.addnew(coll.get(i));
                    continue;
                }
                catch (Exception e) {
                    this.writeLog(this.recColl.get(i).getRowNum(), e, this.blockBeginRowNum);
                    if (this.errHandleMode != ErrorHandleModeEnum.ReturnRightnow) continue;
                    throw new TaskExternalException("", (Throwable)e);
                }
            }
        } else {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                CoreBaseInfo cbInfo = coll.get(i);
                if (cbInfo == null) continue;
                try {
                    if (cbInfo.getId() == null || !cb.exists((IObjectPK)new ObjectUuidPK(cbInfo.getId()))) {
                        cb.addnew(cbInfo);
                        continue;
                    }
                    cb.update((IObjectPK)new ObjectUuidPK(cbInfo.getId()), cbInfo);
                    continue;
                }
                catch (Exception e) {
                    this.writeLog(this.recColl.get(i).getRowNum(), e, this.blockBeginRowNum);
                    if (this.errHandleMode != ErrorHandleModeEnum.ReturnRightnow) continue;
                    throw new TaskExternalException("", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] submitSql(Context ctx, SqlInfo[] sqls) throws SQLException {
        Iterator it;
        int[] nArray;
        Connection conn = null;
        Statement st = null;
        HashMap<Object, Statement> stMap = new HashMap<Object, Statement>(2);
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            boolean isPrepare = this.isCreatePrepareStatement(sqls);
            if (sqls != null && sqls.length > 0) {
                if (!isPrepare) {
                    st = conn.createStatement();
                    stMap.put(sqls[0], st);
                }
                for (int i = 0; i < sqls.length; ++i) {
                    try {
                        if (!isPrepare) {
                            if (st == null) continue;
                            st.addBatch(sqls[i].getSql());
                            continue;
                        }
                        SqlInfo sInfo = sqls[i];
                        if (stMap.containsKey(sInfo.getSql())) {
                            st = (PreparedStatement)stMap.get(sInfo.getSql());
                        } else {
                            st = conn.prepareStatement(sInfo.getSql());
                            stMap.put(sInfo.getSql(), st);
                        }
                        for (int j = 0; j < sInfo.getParams().length; ++j) {
                            ((PreparedStatement)st).setObject(j + 1, sInfo.getParams()[j]);
                        }
                        ((PreparedStatement)st).addBatch();
                        continue;
                    }
                    catch (SQLException e) {
                        this.writeLog(sqls[i].getRecord().getRowNum(), e);
                    }
                }
                for (Object key : stMap.keySet()) {
                    Statement tmpSt = (Statement)stMap.get(key);
                    tmpSt.executeBatch();
                }
            }
            nArray = null;
            it = stMap.keySet().iterator();
        }
        catch (SQLException e) {
            Iterator it2;
            int[] nArray2;
            try {
                this.writeLog(sqls[0].getRecord().getRowNum(), sqls[sqls.length - 1].getRecord().getRowNum(), e);
                nArray2 = new int[]{};
                it2 = stMap.keySet().iterator();
            }
            catch (Throwable throwable) {
                Iterator it3 = stMap.keySet().iterator();
                Statement[] sts = new Statement[stMap.size()];
                int i = 0;
                while (it3.hasNext()) {
                    Statement tmpSt;
                    Object key = it3.next();
                    sts[i] = tmpSt = (Statement)stMap.get(key);
                    ++i;
                }
                this.closeJDBC(conn, sts);
                throw throwable;
            }
            Statement[] sts = new Statement[stMap.size()];
            int i = 0;
            while (it2.hasNext()) {
                Statement tmpSt;
                Object key = it2.next();
                sts[i] = tmpSt = (Statement)stMap.get(key);
                ++i;
            }
            this.closeJDBC(conn, sts);
            return nArray2;
        }
        Statement[] sts = new Statement[stMap.size()];
        int i = 0;
        while (it.hasNext()) {
            Statement tmpSt;
            Object key = it.next();
            sts[i] = tmpSt = (Statement)stMap.get(key);
            ++i;
        }
        this.closeJDBC(conn, sts);
        return nArray;
    }

    protected boolean isCreatePrepareStatement(SqlInfo[] sqls) {
        return sqls.length > 0 && sqls[0].getParams() != null;
    }

    protected void closeJDBC(Connection conn, Statement st) {
        try {
            if (conn != null) {
                conn.close();
                conn = null;
            }
            if (st != null) {
                st.close();
                st = null;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    protected void closeJDBC(Connection conn, Statement[] st) {
        try {
            if (conn != null) {
                conn.close();
                conn = null;
            }
            if (st != null) {
                for (int i = 0; i < st.length; ++i) {
                    st[i].close();
                    st[i] = null;
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    protected void writeLog(Exception e) {
        if (this.log instanceof TaskLog) {
            TaskLog tasklog = (TaskLog)this.getLog();
            tasklog.addException("", e, null);
            tasklog.setFailRecordCount(tasklog.getFailRecordCount() + 1);
            tasklog.setTaskState(TaskStateEnum.FAILEND);
        }
    }

    @Override
    public void writeLog(int rowNum, Exception e) {
        if (this.log instanceof TaskLog) {
            TaskLog tasklog = (TaskLog)this.getLog();
            tasklog.addException(EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "5_BlockDataTransmission", new Object[]{rowNum - 4}), e, rowNum);
            tasklog.setFailRecordCount(tasklog.getFailRecordCount() + 1);
            tasklog.setTaskState(TaskStateEnum.FAILEND);
        } else {
            ExcelTaskLog excelLog = (ExcelTaskLog)this.log;
            int sheetId = RecordUtils.getSheetId(rowNum);
            rowNum = RecordUtils.getRowNum(rowNum);
            String sheetName = this.sheetId2Name.get(sheetId);
            ExcelTaskLog.ExcelSheetTaskLog sheetLog = TaskLogUtil.createAndGetSheetLog(excelLog, sheetId, sheetName);
            sheetLog.setErrorInfo(rowNum, e.getMessage());
        }
    }

    @Override
    public void writeLog(RecordCollection col, List<SuccessInfo> successList) {
        if (this.log instanceof ExcelTaskLog) {
            MultitaskImportExcelRunner mul = (MultitaskImportExcelRunner)this.taskRuner;
            mul.writeLog(col, successList);
        }
    }

    protected void writeLog(int rowNum, Exception e, int beginRowNum) {
        if (this.log instanceof TaskLog) {
            TaskLog tasklog = (TaskLog)this.getLog();
            tasklog.addExceptionForBatch(EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "5_BlockDataTransmission", new Object[]{rowNum}), e, rowNum, beginRowNum);
            tasklog.setFailRecordCount(tasklog.getFailRecordCount() + 1);
            tasklog.setTaskState(TaskStateEnum.FAILEND);
        } else {
            ExcelTaskLog excelLog = (ExcelTaskLog)this.log;
            int sheetId = RecordUtils.getSheetId(rowNum);
            rowNum = RecordUtils.getRowNum(rowNum);
            String sheetName = this.sheetId2Name.get(sheetId);
            ExcelTaskLog.ExcelSheetTaskLog sheetLog = TaskLogUtil.createAndGetSheetLog(excelLog, sheetId, sheetName);
            sheetLog.setErrorInfo(rowNum, e.getMessage());
        }
    }

    protected void writeLog(int startRowNum, int endRowNum, Exception e) {
        if (this.log instanceof TaskLog) {
            TaskLog tasklog = (TaskLog)this.getLog();
            tasklog.addException(EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "5_BlockDataTransmission", new Object[]{startRowNum + "---" + endRowNum}), e, null);
            tasklog.setFailRecordCount(tasklog.getFailRecordCount() + 1);
            tasklog.setTaskState(TaskStateEnum.FAILEND);
        }
    }
}

