/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask;

import com.kingdee.eas.base.forewarn.dataDeal.KSQLData;
import com.kingdee.eas.tools.datatask.DEBaseInfo;
import com.kingdee.eas.tools.datatask.DEDataExportImplHelper;
import com.kingdee.eas.tools.datatask.DEDataTypeEnum;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public final class DEKSQLData {
    static Logger logger = Logger.getLogger(KSQLData.class);
    private static final SimpleDateFormat FORMAT_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String dealData(ResultSet resut, int i, boolean isGenXml, DEBaseInfo dEBaseInfo) throws SQLException {
        ResultSetMetaData restmd = resut.getMetaData();
        String sqlstr = null;
        int typeCode = restmd.getColumnType(i);
        switch (typeCode) {
            case 4: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "int", dEBaseInfo);
                break;
            }
            case 5: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "int", dEBaseInfo);
                break;
            }
            case 6: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "float", dEBaseInfo);
                break;
            }
            case -6: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "int", dEBaseInfo);
                break;
            }
            case 7: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "double", dEBaseInfo);
                break;
            }
            case -7: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "int", dEBaseInfo);
                break;
            }
            case 8: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "double", dEBaseInfo);
                break;
            }
            case 93: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "datetime", dEBaseInfo);
                break;
            }
            case -2: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "timestamp", dEBaseInfo);
                break;
            }
            case 92: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "timestamp", dEBaseInfo);
                break;
            }
            case 12: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "string", dEBaseInfo);
                break;
            }
            case 1: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "string", dEBaseInfo);
                break;
            }
            case 2: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "int", dEBaseInfo);
                break;
            }
            case 91: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "date", dEBaseInfo);
                break;
            }
            case -1: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "string", dEBaseInfo);
                break;
            }
            case 2004: {
                sqlstr = "?";
                break;
            }
            case 2005: {
                if (isGenXml) {
                    sqlstr = "?";
                    break;
                }
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "string", dEBaseInfo);
                break;
            }
            case 2011: {
                sqlstr = "?";
                break;
            }
            case -9: {
                sqlstr = DEKSQLData.getDataKsqlData(resut, i, "string", dEBaseInfo);
                break;
            }
            default: {
                System.out.println(typeCode);
            }
        }
        if (sqlstr == null) {
            return "null";
        }
        return sqlstr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBlobData(String tableName, ResultSet result, String colName) throws SQLException, IOException {
        try (InputStream is = null;){
            byte[] b = null;
            Blob tmpBlob = result.getBlob(colName);
            if (tmpBlob == null) {
                byte[] byArray = null;
                return byArray;
            }
            int size = new Long(tmpBlob.length()).intValue();
            b = new byte[size];
            is = tmpBlob.getBinaryStream();
            is.read(b);
            byte[] byArray = b;
            return byArray;
        }
    }

    public static String getClobData(String tableName, ResultSet result, String colName) throws SQLException, IOException {
        return result.getString(colName);
    }

    public static String getDataKsqlData(ResultSet resut, int i, String str2, DEBaseInfo dEBaseInfo) {
        DEDataTypeEnum dEDataTypeEnum = dEBaseInfo.ExportDataType;
        String typeName = dEDataTypeEnum.getName();
        String str = "";
        try {
            if ("int".equals(str2)) {
                str = String.valueOf(resut.getInt(i));
            }
            if ("float".equals(str2)) {
                str = resut.wasNull() ? "null" : String.valueOf(resut.getShort(i));
            }
            if ("double".equals(str2)) {
                str = resut.wasNull() ? "null" : String.valueOf(resut.getDouble(i));
            }
            if ("string".equals(str2)) {
                String tempStr = resut.getString(i);
                str = tempStr == null ? "null" : (DEKSQLData.isIncludeChinese(tempStr) && !typeName.equalsIgnoreCase("BOTP") && !typeName.equalsIgnoreCase("FOREWARN") ? "N'" + DEDataExportImplHelper.getString(DEDataExportImplHelper.parseString(tempStr)) + "'" : "'" + DEDataExportImplHelper.getString(DEDataExportImplHelper.parseString(tempStr)) + "'");
            }
            if ("datetime".equals(str2)) {
                Timestamp tmpdate = resut.getTimestamp(i);
                str = tmpdate == null ? "null" : "{ts'" + FORMAT_TIME.format(tmpdate) + "'}";
            }
        }
        catch (SQLException e) {
            logger.info((Object)"", (Throwable)e);
        }
        return str;
    }

    public static boolean isIncludeChinese(String str) {
        boolean isIncludeChinese = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if ('\u4e00' >= c || c >= '\u9fbb') continue;
            isIncludeChinese = true;
            break;
        }
        return isIncludeChinese;
    }

    public static boolean isEnglishString(String str) {
        boolean isEnglishString = true;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) <= '\u00ff') continue;
            isEnglishString = false;
            break;
        }
        return isEnglishString;
    }
}

