/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.BillEntryCustomCollection;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.BaseClassConstants;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryInfo;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.DatataskRunServerFactory;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.databind.DataBinder;
import com.kingdee.eas.tools.datatask.databind.InfoClassValueProvider;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultDataTransmission
extends AbstractDataTransmission {
    private static Logger logger = SysLog.getLogger(DefaultDataTransmission.class);
    private DIETemplateInfo templateInfo = null;
    private HashMap propMap = null;
    private String type = null;
    private Context ctx = null;
    private EntityObjectInfo eoInfo = null;
    private DataBinder dataBinder = new DataBinder();
    private boolean isCheckedPrimaryKey = false;
    private Map currentData = null;
    private int currentEntryRowIndex = 0;
    private boolean isCodeImplementTrans;
    private boolean isUserDefineTrans;
    private DIETemplateFieldEntryCollection primaryKeys = new DIETemplateFieldEntryCollection();
    private boolean hasQueryColType = false;
    private HashMap queryColTypeMap = new HashMap(5);
    private HashMap fieldQuery = new HashMap();

    public DefaultDataTransmission(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        if (this.eoInfo == null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
            this.eoInfo = loader.getEntity(this.getBOSObjectType(this.type));
        }
        try {
            if (this.eoInfo.isUserDefined()) {
                return (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)this.eoInfo.getFullName()));
            }
            String factoryName = this.eoInfo.getBusinessImplFactory();
            Class<?> c = Class.forName(factoryName);
            Method m = c.getMethod("getLocalInstance", Context.class);
            ICoreBase cb = (ICoreBase)m.invoke(null, ctx);
            return cb;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            if (e instanceof ClassNotFoundException) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"26_UserDefineImportUI"));
            }
            throw new TaskExternalException("getController error! ", (Throwable)e);
        }
    }

    private void initPrimaryKey() {
        if (!this.isCheckedPrimaryKey) {
            this.primaryKeys = new DIETemplateFieldEntryCollection();
            DIETemplateFieldEntryCollection coll = this.templateInfo.getFieldEntries();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                DIETemplateFieldEntryInfo entryInfo = coll.get(i);
                if (!entryInfo.isIsPrimary()) continue;
                this.primaryKeys.add(entryInfo);
            }
            this.isCheckedPrimaryKey = true;
        }
    }

    private String getIDOfSamePrimaryKey(DIETemplateFieldEntryCollection primarys, CoreBaseInfo info, Context ctx) {
        StringBuffer sb = new StringBuffer("select id where  ");
        if (primarys != null) {
            int size = primarys.size();
            for (int i = 0; i < size; ++i) {
                DIETemplateFieldEntryInfo entryInfo = primarys.get(i);
                if (i == 0) {
                    sb.append(" ").append(this.replaceDollar(entryInfo.getEntityPropName())).append("=").append(this.getOqlValue(entryInfo.getEntityPropClass(), entryInfo.getNumber()));
                    continue;
                }
                sb.append(" and ").append(this.replaceDollar(entryInfo.getEntityPropName())).append("=").append(this.getOqlValue(entryInfo.getEntityPropClass(), entryInfo.getNumber()));
            }
        }
        try {
            CoreBaseCollection coll = this.getController(ctx).getCollection(sb.toString());
            CoreBaseInfo info1 = null;
            if (coll != null && coll.size() > 0) {
                info1 = coll.get(0);
            }
            if (info1 != null && info.getId() == null) {
                info.setId(info1.getId());
                return info1.getId().toString();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getOqlValue(String className, String key) {
        String lastPropClass = this.getLastPropClass(className);
        return this.getValueByType(lastPropClass, this.currentData.get(key).toString());
    }

    private String getLastPropClass(String classStr) {
        String[] astr = classStr.split("\\$");
        if (astr != null && astr.length > 0) {
            return astr[astr.length - 1];
        }
        return "";
    }

    private String getValueByType(String propClassName, String value) {
        if (BaseClassConstants.isStringBOSClass(propClassName)) {
            return "'" + value + "'";
        }
        if (BaseClassConstants.isNumberBOSClass(propClassName)) {
            return value;
        }
        if (BaseClassConstants.isDateBOSClass(propClassName)) {
            return "{" + value + "}";
        }
        if (BaseClassConstants.isBooleanBOSClass(propClassName)) {
            value = "true".equals(value) ? "1" : "0";
            return value;
        }
        if (BaseClassConstants.isEnumBOSClass(propClassName)) {
            return value;
        }
        return "'" + value + "'";
    }

    private String replaceDollar(String entityPropName) {
        if (entityPropName != null) {
            return entityPropName.replace('$', '.');
        }
        return "";
    }

    @Override
    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo == null) {
                return;
            }
            if (this.isSltImportUpdate()) {
                this.initPrimaryKey();
                this.getIDOfSamePrimaryKey(this.primaryKeys, coreBaseInfo, ctx);
            }
            if (this.eoInfo == null) {
                IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
                this.eoInfo = loader.getEntity(this.getBOSObjectType(this.type));
            }
            if (this.eoInfo.isUserDefined() && coreBaseInfo instanceof ICommonBOSType) {
                ((ICommonBOSType)coreBaseInfo).setBOSType(this.getBOSObjectType(this.type));
                ((ICommonBOSType)coreBaseInfo).setPK((IMetaDataPK)MetaDataPK.create((String)this.eoInfo.getFullName()));
            }
            ICoreBase controller = this.getController(ctx);
            if (coreBaseInfo.getId() == null) {
                controller.addnew(coreBaseInfo);
            } else {
                DatataskRunServerFactory.getLocalInstance(ctx).updateByCover(coreBaseInfo, controller, this.dataBinder.getDelOldEntrys());
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo getDynValueClass() throws TaskExternalException {
        if (this.eoInfo == null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx);
            this.eoInfo = loader.getEntity(this.getBOSObjectType(this.type));
        }
        String valueClassName = this.eoInfo.getObjectValueClass();
        CoreBaseInfo info = null;
        try {
            Class<?> c = Class.forName(valueClassName);
            Constructor<?> cst = c.getConstructor(null);
            info = (CoreBaseInfo)cst.newInstance(null);
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return info;
    }

    public void setDIETemplateInfo(DIETemplateInfo info) {
        this.templateInfo = info;
        this.dataBinder.setTemplateInfo(this.templateInfo);
        this.type = this.templateInfo.getEntityBosType();
    }

    public DIETemplateInfo getDIETemplateInfo() {
        return this.templateInfo;
    }

    public void setContext(Context ctx) {
        this.ctx = ctx;
        this.dataBinder.setCtx(ctx);
    }

    public Context getContext() {
        return this.ctx;
    }

    @Override
    public boolean isSameBlock(Map firstData, Map currentData) {
        boolean rs = this.isSameBlock(this.convertMap(firstData), this.convertMap(currentData));
        return rs;
    }

    @Override
    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        boolean rs = false;
        if (firstData != null && currentData != null) {
            String firstMainField = "";
            String currentMainField = "";
            this.initPrimaryKey();
            for (int i = 0; i < this.primaryKeys.size(); ++i) {
                firstMainField = StringUtil.cnulls(firstData.get(this.primaryKeys.get(i).getNumber()));
                currentMainField = StringUtil.cnulls(currentData.get(this.primaryKeys.get(i).getNumber()));
                if (firstMainField.isEmpty() && currentMainField.isEmpty() || !firstMainField.equals(currentMainField)) {
                    rs = false;
                    break;
                }
                if (!firstMainField.equals(currentMainField)) continue;
                rs = true;
            }
        }
        return rs;
    }

    public CoreBaseInfo transmit(Map hsData, CoreBaseInfo oldInfo) throws TaskExternalException {
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        this.currentData = hsData;
        try {
            block24: {
                block23: {
                    int size;
                    StringBuffer sb;
                    this.initPrimaryKey();
                    if (mode != 8) {
                        if (oldInfo == null) {
                            sb = new StringBuffer("select * where  ");
                            if (this.primaryKeys != null && this.primaryKeys.size() > 0) {
                                size = this.primaryKeys.size();
                                for (int i = 0; i < size; ++i) {
                                    DIETemplateFieldEntryInfo entryInfo = this.primaryKeys.get(i);
                                    if (i == 0) {
                                        sb.append(" ").append(this.replaceDollar(entryInfo.getEntityPropName())).append("=").append(this.getOqlValue(entryInfo.getEntityPropClass(), entryInfo.getNumber()));
                                        continue;
                                    }
                                    sb.append(" and ").append(this.replaceDollar(entryInfo.getEntityPropName())).append("=").append(this.getOqlValue(entryInfo.getEntityPropClass(), entryInfo.getNumber()));
                                }
                                CoreBaseCollection coll = this.getController(this.ctx).getCollection(sb.toString());
                                if (coll != null && coll.size() > 0) {
                                    oldInfo = coll.get(0);
                                }
                            }
                        }
                    } else if (oldInfo == null) {
                        sb = new StringBuffer("select id where  ");
                        StringBuffer sb1 = new StringBuffer("");
                        int size2 = this.primaryKeys.size();
                        if (size2 > 0) {
                            for (int i = 0; i < size2; ++i) {
                                DIETemplateFieldEntryInfo entryInfo = this.primaryKeys.get(i);
                                String replaceDollar = this.replaceDollar(entryInfo.getEntityPropName());
                                String oqlValue = this.getOqlValue(entryInfo.getEntityPropClass(), entryInfo.getNumber());
                                sb1.append(replaceDollar).append(" = ").append(oqlValue).append(",");
                                if (i == 0) {
                                    sb.append(" ").append(replaceDollar).append("=").append(oqlValue);
                                    continue;
                                }
                                sb.append(" and ").append(replaceDollar).append("=").append(oqlValue);
                            }
                            CoreBaseCollection coll = this.getController(this.ctx).getCollection(sb.toString());
                            if (coll != null && coll.size() > 0) {
                                String s = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "existBill", this.ctx.getLocale());
                                MessageFormat mf = new MessageFormat(s);
                                throw new TaskExternalException(mf.format(new Object[]{sb1.substring(0, sb1.length() - 1)}));
                            }
                        }
                    }
                    if (oldInfo == null) {
                        oldInfo = this.dataBinder.getDynValueClass();
                    } else {
                        if (this.eoInfo == null) {
                            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx);
                            this.eoInfo = loader.getEntity(this.getBOSObjectType(this.type));
                        }
                        PropertyCollection properties = this.eoInfo.getProperties();
                        size = properties.size();
                        for (int i = 0; i < size; ++i) {
                            PropertyInfo propertyInfo = properties.get(i);
                            if (!propertyInfo.isConfigured() || oldInfo.get(propertyInfo.getName()) != null || !this.dataBinder.isEntry(propertyInfo)) continue;
                            oldInfo.put(propertyInfo.getName(), (Object)new BillEntryCustomCollection());
                        }
                    }
                    if (this.getSubmitType() == 1) break block23;
                    if (this.getSubmitType() != 2) break block24;
                }
                this.dataBinder.setEntryRowIndex(this.getCurrentEntryRowIndex());
            }
            this.dataBinder.setCodeImplementTrans(this.isCodeImplementTrans);
            this.dataBinder.setUserDefineTrans(this.isUserDefineTrans);
            InfoClassValueProvider.setCtx(this.ctx);
            this.dataBinder.trans(hsData, oldInfo, mode);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return oldInfo;
    }

    private BOSObjectType getBOSObjectType(String bosType) {
        return BOSObjectType.create((String)bosType);
    }

    @Override
    public int getSubmitType() {
        if (this.existEntrys()) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getExportQueryInfo(Context ctx) {
        return this.templateInfo.getQueryName();
    }

    private boolean existEntrys() {
        return this.dataBinder.isExistEntrys();
    }

    private void queryColInfo(IRowSet rs) throws TaskExternalException {
        if (!this.hasQueryColType) {
            HashSet<String> queryCols = new HashSet<String>();
            DIETemplateFieldEntryCollection coll = this.templateInfo.getFieldEntries();
            try {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    DIETemplateFieldEntryInfo tmpInfo = coll.get(i);
                    if (!tmpInfo.isIsAutoMapping() || tmpInfo.getQueryPropName() == null || tmpInfo.getQueryPropName().equals("")) continue;
                    this.fieldQuery.put(tmpInfo.getNumber(), tmpInfo.getQueryPropName());
                    queryCols.add(tmpInfo.getQueryPropName());
                }
                ResultSetMetaData data = rs.getMetaData();
                int count = data.getColumnCount();
                for (int i = 1; i < count + 1; ++i) {
                    String tmp = data.getColumnName(i);
                    if (!queryCols.contains(tmp)) continue;
                    ColumnInfo info = new ColumnInfo();
                    info.setColumnType(data.getColumnType(i));
                    info.setQueryName(tmp);
                    this.queryColTypeMap.put(tmp, info);
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.hasQueryColType = true;
        }
    }

    private Object getResetColValue(IRowSet rs, String fieldNumber) throws SQLException, TaskExternalException {
        String queryName = (String)this.fieldQuery.get(fieldNumber);
        ColumnInfo cInfo = (ColumnInfo)this.queryColTypeMap.get(queryName);
        if (cInfo == null) {
            String errorMsg = EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "templateFiled_err", new Object[]{queryName});
            throw new TaskExternalException(errorMsg);
        }
        switch (cInfo.getColumnType()) {
            case 91: 
            case 92: 
            case 93: {
                Date d = rs.getDate(cInfo.getQueryName());
                if (d == null) {
                    return "";
                }
                logger.error((Object)("Debug(CtrlFormatUtilities.getDateTimeFormatString()):" + CtrlFormatUtilities.getDateTimeFormatString()));
                String strFormat = CtrlFormatUtilities.getDateTimeFormatString();
                SimpleDateFormat sdf = null;
                if (StringUtils.isNotEmpty((String)strFormat)) {
                    sdf = new SimpleDateFormat(strFormat);
                    logger.error((Object)("\u5df2\u83b7\u53d6\u65f6\u95f4\u683c\u5f0f\uff1a" + strFormat));
                } else {
                    sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    logger.error((Object)"\u4f7f\u7528\u9ed8\u8ba4\u5f15\u51fa\u65f6\u95f4\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss");
                }
                return sdf.format(d);
            }
        }
        return rs.getString(cInfo.getQueryName());
    }

    @Override
    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        this.queryColInfo(rs);
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator it = this.fieldQuery.keySet().iterator();
        try {
            while (it.hasNext()) {
                String fieldNumber = (String)it.next();
                Object value = this.getResetColValue(rs, fieldNumber);
                if (fieldNumber == null || value == null) continue;
                result.put(fieldNumber, value);
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public int getCurrentEntryRowIndex() {
        return this.currentEntryRowIndex;
    }

    public void setCurrentEntryRowIndex(int currentEntryRowIndex) {
        this.currentEntryRowIndex = currentEntryRowIndex;
    }

    public boolean isUserDefineTrans() {
        return this.isUserDefineTrans;
    }

    public void setUserDefineTrans(boolean isUserDefineTrans) {
        this.isUserDefineTrans = isUserDefineTrans;
    }

    public boolean isCodeImplementTrans() {
        return this.isCodeImplementTrans;
    }

    public void setCodeImplementTrans(boolean isCodeImplementTrans) {
        this.isCodeImplementTrans = isCodeImplementTrans;
    }

    private class ColumnInfo
    implements Serializable {
        private String fieldName = null;
        private String queryName = null;
        private int columnType = -1;

        private ColumnInfo() {
        }

        public int getColumnType() {
            return this.columnType;
        }

        public void setColumnType(int columnType) {
            this.columnType = columnType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getQueryName() {
            return this.queryName;
        }

        public void setQueryName(String queryName) {
            this.queryName = queryName;
        }
    }
}

