/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.app;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.tools.datatask.DEBaseInfo;
import com.kingdee.eas.tools.datatask.DEDataExportFactory;
import com.kingdee.eas.tools.datatask.DEDataExportImplHelper;
import com.kingdee.eas.tools.datatask.DEKSQLData;
import com.kingdee.eas.tools.datatask.DEScriptTypeEnum;
import com.kingdee.eas.tools.datatask.IDEDataExport;
import com.kingdee.eas.util.BASE64Encoder;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;

public class DEDataDealCenter {
    private DEBaseInfo dEBaseInfo = null;
    private DEScriptTypeEnum scType = null;
    private String nameStr = null;
    private BufferedWriter sqlOut = null;
    private XMLWriter xmlOut = null;
    private Element root = new DefaultElement("doc");
    private Document doc = DocumentHelper.createDocument((Element)this.root);
    private boolean isBlobOrClob = false;
    private IDEDataExport iDEDataExport = null;
    Logger logger = Logger.getLogger(DEDataDealCenter.class);

    public DEDataDealCenter(DEBaseInfo dEBaseInfo) {
        this.scType = dEBaseInfo.CUR_SCTYPE;
        this.nameStr = dEBaseInfo.CUR_CHAR_SEPERATOR;
        this.dEBaseInfo = dEBaseInfo;
    }

    public void deal(List tableList, Connection con) throws BOSException, IOException {
        String tableName;
        int i;
        ByteArrayOutputStream basqlout = new ByteArrayOutputStream();
        this.iDEDataExport = DEDataExportFactory.getDataExportImpl(this.dEBaseInfo.ExportDataType);
        this.dEBaseInfo.fidStr = DEDataExportImplHelper.addSeperator(this.iDEDataExport.getFidByNumber(this.dEBaseInfo, tableList, this.dEBaseInfo.numberStr, con));
        this.sqlOut = new BufferedWriter(new OutputStreamWriter((OutputStream)basqlout, "utf-8"));
        OutputFormat otf = OutputFormat.createPrettyPrint();
        otf.setTrimText(false);
        otf.setNewlines(true);
        StringWriter stringWriter = new StringWriter(1024);
        this.xmlOut = new XMLWriter((Writer)stringWriter, otf);
        String[] delStr = this.iDEDataExport.getDelStr(this.dEBaseInfo, tableList, this.dEBaseInfo.fidStr, con);
        if (delStr != null) {
            for (i = 0; i < delStr.length; ++i) {
                this.sqlOut.write(delStr[i]);
                this.sqlOut.newLine();
            }
        }
        for (i = 0; i < tableList.size(); ++i) {
            tableName = (String)tableList.get(i);
            this.insertData(tableName, this.dEBaseInfo.fidStr, con, delStr, false);
        }
        if (this.isBlobOrClob && this.iDEDataExport.isGenXml()) {
            this.xmlOut.write(this.doc);
        }
        this.sqlOut.newLine();
        this.sqlOut.write("--add upgrade script ");
        this.sqlOut.newLine();
        for (i = tableList.size() - 1; i >= 0; --i) {
            tableName = (String)tableList.get(i);
            String[] fids = this.dEBaseInfo.fidStr.split(",");
            for (int j = fids.length - 1; j >= 0; --j) {
                String fidStr = fids[j];
                if (StringUtils.isEmpty((String)fidStr)) continue;
                this.insertData(tableName, fidStr, con, delStr, true);
            }
        }
        this.sqlOut.flush();
        this.dEBaseInfo.sql = basqlout.toByteArray();
        this.dEBaseInfo.xml = stringWriter.toString().getBytes("utf-8");
    }

    private void addCondition(String tableName, String fidStr, BufferedWriter out, Connection con, ResultSet rs) throws IOException, BOSException, SQLException {
        StringBuffer whereStr = new StringBuffer();
        if (this.hasPK(rs)) {
            whereStr.append(" where fid ='").append(rs.getString("fid")).append("'");
        } else {
            IDEDataExport iDEDataExport = DEDataExportFactory.getDataExportImpl(this.dEBaseInfo.ExportDataType);
            whereStr.append(iDEDataExport.getWhereStr(this.dEBaseInfo, tableName, fidStr, con));
        }
        out.write("if not exists (select * from ");
        out.write(tableName);
        out.write(whereStr.toString());
        out.write(")");
    }

    private boolean hasPK(ResultSet rs) throws SQLException {
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            if (!"FID".equalsIgnoreCase(rs.getMetaData().getColumnName(i))) continue;
            return true;
        }
        return false;
    }

    private void insertData(String tableName, String fidStr, Connection con, String[] del, boolean hasUpdate) throws BOSException, IOException {
        Statement statement;
        ResultSet result;
        block12: {
            if (tableName == null || tableName.trim().length() == 0) {
                return;
            }
            result = null;
            statement = null;
            ResultSetMetaData restmd = null;
            this.sqlOut.newLine();
            try {
                statement = con.createStatement();
                IDEDataExport iDEDataExport = DEDataExportFactory.getDataExportImpl(this.dEBaseInfo.ExportDataType);
                String whereStr = iDEDataExport.getWhereStr(this.dEBaseInfo, tableName, fidStr, con);
                String sqlquery = "select * from " + tableName + whereStr;
                result = statement.executeQuery(sqlquery);
                restmd = result.getMetaData();
                StringBuffer colNames = new StringBuffer(125);
                int colCount = restmd.getColumnCount();
                String[] colsName = new String[colCount];
                String[] colsType = new String[colCount];
                int idx = 0;
                boolean hasBlobOrClob = false;
                for (int i = 1; i <= colCount; ++i) {
                    if (i == 1) {
                        colNames.append(restmd.getColumnName(i));
                    } else {
                        colNames.append(" , ").append(restmd.getColumnName(i));
                    }
                    int type = restmd.getColumnType(i);
                    if (type == 2004) {
                        hasBlobOrClob = true;
                        colsName[idx] = restmd.getColumnName(i);
                        colsType[idx] = "BLOB";
                        ++idx;
                        continue;
                    }
                    if (type == 2005) {
                        hasBlobOrClob = true;
                        colsName[idx] = restmd.getColumnName(i);
                        colsType[idx] = "CLOB";
                        ++idx;
                        continue;
                    }
                    if (type != 2011) continue;
                    hasBlobOrClob = true;
                    colsName[idx] = restmd.getColumnName(i);
                    colsType[idx] = "NCLOB";
                    ++idx;
                }
                if (hasBlobOrClob && iDEDataExport.isGenXml()) {
                    this.isBlobOrClob = true;
                    if (!hasUpdate) {
                        String[] colsName2 = new String[idx];
                        String[] colsType2 = new String[idx];
                        System.arraycopy(colsName, 0, colsName2, 0, idx);
                        System.arraycopy(colsType, 0, colsType2, 0, idx);
                        this.dealXml(tableName, result, colNames, colsName2, colsType2);
                    }
                    break block12;
                }
                this.dealSql(tableName, fidStr, con, hasUpdate, result, colNames);
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(result, (Statement)statement);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)result, (Statement)statement);
    }

    private void dealSql(String tableName, String fidStr, Connection con, boolean hasUpdate, ResultSet result, StringBuffer colNames) throws SQLException, IOException, BOSException {
        int iAllRow = 0;
        ResultSetMetaData restmd = result.getMetaData();
        int numberOfColumns = restmd.getColumnCount();
        while (result.next()) {
            ++iAllRow;
            if (hasUpdate) {
                this.addCondition(tableName, fidStr, this.sqlOut, con, result);
                this.sqlOut.newLine();
            }
            this.sqlOut.write("insert into ");
            this.sqlOut.write(tableName);
            this.sqlOut.write(" (");
            this.sqlOut.write(colNames.toString());
            this.sqlOut.write(")  values( ");
            if (DEScriptTypeEnum.KSQL == this.scType) {
                for (int i = 1; i <= numberOfColumns; ++i) {
                    if (i > 1) {
                        this.sqlOut.write(",");
                    }
                    this.sqlOut.write(DEKSQLData.dealData(result, i, this.iDEDataExport.isGenXml(), this.dEBaseInfo));
                }
            }
            this.sqlOut.write(")");
            this.sqlOut.write(this.nameStr);
            this.sqlOut.newLine();
        }
        this.sqlOut.newLine();
        this.sqlOut.write("--" + tableName + ":RowCount=" + iAllRow);
        this.sqlOut.newLine();
        this.sqlOut.flush();
    }

    private void dealXml(String tableName, ResultSet result, StringBuffer colNames, String[] colsName, String[] colsType) throws SQLException, IOException, BOSException {
        StringBuffer sqlStr = new StringBuffer();
        ResultSetMetaData restmd = result.getMetaData();
        int numberOfColumns = restmd.getColumnCount();
        BASE64Encoder encode = new BASE64Encoder();
        while (result.next()) {
            int i;
            sqlStr.setLength(0);
            DefaultElement item = new DefaultElement("item");
            DefaultElement sql = new DefaultElement("sql");
            DefaultElement para = new DefaultElement("para");
            sqlStr.append("insert into ").append(tableName).append(" (").append(colNames).append(")").append(" values(");
            if (DEScriptTypeEnum.KSQL == this.scType) {
                for (i = 1; i <= numberOfColumns; ++i) {
                    if (i > 1) {
                        sqlStr.append(",");
                    }
                    sqlStr.append(DEKSQLData.dealData(result, i, this.iDEDataExport.isGenXml(), this.dEBaseInfo));
                }
            }
            sqlStr.append(")");
            sql.setText(sqlStr.toString());
            item.add((Element)sql);
            for (i = 0; i < colsName.length; ++i) {
                byte[] b = null;
                String c = null;
                String colName = colsName[i];
                String colType = colsType[i];
                DefaultElement extRule = new DefaultElement(colName);
                extRule.addAttribute("dataInFile", "false");
                if (colType.equalsIgnoreCase("BLOB")) {
                    extRule.addAttribute("type", "7");
                    b = DEKSQLData.getBlobData(tableName, result, colName);
                } else if (colType.equalsIgnoreCase("CLOB")) {
                    extRule.addAttribute("type", "9");
                    c = DEKSQLData.getClobData(tableName, result, colName);
                } else if (colType.equalsIgnoreCase("NCLOB")) {
                    extRule.addAttribute("type", "9");
                    c = DEKSQLData.getClobData(tableName, result, colName);
                }
                if (b != null) {
                    extRule.addText(encode.encodeBuffer(b));
                } else if (c != null) {
                    extRule.addText(c);
                }
                para.add((Element)extRule);
            }
            item.add((Element)para);
            this.root.add((Element)item);
        }
    }
}

