/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.export;

import com.kingdee.eas.tools.datatask.export.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class AbstractExcel2007Writer {
    private static final Logger logger = Logger.getLogger(AbstractExcel2007Writer.class);
    private SpreadsheetWriter sw;
    private String defalutTempleteName = "template.xlsx";
    private String produceFileName;
    private XSSFWorkbook wb;
    Map<String, File> sheet_file = new HashMap<String, File>();

    public String getProduceFileName() {
        return this.produceFileName;
    }

    public void setProduceFileName(String produceFileName) {
        this.produceFileName = produceFileName;
    }

    public XSSFWorkbook getWb() {
        return this.wb;
    }

    public void setWb(XSSFWorkbook wb) {
        this.wb = wb;
    }

    public AbstractExcel2007Writer() {
        this.wb = new XSSFWorkbook();
    }

    public void putSheetFile(String sheetRef, File sheetXml) {
        this.sheet_file.put(sheetRef.substring(1), sheetXml);
    }

    public void processFile() throws Exception {
        FileOutputStream os = null;
        FileOutputStream out = null;
        try {
            os = new FileOutputStream(this.defalutTempleteName);
            this.wb.write((OutputStream)os);
            File templateFile = new File(this.defalutTempleteName);
            out = new FileOutputStream(this.produceFileName);
            AbstractExcel2007Writer.substitute(templateFile, this.sheet_file, out);
            if (templateFile.isFile() && templateFile.exists()) {
                templateFile.delete();
            }
            Iterator<String> it = this.sheet_file.keySet().iterator();
            logger.info((Object)("sheet_file\u6587\u4ef6\u4e2a\u6570\uff1a" + this.sheet_file.size() + ",hasNext\uff1a" + it.hasNext()));
            while (it.hasNext()) {
                File file = this.sheet_file.get(it.next());
                if (file != null && file.exists() && file.isFile()) {
                    logger.info((Object)("\u5f15\u51fa\u4efb\u52a1\u670d\u52a1\u5668\u7aef\u751f\u6210\u7684\u4e34\u65f6\u6587\u4ef6\u5927\u5c0f\uff1a" + file.length()));
                    file.delete();
                    continue;
                }
                logger.error((Object)("\u5f15\u51fa\u4efb\u52a1\u670d\u52a1\u5668\u7aef\u751f\u6210\u7684\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff1a" + file.getPath() + "," + file.getName()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u751f\u6210\u670d\u52a1\u7aef\u6587\u4ef6\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void beginSheet() throws IOException {
        this.sw.beginSheet();
    }

    public void beginWorkSheet() throws IOException {
        this.sw.beginWorkSheet();
    }

    public void beginSheetData() throws IOException {
        this.sw.beginSheetData();
    }

    public void endSheetData() throws IOException {
        this.sw.endSheetData();
    }

    public void endWorkSheet() throws IOException {
        this.sw.endWorkSheet();
    }

    public void beginMergeCells(int count) throws IOException {
        this.sw.beginMergeCells(count);
    }

    public void endMergeCells() throws IOException {
        this.sw.endMergeCells();
    }

    public void mergeCell(int r1, int c1, int r2, int c2) throws IOException {
        this.sw.mergeCell(r1, c1, r2, c2);
    }

    public void comment(String refId) throws IOException {
        this.sw.comment(refId);
    }

    public void insertRow(int rowNum) throws IOException {
        this.sw.insertRow(rowNum);
    }

    public void createCell(int columnIndex, String value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, double value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, float value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, float value, int styleIndex) throws IOException {
        this.sw.createCell(columnIndex, value, styleIndex);
    }

    public void createCell(int columnIndex, int value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, int value, int styleIndex) throws IOException {
        this.sw.createCell(columnIndex, value, styleIndex);
    }

    public void createCell(int columnIndex, BigDecimal value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, BigDecimal value, int styleIndex) throws IOException {
        this.sw.createCell(columnIndex, value, styleIndex);
    }

    public void createCell(int columnIndex, double value, int styleIndex) throws IOException {
        this.sw.createCell(columnIndex, value, styleIndex);
    }

    public void createCell(int columnIndex, String value, int styleIndex) throws IOException {
        this.sw.createCell(columnIndex, value, styleIndex);
    }

    public void createCell(int columnIndex, Date value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, Date value, int styleIndex) throws IOException {
        this.sw.createCell(columnIndex, value, styleIndex);
    }

    public void createCell(int columnIndex, boolean value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, boolean value, int styleIndex) throws IOException {
        this.sw.createCell(columnIndex, value, styleIndex);
    }

    public void beginCols() throws IOException {
        this.sw.beginCols();
    }

    public void endCols() throws IOException {
        this.sw.endCols();
    }

    public void insertDefaultColStyle(int col, int width, int styleIndex) throws IOException {
        this.sw.insertDefaultColStyle(col, width, styleIndex);
    }

    public void endRow() throws IOException {
        this.sw.endRow();
    }

    public void endSheet() throws IOException {
        this.sw.endSheet();
    }

    public SpreadsheetWriter getSw() {
        return this.sw;
    }

    public void setSw(SpreadsheetWriter sw) {
        this.sw = sw;
    }

    private static void substitute(File zipfile, Map map, OutputStream out) throws IOException {
        ZipOutputStream zos = null;
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipfile);
            zos = new ZipOutputStream(out);
            Enumeration<? extends ZipEntry> en = zip.entries();
            while (en.hasMoreElements()) {
                InputStream is;
                ZipEntry ze = en.nextElement();
                if (!map.containsKey(ze.getName())) {
                    zos.putNextEntry(new ZipEntry(ze.getName()));
                    is = zip.getInputStream(ze);
                    AbstractExcel2007Writer.copyStream(is, zos);
                    continue;
                }
                zos.putNextEntry(new ZipEntry(ze.getName()));
                is = new FileInputStream((File)map.get(ze.getName()));
                AbstractExcel2007Writer.copyStream(is, zos);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        try {
            int count;
            byte[] chunk = new byte[1024];
            while ((count = in.read(chunk)) >= 0) {
                out.write(chunk, 0, count);
            }
            out.flush();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        finally {
            in.close();
        }
    }

    public static class SpreadsheetWriter {
        private final Writer _out;
        private int _rownum;

        public Writer get_out() {
            return this._out;
        }

        public void endSheet() throws IOException {
            this.endWorkSheet();
            this.endSheetData();
        }

        public void beginSheet() throws IOException {
            this.beginWorkSheet();
            this.beginSheetData();
        }

        public SpreadsheetWriter(Writer out) {
            this._out = out;
        }

        public void beginWorkSheet() throws IOException {
            this._out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?><worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">");
        }

        public void endWorkSheet() throws IOException {
            this._out.write("</worksheet>");
        }

        public void beginSheetData() throws IOException {
            this._out.write("<sheetData>\n");
        }

        public void endSheetData() throws IOException {
            this._out.write("</sheetData>");
        }

        public void insertRow(int rownum) throws IOException {
            this._out.write("<row r=\"" + (rownum + 1) + "\">\n");
            this._rownum = rownum;
        }

        public void endRow() throws IOException {
            this._out.write("</row>\n");
        }

        public void beginMergeCells(int count) throws IOException {
            this._out.write("<mergeCells count=\"" + count + "\">");
        }

        public void endMergeCells() throws IOException {
            this._out.write("</mergeCells>");
        }

        public void mergeCell(int r1, int c1, int r2, int c2) throws IOException {
            String ref1 = new CellReference(r1, c1).formatAsString();
            String ref2 = new CellReference(r2, c2).formatAsString();
            this._out.write("<mergeCell ref=\"" + ref1 + ":" + ref2 + "\">");
            this._out.write("</mergeCell>");
        }

        public void beginCols() throws IOException {
            this._out.write("<cols>");
        }

        public void endCols() throws IOException {
            this._out.write("</cols>");
        }

        public void insertDefaultColStyle(int col, int width, int styleIndex) throws IOException {
            if (width <= 0) {
                width = 10;
            }
            this._out.write("<col min=\"" + col + "\" max=\"" + col + "\" width=\"" + width + "\" style=\"" + styleIndex + "\"/>");
        }

        public void createCell(int columnIndex, String value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"inlineStr\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<is><t>" + XmlUtil.convert(value) + "</t></is>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, String value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, float value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"n\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<v>" + value + "</v>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, float value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, int value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"n\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<v>" + value + "</v>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, BigDecimal value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, BigDecimal value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"n\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<v>" + value + "</v>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, int value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, double value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"n\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<v>" + value + "</v>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, Date value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, Date value, int styleIndex) throws IOException {
            this.createCell(columnIndex, DateUtil.getExcelDate((Date)value, (boolean)false), styleIndex);
        }

        public void createCell(int columnIndex, boolean value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, boolean value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"n\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<is><t>" + value + "</t></is>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, double value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, Calendar value, int styleIndex) throws IOException {
            this.createCell(columnIndex, DateUtil.getExcelDate((Calendar)value, (boolean)false), styleIndex);
        }

        public void comment(String refId) throws IOException {
            this._out.write("<legacyDrawing r:id=\"" + refId + "\"/>");
        }
    }
}

