/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.export;

import com.kingdee.eas.tools.datatask.export.AbstractExternalExcel2007SheetWriter;
import com.kingdee.eas.tools.datatask.export.Excel2007Writer;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ExternalExcelDataGridWriter
extends AbstractExternalExcel2007SheetWriter {
    private static final Logger logger = Logger.getLogger(ExternalExcelDataGridWriter.class);
    private ExternalStructInfo structInfo;

    public ExternalExcelDataGridWriter(Excel2007Writer excelWriter) {
        super(excelWriter);
    }

    @Override
    public void writeStruct(ExternalStructInfo structInfo) {
        this.structInfo = structInfo;
        super.writeStruct(structInfo);
        try {
            ArrayList<FieldPropertyInfo> fields = structInfo.getFieldCollection();
            int size = fields.size();
            String tilte = structInfo.getObjectDesc();
            if (StringUtils.isEmpty((String)tilte)) {
                this.insertRow(0);
                int curRow = 1;
                for (int i = 0; i < size; ++i) {
                    FieldPropertyInfo fpi = (FieldPropertyInfo)fields.get(i);
                    String fieldDesc = fpi.getFieldDesc();
                    int rowNum = fpi.getRowNumber();
                    int colNum = fpi.getFieldColNumber();
                    if (rowNum == curRow) {
                        if (colNum != -1) {
                            this.addOrgStructCell1(colNum, fieldDesc, false);
                            continue;
                        }
                        this.addOrgStructCell1(i, fieldDesc, false);
                        continue;
                    }
                    this.endRow();
                    curRow = rowNum;
                    this.insertRow(rowNum - 1);
                    if (colNum != -1) {
                        this.addOrgStructCell1(colNum, fieldDesc, false);
                        continue;
                    }
                    this.addOrgStructCell1(i, fieldDesc, false);
                }
                this.endRow();
                this.curRowNum = curRow;
            } else {
                this.insertRow(0);
                this.addTitleCell(0, tilte);
                this.endRow();
                this.insertRow(2);
                for (int i = 0; i < size; ++i) {
                    FieldPropertyInfo fpi = (FieldPropertyInfo)fields.get(i);
                    String fieldDesc = fpi.getFieldDesc();
                    this.addOrgStructCell1(i, fieldDesc, false);
                }
                this.endRow();
                this.curRowNum = 3;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected List<String> getFieldOrder() {
        ArrayList<String> rs = new ArrayList<String>();
        ArrayList<FieldPropertyInfo> fields = this.structInfo.getFieldCollection();
        ArrayList<FieldPropertyInfo> fields_ = new ArrayList<FieldPropertyInfo>();
        for (FieldPropertyInfo info : fields) {
            if (info.isVirtualField()) continue;
            fields_.add(info);
        }
        this.orderByColNumber(fields_);
        for (FieldPropertyInfo fpi : fields_) {
            rs.add(fpi.getFieldName());
        }
        return rs;
    }

    @Override
    protected void megeCell() throws IOException {
        String tilte = this.structInfo.getObjectDesc();
        if (StringUtils.isEmpty((String)tilte)) {
            ArrayList<FieldPropertyInfo> fields = this.structInfo.getFieldCollection();
            this.beginMergeCells(1);
            int i = 0;
            for (FieldPropertyInfo info : fields) {
                int rowNum = info.getRowNumber() - 1;
                int x = info.getXPoint() - 1;
                int y = info.getYPoint() - 1;
                if (x > 0 || y > 0) {
                    this.mergeCell(rowNum, rowNum + i, y, rowNum + i);
                }
                ++i;
            }
            this.endMergeCells();
            return;
        }
        this.beginMergeCells(1);
        this.mergeCell(0, 0, 1, this.structInfo.getFieldCollection().size() - 1);
        this.endMergeCells();
    }
}

