/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.export;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.tools.datatask.export.IExternalDataWriter;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelWritingException;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExternalExcelDataWriter
implements IExternalDataWriter {
    private static final Logger logger = CoreUIObject.getLogger(ExternalExcelDataWriter.class);
    private HSSFWorkbook workbook = null;
    private HSSFSheet sheet = null;
    private String fileName = "";
    private String sheetName = "";
    private int sheetPos = 0;
    private int curRowNum = -1;
    private Map keyCol = new HashMap();
    private Locale locale = null;
    private boolean isExportTemplate = true;
    private HSSFCellStyle orgStructStyle = null;
    private HSSFCellStyle orgStructStyle1 = null;
    private HSSFCellStyle orgStructNeedCellStyle = null;
    private HSSFCellStyle valueStyle = null;
    private HSSFCellStyle titleStyle = null;

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void writeCell(int row, int col, DataToken data) throws ExcelWritingException {
        if (data != null) {
            this.writeCell(row, col, data.data);
        } else {
            this.writeCell(row, col, "");
        }
    }

    public void writeCell(int row, int col, Object data) throws ExcelWritingException {
        if (this.sheet == null) {
            String detail = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "visitpage", this.locale) + this.sheetName + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fail", this.locale);
            ExcelWritingException err = new ExcelWritingException(detail);
            throw err;
        }
        try {
            this.addValueCell(this.sheet, row, col, data);
        }
        catch (Exception ex) {
            throw new ExcelWritingException(ex.getMessage(), ex.getCause());
        }
    }

    private void addOrgStructCell(HSSFSheet sht, int rowNum, int colNum, String value) throws Exception {
        HSSFCell cell = this.getCell(sht, rowNum, colNum);
        cell.setCellValue(value);
        cell.setCellStyle(this.orgStructStyle);
    }

    private void addOrgStructCell1(HSSFSheet sht, int rowNum, int colNum, String value, boolean isNecessary) throws Exception {
        HSSFCell cell = this.getCell(sht, rowNum, colNum);
        cell.setCellValue(value);
        if (isNecessary) {
            cell.setCellStyle(this.orgStructNeedCellStyle);
        } else {
            cell.setCellStyle(this.orgStructStyle1);
        }
        this.sheet.setDefaultColumnStyle((int)((short)colNum), (CellStyle)this.valueStyle);
    }

    private void addTitleCell(HSSFSheet sht, int rowNum, int colNum, String value) throws Exception {
        HSSFCell cell = this.getCell(sht, rowNum, colNum);
        cell.setCellValue(value);
        cell.setCellStyle(this.titleStyle);
    }

    private void addValueCell(HSSFSheet sht, int rowNum, int colNum, Object value) throws Exception {
        HSSFCell cell = this.getCell(sht, rowNum, colNum);
        if (value == null) {
            value = "";
        }
        if (value instanceof String) {
            cell.setCellType(CellType.STRING);
            cell.setCellValue((String)value);
            cell.setCellStyle(this.valueStyle);
        } else if (value instanceof Float) {
            cell.setCellValue((double)((Float)value).floatValue());
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)value).doubleValue());
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof HSSFRichTextString) {
            cell.setCellValue((RichTextString)((HSSFRichTextString)value));
        } else {
            cell.setCellType(CellType.STRING);
            cell.setCellValue(value.toString());
        }
    }

    private HSSFCell getCell(HSSFSheet sht, int rowNum, int colNum) {
        int rowCount = sht.getPhysicalNumberOfRows();
        HSSFRow row = null;
        row = rowNum >= rowCount ? sht.createRow(rowNum) : sht.getRow(rowNum);
        HSSFCell cell = row.getCell((int)((short)colNum));
        if (cell == null) {
            cell = row.createCell((int)((short)colNum));
        }
        return cell;
    }

    private void createOrgStructCellStyle() {
        this.orgStructStyle = null;
        if (this.orgStructStyle == null) {
            this.orgStructStyle = this.workbook.createCellStyle();
            this.orgStructStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.orgStructStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_CORNFLOWER_BLUE.getIndex());
            this.orgStructStyle.setAlignment(HorizontalAlignment.LEFT);
            this.orgStructStyle.setHidden(false);
            this.orgStructStyle.setLocked(false);
            this.orgStructStyle.setBorderLeft(BorderStyle.DOTTED);
            this.orgStructStyle.setBorderRight(BorderStyle.DOTTED);
            this.orgStructStyle.setBorderTop(BorderStyle.DOTTED);
            this.orgStructStyle.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.orgStructStyle.setBottomBorderColor(backColorIndex);
            this.orgStructStyle.setTopBorderColor(backColorIndex);
            this.orgStructStyle.setLeftBorderColor(backColorIndex);
            this.orgStructStyle.setRightBorderColor(backColorIndex);
            this.orgStructStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont defaultFont = this.workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.orgStructStyle.setFont(defaultFont);
        }
    }

    private void createOrgStructCellStyle1() {
        this.orgStructStyle1 = null;
        if (this.orgStructStyle1 == null) {
            this.orgStructStyle1 = this.workbook.createCellStyle();
            this.orgStructStyle1.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.orgStructStyle1.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
            this.orgStructStyle1.setAlignment(HorizontalAlignment.CENTER);
            this.orgStructStyle1.setHidden(false);
            this.orgStructStyle1.setLocked(false);
            this.orgStructStyle1.setBorderLeft(BorderStyle.DOTTED);
            this.orgStructStyle1.setBorderRight(BorderStyle.DOTTED);
            this.orgStructStyle1.setBorderTop(BorderStyle.DOTTED);
            this.orgStructStyle1.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.orgStructStyle1.setBottomBorderColor(backColorIndex);
            this.orgStructStyle1.setTopBorderColor(backColorIndex);
            this.orgStructStyle1.setLeftBorderColor(backColorIndex);
            this.orgStructStyle1.setRightBorderColor(backColorIndex);
            this.orgStructStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont defaultFont = this.workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.orgStructStyle1.setFont(defaultFont);
        }
    }

    private void createOrgStructNeedCellStyle() {
        this.orgStructNeedCellStyle = null;
        if (this.orgStructNeedCellStyle == null) {
            this.orgStructNeedCellStyle = this.workbook.createCellStyle();
            this.orgStructNeedCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.orgStructNeedCellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
            this.orgStructNeedCellStyle.setAlignment(HorizontalAlignment.CENTER);
            this.orgStructNeedCellStyle.setHidden(false);
            this.orgStructNeedCellStyle.setLocked(false);
            this.orgStructNeedCellStyle.setBorderLeft(BorderStyle.DOTTED);
            this.orgStructNeedCellStyle.setBorderRight(BorderStyle.DOTTED);
            this.orgStructNeedCellStyle.setBorderTop(BorderStyle.DOTTED);
            this.orgStructNeedCellStyle.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.orgStructNeedCellStyle.setBottomBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setTopBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setLeftBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setRightBorderColor(backColorIndex);
            this.orgStructNeedCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont defaultFont = this.workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.orgStructNeedCellStyle.setFont(defaultFont);
        }
    }

    private void createValueCellStyle() {
        this.valueStyle = null;
        if (this.valueStyle == null) {
            this.valueStyle = this.workbook.createCellStyle();
            this.valueStyle.setAlignment(HorizontalAlignment.LEFT);
            this.valueStyle.setHidden(true);
            this.valueStyle.setLocked(false);
            this.valueStyle.setBorderLeft(BorderStyle.DOTTED);
            this.valueStyle.setBorderRight(BorderStyle.DOTTED);
            this.valueStyle.setBorderTop(BorderStyle.DOTTED);
            this.valueStyle.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.valueStyle.setBottomBorderColor(backColorIndex);
            this.valueStyle.setTopBorderColor(backColorIndex);
            this.valueStyle.setLeftBorderColor(backColorIndex);
            this.valueStyle.setRightBorderColor(backColorIndex);
            this.valueStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont defaultFont = this.workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            this.valueStyle.setFont(defaultFont);
            this.valueStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        }
    }

    private void createTitleCellStyle() {
        this.titleStyle = null;
        if (this.titleStyle == null) {
            this.titleStyle = this.workbook.createCellStyle();
            this.titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.titleStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
            this.titleStyle.setAlignment(HorizontalAlignment.LEFT);
            this.titleStyle.setHidden(false);
            this.titleStyle.setLocked(false);
            this.titleStyle.setBorderLeft(BorderStyle.DOTTED);
            this.titleStyle.setBorderRight(BorderStyle.DOTTED);
            this.titleStyle.setBorderTop(BorderStyle.DOTTED);
            this.titleStyle.setBorderBottom(BorderStyle.DOTTED);
            short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
            this.titleStyle.setBottomBorderColor(backColorIndex);
            this.titleStyle.setTopBorderColor(backColorIndex);
            this.titleStyle.setLeftBorderColor(backColorIndex);
            this.titleStyle.setRightBorderColor(backColorIndex);
            this.titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            HSSFFont defaultFont = this.workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"46_ExternalExcelDataWriter"));
            defaultFont.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
            short size = 18;
            defaultFont.setFontHeight(size);
            defaultFont.setFontHeightInPoints(size);
            this.titleStyle.setFont(defaultFont);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HSSFWorkbook createOvercastWriter() throws Exception {
        try (FileInputStream is = null;){
            is = new FileInputStream(this.fileName);
            HSSFWorkbook writeBook = new HSSFWorkbook((InputStream)is);
            int numbCount = writeBook.getNumberOfSheets();
            for (int i = 0; i < numbCount; ++i) {
                String curSheetName = writeBook.getSheetName(i);
                if (curSheetName.compareTo(this.sheetName) != 0) continue;
                writeBook.removeSheetAt(i);
                break;
            }
            HSSFWorkbook hSSFWorkbook = writeBook;
            return hSSFWorkbook;
        }
    }

    @Override
    public void openWriter() throws TaskRunnerException {
        try {
            if (this.workbook == null) {
                String path = GlobalFunction.getFilePathForServer();
                this.workbook = GlobalFunction.isFileExists(path, this.fileName) ? this.createOvercastWriter() : new HSSFWorkbook();
            }
            this.createOrgStructCellStyle();
            this.createOrgStructCellStyle1();
            this.createOrgStructNeedCellStyle();
            this.createTitleCellStyle();
            this.createValueCellStyle();
        }
        catch (Exception err) {
            String detail = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "createexcelfile", this.locale) + this.fileName + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "exceptionhappen", this.locale) + "\n";
            detail = detail + err.getMessage();
            throw new TaskRunnerException(detail);
        }
        this.sheetPos = this.workbook.getNumberOfSheets();
        String tmpName = "sheet" + System.currentTimeMillis();
        this.sheet = this.workbook.createSheet(tmpName);
        if (this.sheetName == null || this.sheetName.equals("")) {
            this.sheetName = tmpName;
        }
        this.workbook.setSheetName(this.workbook.getSheetIndex(tmpName), this.sheetName);
        if (this.sheet == null) {
            String detail = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "createexcelfile", this.locale) + this.fileName;
            detail = detail + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "sheets", this.locale) + this.sheetName + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fail", this.locale);
            TaskRunnerException err = new TaskRunnerException(detail);
            throw err;
        }
    }

    @Override
    public void closeWriter() throws TaskRunnerException {
        OutputStream fos = null;
        try {
            if (this.workbook != null) {
                if (this.isExportTemplate) {
                    fos = new FileOutputStream(this.fileName);
                } else {
                    String path = GlobalFunction.getFilePathForServer();
                    File f = new File(path, this.fileName);
                    fos = new FileOutputStream(f);
                }
                this.workbook.write(fos);
                this.workbook = null;
            }
        }
        catch (Exception e) {
            throw new TaskRunnerException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "closefileexception", this.locale), (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    @Override
    public void writeStruct(ExternalStructInfo structInfo) {
        try {
            if (this.sheet == null) {
                String detail = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "visitpage", this.locale) + this.sheetName + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fail", this.locale);
                ExcelWritingException err = new ExcelWritingException(detail);
                throw err;
            }
            this.addOrgStructCell(this.sheet, 0, 0, structInfo.getProductName());
            this.addOrgStructCell(this.sheet, 0, 1, structInfo.getVersion());
            this.addOrgStructCell(this.sheet, 1, 0, structInfo.getObjectName());
            this.addOrgStructCell(this.sheet, 1, 1, structInfo.getObjectDesc());
            ArrayList<FieldPropertyInfo> fields = structInfo.getFieldCollection();
            int size = fields.size();
            this.sheet.addMergedRegion(new CellRangeAddress(0, 1, 2, (short)size - 1));
            this.addTitleCell(this.sheet, 0, 2, structInfo.getObjectDesc());
            this.orderByColNumber(fields);
            for (int i = 9; i < size; ++i) {
                this.addOrgStructCell(this.sheet, 0, i, "");
                this.addOrgStructCell(this.sheet, 1, i, "");
            }
            HSSFPatriarch p = this.sheet.createDrawingPatriarch();
            for (int i = 0; i < size; ++i) {
                FieldPropertyInfo fpi = (FieldPropertyInfo)fields.get(i);
                this.addOrgStructCell(this.sheet, 2, i, fpi.getFieldName());
                this.keyCol.put(fpi.getFieldName(), new Integer(i));
                String fieldDesc = fpi.getFieldDesc();
                if (fpi.getIsNecessary()) {
                    fieldDesc = "*" + fieldDesc;
                    this.addOrgStructCell1(this.sheet, 3, i, fieldDesc, true);
                } else {
                    this.addOrgStructCell1(this.sheet, 3, i, fieldDesc, false);
                }
                if (StringUtils.isEmpty((String)fpi.getFiledMemo())) continue;
                HSSFComment comment = p.createComment((HSSFAnchor)new HSSFClientAnchor(0, 0, 0, 0, (short)(3 + i), 3 + i, (short)(5 + i), 6 + i));
                comment.setString((RichTextString)new HSSFRichTextString(fpi.getFiledMemo()));
                HSSFCell cell = this.getCell(this.sheet, 3, i);
                cell.setCellComment((Comment)comment);
            }
            this.curRowNum = 4;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    private boolean isExistMemo(ExternalStructInfo structInfo) {
        if (structInfo == null) {
            return false;
        }
        if (structInfo.getComment() != null && !structInfo.getComment().equals("")) {
            return true;
        }
        ArrayList<FieldPropertyInfo> tmpfields = structInfo.getFieldCollection();
        int tmpsize = 0;
        if (tmpfields != null) {
            tmpsize = tmpfields.size();
            for (int i = 0; i < tmpsize; ++i) {
                FieldPropertyInfo fpInfo = (FieldPropertyInfo)tmpfields.get(i);
                if (fpInfo.getFiledMemo() == null) continue;
                return true;
            }
        }
        return false;
    }

    private void orderByColNumber(List<FieldPropertyInfo> fields) {
        if (fields == null || fields.size() <= 1) {
            return;
        }
        int size = fields.size();
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                FieldPropertyInfo fpii = fields.get(i);
                FieldPropertyInfo fpij = fields.get(j);
                if (fpii.getFieldColNumber() <= fpij.getFieldColNumber()) continue;
                fields.set(i, fpij);
                fields.set(j, fpii);
            }
        }
    }

    public boolean containsFieldName(String key) {
        return this.keyCol.containsKey(key);
    }

    @Override
    public void writeLine(Map data) throws TaskRunnerException {
        Iterator it = data.keySet().iterator();
        try {
            while (it.hasNext()) {
                String key = (String)it.next();
                int colNum = this.getColNumByFieldName(key);
                if (colNum < 0) continue;
                this.writeCell(this.curRowNum, colNum, data.get(key));
            }
            ++this.curRowNum;
        }
        catch (TaskRunnerException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new TaskRunnerException(ex.getMessage(), (Throwable)ex);
        }
    }

    private int getColNumByFieldName(String key) throws TaskRunnerException {
        Integer colNum = (Integer)this.keyCol.get(key);
        if (colNum == null) {
            return -1;
        }
        return colNum;
    }

    @Override
    public void setLocacle(Locale l) {
        this.locale = l;
    }

    @Override
    public Locale getLocacle() {
        return this.locale;
    }

    public boolean isExportTemplate() {
        return this.isExportTemplate;
    }

    public void setExportTemplate(boolean isExportTemplate) {
        this.isExportTemplate = isExportTemplate;
    }
}

