/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.AutoImportJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class AutImportSchedulerManager {
    private static final String jobName = "AutoImportJob";
    private static final String jobGroup = "DEFAULT";
    private static final String triggerName = "AutoImportTrigger";
    private static final String triggerGroup = "triggerGroup";
    private boolean isStartScheduleService = false;
    private static AutImportSchedulerManager manager = null;

    private AutImportSchedulerManager() {
    }

    public static AutImportSchedulerManager getInstance() {
        if (manager == null) {
            manager = new AutImportSchedulerManager();
        }
        return manager;
    }

    public boolean isStartSchedule() {
        return this.isStartScheduleService;
    }

    public void startScheduler(JobDetail jobDetail, CronTrigger trigger) throws TaskExternalException {
        try {
            Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            scheduler.start();
            this.isStartScheduleService = true;
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    public void startScheduler(String scheduleXML) throws TaskExternalException {
        String consExpre = this.getTriggerContent(scheduleXML);
        JobDetail jobDetail = JobBuilder.newJob(AutoImportJob.class).withIdentity(jobName, jobGroup).build();
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, jobGroup).startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)consExpre)).build();
        this.startScheduler(jobDetail, trigger);
    }

    public void stopSchedule() throws TaskExternalException {
        try {
            Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
            scheduler.deleteJob(new JobKey(jobName, jobGroup));
        }
        catch (SchedulerException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public void resumeScheduler(String scheduleXML) throws TaskExternalException {
        this.stopSchedule();
        this.startScheduler(scheduleXML);
    }

    private String getTriggerContent(String scheduleXML) throws TaskExternalException {
        ScheduleDef scheduleDef;
        try {
            scheduleDef = KpdlParser.parseSchedule((String)scheduleXML);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return scheduleDef.getDefine();
    }
}

