/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.tools.datatask.AutoImportCollection;
import com.kingdee.eas.tools.datatask.AutoImportFactory;
import com.kingdee.eas.tools.datatask.AutoImportInfo;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DatataskRunServerFactory;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.IAutoImport;
import com.kingdee.eas.tools.datatask.IDatataskRunServer;
import com.kingdee.eas.tools.datatask.log.LogGenerator;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.runtime.UploadFileToServerHelper;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import java.io.File;
import java.util.Date;
import org.apache.log4j.Logger;

public class AutoImportExecutor {
    private static final Logger logger = CoreUIObject.getLogger(AutoImportExecutor.class);
    private IDatataskRunServer iDatatask = null;
    private static final String LOGFILEPATH = "c:" + File.separator + "importlog" + File.separator;
    private static final String JGSTR = "_";
    private static final String MIDSTR = "-";
    private Date date = new Date();

    public void run() {
        this.execute();
    }

    public void run(String fid) {
        this.execute(fid);
    }

    private void execute() {
        this.execute(null);
    }

    private void execute(String fid) {
        logger.debug((Object)("start execute at:" + new Date()));
        try {
            AutoImportCollection coll;
            this.iDatatask = DatataskRunServerFactory.getRemoteInstance();
            IAutoImport ai = AutoImportFactory.getRemoteInstance();
            StringBuffer sb = new StringBuffer("select *,importObject.number,importObject.name,importObject.sheetName where state = 0");
            if (fid != null) {
                sb.setLength(0);
                sb.append("select *,importObject.number,importObject.name,importObject.sheetName where id = '").append(fid).append("'");
            }
            if ((coll = ai.getAutoImportCollection(sb.toString())) != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    String uuid = GlobalFunction.getUuID();
                    this.date = new Date();
                    try {
                        AutoImportInfo info = coll.get(i);
                        String fileName = info.getFilePath();
                        if (!this.isExist(fileName)) continue;
                        String serverTmpName = this.uploadFile2Server(fileName);
                        String fileType = GlobalFunction.getFileExtension(fileName);
                        DatataskParameter dp = this.constructImportParam(serverTmpName, info, uuid, fileType);
                        this.executeImport(dp);
                        TaskLog log = this.getFileLog(dp.getLogUuID());
                        this.clearServerTaskLog(uuid);
                        this.convertTaskLog2FileLog(log, info);
                        this.changeFileName(fileName);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)("error when auto importing data\u3002" + e));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("error when auto importing data\u3002" + e));
        }
    }

    private boolean isExist(String fileName) {
        File f = new File(fileName);
        return f.exists();
    }

    private String uploadFile2Server(String fileName) throws Exception {
        UploadFileToServerHelper helper = new UploadFileToServerHelper();
        String serverTmpFileName = helper.uploadFile(fileName);
        return serverTmpFileName;
    }

    private DatataskParameter constructImportParam(String serverFileName, AutoImportInfo info, String uuid, String fileType) {
        DatataskParameter param = new DatataskParameter();
        param.alias = info.getImportObject().getSheetName();
        param.datataskMode = 16;
        param.solutionName = info.getImportObject().getNumber();
        param.setOpenFileName(serverFileName);
        param.setLogUuID(uuid);
        param.setFileType(fileType);
        param.getContextParam().put("errorHandleMode", ErrorHandleModeEnum.ReturnWhenFinish);
        return param;
    }

    private void executeImport(DatataskParameter dp) throws Exception {
        this.iDatatask.runSingleTask(dp);
    }

    private TaskLog getFileLog(String uuid) throws Exception {
        return this.iDatatask.getTaskLog(uuid);
    }

    private void clearServerTaskLog(String uuid) throws Exception {
        this.iDatatask.clearTaskLog(uuid);
    }

    private void convertTaskLog2FileLog(TaskLog log, AutoImportInfo info) {
        String fileName = this.getFileNameFromPath(info.getFilePath());
        String logFileName = this.getLogFileName(fileName);
        LogGenerator.writeTaskLog2File(logFileName, log, info);
    }

    private String getFileNameFromPath(String filePath) {
        if (filePath == null) {
            return null;
        }
        int startP = filePath.lastIndexOf(File.separator) + 1;
        int endP = filePath.lastIndexOf(".");
        return filePath.substring(startP, endP);
    }

    private String getLogFileName(String dataFileName) {
        StringBuffer sb = new StringBuffer();
        sb.append(dataFileName).append(JGSTR).append(this.getDateStr()).append(".log");
        File f = new File(LOGFILEPATH);
        if (!f.exists() && !f.isFile()) {
            f.mkdirs();
        }
        return LOGFILEPATH + sb.toString();
    }

    private void changeFileName(String fileName) {
        File f = new File(fileName);
        StringBuffer sb = new StringBuffer();
        int startP = fileName.lastIndexOf(".");
        sb.append(fileName.substring(0, startP)).append(JGSTR).append(this.getDateStr()).append(fileName.substring(startP));
        File fnew = new File(sb.toString());
        f.renameTo(fnew);
    }

    private StringBuffer getDateStr() {
        Date d = this.date;
        StringBuffer sb = new StringBuffer();
        sb.append(d.getYear() + 1900).append(MIDSTR).append(d.getMonth() + 1).append(MIDSTR).append(d.getDate()).append(MIDSTR).append(d.getHours()).append(JGSTR).append(d.getMinutes());
        return sb;
    }

    public static void main(String[] args) {
        AutoImportExecutor executor = new AutoImportExecutor();
        executor.changeFileName("c:/temp.xls");
    }
}

