/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.tools.datatask.runtime.ExternalDataMeta;
import com.kingdee.eas.tools.datatask.runtime.ExternalDataRowInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.runtime.FileFormatNotStandardException;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;

public class ExternalExcelDataReader
extends AbstractExternalDataReader {
    private static final Logger logger = Logger.getLogger(ExternalExcelDataReader.class);
    private HSSFWorkbook workBook = null;
    private HashMap fieldKeys = new HashMap(3);
    private boolean isOpenSuccess = false;
    private int curRowNumber = -1;
    private HSSFSheet sheet = null;
    private boolean existFNumber = false;
    private boolean isCheckFNumber = false;
    private int FNumberPosition = -1;
    private int rowCount = 0;
    private InputStream is = null;

    @Override
    public boolean hasNext() throws TaskRunnerException {
        if (!this.isOpenSuccess) {
            throw new TaskRunnerException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "openDataFile", this.locale));
        }
        if (this.curRowNumber == -1) {
            this.curRowNumber = this.rowInfo.getRowOfDataStart() + this.curRowNumber + 1;
            return this.curRowNumber <= this.rowCount - 1;
        }
        if (this.curRowNumber < this.rowCount - 1) {
            ++this.curRowNumber;
            return true;
        }
        return false;
    }

    @Override
    public void calculatorRowCount() {
        this.rowCount = this.sheet.getPhysicalNumberOfRows();
    }

    private HSSFCell[] getCells(HSSFRow row) {
        if (row == null) {
            return null;
        }
        int count = row.getLastCellNum() + 1;
        HSSFCell[] cells = new HSSFCell[count];
        for (int i = 0; i < count; ++i) {
            cells[i] = row.getCell((int)((short)i));
        }
        return cells;
    }

    private HSSFCell getCell(HSSFRow row, int cellNum) {
        return row.getCell((int)((short)cellNum));
    }

    private HSSFCell[] getCells(HSSFSheet hssfSheet, int rowNum) {
        HSSFRow row = hssfSheet.getRow(rowNum);
        return this.getCells(row);
    }

    private String getCellValue(HSSFCell cell) {
        return ExcelUtil.getCellValue(cell);
    }

    @Override
    public Hashtable getNext() throws TaskRunnerException {
        Hashtable<String, DataToken> data = new Hashtable<String, DataToken>();
        HSSFRow row = this.sheet.getRow(this.curRowNumber);
        if (row == null) {
            ++this.rowCount;
            return data;
        }
        HSSFCell[] values = this.getCells(row);
        if (values.length <= 0) {
            return data;
        }
        ArrayList<FieldPropertyInfo> fields = this.info.getFieldCollection();
        int blankCount = 0;
        int size = fields.size();
        String cellValue = "";
        for (int i = 0; i < size; ++i) {
            DataToken value;
            String fieldName;
            FieldPropertyInfo fi = (FieldPropertyInfo)fields.get(i);
            int tmpColNumber = fi.getFieldColNumber();
            String string = fieldName = fi.getFieldName() == null ? "" : fi.getFieldName().trim();
            if (tmpColNumber < values.length) {
                value = new DataToken();
                value.name = fieldName;
                value.desc = fi.getFieldDesc();
                try {
                    CellType fieldType = fi.getFieldType();
                    if (fieldType != CellType.STRING) {
                        values[tmpColNumber].setCellType(fieldType);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new TaskRunnerException(e.getMessage(), (Throwable)e);
                }
                cellValue = this.getCellValue(values[tmpColNumber]);
                Object object = value.data = cellValue == null ? "" : cellValue;
                if (value.data.equals("")) {
                    ++blankCount;
                }
                value.type = String.valueOf(values[tmpColNumber] == null ? Integer.valueOf(1) : values[tmpColNumber].getCellType());
                data.put(fieldName, value);
                continue;
            }
            value = new DataToken();
            value.name = fieldName;
            value.type = "Label";
            value.data = "";
            data.put(fieldName, value);
            ++blankCount;
        }
        row = null;
        values = null;
        if (blankCount == data.size()) {
            data.clear();
            return data;
        }
        DataToken value = new DataToken();
        this.checkExistFNumber(this.info);
        if (this.existFNumber) {
            for (int preRowNumber = this.curRowNumber - 1; preRowNumber >= this.rowInfo.getRowOfDataStart(); --preRowNumber) {
                HSSFRow rowtmp = this.sheet.getRow(preRowNumber);
                if (rowtmp == null || "".equals(cellValue = this.getCellValue(this.getCell(rowtmp, this.FNumberPosition)))) continue;
                value.data = cellValue;
                value.name = "PreviousNumber";
                value.type = "Label";
                data.put(value.name, value);
                break;
            }
        }
        return data;
    }

    private void checkExistFNumber(ExternalStructInfo info) {
        if (this.isCheckFNumber) {
            return;
        }
        ArrayList<FieldPropertyInfo> fields = info.getFieldCollection();
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            FieldPropertyInfo fi = (FieldPropertyInfo)fields.get(i);
            if (!"FNumber".equalsIgnoreCase(fi.getFieldName())) continue;
            this.existFNumber = true;
            this.isCheckFNumber = true;
            this.FNumberPosition = i;
        }
    }

    @Override
    public int getCurrentRow() {
        return this.curRowNumber + this.rowInfo.getRowOfDataStart();
    }

    @Override
    public int getRowOfCurrentData() {
        return this.curRowNumber;
    }

    @Override
    public void openFile(String fileName) throws FileFormatNotStandardException {
        this.openFile(fileName, null);
    }

    @Override
    public ExternalStructInfo getExternalStructInfo() {
        return this.info;
    }

    public ArrayList getSheetNameCollection(String fileName) throws Exception {
        HSSFWorkbook tmpBook = null;
        ArrayList<String> nameList = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            tmpBook = new HSSFWorkbook((InputStream)fis);
            int sheetCount = tmpBook.getNumberOfSheets();
            nameList = new ArrayList<String>();
            for (int i = 0; i < sheetCount; ++i) {
                nameList.add(tmpBook.getSheetName(i));
            }
        }
        catch (Exception err) {
            throw err;
        }
        finally {
            if (tmpBook != null) {
                tmpBook = null;
            }
            if (fis != null) {
                ((InputStream)fis).close();
                fis = null;
            }
        }
        return nameList;
    }

    @Override
    public void openFile(String fileName, String sheetName) throws FileFormatNotStandardException {
        File excelFile = new File(fileName);
        this.openFile(excelFile, sheetName);
    }

    @Override
    public void openFile(InputStream file, String sheetName) throws FileFormatNotStandardException {
        HSSFWorkbook wb = null;
        try {
            wb = new HSSFWorkbook(file);
            this.is = file;
        }
        catch (Exception e) {
            logger.error((Object)("open file failed:" + e));
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "openFileFail", this.locale));
        }
        this.init(wb, sheetName);
    }

    @Override
    public void openFile(InputStream file) throws FileFormatNotStandardException {
        this.openFile(file, null);
    }

    @Override
    public void openFile(File file) throws FileFormatNotStandardException {
        this.openFile(file, null);
    }

    public void init(HSSFWorkbook wb, String sheetName) throws FileFormatNotStandardException {
        int i;
        try {
            this.workBook = wb;
            this.fileName = this.workBook.toString();
        }
        catch (Exception e) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "openFileFail", this.locale));
        }
        if (sheetName == null || sheetName.equals("")) {
            this.sheet = this.workBook.getSheetAt(0);
            sheetName = this.workBook.getSheetName(0);
        } else {
            this.sheet = this.workBook.getSheet(sheetName);
        }
        if (this.sheet == null) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "notFoundInFile", this.locale) + sheetName + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "anSheet", this.locale));
        }
        this.calculatorRowCount();
        HSSFCell[] cells = null;
        for (i = 0; i < this.rowCount; ++i) {
            cells = this.getCells(this.sheet, i);
            if (ExcelUtil.isBlankRow(cells)) continue;
            this.getProductAndVersion(cells);
            this.rowInfo.setRowOfVersion(i);
            break;
        }
        if (this.rowInfo.getRowOfVersion() < 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "templateError", this.locale));
        }
        for (i = this.rowInfo.getRowOfVersion() + 1; i < this.rowCount; ++i) {
            cells = this.getCells(this.sheet, i);
            if (ExcelUtil.isBlankRow(cells)) continue;
            this.getObject(cells);
            this.rowInfo.setRowOfObject(i);
            break;
        }
        if (this.rowInfo.getRowOfObject() <= 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "objectNameError", this.locale));
        }
        for (i = this.rowInfo.getRowOfObject() + 1; i < this.rowCount; ++i) {
            cells = this.getCells(this.sheet.getRow(i));
            if (ExcelUtil.isBlankRow(cells)) continue;
            this.getFieldName(cells);
            this.rowInfo.setRowOfFieldName(i);
            break;
        }
        if (this.rowInfo.getRowOfFieldName() <= 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "notFoundDefinition", this.locale));
        }
        for (i = this.rowInfo.getRowOfFieldName() + 1; i < this.rowCount; ++i) {
            cells = this.getCells(this.sheet.getRow(i));
            if (ExcelUtil.isBlankRow(cells)) continue;
            this.getFieldDesc(cells);
            this.rowInfo.setRowOfFieldDesc(i);
            break;
        }
        if (this.rowInfo.getRowOfFieldDesc() <= 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "definitionError", this.locale));
        }
        for (i = this.rowInfo.getRowOfFieldDesc() + 1; i < this.rowCount; ++i) {
            cells = this.getCells(this.sheet.getRow(i));
            if (ExcelUtil.isBlankRow(cells)) continue;
            if (this.getCellValue(cells[0]) != null && this.getCellValue(cells[0]).trim().equals("/*****")) {
                this.rowInfo.setRowOfCommentStart(i);
                break;
            }
            this.rowInfo.setRowOfCommentStart(-1);
            break;
        }
        if (this.rowInfo.getRowOfCommentStart() == -1) {
            this.rowInfo.setRowOfCommentEnd(-1);
            this.rowInfo.setRowOfDataStart(this.rowInfo.getRowOfFieldDesc() + 1);
        } else {
            for (i = this.rowInfo.getRowOfCommentStart() + 1; i < this.rowCount; ++i) {
                cells = this.getCells(this.sheet.getRow(i));
                if (ExcelUtil.isBlankRow(cells) || this.getCellValue(cells[0]) == null || !this.getCellValue(cells[0]).trim().equals("//*****")) continue;
                this.rowInfo.setRowOfCommentEnd(i);
                this.rowInfo.setRowOfDataStart(i + 1);
                break;
            }
            if (this.rowInfo.getRowOfCommentEnd() <= 0) {
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "noEndLine", this.locale));
            }
        }
        this.info.setFileName(this.fileName);
        this.info.setSheetName(sheetName);
        cells = null;
        this.isOpenSuccess = true;
    }

    @Override
    public void openFile(File file, String sheetName) throws FileFormatNotStandardException {
        try {
            FileInputStream fis = new FileInputStream(file);
            this.openFile(fis, sheetName);
        }
        catch (FileFormatNotStandardException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "openFileFail", this.locale));
        }
    }

    private void getProductAndVersion(HSSFCell[] cells) throws FileFormatNotStandardException {
        String tmp = null;
        for (int i = 0; i < cells.length; ++i) {
            tmp = this.getCellValue(cells[i]);
            if (tmp == null || tmp.equals("")) continue;
            if (!tmp.trim().equals(ExternalDataMeta.productName) && !"EAS".equals(tmp.trim())) {
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "productNameIncorrent", this.locale));
            }
            this.info.setProductName(tmp);
            break;
        }
        for (int j = i + 1; j < cells.length; ++j) {
            tmp = this.getCellValue(cells[j]);
            if (tmp == null || tmp.equals("")) continue;
            if (!tmp.trim().equals(ExternalDataMeta.productVersion)) {
                // empty if block
            }
            this.info.setVersion(tmp);
            break;
        }
    }

    private void getObject(HSSFCell[] cells) throws FileFormatNotStandardException {
        String tmp = null;
        for (int i = 0; i < cells.length; ++i) {
            tmp = this.getCellValue(cells[i]);
            if (tmp == null || tmp.equals("")) continue;
            this.info.setObjectName(tmp);
            break;
        }
    }

    private void getFieldName(HSSFCell[] cells) throws FileFormatNotStandardException {
        String tmp = "";
        for (int i = 0; i < cells.length; ++i) {
            tmp = this.getCellValue(cells[i]);
            if (this.fieldKeys.containsValue(tmp)) {
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "sameField", this.locale) + tmp + ")");
            }
            if (tmp == null || tmp.equals("")) continue;
            this.fieldKeys.put(new Integer(i), tmp);
        }
    }

    private void getFieldDesc(HSSFCell[] cells) throws FileFormatNotStandardException {
        String tmp = "";
        for (int i = 0; i < cells.length; ++i) {
            tmp = this.getCellValue(cells[i]);
            if (tmp == null || tmp.equals("")) continue;
            FieldPropertyInfo tmpField = new FieldPropertyInfo();
            if (this.fieldKeys.get(new Integer(i)) != null) {
                tmpField.setFieldName((String)this.fieldKeys.get(new Integer(i)));
                if (tmp.indexOf("*") == 0 && tmp.length() == 1) {
                    throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "desIncorrect", this.locale));
                }
                if (tmp.indexOf("*") == 0) {
                    tmpField.setFieldDesc(tmp.substring(1));
                    tmpField.setIsNecessary(true);
                } else {
                    tmpField.setFieldDesc(tmp);
                }
            } else {
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "notFoundDesc", this.locale) + tmp + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fieldDefinition", this.locale));
            }
            tmpField.setFieldType(cells[i].getCellType());
            tmpField.setFieldColNumber(i);
            this.info.addField(tmpField);
        }
    }

    @Override
    public ExternalDataRowInfo getExternalDataRowInfo() {
        return this.rowInfo;
    }

    @Override
    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.workBook != null) {
            this.workBook = null;
        }
    }

    @Override
    public boolean hasNextRecord() throws TaskRunnerException {
        return this.hasNext();
    }

    @Override
    public IRecord getNextRecord() throws TaskRunnerException {
        Hashtable data = this.getNext();
        return this.convertToRecord(data);
    }

    private IRecord convertToRecord(Map data) {
        SimpleRecord rec = new SimpleRecord();
        rec.setRowNum(this.curRowNumber + 1);
        Set keys = data.keySet();
        for (String key : keys) {
            rec.put(key, (DataToken)data.get(key));
        }
        return rec;
    }
}

