/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelXUtil;
import com.kingdee.eas.tools.datatask.runtime.ExternalDataMeta;
import com.kingdee.eas.tools.datatask.runtime.ExternalDataRowInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.runtime.FileFormatNotStandardException;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExternalExcelXDataReader
extends AbstractExternalDataReader {
    private static final Logger logger = Logger.getLogger(ExternalExcelDataReader.class);
    private XSSFWorkbook workBook = null;
    private HashMap fieldKeys = new HashMap(3);
    private boolean isOpenSuccess = false;
    private int curRowNumber = -1;
    private XSSFSheet sheet = null;
    private boolean existFNumber = false;
    private boolean isCheckFNumber = false;
    private int FNumberPosition = -1;
    private int rowCount = 0;
    private InputStream is = null;
    private boolean isImportTemplate = false;
    private SharedStringsTable sst;
    private String lastContents;
    private boolean nextIsString;
    private int sheetIndex = -1;
    private List rowlist = new ArrayList();
    private BlockingQueue blocklist = new ArrayBlockingQueue(500);
    private String endFlag = "positionPills";
    private int blockRowNum = 0;
    private int curRow = 0;
    private int curCol = 0;
    private int preCol = 0;
    private List sheetNameList = null;
    protected int formatIndex;
    protected String formatString;
    private boolean continueCondition = true;
    private boolean isFishParse = false;
    ExcelXParserThread parseThread = null;
    private boolean hasErrorColumn = false;
    StylesTable stylesTable;
    private String stylesIndex = "";

    @Override
    public boolean hasNext() throws TaskRunnerException {
        return !this.isFishParse;
    }

    @Override
    public void calculatorRowCount() {
        this.rowCount = this.sheet.getPhysicalNumberOfRows();
    }

    private XSSFCell[] getCells(XSSFRow row) {
        if (row == null) {
            return null;
        }
        int count = row.getLastCellNum() + 1;
        XSSFCell[] cells = new XSSFCell[count];
        for (int i = 0; i < count; ++i) {
            cells[i] = row.getCell((int)((short)i));
        }
        return cells;
    }

    private XSSFCell getCell(XSSFRow row, int cellNum) {
        return row.getCell((int)((short)cellNum));
    }

    private XSSFCell[] getCells(XSSFSheet XSSFSheet2, int rowNum) {
        XSSFRow row = XSSFSheet2.getRow(rowNum);
        return this.getCells(row);
    }

    private String getCellValue(XSSFCell cell) {
        return ExcelXUtil.getCellValue(cell);
    }

    @Override
    public Map getNext() throws TaskRunnerException {
        HashMap<String, DataToken> data = new HashMap<String, DataToken>();
        List outputlist = new ArrayList();
        try {
            Object obj = this.blocklist.take();
            if (obj instanceof TaskRunnerException) {
                throw (TaskRunnerException)((Object)obj);
            }
            if (obj instanceof String && obj.toString().equals(this.endFlag)) {
                this.isFishParse = true;
                return data;
            }
            Object[][] array = (Object[][])obj;
            this.blockRowNum = (Integer)array[0][0];
            outputlist = (List)array[0][1];
        }
        catch (InterruptedException e) {
            this.blocklist.clear();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        int blankCount = 0;
        String cellValue = "";
        ArrayList<FieldPropertyInfo> fields = this.info.getFieldCollection();
        for (int i = 0; i < fields.size(); ++i) {
            DataToken value;
            String fieldName;
            FieldPropertyInfo fi = (FieldPropertyInfo)fields.get(i);
            int tmpColNumber = fi.getFieldColNumber();
            String string = fieldName = fi.getFieldName() == null ? "" : fi.getFieldName().trim();
            if (tmpColNumber < outputlist.size()) {
                value = new DataToken();
                value.name = fieldName;
                value.desc = fi.getFieldDesc();
                cellValue = (String)outputlist.get(tmpColNumber);
                Object object = value.data = cellValue == null ? "" : cellValue.trim();
                if (value.data.equals("")) {
                    ++blankCount;
                }
                data.put(fieldName, value);
                continue;
            }
            value = new DataToken();
            value.name = fieldName;
            value.type = "Label";
            value.data = "";
            data.put(fieldName, value);
            ++blankCount;
        }
        if (blankCount == data.size()) {
            data.clear();
            return data;
        }
        return data;
    }

    private void checkExistFNumber(ExternalStructInfo info) {
        if (this.isCheckFNumber) {
            return;
        }
        ArrayList<FieldPropertyInfo> fields = info.getFieldCollection();
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            FieldPropertyInfo fi = (FieldPropertyInfo)fields.get(i);
            if (!"FNumber".equalsIgnoreCase(fi.getFieldName())) continue;
            this.existFNumber = true;
            this.isCheckFNumber = true;
            this.FNumberPosition = i;
        }
    }

    @Override
    public int getCurrentRow() {
        return this.curRowNumber + this.rowInfo.getRowOfDataStart();
    }

    @Override
    public int getRowOfCurrentData() {
        return this.curRowNumber;
    }

    @Override
    public void openFile(String fileName) throws FileFormatNotStandardException {
        this.openFile(fileName, null);
    }

    @Override
    public ExternalStructInfo getExternalStructInfo() {
        this.info.setLocale(this.locale);
        return this.info;
    }

    public ArrayList getSheetNameCollection(String fileName) throws Exception {
        OPCPackage pkg = OPCPackage.open((String)fileName);
        XSSFReader r = new XSSFReader(pkg);
        XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
        ArrayList<String> nameList = new ArrayList<String>();
        while (sheets.hasNext()) {
            sheets.next();
            nameList.add(sheets.getSheetName());
        }
        pkg.close();
        return nameList;
    }

    @Override
    public void openFile(String fileName, String sheetName) throws FileFormatNotStandardException {
        if (this.isImportTemplate) {
            File excelFile = new File(fileName);
            this.openFile(excelFile, sheetName);
        } else {
            try {
                OPCPackage pkg = OPCPackage.open((String)fileName);
                XSSFReader r = new XSSFReader(pkg);
                XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
                this.sheetNameList = new ArrayList();
                while (sheets.hasNext()) {
                    sheets.next();
                    this.sheetNameList.add(sheets.getSheetName());
                }
                pkg.close();
            }
            catch (Exception e) {
                logger.error((Object)("open file failed:" + e));
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "openFileFail", this.locale));
            }
            this.parseThread = new ExcelXParserThread(fileName, sheetName);
            this.parseThread.start();
        }
    }

    @Override
    public void openFile(String fileName, int sheetIndex) throws FileFormatNotStandardException {
        try {
            OPCPackage pkg = OPCPackage.open((String)fileName);
            XSSFReader r = new XSSFReader(pkg);
            XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
            this.sheetNameList = new ArrayList();
            while (sheets.hasNext()) {
                sheets.next();
                this.sheetNameList.add(sheets.getSheetName());
            }
            pkg.close();
        }
        catch (Exception e) {
            logger.error((Object)("open file failed:" + e));
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "openFileFail", this.locale));
        }
        this.parseThread = new ExcelXParserThread(fileName, (String)this.sheetNameList.get(sheetIndex));
        this.parseThread.start();
    }

    @Override
    public void openFile(InputStream file, String sheetName) throws FileFormatNotStandardException {
        XSSFWorkbook wb = null;
        try {
            wb = new XSSFWorkbook(file);
            this.is = file;
        }
        catch (Exception e) {
            logger.error((Object)("open file failed:" + e));
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "openFileFail", this.locale));
        }
        this.init(wb, sheetName);
    }

    @Override
    public void openFile(InputStream file) throws FileFormatNotStandardException {
        this.openFile(file, null);
    }

    @Override
    public void openFile(File file) throws FileFormatNotStandardException {
        this.openFile(file, null);
    }

    public void init(XSSFWorkbook wb, String sheetName) throws FileFormatNotStandardException {
        int i;
        try {
            this.workBook = wb;
            this.fileName = this.workBook.toString();
        }
        catch (Exception e) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "openFileFail", this.locale));
        }
        if (sheetName == null || sheetName.equals("")) {
            this.sheet = this.workBook.getSheetAt(0);
            sheetName = this.workBook.getSheetName(0);
        } else {
            this.sheet = this.workBook.getSheet(sheetName);
        }
        if (this.sheet == null) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "notFoundInFile", this.locale) + sheetName + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "anSheet", this.locale));
        }
        this.calculatorRowCount();
        XSSFCell[] cells = null;
        for (i = 0; i < this.rowCount; ++i) {
            cells = this.getCells(this.sheet, i);
            if (ExcelXUtil.isBlankRow(cells)) continue;
            this.getProductAndVersion(cells);
            this.rowInfo.setRowOfVersion(i);
            break;
        }
        if (this.rowInfo.getRowOfVersion() < 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "templateError", this.locale));
        }
        for (i = this.rowInfo.getRowOfVersion() + 1; i < this.rowCount; ++i) {
            cells = this.getCells(this.sheet, i);
            if (ExcelXUtil.isBlankRow(cells)) continue;
            this.getObject(cells);
            this.rowInfo.setRowOfObject(i);
            break;
        }
        if (this.rowInfo.getRowOfObject() <= 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "objectNameError", this.locale));
        }
        for (i = this.rowInfo.getRowOfObject() + 1; i < this.rowCount; ++i) {
            cells = this.getCells(this.sheet.getRow(i));
            if (ExcelXUtil.isBlankRow(cells)) continue;
            this.getFieldName(cells);
            this.rowInfo.setRowOfFieldName(i);
            break;
        }
        if (this.rowInfo.getRowOfFieldName() <= 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "notFoundDefinition", this.locale));
        }
        for (i = this.rowInfo.getRowOfFieldName() + 1; i < this.rowCount; ++i) {
            cells = this.getCells(this.sheet.getRow(i));
            if (ExcelXUtil.isBlankRow(cells)) continue;
            this.getFieldDesc(cells);
            this.rowInfo.setRowOfFieldDesc(i);
            break;
        }
        if (this.rowInfo.getRowOfFieldDesc() <= 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "definitionError", this.locale));
        }
        for (i = this.rowInfo.getRowOfFieldDesc() + 1; i < this.rowCount; ++i) {
            cells = this.getCells(this.sheet.getRow(i));
            if (ExcelXUtil.isBlankRow(cells)) continue;
            if (this.getCellValue(cells[0]) != null && this.getCellValue(cells[0]).trim().equals("/*****")) {
                this.rowInfo.setRowOfCommentStart(i);
                break;
            }
            this.rowInfo.setRowOfCommentStart(-1);
            break;
        }
        if (this.rowInfo.getRowOfCommentStart() == -1) {
            this.rowInfo.setRowOfCommentEnd(-1);
            this.rowInfo.setRowOfDataStart(this.rowInfo.getRowOfFieldDesc() + 1);
        } else {
            for (i = this.rowInfo.getRowOfCommentStart() + 1; i < this.rowCount; ++i) {
                cells = this.getCells(this.sheet.getRow(i));
                if (ExcelXUtil.isBlankRow(cells) || this.getCellValue(cells[0]) == null || !this.getCellValue(cells[0]).trim().equals("//*****")) continue;
                this.rowInfo.setRowOfCommentEnd(i);
                this.rowInfo.setRowOfDataStart(i + 1);
                break;
            }
            if (this.rowInfo.getRowOfCommentEnd() <= 0) {
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "noEndLine", this.locale));
            }
        }
        this.info.setFileName(this.fileName);
        this.info.setSheetName(sheetName);
        cells = null;
        this.isOpenSuccess = true;
    }

    @Override
    public void openFile(File file, String sheetName) throws FileFormatNotStandardException {
        try {
            FileInputStream fis = new FileInputStream(file);
            this.openFile(fis, sheetName);
        }
        catch (FileFormatNotStandardException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "openFileFail", this.locale));
        }
    }

    private void getProductAndVersion(XSSFCell[] cells) throws FileFormatNotStandardException {
        String tmp = null;
        for (int i = 0; i < cells.length; ++i) {
            tmp = this.getCellValue(cells[i]);
            if (tmp == null || tmp.equals("")) continue;
            if (!tmp.trim().equals(ExternalDataMeta.productName) && !"EAS".equals(tmp.trim())) {
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "productNameIncorrent", this.locale));
            }
            this.info.setProductName(tmp);
            break;
        }
        for (int j = i + 1; j < cells.length; ++j) {
            tmp = this.getCellValue(cells[j]);
            if (tmp == null || tmp.equals("")) continue;
            this.info.setVersion(tmp);
            break;
        }
    }

    private void getObject(XSSFCell[] cells) throws FileFormatNotStandardException {
        String tmp = null;
        for (int i = 0; i < cells.length; ++i) {
            tmp = this.getCellValue(cells[i]);
            if (tmp == null || tmp.equals("")) continue;
            this.info.setObjectName(tmp);
            break;
        }
    }

    private void getFieldName(XSSFCell[] cells) throws FileFormatNotStandardException {
        String tmp = "";
        for (int i = 0; i < cells.length; ++i) {
            tmp = this.getCellValue(cells[i]);
            if (this.fieldKeys.containsValue(tmp)) {
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "sameField", this.locale) + tmp + ")");
            }
            if (tmp == null || tmp.equals("")) continue;
            this.fieldKeys.put(new Integer(i), tmp);
        }
    }

    private void getFieldDesc(XSSFCell[] cells) throws FileFormatNotStandardException {
        String tmp = "";
        for (int i = 0; i < cells.length; ++i) {
            tmp = this.getCellValue(cells[i]);
            if (tmp == null || tmp.equals("")) continue;
            FieldPropertyInfo tmpField = new FieldPropertyInfo();
            if (this.fieldKeys.get(new Integer(i)) != null) {
                tmpField.setFieldName((String)this.fieldKeys.get(new Integer(i)));
                if (tmp.indexOf("*") == 0 && tmp.length() == 1) {
                    throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "desIncorrect", this.locale));
                }
                if (tmp.indexOf("*") == 0) {
                    tmpField.setFieldDesc(tmp.substring(1));
                    tmpField.setIsNecessary(true);
                } else {
                    tmpField.setFieldDesc(tmp);
                }
            } else {
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "notFoundDesc", this.locale) + tmp + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fieldDefinition", this.locale));
            }
            tmpField.setFieldType(cells[i].getCellType());
            tmpField.setFieldColNumber(i);
            this.info.addField(tmpField);
        }
    }

    @Override
    public ExternalDataRowInfo getExternalDataRowInfo() {
        return this.rowInfo;
    }

    @Override
    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.workBook != null) {
            this.workBook = null;
        }
    }

    @Override
    public boolean hasNextRecord() throws TaskRunnerException {
        return this.hasNext();
    }

    @Override
    public IRecord getNextRecord() throws TaskRunnerException {
        Map data = this.getNext();
        if (data.isEmpty()) {
            return null;
        }
        return this.convertToRecord(data);
    }

    private IRecord convertToRecord(Map data) {
        SimpleRecord rec = new SimpleRecord();
        rec.setRowNum(this.blockRowNum + 1);
        Set entrySet = data.entrySet();
        for (Map.Entry entry : entrySet) {
            rec.put((String)entry.getKey(), (DataToken)entry.getValue());
        }
        return rec;
    }

    public XMLReader fetchSheetParser(SharedStringsTable sst) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.sst = sst;
        parser.setContentHandler(this);
        parser.setFeature("http://xml.org/sax/features/external-general-entities", false);
        parser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        parser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return parser;
    }

    private boolean isDigitAndPoint(String value) {
        Pattern p1 = Pattern.compile("^\\d+$");
        Pattern p2 = Pattern.compile("^\\d+\\.\\d+$");
        Matcher m1 = p1.matcher(value);
        Matcher m2 = p2.matcher(value);
        if (m1.matches()) {
            logger.info((Object)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"88_ExternalExcelXDataReader"));
            return false;
        }
        if (m2.matches()) {
            logger.info((Object)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"89_ExternalExcelXDataReader"));
            return true;
        }
        logger.info((Object)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"90_ExternalExcelXDataReader"));
        return false;
    }

    private String valueWhenNumberic(String value) {
        BigDecimal big = new BigDecimal(new Double(value).toString());
        if ((value = big.toString()).endsWith(".0")) {
            value = value.substring(0, value.length() - 2);
        }
        return value;
    }

    private String valueConvert(String value) {
        try {
            if (!StringUtils.isEmpty((String)this.stylesIndex)) {
                Integer.parseInt(this.stylesIndex);
                XSSFCellStyle cellStyle = this.stylesTable.getStyleAt(Integer.parseInt(this.stylesIndex));
                short formatIndex = cellStyle.getDataFormat();
                String formatString = cellStyle.getDataFormatString();
                if (formatString == null) {
                    formatString = BuiltinFormats.getBuiltinFormat((int)formatIndex);
                }
                if ((StringUtils.isEmpty((String)formatString) || "General".equalsIgnoreCase(formatString)) && this.isDigitAndPoint(value)) {
                    value = this.valueWhenNumberic(value);
                } else if (DateUtil.isADateFormat((int)formatIndex, (String)formatString)) {
                    Date date = DateUtil.getJavaDate((double)Double.parseDouble(value));
                    String dateFormatStr = "yyyy-MM-dd";
                    if (value.contains(".") || date.getHours() != 0 || date.getMinutes() != 0 || date.getSeconds() != 0) {
                        dateFormatStr = "yyyy-MM-dd HH:mm:ss";
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormatStr);
                    value = simpleDateFormat.format(date);
                } else {
                    if (value.length() > 15 && !value.contains(".")) {
                        return value;
                    }
                    DataFormatter formatter = new DataFormatter();
                    if (!StringUtils.isEmpty((String)formatString) && formatString.indexOf("_") > -1) {
                        formatString = formatString.substring(0, formatString.indexOf("_"));
                    }
                    value = formatter.formatRawCellContents(Double.parseDouble(value), (int)formatIndex, formatString);
                }
            } else if (this.isDigitAndPoint(value)) {
                value = this.valueWhenNumberic(value);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return value;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals("c")) {
            String cellType = attributes.getValue("t");
            String rowStr = attributes.getValue("r");
            String styles = attributes.getValue("s");
            this.curCol = this.getRowIndex(rowStr);
            this.nextIsString = cellType != null && (cellType.equals("s") || cellType.equals("inlineStr"));
            this.stylesIndex = !StringUtils.isEmpty((String)styles) ? styles : null;
        }
        this.lastContents = "";
        if (this.curRow == 4) {
            try {
                this.checkTemplateTitle();
            }
            catch (FileFormatNotStandardException e) {
                SAXException se = new SAXException(e.getMessage(), e);
                throw se;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.nextIsString) {
            try {
                int idx = Integer.parseInt(this.lastContents);
                this.lastContents = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
            }
            catch (Exception idx) {
                // empty catch block
            }
        }
        if (name.equals("v") || name.equals("t")) {
            String value = this.lastContents.trim();
            if (!this.nextIsString) {
                value = this.valueConvert(value);
            }
            value = value.equals("") ? " " : value;
            int cols = this.curCol - this.preCol;
            if (cols > 1) {
                for (int i = 0; i < cols - 1; ++i) {
                    this.rowlist.add(this.preCol, "");
                }
            }
            this.preCol = this.curCol;
            this.rowlist.add(this.curCol - 1, value);
        } else if (name.equals("row")) {
            if (this.curRow >= 4 && this.hasErrorColumn) {
                this.rowlist.remove(0);
            }
            if (this.curRow <= 3) {
                try {
                    this.optRows(this.sheetIndex, this.curRow, this.rowlist);
                }
                catch (FileFormatNotStandardException e) {
                    logger.error((Object)("read title failed:" + e));
                    SAXException se = new SAXException(e.getMessage(), e);
                    throw se;
                }
            }
            if (this.curRow >= 4) {
                int fieldSize = this.info.getFieldCollection().size();
                int dataSize = this.rowlist.size();
                if (dataSize < fieldSize) {
                    for (int i = dataSize; i < fieldSize; ++i) {
                        this.rowlist.add(i, "");
                    }
                }
            }
            try {
                if (this.rowlist.size() > 0) {
                    ArrayList copylist = new ArrayList();
                    copylist.addAll(this.rowlist);
                    Object[][] array = new Object[][]{{this.curRow, copylist}};
                    this.blocklist.put(array);
                    this.rowlist.clear();
                }
            }
            catch (InterruptedException e) {
                this.blocklist.clear();
                SAXException se = new SAXException(e.getMessage(), e);
                throw se;
            }
            this.curRowNumber = this.curRow++;
            this.curCol = 0;
            this.preCol = 0;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = this.lastContents + new String(ch, start, length);
    }

    public int getRowIndex(String rowStr) {
        rowStr = rowStr.replaceAll("[^A-Z]", "");
        byte[] rowAbc = rowStr.getBytes();
        int len = rowAbc.length;
        float num = 0.0f;
        for (int i = 0; i < len; ++i) {
            num = (float)((double)num + (double)(rowAbc[i] - 65 + 1) * Math.pow(26.0, len - i - 1));
        }
        return (int)num;
    }

    public void optRows(int sheetIndex, int curRow, List<String> rowlist) throws FileFormatNotStandardException {
        switch (curRow) {
            case 0: {
                this.getProductAndVersion(rowlist);
                this.rowInfo.setRowOfVersion(curRow);
                rowlist.clear();
                break;
            }
            case 1: {
                this.getObject(rowlist);
                this.rowInfo.setRowOfObject(curRow);
                rowlist.clear();
                break;
            }
            case 2: {
                this.getFieldName(rowlist);
                this.rowInfo.setRowOfFieldName(curRow);
                rowlist.clear();
                break;
            }
            case 3: {
                this.getFieldDesc(rowlist);
                this.rowInfo.setRowOfFieldDesc(curRow);
                this.rowInfo.setRowOfDataStart(curRow + 1);
                rowlist.clear();
            }
        }
    }

    private void getFieldDesc(List<String> rowDataList) throws FileFormatNotStandardException {
        int i = 0;
        String tmp = "";
        String errFieldDesc = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"errorReason");
        while (i < rowDataList.size()) {
            tmp = rowDataList.get(i);
            if (tmp != null && !tmp.equals("")) {
                if (errFieldDesc.equals(tmp)) {
                    ++i;
                    continue;
                }
                FieldPropertyInfo tmpField = new FieldPropertyInfo();
                if (this.fieldKeys.get(new Integer(i)) != null) {
                    tmpField.setFieldName((String)this.fieldKeys.get(new Integer(i)));
                    if (tmp.indexOf("*") == 0 && tmp.length() == 1) {
                        throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "desIncorrect", this.locale));
                    }
                    if (tmp.indexOf("*") == 0) {
                        tmpField.setFieldDesc(tmp.substring(1));
                        tmpField.setIsNecessary(true);
                    } else {
                        tmpField.setFieldDesc(tmp);
                    }
                    if (this.hasErrorColumn) {
                        tmpField.setFieldColNumber(i - 1);
                    } else {
                        tmpField.setFieldColNumber(i);
                    }
                }
                this.info.addField(tmpField);
            }
            ++i;
        }
    }

    private void getFieldName(List<String> rowDataList) throws FileFormatNotStandardException {
        int i = 0;
        String tmp = "";
        while (i < rowDataList.size()) {
            tmp = rowDataList.get(i).trim();
            if ("ErrorReason".equals(tmp)) {
                this.hasErrorColumn = true;
                ++i;
                continue;
            }
            if (tmp != null && !tmp.equals("")) {
                this.fieldKeys.put(new Integer(i), tmp);
            }
            ++i;
        }
    }

    private void getObject(List<String> rowDataList) throws FileFormatNotStandardException {
        String tmp = null;
        for (int i = 0; i < rowDataList.size(); ++i) {
            tmp = rowDataList.get(i);
            if (tmp == null || tmp.equals("")) continue;
            this.info.setObjectName(tmp);
            break;
        }
    }

    private void getProductAndVersion(List<String> rowDatalist) throws FileFormatNotStandardException {
        String tmp = null;
        for (int i = 0; i < rowDatalist.size(); ++i) {
            tmp = rowDatalist.get(i);
            if (tmp == null || tmp.trim().equals("")) continue;
            if (!tmp.trim().equals(ExternalDataMeta.productName) && !"EAS".equals(tmp.trim())) {
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "productNameIncorrent", this.locale));
            }
            this.info.setProductName(tmp);
            break;
        }
        for (int j = i + 1; j < rowDatalist.size(); ++j) {
            tmp = rowDatalist.get(j);
            if (tmp == null || tmp.equals("")) continue;
            this.info.setVersion(tmp);
            break;
        }
    }

    public void checkTemplateTitle() throws FileFormatNotStandardException {
        if (this.rowInfo.getRowOfVersion() < 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "templateError", this.locale));
        }
        if (this.rowInfo.getRowOfObject() <= 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "objectNameError", this.locale));
        }
        if (this.rowInfo.getRowOfFieldName() <= 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "notFoundDefinition", this.locale));
        }
        if (this.rowInfo.getRowOfFieldDesc() <= 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "definitionError", this.locale));
        }
        this.info.setFileName(this.fileName);
        this.info.setSheetName((String)this.sheetNameList.get(0));
        ExternalStructInfo structInfo = this.getExternalStructInfo();
        structInfo.isSelfStandard(this.getStructInfo());
        this.isOpenSuccess = true;
    }

    public void setIsImportTemplate(boolean isImportTemplate) {
        this.isImportTemplate = isImportTemplate;
    }

    public boolean getIsImportTemplate() {
        return this.isImportTemplate;
    }

    public void setContinueCondition(boolean continueCondition) {
        this.continueCondition = continueCondition;
    }

    public boolean getContinueCondition() {
        return this.continueCondition;
    }

    public void interruptExcelXParseThread() {
        this.parseThread.interrupt();
    }

    class ExcelXParserThread
    extends Thread {
        private String fileName;
        private String processSheetName;

        public ExcelXParserThread(String fileName, String processSheetName) {
            this.fileName = fileName;
            this.processSheetName = processSheetName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SAXException se = null;
            try {
                OPCPackage pkg = OPCPackage.open((String)this.fileName);
                XSSFReader r = new XSSFReader(pkg);
                SharedStringsTable sst = r.getSharedStringsTable();
                ExternalExcelXDataReader.this.stylesTable = r.getStylesTable();
                XMLReader parser = ExternalExcelXDataReader.this.fetchSheetParser(sst);
                XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
                while (sheets.hasNext()) {
                    InputStream sheet = sheets.next();
                    if (!StringUtils.equals((String)sheets.getSheetName(), (String)this.processSheetName)) continue;
                    InputSource sheetSource = new InputSource(sheet);
                    parser.parse(sheetSource);
                    sheet.close();
                    break;
                }
                pkg.close();
            }
            catch (SAXException e) {
                se = e;
            }
            catch (Exception e) {
                e.getCause();
                logger.error((Object)("open file failed:" + e));
            }
            finally {
                try {
                    if (se != null) {
                        TaskRunnerException te = new TaskRunnerException(4, se.getMessage(), se.getException());
                        ExternalExcelXDataReader.this.blocklist.put(te);
                    }
                    ExternalExcelXDataReader.this.blocklist.put(ExternalExcelXDataReader.this.endFlag);
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

