/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.IFileInfo;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordUtils;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelInfo;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.tools.datatask.runtime.ExternalDataMeta;
import com.kingdee.eas.tools.datatask.runtime.ExternalDataRowInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.runtime.FileFormatNotStandardException;
import com.kingdee.eas.tools.datatask.runtime.IDataReader;
import com.kingdee.eas.tools.datatask.task.MultitaskImportExcelRunner;
import com.kingdee.eas.tools.datatask.task.util.ExcelParam;
import com.kingdee.eas.tools.datatask.task.util.TaskEnum;
import com.kingdee.eas.tools.datatask.task.util.TaskResult;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.util.StringUtils;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExternalExcelXDataReaderTask
extends DefaultHandler
implements IDataReader {
    private static final Logger logger = Logger.getLogger(ExternalExcelXDataReaderTask.class);
    private Locale locale;
    private XMLReader parser;
    private StylesTable stylesTable;
    private SharedStringsTable sst;
    private StringBuilder lastContents = new StringBuilder();
    private boolean nextIsString;
    private BlockingQueue blocklist = new ArrayBlockingQueue(500);
    private String endFlag = "positionPills";
    private IRecord rec = null;
    private List rowlist = new ArrayList();
    private String stylesIndex = "";
    private int curRow = 0;
    private int curCol = 0;
    private int preCol = 0;
    private String fileUuId;
    private int sheetIndex = 0;
    private List<String> sheetNameList = new ArrayList<String>();
    private ConcurrentHashMap<String, ExcelInfo> excelInfoMap = new ConcurrentHashMap();
    private boolean hasErrorColumn = false;
    private HashMap<Integer, String> fieldKeys = new HashMap();
    private Map<String, ExcelParam> expMap;
    private Map<String, ExternalStructInfo> structMap;
    private String openFileName;
    private String fileName;
    private boolean isOnlyParseTitle = false;
    private String taskRsKey;
    private MultitaskImportExcelRunner importRunner;

    public ExternalExcelXDataReaderTask(Map<String, ExcelParam> expMap, boolean isOnlyParseTitle) {
        this.isOnlyParseTitle = isOnlyParseTitle;
        this.expMap = expMap;
    }

    public ExternalExcelXDataReaderTask(Map<String, ExcelParam> expMap) {
        this(expMap, false);
    }

    public ExternalExcelXDataReaderTask(ExcelParam exp) {
        this.expMap = new HashMap<String, ExcelParam>(1);
        this.expMap.put(exp.getTaskParam().getFileUuId(), exp);
        this.isOnlyParseTitle = false;
    }

    public ExternalExcelXDataReaderTask(String fileUuId, String fileName, Map<String, ExternalStructInfo> structMap) {
        this.fileUuId = fileUuId;
        this.fileName = fileName;
        this.structMap = structMap;
        this.isOnlyParseTitle = true;
    }

    public void setImportRunner(MultitaskImportExcelRunner importRunner) {
        this.importRunner = importRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult call() throws Exception {
        TaskResult rs = this.getTaskResult();
        TaskRunnerException te = null;
        try {
            for (Map.Entry<String, ExcelParam> entry : this.expMap.entrySet()) {
                this.parseFile(entry.getValue());
            }
        }
        catch (TaskRunnerException e) {
            te = e;
        }
        finally {
            try {
                if (te != null) {
                    this.blocklist.put(te);
                }
                this.blocklist.put(this.endFlag);
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return rs;
    }

    public List<String> getSheetNameList(String filePath) {
        try {
            OPCPackage pkg = null;
            pkg = OPCPackage.open((String)filePath, (PackageAccess)PackageAccess.READ);
            XSSFReader r = new XSSFReader(pkg);
            XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
            while (sheets.hasNext()) {
                String sheetName = sheets.getSheetName();
                this.sheetNameList.add(sheetName);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.sheetNameList;
    }

    public void parseFile(ExcelParam xlspram) throws TaskRunnerException {
        TaskRunnerException te = null;
        OPCPackage pkg = null;
        DatataskParameter taskParam = xlspram.getTaskParam();
        this.fileUuId = taskParam.getFileUuId();
        this.fileName = taskParam.getFileName();
        ExcelInfo excelInfo = new ExcelInfo(this.fileUuId, this.fileName);
        this.excelInfoMap.putIfAbsent(taskParam.getFileUuId(), excelInfo);
        try {
            String filePath = this.getOpenFileName();
            pkg = ConfigMDUtil.isClient() ? OPCPackage.open((String)this.fileName, (PackageAccess)PackageAccess.READ) : OPCPackage.open((String)filePath, (PackageAccess)PackageAccess.READ);
            XSSFReader r = new XSSFReader(pkg);
            this.sst = r.getSharedStringsTable();
            this.stylesTable = r.getStylesTable();
            this.fetchSheetParser();
            for (Map.Entry<Integer, String> entry : taskParam.getSheetIdAndName().entrySet()) {
                this.sheetIndex = entry.getKey();
                String sheetName = entry.getValue();
                ExcelInfo excelInfo2 = excelInfo;
                excelInfo2.getClass();
                ExcelInfo.ExcelSheetInfo excelSheetInfo = excelInfo2.new ExcelInfo.ExcelSheetInfo(this.sheetIndex, sheetName);
                excelInfo.add(this.sheetIndex, excelSheetInfo);
                XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
                while (sheets.hasNext()) {
                    InputStream sheet = sheets.next();
                    String tmpSheetName = sheets.getSheetName();
                    if (!StringUtils.equals((String)tmpSheetName, (String)sheetName)) continue;
                    this.parser.parse(new InputSource(sheet));
                }
                this.initSheetParam();
            }
        }
        catch (Exception e) {
            te = new TaskRunnerException(4, e.getMessage(), e);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw te;
        }
        finally {
            pkg.revert();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFile() throws TaskRunnerException {
        TaskRunnerException te = null;
        OPCPackage pkg = null;
        ExcelInfo excelInfo = new ExcelInfo(this.fileUuId, this.fileName);
        this.excelInfoMap.putIfAbsent(this.fileUuId, excelInfo);
        try {
            String filePath = this.getOpenFileName();
            pkg = ConfigMDUtil.isClient() ? OPCPackage.open((String)this.fileName, (PackageAccess)PackageAccess.READ) : OPCPackage.open((String)filePath, (PackageAccess)PackageAccess.READ);
            XSSFReader r = new XSSFReader(pkg);
            this.sst = r.getSharedStringsTable();
            this.stylesTable = r.getStylesTable();
            this.fetchSheetParser();
            XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
            InputStream sheet = null;
            while (sheets.hasNext()) {
                try {
                    ++this.sheetIndex;
                    sheet = sheets.next();
                    String sheetName = sheets.getSheetName();
                    ExcelInfo excelInfo2 = excelInfo;
                    excelInfo2.getClass();
                    ExcelInfo.ExcelSheetInfo excelSheetInfo = excelInfo2.new ExcelInfo.ExcelSheetInfo(this.sheetIndex, sheetName);
                    excelInfo.add(this.sheetIndex, excelSheetInfo);
                    InputSource sheetSource = new InputSource(sheet);
                    this.parser.parse(sheetSource);
                }
                catch (Exception e) {
                    if (e.getMessage().equals("stopParse")) continue;
                    te = new TaskRunnerException(4, e.getMessage(), e);
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw te;
                }
                finally {
                    this.initSheetParam();
                    if (sheet == null) continue;
                    sheet.close();
                }
            }
        }
        catch (Exception e) {
            te = new TaskRunnerException(4, e.getMessage(), e);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw te;
        }
        finally {
            pkg.revert();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFile(String type) throws TaskRunnerException {
        TaskRunnerException te = null;
        OPCPackage pkg = null;
        ExcelInfo excelInfo = new ExcelInfo(this.fileUuId, this.fileName);
        this.excelInfoMap.putIfAbsent(this.fileUuId, excelInfo);
        try {
            String filePath = this.getOpenFileName();
            pkg = "GUI".equals(type) ? OPCPackage.open((String)this.fileName, (PackageAccess)PackageAccess.READ) : OPCPackage.open((String)filePath, (PackageAccess)PackageAccess.READ);
            XSSFReader r = new XSSFReader(pkg);
            this.sst = r.getSharedStringsTable();
            this.stylesTable = r.getStylesTable();
            this.fetchSheetParser();
            XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
            InputStream sheet = null;
            while (sheets.hasNext()) {
                try {
                    ++this.sheetIndex;
                    sheet = sheets.next();
                    String sheetName = sheets.getSheetName();
                    ExcelInfo excelInfo2 = excelInfo;
                    excelInfo2.getClass();
                    ExcelInfo.ExcelSheetInfo excelSheetInfo = excelInfo2.new ExcelInfo.ExcelSheetInfo(this.sheetIndex, sheetName);
                    excelInfo.add(this.sheetIndex, excelSheetInfo);
                    InputSource sheetSource = new InputSource(sheet);
                    this.parser.parse(sheetSource);
                }
                catch (Exception e) {
                    if (e.getMessage().equals("stopParse")) continue;
                    te = new TaskRunnerException(4, e.getMessage(), e);
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw te;
                }
                finally {
                    this.initSheetParam();
                    if (sheet == null) continue;
                    sheet.close();
                }
            }
        }
        catch (Exception e) {
            te = new TaskRunnerException(4, e.getMessage(), e);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw te;
        }
        finally {
            pkg.revert();
        }
    }

    private void initSheetParam() {
        this.curRow = 0;
        this.curCol = 0;
        this.preCol = 0;
        this.hasErrorColumn = false;
    }

    public void fetchSheetParser() throws SAXException {
        if (this.parser == null) {
            this.parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.parser.setContentHandler(this);
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals("dimension")) {
            String dim = attributes.getValue("ref");
            int rowCount = ExcelUtil.getSheetRowCount(dim);
            String sheetName = this.getCurrentSheet().getSheetName();
            DIETemplateInfo dieTemplateInfo = new DIETemplateInfo();
            try {
                dieTemplateInfo = DIETemplateFactory.getRemoteInstance().getDIETemplateInfo("select importMaxCount where sheetName = '" + sheetName + "'");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (dieTemplateInfo != null && dieTemplateInfo.getImportMaxCount() > 0 && rowCount > dieTemplateInfo.getImportMaxCount()) {
                throw new SAXException(EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "RowsNumberLimit", new Object[]{dieTemplateInfo.getImportMaxCount()}));
            }
            this.getCurrentSheet().setRowCount(rowCount);
        }
        if (name.equals("c")) {
            String cellType = attributes.getValue("t");
            String rowStr = attributes.getValue("r");
            String styles = attributes.getValue("s");
            this.curCol = ExcelUtil.getRowIndex(rowStr);
            this.nextIsString = cellType != null && (cellType.equals("s") || cellType.equals("inlineStr"));
            this.stylesIndex = !StringUtils.isEmpty((String)styles) ? styles : null;
        }
        this.lastContents.delete(0, this.lastContents.length());
        if (this.curRow == 4) {
            try {
                this.checkTemplateTitle();
            }
            catch (FileFormatNotStandardException e) {
                SAXException se = new SAXException(e.getMessage(), e);
                throw se;
            }
            if (this.isOnlyParseTitle) {
                SAXException se = new SAXException("stopParse");
                throw se;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        block16: {
            if (this.nextIsString) {
                String tmpStr = this.lastContents.toString();
                try {
                    int idx = Integer.parseInt(this.lastContents.toString());
                    this.lastContents.delete(0, this.lastContents.length());
                    this.lastContents.append(new XSSFRichTextString(this.sst.getEntryAt(idx)).toString());
                }
                catch (Exception e) {
                    if (this.lastContents.length() > 0) break block16;
                    this.lastContents.append(tmpStr);
                }
            }
        }
        if (name.equals("v") || name.equals("t")) {
            String value = this.lastContents.toString().trim();
            if (!this.nextIsString) {
                value = this.valueConvert(value);
            }
            value = value.equals("") ? " " : value;
            int cols = this.curCol - this.preCol;
            if (cols > 1) {
                for (int i = 0; i < cols - 1; ++i) {
                    this.rowlist.add(this.preCol, "");
                }
            }
            this.preCol = this.curCol;
            this.rowlist.add(this.curCol - 1, value);
        } else if (name.equals("row")) {
            if (this.curRow >= 4 && this.hasErrorColumn) {
                this.rowlist.remove(0);
            }
            if (this.curRow <= 3) {
                try {
                    this.optRows(this.sheetIndex, this.curRow, this.rowlist);
                }
                catch (FileFormatNotStandardException e) {
                    logger.error((Object)("read title failed:" + e));
                    SAXException se = new SAXException(e.getMessage(), e);
                    throw se;
                }
            }
            try {
                if (this.curRow >= 4) {
                    this.blocklist.put(this.convertBlockData(this.rowlist));
                    this.rowlist.clear();
                }
            }
            catch (InterruptedException e) {
                this.blocklist.clear();
                SAXException se = new SAXException(e.getMessage(), e);
                throw se;
            }
            ++this.curRow;
            this.curCol = 0;
            this.preCol = 0;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents.append(new String(ch, start, length));
    }

    public void optRows(int sheetIndex, int curRow, List<String> rowlist) throws FileFormatNotStandardException {
        switch (curRow) {
            case 0: {
                this.getProductAndVersion(rowlist);
                this.getCurrentSheet().getRowInfo().setRowOfVersion(curRow);
                rowlist.clear();
                break;
            }
            case 1: {
                this.getObject(rowlist);
                this.getCurrentSheet().getRowInfo().setRowOfObject(curRow);
                rowlist.clear();
                break;
            }
            case 2: {
                this.getFieldName(rowlist);
                this.getCurrentSheet().getRowInfo().setRowOfFieldName(curRow);
                rowlist.clear();
                break;
            }
            case 3: {
                this.getFieldDesc(rowlist);
                this.getCurrentSheet().getRowInfo().setRowOfFieldDesc(curRow);
                this.getCurrentSheet().getRowInfo().setRowOfDataStart(curRow + 1);
                rowlist.clear();
            }
        }
    }

    private String valueConvert(String value) {
        try {
            if (!StringUtils.isEmpty((String)this.stylesIndex)) {
                Integer.parseInt(this.stylesIndex);
                XSSFCellStyle cellStyle = this.stylesTable.getStyleAt(Integer.parseInt(this.stylesIndex));
                short formatIndex = cellStyle.getDataFormat();
                String formatString = cellStyle.getDataFormatString();
                if (formatString == null) {
                    formatString = BuiltinFormats.getBuiltinFormat((int)formatIndex);
                }
                if ((StringUtils.isEmpty((String)formatString) || "General".equalsIgnoreCase(formatString)) && this.isDigitAndPoint(value)) {
                    value = this.valueWhenNumberic(value);
                } else if (DateUtil.isADateFormat((int)formatIndex, (String)formatString)) {
                    Date date = DateUtil.getJavaDate((double)Double.parseDouble(value));
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    value = simpleDateFormat.format(date);
                } else {
                    DataFormatter formatter = new DataFormatter();
                    if (!StringUtils.isEmpty((String)formatString) && formatString.indexOf("_") > -1) {
                        formatString = formatString.substring(0, formatString.indexOf("_"));
                    }
                    value = formatter.formatRawCellContents(Double.parseDouble(value), (int)formatIndex, formatString);
                }
            } else if (this.isDigitAndPoint(value)) {
                value = this.valueWhenNumberic(value);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return value;
    }

    private boolean isDigitAndPoint(String value) {
        Pattern p1 = Pattern.compile("^\\d+$");
        Pattern p2 = Pattern.compile("^\\d+\\.\\d+$");
        Matcher m1 = p1.matcher(value);
        Matcher m2 = p2.matcher(value);
        if (m1.matches()) {
            return false;
        }
        return m2.matches();
    }

    private String valueWhenNumberic(String value) {
        BigDecimal big = new BigDecimal(new Double(value).toString());
        if ((value = big.toString()).endsWith(".0")) {
            value = value.substring(0, value.length() - 2);
        }
        return value;
    }

    private void getProductAndVersion(List<String> rowDatalist) throws FileFormatNotStandardException {
        String tmp = null;
        for (int i = 0; i < rowDatalist.size(); ++i) {
            tmp = rowDatalist.get(i);
            if (tmp == null || tmp.trim().equals("")) continue;
            if (!tmp.trim().equals(ExternalDataMeta.productName) && !"EAS".equals(tmp.trim())) {
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "productNameIncorrent", this.locale));
            }
            this.getCurrentSheet().getStructInfo().setProductName(tmp);
            break;
        }
        for (int j = i + 1; j < rowDatalist.size(); ++j) {
            tmp = rowDatalist.get(j);
            if (tmp == null || tmp.equals("")) continue;
            this.getCurrentSheet().getStructInfo().setVersion(tmp);
            break;
        }
    }

    private void getObject(List<String> rowDataList) throws FileFormatNotStandardException {
        String tmp = null;
        for (int i = 0; i < rowDataList.size(); ++i) {
            tmp = rowDataList.get(i);
            if (tmp == null || tmp.equals("")) continue;
            this.getCurrentSheet().getStructInfo().setObjectName(tmp);
            break;
        }
    }

    private void getFieldName(List<String> rowDataList) throws FileFormatNotStandardException {
        int i = 0;
        String tmp = "";
        while (i < rowDataList.size()) {
            tmp = rowDataList.get(i).trim();
            if ("ErrorReason".equals(tmp)) {
                this.hasErrorColumn = true;
                ++i;
                continue;
            }
            if (tmp != null && !tmp.equals("")) {
                this.fieldKeys.put(new Integer(i), tmp);
            }
            ++i;
        }
    }

    private void getFieldDesc(List<String> rowDataList) throws FileFormatNotStandardException {
        int i = 0;
        String tmp = "";
        if (this.hasErrorColumn) {
            ++i;
        }
        while (i < rowDataList.size()) {
            tmp = rowDataList.get(i);
            if (tmp != null && !tmp.equals("")) {
                FieldPropertyInfo tmpField = new FieldPropertyInfo();
                String fieldName = this.fieldKeys.get(new Integer(i));
                if (fieldName != null) {
                    tmpField.setFieldName(fieldName);
                    if (tmp.indexOf("*") == 0 && tmp.length() == 1) {
                        throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "desIncorrect", this.locale));
                    }
                    if (tmp.indexOf("*") == 0) {
                        tmpField.setFieldDesc(tmp.substring(1));
                        tmpField.setIsNecessary(true);
                    } else {
                        tmpField.setFieldDesc(tmp);
                    }
                    if (this.hasErrorColumn) {
                        tmpField.setFieldColNumber(i - 1);
                    } else {
                        tmpField.setFieldColNumber(i);
                    }
                }
                this.getCurrentSheet().getStructInfo().addField(tmpField);
            }
            ++i;
        }
    }

    public void checkTemplateTitle() throws FileFormatNotStandardException {
        ExternalDataRowInfo rowInfo = this.getCurrentSheet().getRowInfo();
        if (rowInfo.getRowOfVersion() < 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "templateError", this.locale));
        }
        if (rowInfo.getRowOfObject() <= 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "objectNameError", this.locale));
        }
        if (rowInfo.getRowOfFieldName() <= 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "notFoundDefinition", this.locale));
        }
        if (rowInfo.getRowOfFieldDesc() <= 0) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "definitionError", this.locale));
        }
        this.getCurrentSheet().getStructInfo().setFileName(this.getOpenFileName());
        this.getCurrentSheet().getStructInfo().setSheetName(this.getCurrentSheet().getSheetName());
        ExternalStructInfo stand_struct = null;
        if (this.expMap != null) {
            stand_struct = this.expMap.get(this.fileUuId).getStructMap().get(this.sheetIndex);
        } else {
            String solu = this.getCurrentSheet().getStructInfo().getObjectName();
            if (!this.structMap.containsKey(solu)) {
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fileNotMatchSolu", this.locale));
            }
            stand_struct = this.structMap.get(solu);
        }
        this.getCurrentSheet().getStructInfo().setLocale(this.locale);
        this.getCurrentSheet().getStructInfo().isSelfStandard(stand_struct);
    }

    private IRecord convertBlockData(List outputlist) {
        SimpleRecord rec = new SimpleRecord();
        rec.setSheetId(this.sheetIndex);
        int rowNum = RecordUtils.convertRowNum(this.sheetIndex, this.curRow + 1);
        rec.setRowNum(rowNum);
        rec.setFileUuId(this.fileUuId);
        if (outputlist.size() == 0) {
            return rec;
        }
        int blankCount = 0;
        String cellValue = "";
        ArrayList<FieldPropertyInfo> fields = this.getCurrentSheet().getStructInfo().getFieldCollection();
        for (FieldPropertyInfo fi : fields) {
            DataToken value;
            String fieldName;
            int tmpColNumber = fi.getFieldColNumber();
            String string = fieldName = fi.getFieldName() == null ? "" : fi.getFieldName().trim();
            if (tmpColNumber < outputlist.size()) {
                value = new DataToken();
                value.name = fieldName;
                value.desc = fi.getFieldDesc();
                cellValue = (String)outputlist.get(tmpColNumber);
                Object object = value.data = cellValue == null ? "" : cellValue.trim();
                if (value.data.equals("")) {
                    ++blankCount;
                }
                rec.put(fieldName, value);
                continue;
            }
            value = new DataToken();
            value.name = fieldName;
            value.type = "Label";
            value.data = "";
            rec.put(fieldName, value);
            ++blankCount;
        }
        if (blankCount == rec.getMap().size()) {
            rec.getMap().clear();
        }
        return rec;
    }

    @Override
    public boolean hasNextRecord() throws TaskRunnerException {
        try {
            if (this.rec != null) {
                return true;
            }
            Object obj = this.blocklist.take();
            if (obj instanceof TaskRunnerException) {
                throw (TaskRunnerException)((Object)obj);
            }
            if (obj instanceof String && obj.toString().equals(this.endFlag)) {
                return false;
            }
            this.rec = (IRecord)obj;
        }
        catch (InterruptedException e) {
            Thread.currentThread();
            Thread.interrupted();
            this.hasNextRecord();
            this.importRunner.setCancelFlag();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    @Override
    public IRecord getNextRecord() throws TaskRunnerException {
        IRecord rs = this.rec;
        this.rec = null;
        return rs;
    }

    private ExcelInfo.ExcelSheetInfo getCurrentSheet() {
        ExcelInfo excel = this.excelInfoMap.get(this.fileUuId);
        return excel.get(this.sheetIndex);
    }

    @Override
    public void close() {
    }

    @Override
    public IFileInfo getFileInfo(String fileUuId) {
        ExcelInfo excel = this.excelInfoMap.get(fileUuId);
        return excel;
    }

    public BlockingQueue<?> getBlockingQueue() {
        return null;
    }

    @Override
    public void setLocacle(Locale l) {
        this.locale = l;
    }

    public String getOpenFileName() {
        return GlobalFunction.getFileTempSavePath(this.fileUuId);
    }

    public void setOpenFileName(String openFileName) {
        this.openFileName = openFileName;
    }

    @Override
    public TaskResult getTaskResult() {
        TaskResult rs = new TaskResult();
        rs.setTaskEnum(TaskEnum.readerTask);
        rs.setKey(this.getTaskRsKey());
        return rs;
    }

    public String getTaskRsKey() {
        return this.taskRsKey;
    }

    @Override
    public void setTaskRsKey(String key) {
        this.taskRsKey = key;
    }
}

