/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExternalDataRowInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.runtime.FileFormatNotStandardException;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class ExternalXmlDataReader
extends AbstractExternalDataReader {
    private ExternalStructInfo structInfo = null;
    private Element rootElement = null;
    private Element struct = null;
    private Element records = null;
    private int curRowNumber = -1;
    private int rowCount = -1;

    @Override
    public void openFile(String fileName) throws FileFormatNotStandardException {
        File f = new File(fileName);
        this.openFile(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(File file) throws FileFormatNotStandardException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            this.openFile(is);
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void openFile(InputStream file) throws FileFormatNotStandardException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(file);
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.rootElement = doc.getRootElement();
        List children = this.rootElement.getChildren();
        if (children.size() == 0) {
            this.struct = (Element)children.get(0);
        } else if (children.size() >= 1) {
            this.struct = (Element)children.get(0);
            this.records = (Element)children.get(1);
        }
        this.rowCount = this.records.getChildren().size();
    }

    @Override
    public ExternalStructInfo getExternalStructInfo() {
        if (this.structInfo != null) {
            return this.structInfo;
        }
        this.structInfo = new ExternalStructInfo();
        this.structInfo.setProductName(this.rootElement.getAttributeValue("product"));
        this.structInfo.setVersion(this.rootElement.getAttributeValue("version"));
        this.structInfo.setObjectDesc(this.rootElement.getAttributeValue("objectDesc"));
        this.structInfo.setObjectName(this.rootElement.getAttributeValue("objectName"));
        List fields = this.struct.getChildren();
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            Element tableEl = (Element)fields.get(i);
            FieldPropertyInfo fpi = new FieldPropertyInfo();
            fpi.setFieldName(tableEl.getAttributeValue("name"));
            fpi.setFieldDesc(tableEl.getAttributeValue("desc"));
            fpi.setIsNecessary(Boolean.valueOf(tableEl.getAttributeValue("isNeed")));
            fpi.setFiledMemo(tableEl.getAttributeValue("memo"));
            this.structInfo.addField(fpi);
        }
        return this.structInfo;
    }

    @Override
    public ExternalDataRowInfo getExternalDataRowInfo() {
        return this.rowInfo;
    }

    @Override
    public boolean hasNext() throws TaskRunnerException {
        if (this.curRowNumber == -1) {
            this.curRowNumber = 0;
            return this.curRowNumber <= this.rowCount - 1;
        }
        if (this.curRowNumber < this.rowCount - 1) {
            ++this.curRowNumber;
            return true;
        }
        return false;
    }

    @Override
    public Map getNext() throws TaskRunnerException {
        List recs = this.records.getChildren();
        Element curElement = (Element)recs.get(this.curRowNumber);
        List fields = curElement.getChildren();
        HashMap<String, DataToken> hsData = new HashMap<String, DataToken>();
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            Element tmpEle = (Element)fields.get(i);
            String fieldName = tmpEle.getAttributeValue("name");
            String fieldValue = tmpEle.getText();
            DataToken dt = new DataToken();
            dt.name = fieldName;
            dt.data = fieldValue;
            hsData.put(fieldName, dt);
        }
        ArrayList<FieldPropertyInfo> fieldProp = this.structInfo.getFieldCollection();
        for (int i = 0; i < fieldProp.size(); ++i) {
            FieldPropertyInfo fpi = fieldProp.get(i);
            if (fpi == null || hsData.get(fpi.getFieldName()) != null) continue;
            DataToken dt = new DataToken();
            dt.data = "";
            dt.name = fpi.getFieldName();
            hsData.put(fpi.getFieldName(), dt);
        }
        return hsData;
    }

    @Override
    public int getCurrentRow() {
        return this.curRowNumber;
    }

    @Override
    public int getRowOfCurrentData() {
        return 0;
    }

    @Override
    public void close() {
    }
}

