/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.IAttachmentFtpFacade;
import com.kingdee.eas.base.attachment.ftp.AttachmentFtpInfo;
import com.kingdee.eas.common.EASBizException;
import java.io.FileInputStream;
import org.apache.commons.io.FilenameUtils;

public class UploadFileToServerHelper {
    private static final int MAX_UPLOAD_LENGTH = 0x100000;
    private IAttachmentFtpFacade ia = AttachmentFtpFacadeFactory.getRemoteInstance();

    public String uploadFile(String fileName) throws Exception {
        FileInputStream fis = null;
        String serverTempFileName = null;
        try {
            int leaveLen;
            fileName = FilenameUtils.normalize((String)fileName);
            if (fileName == null) {
                throw new Exception("The file path is not standard!");
            }
            fis = new FileInputStream(fileName);
            byte[] onetrans = null;
            int fileSize = fis.available();
            int hasReadSize = 0;
            while ((leaveLen = fileSize - hasReadSize) > 0) {
                if (leaveLen > 0x100000) {
                    onetrans = new byte[0x100000];
                    fis.read(onetrans, 0, onetrans.length);
                    serverTempFileName = this.updateFile2Server(serverTempFileName, onetrans);
                    hasReadSize += 0x100000;
                    continue;
                }
                onetrans = new byte[leaveLen];
                fis.read(onetrans, 0, onetrans.length);
                serverTempFileName = this.updateFile2Server(serverTempFileName, onetrans);
                hasReadSize += leaveLen;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
                fis = null;
            }
        }
        return serverTempFileName;
    }

    public String updateFile2Server(String serverTempFileName, byte[] content) throws BOSException, EASBizException {
        AttachmentFtpInfo ftpInfo = this.ia.uploadFile(serverTempFileName, content);
        if (ftpInfo != null && serverTempFileName == null) {
            return ftpInfo.getTempFileName();
        }
        return serverTempFileName;
    }
}

