/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.Context;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.ITaskRunner;
import com.kingdee.eas.tools.datatask.task.util.TaskResult;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class AbstractTaskBaseRunner
implements ITaskRunner {
    protected static Logger logger = SysLog.getLogger(AbstractTaskBaseRunner.class);
    protected Context ctx;
    protected Locale locale;
    protected ITask task;

    protected abstract void onMainRunningProcess() throws TaskRunnerException;

    protected abstract void onFinishRunning() throws TaskRunnerException;

    protected abstract void handFailure(Exception var1) throws Exception;

    protected abstract void handSuccess() throws Exception;

    public AbstractTaskBaseRunner(ITask task, Context ctx) {
        this.task = task;
        this.ctx = ctx;
        if (this.ctx != null) {
            this.locale = ctx.getLocale();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult call() throws Exception {
        TaskResult rs = new TaskResult();
        try {
            this.onMainRunningProcess();
            this.handSuccess();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                this.handFailure(e);
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        finally {
            try {
                this.onFinishRunning();
                rs = this.getTaskResult();
            }
            catch (TaskRunnerException e) {
                logger.error((Object)e.getMessage(), (Throwable)((Object)e));
            }
        }
        return rs;
    }

    protected String getFatalError() {
        return EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fatalError", this.locale);
    }
}

