/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.export.Excel2007Writer;
import com.kingdee.eas.tools.datatask.export.ExternalExcelDataGridWriter;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.task.AbstractTaskRunner;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.util.TaskEnum;
import com.kingdee.eas.tools.datatask.task.util.TaskResult;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataGridExportExcelRunner
extends AbstractTaskRunner {
    private static Logger logger = SysLog.getLogger(DataGridExportExcelRunner.class);
    private IRowSet rs = null;
    private List<Enum> BooleanEnumList;
    private int allRowCount = 0;
    private int currentRowCount = 0;
    private int fetchRowCount = 0;
    int maxQueryCount = 0;
    int maxExcelSheetRowCount2007 = 100000;
    private IQueryExecutor exec = null;
    private int sheetIndex = 0;
    private ExternalExcelDataGridWriter sheetWriter = null;
    private DatataskParameter dp = null;
    private ExternalStructInfo structInfo;
    private List<String> exportFields;
    private boolean hasNext = true;
    private Excel2007Writer excelWriter;

    public DataGridExportExcelRunner(ITask task, Context ctx) {
        super(task, ctx);
        this.dp = (DatataskParameter)task.getTaskParameter();
        this.structInfo = this.taskCode.getExternalStructInfo();
    }

    @Override
    protected boolean hasNext() throws TaskRunnerException {
        return this.hasNext;
    }

    @Override
    protected void onBeforeProcess() throws TaskRunnerException {
        try {
            this.exec = this.getQueryExecutor();
            this.allRowCount = this.exec.getRowCount();
            IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
            this.maxQueryCount = manager.getCriticalIDList();
            this.rs = this.exec.executeQuery(0, this.maxQueryCount);
            this.fetchRowCount = this.rs.size();
            this.exportFields = this.getExportFields();
            this.excelWriter = new Excel2007Writer(GlobalFunction.getFilePathForServer() + this.dp.getOpenFileName());
            this.excelWriter.initWb();
            this.sheetWriter = new ExternalExcelDataGridWriter(this.excelWriter);
            this.sheetWriter.setSheetName(this.dp.getAlias());
            this.sheetWriter.openWriter();
            this.sheetWriter.writeStruct(this.structInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskRunnerException(4, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"getexportdatafail"), e);
        }
    }

    @Override
    protected void onEachRunningLoop() throws Exception {
        Map<String, Object> data = this.getNextSingle();
        if (!this.hasNext) {
            return;
        }
        if ((this.currentRowCount + 1) % this.maxExcelSheetRowCount2007 == 0) {
            this.sheetWriter.closeWriter();
            this.sheetWriter = new ExternalExcelDataGridWriter(this.excelWriter);
            this.sheetWriter.setSheetName(this.dp.getAlias() + ++this.sheetIndex);
            this.sheetWriter.openWriter();
            this.sheetWriter.writeStruct(this.structInfo);
        }
        this.sheetWriter.writeLine(data);
    }

    private Map<String, Object> getNextSingle() throws TaskRunnerException {
        Map<String, Object> rec = null;
        while ((this.hasNext = this.hasNextRecord()) && (rec = this.getNextRecord()) == null) {
        }
        return rec;
    }

    private Map<String, Object> getNextRecord() throws TaskRunnerException {
        HashMap<String, Object> rec = new HashMap<String, Object>();
        int blankCount = 0;
        try {
            for (String fieldName : this.exportFields) {
                if (fieldName.equals("seq")) {
                    rec.put(fieldName, this.currentRowCount);
                    continue;
                }
                Object obj = null;
                try {
                    obj = this.rs.getObject(fieldName);
                }
                catch (SQLException e) {
                    logger.error((Object)("DataGridExportExcelRunner.getNextRecord() :\u8be5\u67e5\u8be2query\u7f3a\u5c11 \u5b57\u6bb5 :" + fieldName));
                }
                if (obj instanceof Boolean) {
                    if (this.BooleanEnumList == null) {
                        this.BooleanEnumList = EnumUtils.getEnumList((String)"com.kingdee.eas.base.commonquery.BooleanEnum");
                    }
                    for (Enum enumItem : this.BooleanEnumList) {
                        if (!enumItem.getName().toLowerCase().equals(obj.toString().toLowerCase())) continue;
                        obj = enumItem.getAlias(this.ctx.getLocale());
                    }
                }
                if (obj instanceof Timestamp) {
                    obj = this.dropTimestampDot(obj.toString());
                }
                if (obj instanceof BigDecimal) {
                    obj = this.dropBigDecimalZero((BigDecimal)obj);
                }
                rec.put(fieldName, obj);
                if (obj != null && !obj.equals("")) continue;
                ++blankCount;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskRunnerException(4, "", e);
        }
        if (blankCount == rec.size()) {
            rec = null;
        }
        return rec;
    }

    private boolean hasNextRecord() throws TaskRunnerException {
        boolean rtn = false;
        try {
            if (this.currentRowCount >= this.fetchRowCount && this.currentRowCount < this.allRowCount) {
                this.rs = this.exec.executeQuery(this.currentRowCount, this.maxQueryCount);
                this.fetchRowCount += this.rs.size();
            }
            rtn = this.rs.next();
            ++this.currentRowCount;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new TaskRunnerException(4, "", e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskRunnerException(4, "", e);
        }
        return rtn;
    }

    private IQueryExecutor getQueryExecutor() throws TaskRunnerException {
        IMetaDataPK mainQueryPK = this.getQueryMetaDataPK();
        EntityViewInfo entityViewInfo = this.getEntityViewInfo();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(entityViewInfo);
        String sorterItems = (String)this.dp.getContextParam().get("sorterItems");
        exec.option().isIgnoreOrder = !StringUtils.isEmpty((String)sorterItems);
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        exec.setObjectView(entityViewInfo);
        return exec;
    }

    private IMetaDataPK getQueryMetaDataPK() throws TaskRunnerException {
        String queryPK = (String)this.dp.getContextParam().get("mainQueryPK");
        MetaDataPK mainQueryPK = new MetaDataPK(queryPK);
        return mainQueryPK;
    }

    private EntityViewInfo getEntityViewInfo() throws TaskRunnerException {
        EntityViewInfo entityViewInfo = (EntityViewInfo)this.dp.getContextParam().get("commonFilter");
        if (entityViewInfo == null) {
            entityViewInfo = new EntityViewInfo();
        }
        try {
            String sorterItems;
            String filterItems = (String)this.dp.getContextParam().get("filterItems");
            if (filterItems != null && filterItems.length() > 0) {
                FilterInfo filterInfo = new FilterInfo(filterItems);
                if (FilterUtility.hasFilterItem((FilterInfo)entityViewInfo.getFilter())) {
                    entityViewInfo.getFilter().mergeFilter(filterInfo, "AND");
                } else {
                    entityViewInfo.setFilter(new FilterInfo(filterItems));
                }
            }
            if ((sorterItems = (String)this.dp.getContextParam().get("sorterItems")) != null) {
                SorterItemCollection sorterItemCollection = new SorterItemCollection();
                if (sorterItems.toLowerCase().indexOf("order by") == -1) {
                    sorterItems = "ORDER BY " + sorterItems;
                }
                sorterItemCollection.getSorter().decode(sorterItems);
                entityViewInfo.setSorter(sorterItemCollection);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return entityViewInfo;
    }

    private List<String> getExportFields() {
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<FieldPropertyInfo> fpiList = this.structInfo.getFieldCollection();
        for (FieldPropertyInfo fpi : fpiList) {
            if (fpi.isVirtualField()) continue;
            fields.add(fpi.getFieldName());
        }
        return fields;
    }

    @Override
    protected void onFinishRunning() throws TaskRunnerException {
        if (this.sheetWriter != null) {
            this.sheetWriter.closeWriter();
            this.sheetWriter = null;
        }
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            this.rs = null;
        }
        if (this.excelWriter != null) {
            try {
                this.excelWriter.processFile();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new TaskRunnerException(4, e.getMessage(), e);
            }
        }
    }

    @Override
    protected void onDataError(Throwable ex) throws TaskRunnerException {
    }

    @Override
    protected void onDataSuccess() throws TaskRunnerException {
    }

    @Override
    protected void handFailure(Exception ex) throws Exception {
    }

    @Override
    protected void handSuccess() throws Exception {
    }

    @Override
    public TaskResult getTaskResult() {
        TaskResult rs = new TaskResult();
        rs.setTaskEnum(TaskEnum.exportTask);
        return rs;
    }

    @Override
    public void setTaskRsKey(String key) {
    }

    @Override
    protected void onAfterProcess() throws TaskRunnerException {
    }

    private BigDecimal dropBigDecimalZero(BigDecimal bigDecimal) {
        String decimalString = this.dropBigDecimalZero(bigDecimal.toPlainString());
        int dotPos = decimalString.indexOf(46);
        int scale = dotPos > 0 ? decimalString.length() - (dotPos + 1) : 0;
        BigDecimal result = new BigDecimal(decimalString);
        result.setScale(scale);
        return result;
    }

    public String dropBigDecimalZero(String s) {
        if (s.indexOf(".") > 0 && (s = s.replaceAll("0+?$", "")).endsWith(".")) {
            s = s + "00";
        }
        if (s.equals("0.00")) {
            s = "0";
        }
        return s;
    }

    public String dropTimestampDot(String s) {
        int index = -1;
        if (null != s && (index = s.indexOf(".")) > 0) {
            s = s.substring(0, index);
        }
        return s;
    }
}

