/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.Context;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class IEImplGenerator {
    private static Logger logger = SysLog.getLogger(IEImplGenerator.class);
    private Context ctx;

    public void runImport(Context ctx, TaskExternalCode taskCode) throws TaskRunnerException {
        BlockDataTransmission trans = this.createImplementObject(taskCode);
        trans.importFile(ctx, taskCode);
    }

    private BlockDataTransmission createImplementObject(TaskExternalCode taskCode) throws TaskRunnerException {
        BlockDataTransmission iObject = null;
        try {
            Class<?> classDefinition = Class.forName(taskCode.getDataTransmissionClassName());
            iObject = (BlockDataTransmission)classDefinition.newInstance();
            HashMap<String, Integer> contextParam = new HashMap<String, Integer>();
            DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
            Map myParam = dp.getContextParam();
            if (myParam != null) {
                contextParam.putAll(myParam);
            }
            contextParam.put("DATATASKMODE", new Integer(dp.datataskMode));
            iObject.setContextParameter(contextParam);
        }
        catch (Exception e) {
            logger.error((Object)e);
            Locale l = this.ctx.getLocale();
            String detail = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "create", l) + taskCode.getDataTransmissionClassName() + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "createException", l);
            detail = detail + e.getMessage();
            throw new TaskRunnerException(4, detail, e);
        }
        return iObject;
    }
}

