/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.util.StringUtils;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MultiExcelInfo
implements IMarshalObject {
    private String fileName;
    private String fileUuId;
    private String errFileUuId;
    private int rowCount;
    private Map<Integer, String> sheetId2Name;
    private Map<Integer, String> sheetId2Solu;
    private Map<String, Integer> solu2Seq;

    public Map<Integer, List<Integer>> takeSeqToSheetId() {
        HashMap<Integer, List<Integer>> seqToSheetId = new HashMap<Integer, List<Integer>>();
        for (Map.Entry<Integer, String> entry : this.sheetId2Solu.entrySet()) {
            int sheetId = entry.getKey();
            String solution = entry.getValue();
            int seq = this.solu2Seq.get(solution);
            ArrayList<Integer> sheetIds = (ArrayList<Integer>)seqToSheetId.get(seq);
            if (sheetIds == null) {
                sheetIds = new ArrayList<Integer>();
            }
            sheetIds.add(sheetId);
            seqToSheetId.put(seq, sheetIds);
        }
        return seqToSheetId;
    }

    public Map<Integer, String> takeSheetId2NameBySolu(String solution) {
        TreeMap<Integer, String> _sheetId2Name = new TreeMap<Integer, String>();
        for (Map.Entry<Integer, String> entry : this.sheetId2Solu.entrySet()) {
            if (!entry.getValue().equals(solution)) continue;
            int sheetId = entry.getKey();
            _sheetId2Name.put(sheetId, this.sheetId2Name.get(sheetId));
        }
        return _sheetId2Name;
    }

    public boolean isExist(String solution) {
        return this.solu2Seq.containsKey(solution);
    }

    public Set<String> takeSheetNames() {
        HashSet<String> sheets = new HashSet<String>();
        sheets.addAll(this.sheetId2Name.values());
        return sheets;
    }

    public int takeSheetIdBySheetName(String sheetName) {
        int sheetId = 0;
        if (StringUtils.isEmpty((String)sheetName)) {
            return sheetId;
        }
        for (Map.Entry<Integer, String> entry : this.sheetId2Name.entrySet()) {
            sheetId = entry.getKey();
            String _sheetName = entry.getValue();
            if (!sheetName.equals(_sheetName)) continue;
            break;
        }
        return sheetId;
    }

    public Map<Integer, String> takeSubSheetId2NameBySheetName(Set<String> sheetNames) {
        HashMap<Integer, String> subMap = new HashMap<Integer, String>();
        for (String sheetName : sheetNames) {
            int sheetId = this.takeSheetIdBySheetName(sheetName);
            subMap.put(sheetId, sheetName);
        }
        return subMap;
    }

    public Map<Integer, String> takeSubSheetId2NameBySheetId(Set<Integer> sheetIds) {
        HashMap<Integer, String> subMap = new HashMap<Integer, String>();
        for (int sheetId : sheetIds) {
            subMap.put(sheetId, this.sheetId2Name.get(sheetId));
        }
        return subMap;
    }

    public List<String> takeSoluList() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> iter = this.getSheetId2Solu().values().iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public void addSheetId2Name(int sheetId, String sheetName) {
        if (this.sheetId2Name == null) {
            this.sheetId2Name = new HashMap<Integer, String>();
        }
        this.sheetId2Name.put(sheetId, sheetName);
    }

    public void addSheetId2Solu(int sheetId, String solu) {
        if (this.sheetId2Solu == null) {
            this.sheetId2Solu = new HashMap<Integer, String>();
        }
        this.sheetId2Solu.put(sheetId, solu);
    }

    public void addSolu2Seq(String solu, int seq) {
        if (this.solu2Seq == null) {
            this.solu2Seq = new HashMap<String, Integer>();
        }
        this.solu2Seq.put(solu, seq);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileUuId() {
        return this.fileUuId;
    }

    public void setFileUuId(String fileUuId) {
        this.fileUuId = fileUuId;
    }

    public Map<Integer, String> getSheetId2Name() {
        return this.sheetId2Name;
    }

    public void setSheetId2Name(Map<Integer, String> sheetId2Name) {
        this.sheetId2Name = sheetId2Name;
    }

    public Map<Integer, String> getSheetId2Solu() {
        return this.sheetId2Solu;
    }

    public void setSheetId2Solu(Map<Integer, String> sheetId2Solu) {
        this.sheetId2Solu = sheetId2Solu;
    }

    public Map<String, Integer> getSolu2Seq() {
        return this.solu2Seq;
    }

    public void setSolu2Seq(Map<String, Integer> solu2Seq) {
        this.solu2Seq = solu2Seq;
    }

    public String getErrFileUuId() {
        return this.errFileUuId;
    }

    public void setErrFileUuId(String errFileUuId) {
        this.errFileUuId = errFileUuId;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate((IMarshalObject)this).writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate((IMarshalObject)this).readExternal(in);
    }

    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeObject((Object)this.fileName);
        marshaller.writeObject((Object)this.fileUuId);
        marshaller.writeObject((Object)this.errFileUuId);
        marshaller.writeObject((Object)this.rowCount);
        marshaller.writeObject(this.sheetId2Name);
        marshaller.writeObject(this.sheetId2Solu);
        marshaller.writeObject(this.solu2Seq);
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.fileName = (String)unmarshaller.readObject();
        this.fileUuId = (String)unmarshaller.readObject();
        this.errFileUuId = (String)unmarshaller.readObject();
        this.rowCount = (Integer)unmarshaller.readObject();
        this.sheetId2Name = (Map)unmarshaller.readObject();
        this.sheetId2Solu = (Map)unmarshaller.readObject();
        this.solu2Seq = (Map)unmarshaller.readObject();
    }
}

