/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DefaultDataTransmission;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.IDataTransmission;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.export.ExternalExcelDataWriter;
import com.kingdee.eas.tools.datatask.export.ExternalExcelDataWriter2007;
import com.kingdee.eas.tools.datatask.export.ExternalTxtDataWriter;
import com.kingdee.eas.tools.datatask.export.IExternalDataWriter;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskIERunner;
import com.kingdee.eas.tools.datatask.task.TaskUtil;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class MultiSheetTaskExportEASDataRunner
extends TaskIERunner {
    private static Logger logger = SysLog.getLogger(MultiSheetTaskExportEASDataRunner.class);
    private IRowSet[] rss = null;
    private int allRowCount = 0;
    private int currentRowCount = 0;
    private List<Integer> fetchRowCountList = new ArrayList<Integer>();
    int maxQueryCount = 0;
    int maxExcelSheetRowCount2003 = 60000;
    int maxExcelSheetRowCount2007 = 100000;
    private IQueryExecutor[] execs = null;
    private int sheetIndex = 0;
    private IDataTransmission[] iDataTranss;
    private Context[] ctxs;
    private IExternalDataWriter writer = null;
    private DatataskParameter[] dps = null;
    private boolean isCodeImplementTrans = true;
    private boolean isUserDefineTrans = false;
    private boolean isScriptTrans = false;
    private DefaultDataTransmission[] defaultTrans = null;
    private String fileName = "";
    protected ITask[] tasks;
    int index = 0;
    int runningLopCount = 0;

    public MultiSheetTaskExportEASDataRunner(ITask task) {
        super(task, null);
    }

    public MultiSheetTaskExportEASDataRunner(ITask task, Context ctx) {
        super(task, ctx);
    }

    public MultiSheetTaskExportEASDataRunner(ITask[] tasks, Context ctx) {
        super(tasks[0], ctx);
        this.tasks = tasks;
    }

    public ITask[] getTasks() {
        return this.tasks;
    }

    public void setTasks(ITask[] tasks) {
        this.tasks = tasks;
    }

    @Override
    protected void onInitResources() throws TaskRunnerException {
        int length = this.tasks.length;
        this.rss = new IRowSet[length];
        this.execs = new IQueryExecutor[length];
        this.iDataTranss = new IDataTransmission[length];
        this.defaultTrans = new DefaultDataTransmission[length];
        this.dps = new DatataskParameter[length];
        this.ctxs = new Context[length];
    }

    @Override
    protected void onMainRunningProcess() throws TaskRunnerException {
        int length = this.tasks.length;
        IObjectPK[] logPKS = new IObjectPK[length];
        String methodName = ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"0_DatataskRunServerControllerBean", (Locale)this.ctx.getLocale());
        String instanceDetail = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"multiSheetExport");
        String logItemName = "dataExport";
        for (int i = 0; i < length && !this.stopOnDataErr; ++i) {
            String errMsg;
            try {
                TaskExternalCode taskCode = (TaskExternalCode)this.tasks[i];
                this.dps[i] = (DatataskParameter)taskCode.getTaskParameter();
                logPKS[i] = LogUtil.beginLog((Context)this.ctx, (String)methodName, (BOSObjectType)BOSObjectType.create((String)"5C28524B"), null, (String)(instanceDetail + ":" + this.dps[i].getAlias()), (String)logItemName);
                this.tl.setLogUuID(this.tasks[i].getTaskUuID());
                this.tl.setTaskState(TaskStateEnum.INITTASK);
                TaskLogUtil.putLog(this.tl);
                this.continueCondition = true;
                this.initErrorHandleMode(this.tasks[i]);
                this.index = i;
                this.sheetIndex = 0;
                this.ctxs[i] = (Context)this.dps[i].getContextParam().get("context");
                String fileType = this.dps[i].getFileType();
                if ("xls".equals(fileType)) {
                    if (this.writer == null) {
                        this.writer = new ExternalExcelDataWriter();
                    }
                    this.writer.setLocacle(this.ctx.getLocale());
                    ((ExternalExcelDataWriter)this.writer).setExportTemplate(false);
                    ((ExternalExcelDataWriter)this.writer).setSheetName(this.dps[i].alias);
                } else if ("xlsx".equals(fileType)) {
                    if (this.writer == null) {
                        this.writer = new ExternalExcelDataWriter2007();
                    }
                    this.writer.setLocacle(this.ctx.getLocale());
                    ((ExternalExcelDataWriter2007)this.writer).setSheetName(this.dps[i].alias);
                } else {
                    this.writer = new ExternalTxtDataWriter();
                    this.writer.setLocacle(this.ctx.getLocale());
                }
                if (StringUtils.isEmpty((CharSequence)this.writer.getFileName())) {
                    this.writer.setFileName(this.dps[i].getOpenFileName());
                }
                this.fileName = this.writer.getFileName();
                this.writer.openWriter();
                this.writer.writeStruct(taskCode.getExternalStructInfo());
                if (this.dps[i].getContextParam().get("exportTemplateOnly") != null) {
                    this.continueCondition = false;
                    return;
                }
                try {
                    if (this.continueCondition) {
                        this.onBeforeEachRunningLoop();
                    }
                }
                catch (TaskRunnerException ex) {
                    logger.error((Object)this.emptyIfNull(ex.getMessage()), (Throwable)((Object)ex));
                    this.onDataError((Throwable)((Object)ex));
                }
                this.onRecordProcess();
                this.needInitCountFlag = false;
                if (TaskLogUtil.getLog(this.tasks[i].getTaskUuID()) != null && TaskStateEnum.SUCCESSEND.equals((Object)TaskLogUtil.getLog(this.tasks[i].getTaskUuID()).getTaskState())) {
                    LogUtil.afterLog((Context)this.ctx, (IObjectPK)logPKS[i]);
                }
                if (this.nFailCount <= 0) {
                    this.tl.setTaskState(TaskStateEnum.SUCCESSEND);
                } else {
                    this.tl.setTaskState(TaskStateEnum.FAILEND);
                }
                TaskLogUtil.putLog(this.tl);
                continue;
            }
            catch (TaskRunnerException ex) {
                if (ex.getExceptionCode() == 4) {
                    errMsg = this.getFatalError();
                    this.tl.addException(errMsg, (Throwable)((Object)ex), null);
                    this.tl.setTaskState(TaskStateEnum.FAILEND);
                    TaskLogUtil.putLog(this.tl);
                }
                this.dataErrorHandle((Throwable)((Object)ex));
                continue;
            }
            catch (Exception e) {
                errMsg = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fatalError", this.locale);
                if (e.getMessage() != null) {
                    errMsg = errMsg + "\u3002" + e.getMessage();
                }
                this.tl.addException(errMsg, e, null);
                this.tl.setTaskState(TaskStateEnum.FAILEND);
                TaskLogUtil.putLog(this.tl);
                this.dataErrorHandle(e);
            }
        }
    }

    private void initErrorHandleMode(ITask task) {
        TaskExternalCode taskCode = (TaskExternalCode)task;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        this.errorHandle = dp.getContextParam().get("errorHandleMode") != null ? (ErrorHandleModeEnum)((Object)dp.getContextParam().get("errorHandleMode")) : ErrorHandleModeEnum.ReturnWhenFinish;
    }

    @Override
    protected void onBeforeEachRunningLoop() throws TaskRunnerException {
        if (this.runningLopCount++ > this.index) {
            return;
        }
        super.onBeforeEachRunningLoop();
        TaskExternalCode taskCode = (TaskExternalCode)this.tasks[this.index];
        this.isCodeImplementTrans = TaskUtil.isCodeImplementTrans(taskCode);
        this.isUserDefineTrans = TaskUtil.isUserDefineTrans(taskCode);
        this.isScriptTrans = TaskUtil.isScriptTrans(taskCode);
        this.defaultTrans[this.index] = new DefaultDataTransmission(this.ctx);
        this.defaultTrans[this.index].setDIETemplateInfo(taskCode.getDIETemplateInfo());
        this.defaultTrans[this.index].setContext(this.ctx);
        this.iDataTranss[this.index] = this.createDataTransmissionObject(taskCode);
        IMetaDataPK mainQueryPK = this.getQueryMetaDataPK((DatataskParameter)taskCode.getTaskParameter(), this.index);
        EntityViewInfo mainQuery = this.getMainQuery((DatataskParameter)taskCode.getTaskParameter(), this.index);
        try {
            this.execs[this.index] = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)mainQueryPK);
            this.execs[this.index].setObjectView(mainQuery);
            this.allRowCount = this.execs[this.index].getRowCount();
            IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
            this.maxQueryCount = manager.getCriticalIDList();
            if (this.maxQueryCount == 0) {
                this.maxQueryCount = 10000;
            }
            this.rss[this.index] = this.execs[this.index].executeQuery(0, this.maxQueryCount);
            this.fetchRowCountList.add(this.rss[this.index].size());
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskRunnerException(4, "Sheet\u9875\u7b7e[" + this.index + "]:" + EASResourceJoinUtil.getServerString("getexportdatafail", this.locale), e);
        }
    }

    private IMetaDataPK getQueryMetaDataPK(DatataskParameter dp, int i) throws TaskRunnerException {
        IMetaDataPK mainQueryPK = null;
        if (this.isExportFromListUI(i)) {
            mainQueryPK = (IMetaDataPK)dp.getContextParam().get("mainQueryPK");
            if (mainQueryPK == null) {
                return this.getCodeMetaDataPK(i);
            }
            return mainQueryPK;
        }
        return this.getCodeMetaDataPK(i);
    }

    private IMetaDataPK getCodeMetaDataPK(int i) throws TaskRunnerException {
        MetaDataPK mainQueryPK = null;
        String fullName = null;
        if (this.isCodeImplementTrans) {
            fullName = this.iDataTranss[i].getExportQueryInfo(this.ctx);
        } else if (this.isUserDefineTrans) {
            fullName = this.defaultTrans[i].getExportQueryInfo(this.ctx);
        }
        if (fullName == null) {
            throw new TaskRunnerException(4, EASResourceJoinUtil.getServerString("exportnotimplement", this.locale));
        }
        QueryInfo queryInfo = MultiSheetTaskExportEASDataRunner.getQueryInfo(this.ctx, fullName);
        if (queryInfo == null) {
            throw new TaskRunnerException(4, EASResourceJoinUtil.getServerString("exportnotimplement", this.locale));
        }
        mainQueryPK = new MetaDataPK(fullName);
        return mainQueryPK;
    }

    private EntityViewInfo getMainQuery(DatataskParameter dp, int i) throws TaskRunnerException {
        EntityViewInfo mainQuery = null;
        if (this.isExportFromListUI(i)) {
            mainQuery = (EntityViewInfo)dp.getContextParam().get("mainQuery");
            if (mainQuery == null) {
                FilterInfo filterInfo = null;
                if (this.isCodeImplementTrans) {
                    filterInfo = this.iDataTranss[i].getExportFilterForQuery(this.ctx);
                } else if (this.isUserDefineTrans) {
                    filterInfo = this.defaultTrans[i].getExportFilterForQuery(this.ctx);
                }
                EntityViewInfo commonFilter = new EntityViewInfo();
                mainQuery = this.getEntityViewInfo(filterInfo, commonFilter);
            }
        } else {
            String queryName;
            QueryInfo queryInfo;
            ArrayList entityNames;
            FilterInfo filterInfo = null;
            if (this.isCodeImplementTrans) {
                filterInfo = this.iDataTranss[i].getExportFilterForQuery(this.ctx);
            } else if (this.isUserDefineTrans && (entityNames = MultiSheetTaskExportEASDataRunner.getEntitiyNames(queryInfo = MultiSheetTaskExportEASDataRunner.getQueryInfo(this.ctx, queryName = this.defaultTrans[i].getDIETemplateInfo().getQueryName()))).size() > 0) {
                String name = (String)entityNames.get(0);
                EntityObjectInfo entityObjectInfo = MultiSheetTaskExportEASDataRunner.getEntity(this.ctx, name);
                PropertyCollection coll = MultiSheetTaskExportEASDataRunner.getAllEntityProperties(entityObjectInfo);
                for (int j = 0; j < coll.size(); ++j) {
                    String proName;
                    PropertyInfo info = coll.get(j);
                    if (!MultiSheetTaskExportEASDataRunner.isValidProp(info) || !(proName = info.getName()).equalsIgnoreCase("CU")) continue;
                    filterInfo = this.defaultTrans[i].getExportFilterForQuery(this.ctx);
                    break;
                }
            }
            EntityViewInfo commonFilter = null;
            commonFilter = dp.getContextParam().get("commonFilter") instanceof EntityViewInfo ? (EntityViewInfo)dp.getContextParam().get("commonFilter") : new EntityViewInfo();
            mainQuery = this.getEntityViewInfo(filterInfo, commonFilter);
        }
        return mainQuery;
    }

    private boolean isExportFromListUI(int i) {
        return this.dps[i].getContextParam().get("exportFrom") == null;
    }

    private void checkRsSize(IRowSet rs) throws TaskRunnerException {
        if (rs != null && rs.size() > 60000) {
            throw new TaskRunnerException(4, EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "exportrecordtoolarge", new Object[]{60000}));
        }
    }

    protected final EntityViewInfo getEntityViewInfo(FilterInfo filterCU, EntityViewInfo QueryFilter) throws TaskRunnerException {
        if (filterCU != null && filterCU.size() > 0) {
            if (QueryFilter.getFilter() != null && QueryFilter.getFilter().size() > 0 && !QueryFilter.getFilter().toString().equals("")) {
                FilterItemCollection filters = QueryFilter.getFilter().getFilterItems();
                boolean hasCUFilter = false;
                for (int i = 0; i < filters.size(); ++i) {
                    if (!filters.get(i).getPropertyName().equals("CU.id")) continue;
                    hasCUFilter = true;
                    break;
                }
                if (!hasCUFilter) {
                    try {
                        QueryFilter.getFilter().mergeFilter(filterCU, "AND");
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                        throw new TaskRunnerException(EASResourceJoinUtil.getServerString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "61_TaskExportEASDataRunner", this.locale));
                    }
                }
            } else {
                QueryFilter.setFilter(filterCU);
            }
        }
        return QueryFilter;
    }

    private IDataTransmission createDataTransmissionObject(TaskExternalCode taskCode) throws TaskRunnerException {
        if (taskCode.getDataTransmissionClassName() == null || taskCode.getDataTransmissionClassName().equals("")) {
            return null;
        }
        IDataTransmission iObject = null;
        try {
            Class<?> classDefinition = Class.forName(taskCode.getDataTransmissionClassName());
            iObject = (IDataTransmission)classDefinition.newInstance();
            HashMap<String, Integer> contextParam = new HashMap<String, Integer>();
            DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
            Map myParam = dp.getContextParam();
            if (myParam != null) {
                contextParam.putAll(myParam);
            }
            contextParam.put("DATATASKMODE", new Integer(dp.datataskMode));
            iObject.setContextParameter(contextParam);
        }
        catch (Exception e) {
            logger.error((Object)e);
            String detail = EASResourceJoinUtil.getServerString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "62_TaskExportEASDataRunner", new Object[]{taskCode.getDataTransmissionClassName()}, this.locale);
            detail = detail + e.getMessage();
            throw new TaskRunnerException(4, detail, e);
        }
        return iObject;
    }

    @Override
    protected boolean hasMoreRecord() throws TaskRunnerException {
        boolean rtn = false;
        try {
            if (this.currentRowCount >= this.fetchRowCountList.get(this.index) && this.currentRowCount < this.allRowCount) {
                this.rss[this.index] = this.execs[this.index].executeQuery(this.currentRowCount, this.maxQueryCount);
                this.fetchRowCountList.add(this.index, this.fetchRowCountList.get(this.index) + this.rss[this.index].size());
            }
            rtn = this.rss[this.index].next();
            ++this.currentRowCount;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new TaskRunnerException(4, "", e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskRunnerException(4, "", e);
        }
        return rtn;
    }

    @Override
    protected void onRecordProcess() throws TaskRunnerException {
        while (this.hasMoreRecord() && this.continueCondition) {
            ++this.nCurCount;
            try {
                this.onEachRunningLoop();
                if (this.nSuccessCount % 100 != 0) continue;
                this.tl.setSuccessRecordCount(this.nSuccessCount);
            }
            catch (Throwable ex) {
                logger.error((Object)this.emptyIfNull(ex.getMessage()), ex);
                ++this.nFailCount;
                this.onDataError(ex);
            }
        }
        if (this.nSuccessCount % 100 != 0) {
            this.tl.setSuccessRecordCount(this.nSuccessCount);
        }
        if (this.nFailCount <= 0) {
            this.tl.setTaskState(TaskStateEnum.SUCCESSEND);
        } else {
            this.tl.setTaskState(TaskStateEnum.FAILEND);
        }
        TaskLogUtil.putLog(this.tl);
    }

    private boolean isHasData(Map data) {
        if (data == null || data.size() <= 0) {
            return false;
        }
        Set sets = data.keySet();
        Iterator it = sets.iterator();
        int blankDataCount = 0;
        while (it.hasNext()) {
            Object oneData = data.get(it.next());
            if (oneData != null && !oneData.equals("")) {
                return true;
            }
            ++blankDataCount;
        }
        return blankDataCount != data.size();
    }

    @Override
    protected void onFinishingRunning() throws TaskRunnerException {
        if (this.writer != null) {
            this.writer.closeWriter();
            this.writer = null;
        }
        for (int i = 0; i < this.tasks.length; ++i) {
            if (this.rss[i] == null) continue;
            try {
                this.rss[i].close();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            this.rss[i] = null;
        }
    }

    @Override
    protected void onEachRunningLoop() throws Exception {
        Map data = null;
        if (this.isCodeImplementTrans) {
            data = this.iDataTranss[this.index].exportTransmit(this.rss[this.index], this.ctx);
        }
        if (this.isUserDefineTrans) {
            Map userMap = this.defaultTrans[this.index].exportTransmit(this.rss[this.index], this.ctx);
            if (data != null) {
                data.putAll(userMap);
            } else {
                data = userMap;
            }
        }
        if (this.isHasData(data)) {
            TaskExternalCode taskCode;
            String fileType = this.dps[this.index].getFileType();
            if ("xls".equals(fileType) && (this.currentRowCount + 1) % this.maxExcelSheetRowCount2003 == 0) {
                ((ExternalExcelDataWriter)this.writer).setSheetName(this.dps[this.index].alias + ++this.sheetIndex);
                ((ExternalExcelDataWriter)this.writer).openWriter();
                taskCode = (TaskExternalCode)this.task;
                this.writer.writeStruct(taskCode.getExternalStructInfo());
            }
            if ("xlsx".equals(fileType) && (this.currentRowCount + 1) % this.maxExcelSheetRowCount2007 == 0) {
                ((ExternalExcelDataWriter2007)this.writer).setSheetName(this.dps[this.index].alias + ++this.sheetIndex);
                ((ExternalExcelDataWriter2007)this.writer).openWriter();
                taskCode = (TaskExternalCode)this.task;
                this.writer.writeStruct(taskCode.getExternalStructInfo());
            }
            this.writer.writeLine(data);
            ++this.nSuccessCount;
        }
    }

    @Override
    protected String getMsgOnDataErr() {
        return "\u9875\u7b7e[" + this.tasks[this.index].toString() + "]--" + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "exportno", this.locale) + this.nCurCount + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "lineData", this.locale);
    }

    public static QueryInfo getQueryInfo(Context ctx, String queryName) {
        MetaDataPK queryPK = new MetaDataPK(queryName);
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getQuery((IMetaDataPK)queryPK);
    }

    protected static ArrayList getEntitiyNames(QueryInfo queryInfo) {
        ArrayList<String> entityNames = new ArrayList<String>();
        SubObjectCollection subObjectCollection = queryInfo.getSubObjects();
        int size = subObjectCollection.size();
        for (int i = 0; i < size; ++i) {
            SubObjectInfo subObjectInfo = subObjectCollection.get(i);
            if (subObjectInfo instanceof SubEntityInfo) {
                SubEntityInfo subEntityInfo = (SubEntityInfo)subObjectInfo;
                String entityName = subEntityInfo.getEntityRef().getPackage() + "." + subEntityInfo.getEntityRef().getName();
                entityNames.add(entityName);
                continue;
            }
            if (!(subObjectInfo instanceof SubQueryInfo)) continue;
            QueryInfo subQueryInfo = ((SubQueryInfo)subObjectInfo).getQueryRef();
            entityNames.addAll(MultiSheetTaskExportEASDataRunner.getEntitiyNames(subQueryInfo));
        }
        return entityNames;
    }

    public static EntityObjectInfo getEntity(Context ctx, String entityName) {
        MetaDataPK entityPK = new MetaDataPK(entityName);
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getEntity((IMetaDataPK)entityPK);
    }

    public static PropertyCollection getAllEntityProperties(EntityObjectInfo entity) {
        PropertyCollection properties = new PropertyCollection();
        properties.addObjectCollection((IObjectCollection)entity.getProperties());
        while (entity.getBaseEntity() != null) {
            properties.addObjectCollection((IObjectCollection)entity.getBaseEntity().getProperties());
            entity = entity.getBaseEntity();
        }
        return properties;
    }

    private static boolean isValidProp(PropertyInfo info) {
        return info instanceof LinkPropertyInfo;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    protected void dataErrorHandle(Throwable ex) {
        switch (this.errorHandle.getValue()) {
            case 1: {
                this.onDataErrorStop(ex);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.onDataErrorSkip(ex);
                break;
            }
            default: {
                this.onDataErrorStop(ex);
            }
        }
    }
}

