/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.export.Excel2007Writer;
import com.kingdee.eas.tools.datatask.export.ExternalExcelSheetWriter;
import com.kingdee.eas.tools.datatask.log.ExcelTaskLog;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.task.AbstractTaskRunner;
import com.kingdee.eas.tools.datatask.task.DataGridExportExcelRunner;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.util.TaskEnum;
import com.kingdee.eas.tools.datatask.task.util.TaskResult;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultitaskExportExcelRunner
extends AbstractTaskRunner {
    private static Logger logger = SysLog.getLogger(DataGridExportExcelRunner.class);
    private IRowSet rs = null;
    private int allRowCount = 0;
    private int currentRowCount = 0;
    private int fetchRowCount = 0;
    int maxQueryCount = 10000;
    int remainder = 0;
    int maxExcelSheetRowCount2007 = 100000;
    private IQueryExecutor exec = null;
    private int sheetIndex = 0;
    private ExternalExcelSheetWriter sheetWriter = null;
    private DatataskParameter dp = null;
    private ExternalStructInfo structInfo;
    private boolean hasNext = true;
    private Excel2007Writer excelWriter;
    private String logUuId;
    private String fileUuId;
    private String solu;
    private ExcelTaskLog excelLog = null;
    private String taskRsKey;

    public MultitaskExportExcelRunner(ITask task, Context ctx) {
        super(task, ctx);
        this.dp = (DatataskParameter)task.getTaskParameter();
        this.fileUuId = this.dp.getFileUuId();
        this.logUuId = task.getTaskUuID();
        this.solu = this.dp.getSolutionName();
        this.structInfo = this.taskCode.getExternalStructInfo();
    }

    @Override
    protected boolean hasNext() throws TaskRunnerException {
        return this.hasNext;
    }

    @Override
    protected void onBeforeProcess() throws TaskRunnerException {
        super.onBeforeProcess();
        this.initRowSet();
        this.initExcelWriter();
        this.setTaskInfo();
    }

    private void initRowSet() throws TaskRunnerException {
        try {
            this.exec = this.getQueryExecutor();
            this.allRowCount = this.exec.getRowCount();
            IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
            this.rs = this.exec.executeQuery(0, this.maxQueryCount);
            this.fetchRowCount = this.rs.size();
        }
        catch (Exception e) {
            throw new TaskRunnerException(4, e.getMessage(), e);
        }
    }

    private void initExcelWriter() throws TaskRunnerException {
        String fileName = GlobalFunction.getFilePathForServer() + this.fileUuId;
        this.excelWriter = new Excel2007Writer(fileName);
        this.excelWriter.initWb();
        this.sheetWriter = new ExternalExcelSheetWriter(this.excelWriter);
        this.sheetWriter.setSheetName(this.dp.getAlias());
        int rowspan = 0;
        rowspan = this.allRowCount / this.maxExcelSheetRowCount2007 > 0 ? this.maxExcelSheetRowCount2007 : this.allRowCount;
        this.remainder = this.allRowCount - rowspan;
        this.sheetWriter.openWriter();
        this.sheetWriter.setDimension(rowspan + 4, this.structInfo.getFieldCollection().size());
        this.sheetWriter.writeStruct(this.structInfo);
    }

    @Override
    protected void onEachRunningLoop() throws Exception {
        Map<String, Object> data = this.getNextSingle();
        if (data == null && !this.hasNext) {
            return;
        }
        if ((this.currentRowCount + 1) % this.maxExcelSheetRowCount2007 == 0) {
            this.sheetWriter.closeWriter();
            this.sheetWriter = new ExternalExcelSheetWriter(this.excelWriter);
            this.sheetWriter.setSheetName(this.dp.getAlias() + ++this.sheetIndex);
            int rowspan = 0;
            rowspan = this.remainder / this.maxExcelSheetRowCount2007 > 0 ? this.maxExcelSheetRowCount2007 : this.remainder;
            this.remainder -= rowspan;
            this.sheetWriter.openWriter();
            this.sheetWriter.setDimension(rowspan + 4, this.structInfo.getFieldCollection().size());
            this.sheetWriter.writeStruct(this.structInfo);
        }
        this.sheetWriter.writeLine(data);
    }

    @Override
    protected void onDataError(Throwable ex) throws TaskRunnerException {
        this.excelLog = this.createAndGetExcelLog();
        this.excelLog.setExcelErrorInfo(this.dp.getAlias() + ": " + ex.getMessage());
    }

    @Override
    protected void onDataSuccess() throws TaskRunnerException {
        if (this.hasNext) {
            this.excelLog = this.createAndGetExcelLog();
            this.excelLog.setExpCurrentRowCount();
        }
    }

    @Override
    protected void onFinishRunning() throws TaskRunnerException {
        if (this.sheetWriter != null) {
            this.sheetWriter.closeWriter();
            this.sheetWriter = null;
        }
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            this.rs = null;
        }
        if (this.excelWriter != null) {
            try {
                this.excelWriter.processFile();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new TaskRunnerException(4, e.getMessage(), e);
            }
        }
    }

    @Override
    protected void handFailure(Exception ex) throws Exception {
        this.excelLog = this.createAndGetExcelLog();
        this.excelLog.setTaskLogInfo(TaskStateEnum.FAILEND, ((TaskRunnerException)((Object)ex)).getOriginalMessage(), ex);
    }

    @Override
    protected void handSuccess() throws Exception {
        this.excelLog = this.createAndGetExcelLog();
        this.excelLog.setTaskState(TaskStateEnum.SUCCESSEND);
    }

    private void setTaskInfo() {
        this.excelLog = this.createAndGetExcelLog();
        this.excelLog.setTaskState(TaskStateEnum.PROCESS);
        this.excelLog.setExpAllRowCount(this.allRowCount);
    }

    @Override
    public void setTaskRsKey(String key) {
        this.taskRsKey = key;
    }

    @Override
    public TaskResult getTaskResult() {
        TaskResult rs = new TaskResult();
        rs.setTaskEnum(TaskEnum.exportTask);
        rs.setKey(this.getTaskRsKey());
        rs.setSucced(this.checkTaskIsSucced());
        return rs;
    }

    private boolean checkTaskIsSucced() {
        this.excelLog = this.createAndGetExcelLog();
        TaskStateEnum taskState = this.excelLog.getTaskState();
        return taskState.getValue() == 3;
    }

    public String getTaskRsKey() {
        return this.taskRsKey;
    }

    private ExcelTaskLog createAndGetExcelLog() {
        if (this.excelLog == null) {
            String fileName = this.dp.getFileName();
            this.excelLog = TaskLogUtil.createAndGetExcelLog(this.logUuId, this.solu, fileName);
            this.excelLog.setCtx(this.ctx);
        }
        return this.excelLog;
    }

    private Map<String, Object> getNextSingle() throws TaskRunnerException {
        Map rec = null;
        this.hasNext = this.hasNextRecord();
        if (this.hasNext) {
            rec = this.iDataTrans.exportTransmit(this.rs, this.ctx);
            if (this.isUserDefineTrans) {
                Map userMap = this.defaultTrans.exportTransmit(this.rs, this.ctx);
                if (rec != null) {
                    rec.putAll(userMap);
                }
            }
        }
        return rec;
    }

    private boolean hasNextRecord() throws TaskRunnerException {
        boolean rtn = false;
        try {
            if (this.currentRowCount >= this.fetchRowCount && this.currentRowCount < this.allRowCount) {
                this.rs = this.exec.executeQuery(this.currentRowCount, this.maxQueryCount);
                this.fetchRowCount += this.rs.size();
            }
            rtn = this.rs.next();
            ++this.currentRowCount;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskRunnerException(4, e.getMessage(), e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskRunnerException(4, e.getMessage(), e);
        }
        return rtn;
    }

    private IQueryExecutor getQueryExecutor() throws TaskRunnerException {
        IMetaDataPK mainQueryPK = this.getQueryMetaDataPK();
        EntityViewInfo mainQuery = this.getMainQuery();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(mainQuery);
        return exec;
    }

    private IMetaDataPK getQueryMetaDataPK() throws TaskRunnerException {
        IMetaDataPK mainQueryPK = (IMetaDataPK)this.dp.getContextParam().get("mainQueryPK");
        if (mainQueryPK == null) {
            return this.getCodeMetaDataPK();
        }
        return mainQueryPK;
    }

    private IMetaDataPK getCodeMetaDataPK() throws TaskRunnerException {
        MetaDataPK mainQueryPK = null;
        String fullName = null;
        fullName = this.iDataTrans.getExportQueryInfo(this.ctx);
        if (fullName == null) {
            throw new TaskRunnerException(4, EASResourceJoinUtil.getServerString("exportnotimplement", this.locale));
        }
        QueryInfo queryInfo = this.getQueryInfo(this.ctx, fullName);
        if (queryInfo == null) {
            throw new TaskRunnerException(4, EASResourceJoinUtil.getServerString("exportnotimplement", this.locale));
        }
        mainQueryPK = new MetaDataPK(fullName);
        return mainQueryPK;
    }

    private QueryInfo getQueryInfo(Context ctx, String queryName) {
        MetaDataPK queryPK = new MetaDataPK(queryName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        return loader.getQuery((IMetaDataPK)queryPK);
    }

    private EntityViewInfo getMainQuery() throws TaskRunnerException {
        FilterInfo filter = null;
        EntityViewInfo mainQuery = new EntityViewInfo();
        if (this.dp.getContextParam().get("mainQuery") instanceof String) {
            String filterStr = (String)this.dp.getContextParam().get("mainQuery");
            try {
                filter = new FilterInfo(filterStr);
                mainQuery.setFilter(filter);
            }
            catch (ParserException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new TaskRunnerException(e.getMessage());
            }
        } else {
            FilterInfo filterInfo = this.iDataTrans.getExportFilterForQuery(this.ctx);
            mainQuery = this.getEntityViewInfo(filterInfo, new EntityViewInfo());
        }
        return mainQuery;
    }

    private EntityViewInfo getEntityViewInfo(FilterInfo filterCU, EntityViewInfo queryFilter) throws TaskRunnerException {
        if (filterCU != null && filterCU.size() > 0) {
            if (queryFilter.getFilter() != null && queryFilter.getFilter().size() > 0 && !queryFilter.getFilter().toString().equals("")) {
                FilterItemCollection filters = queryFilter.getFilter().getFilterItems();
                boolean hasCUFilter = false;
                for (int i = 0; i < filters.size(); ++i) {
                    if (!filters.get(i).getPropertyName().equals("CU.id")) continue;
                    hasCUFilter = true;
                    break;
                }
                if (!hasCUFilter) {
                    try {
                        queryFilter.getFilter().mergeFilter(filterCU, "AND");
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                        throw new TaskRunnerException(EASResourceJoinUtil.getServerString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "61_TaskExportEASDataRunner", this.locale));
                    }
                }
            } else {
                queryFilter.setFilter(filterCU);
            }
        }
        return queryFilter;
    }

    @Override
    protected void onAfterProcess() throws TaskRunnerException {
    }
}

