/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.Context;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.ITaskRunnerAdapter;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import java.util.Locale;

public abstract class TaskAbstractRunnerAdapter
implements ITaskRunnerAdapter {
    protected Context ctx;
    protected Locale locale;
    protected ITask task;
    protected String runStats;
    protected TaskLog tl = new TaskLog(0);
    protected boolean needInitCountFlag = true;

    protected abstract void onFinishingRunning() throws TaskRunnerException;

    protected abstract void onMainRunningProcess() throws TaskRunnerException;

    protected abstract void onInitResources() throws TaskRunnerException;

    public TaskAbstractRunnerAdapter(ITask task) {
        this(task, null);
    }

    public TaskAbstractRunnerAdapter(ITask task, Context ctx) {
        this.ctx = ctx;
        if (this.ctx != null) {
            this.locale = ctx.getLocale();
        }
        this.task = task;
        this.runStats = "";
    }

    public void setTaskLog(TaskLog log) {
        this.tl = log;
        this.needInitCountFlag = false;
    }

    public TaskLog getTaskLog() {
        return this.tl;
    }

    @Override
    public final void run() throws Exception {
        try {
            this.onInitResources();
            this.onMainRunningProcess();
            this.handSuccess();
        }
        catch (TaskRunnerException ex) {
            if (ex.getExceptionCode() == 4) {
                String errMsg = this.getFatalError();
                this.tl.addException(errMsg, (Throwable)((Object)ex), null);
                this.tl.setTaskState(TaskStateEnum.FAILEND);
                TaskLogUtil.putLog(this.tl);
            }
        }
        catch (Exception e) {
            String errMsg = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fatalError", this.locale);
            if (e.getMessage() != null) {
                errMsg = errMsg + "\u3002" + e.getMessage();
            }
            this.tl.addException(errMsg, e, null);
            this.tl.setTaskState(TaskStateEnum.FAILEND);
            TaskLogUtil.putLog(this.tl);
        }
        finally {
            this.onFinishingRunning();
        }
    }

    protected String getFatalError() {
        return EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fatalError", this.locale);
    }

    private final void handFatelError(Exception ex) throws Exception {
        String msg = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "runningTask", this.locale) + this.task.getName() + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "restart", this.locale);
        msg = msg + ex.getMessage();
    }

    private final void handSuccess() {
    }

    public final void setTask(ITask task) {
        this.task = task;
    }

    public final ITask getTask() {
        return this.task;
    }
}

