/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import org.apache.log4j.Logger;

public class PermissionCheckUtil {
    private static final Logger logger = CoreUIObject.getLogger(PermissionCheckUtil.class);

    public static void hasExportFunctionPermision(Context ctx, ITask task) throws PermissionServiceException, BOSException {
        PermissionCheckUtil.showResult(ctx, ((TaskExternalCode)task).getExportPermItemName());
    }

    public static void hasImportFunctionPermision(Context ctx, ITask task) throws PermissionServiceException, BOSException {
        PermissionCheckUtil.showResult(ctx, ((TaskExternalCode)task).getImportPermItemName());
    }

    private static void showResult(Context ctx, String importName) throws PermissionServiceException, BOSException {
        String[][] permCheckResult = PermissionCheckUtil.hasFunctionPermision2(ctx, importName);
        String s = permCheckResult[0][0];
        if ("error".equals(s)) {
            throw new BOSException(permCheckResult[0][1]);
        }
        if ("false".equals(s)) {
            throw new PermissionServiceException(permCheckResult[0][1]);
        }
    }

    public static String[][] hasFunctionPermision2(Context ctx, String itemNameLong) {
        String[][] result = new String[1][2];
        try {
            if (itemNameLong == null || itemNameLong.equals("")) {
                result[0][0] = "true";
                return result;
            }
            IPermission perm = PermissionFactory.getLocalInstance((Context)ctx);
            IPermItem iPermItem = PermItemFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
            String[] itemNames = itemNameLong.trim().split(";");
            int nopermCount = 0;
            String permAlias = "";
            String orgAlias = "";
            for (int i = 0; i < itemNames.length; ++i) {
                String itemName = itemNames[i];
                if (itemName == null || itemName.equals("")) {
                    ++nopermCount;
                    continue;
                }
                PermItemInfo piInfo = iPermItem.getPermItemInfoByNumber(itemName);
                OrgType orgType = piInfo.getOrgRelation();
                ObjectUuidPK orgPK = null;
                if (orgType == OrgType.NONE) {
                    orgPK = new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4");
                } else {
                    OrgUnitInfo currentOrgUnit = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)orgType);
                    if (currentOrgUnit != null) {
                        orgPK = new ObjectUuidPK(currentOrgUnit.getId().toString());
                    }
                }
                if (orgPK != null) {
                    if (perm.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, itemName)) continue;
                    ++nopermCount;
                    permAlias = permAlias + piInfo.getAlias() + ",";
                    continue;
                }
                ++nopermCount;
                orgAlias = orgAlias + orgType.toString() + ",";
            }
            if (nopermCount > 0) {
                result[0][0] = "false";
                String s1 = "";
                String orgName = ContextUtil.getCurrentCtrlUnit((Context)ctx).getName();
                if (permAlias.endsWith(",")) {
                    permAlias = permAlias.substring(0, permAlias.length() - 1);
                    s1 = EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "permissionCheck", new Object[]{userInfo.getName(), orgName, permAlias});
                }
                String s2 = "";
                if (orgAlias.endsWith(",")) {
                    orgAlias = orgAlias.substring(0, orgAlias.length() - 1);
                    s2 = EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "noOrgType", new Object[]{orgName, orgAlias});
                }
                result[0][1] = s1 + s2;
            } else {
                result[0][0] = "true";
            }
            return result;
        }
        catch (Exception e) {
            result[0][0] = "error";
            result[0][1] = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"errorMessage") + ":" + e.getMessage();
            logger.error((Object)e.getMessage(), (Throwable)e);
            return result;
        }
    }

    public static boolean hasFunctionPermision(Context ctx, String itemNameLong) {
        if (itemNameLong == null || itemNameLong.equals("")) {
            return true;
        }
        String[] itemNames = itemNameLong.trim().split(";");
        try {
            IPermission perm = PermissionFactory.getLocalInstance((Context)ctx);
            IPermItem iPermItem = PermItemFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
            for (int i = 0; i < itemNames.length; ++i) {
                String itemName = itemNames[i];
                if (itemName == null || itemName.equals("")) {
                    return false;
                }
                PermItemInfo piInfo = iPermItem.getPermItemInfoByNumber(itemName);
                OrgType orgType = piInfo.getOrgRelation();
                ObjectUuidPK orgPK = orgType == OrgType.NONE ? new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4") : new ObjectUuidPK(ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)orgType).getId().toString());
                if (perm.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, itemName)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

