/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter.common;

import com.kingdee.messageCenter.IAdapter;
import com.kingdee.messageCenter.IClientManager;
import com.kingdee.messageCenter.IClientManagerDAO;
import com.kingdee.messageCenter.IWorker;
import com.kingdee.messageCenter.MessageException;
import com.kingdee.messageCenter.common.ObjectFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClientManager
implements IClientManager {
    private static final Logger logger = Logger.getLogger(ClientManager.class);

    private IClientManagerDAO getClientDAO() {
        return ObjectFactory.getInstance().getClientDAO();
    }

    private IAdapter getAdapter() {
        return ObjectFactory.getInstance().getAdapter();
    }

    @Override
    public String getSecretKey(String clientId) throws MessageException {
        return this.getClientDAO().getSecretKey(clientId);
    }

    @Override
    public String getClientId() throws MessageException {
        return this.getClientDAO().getClientId();
    }

    @Override
    public String getServerUrl() throws MessageException {
        return this.getClientDAO().getServerUrl();
    }

    @Override
    public Map<String, IWorker> getWorkers() throws MessageException {
        Map<String, String> workerSetting = this.getClientDAO().getWorkerSetting();
        HashMap<String, IWorker> workers = new HashMap<String, IWorker>(workerSetting.size());
        String className = null;
        IWorker worker = null;
        for (String key : workerSetting.keySet()) {
            className = workerSetting.get(key);
            try {
                worker = (IWorker)Class.forName(className).newInstance();
                key = this.getAdapter().processSubject(key);
                workers.put(key, worker);
            }
            catch (Exception e) {
                logger.error((Object)("\u5b9e\u4f8b\u5316worker(" + className + ")\u5931\u8d25"), (Throwable)e);
            }
        }
        return workers;
    }

    @Override
    public boolean isProxy() {
        return this.getClientDAO().isProxy();
    }

    @Override
    public String getProxyHost() {
        return this.getClientDAO().getProxyHost();
    }

    @Override
    public String getProxyPort() {
        return this.getClientDAO().getProxyPort();
    }
}

