/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter.common;

import com.kingdee.messageCenter.IAdapter;
import com.kingdee.messageCenter.IClientManager;
import com.kingdee.messageCenter.IClientManagerDAO;
import com.kingdee.messageCenter.IMessage;
import com.kingdee.messageCenter.IMessageDAO;
import com.kingdee.messageCenter.IMessagePool;
import com.kingdee.messageCenter.IMessageQueue;
import com.kingdee.messageCenter.common.ClientManager;
import com.kingdee.messageCenter.common.MessagePool;
import com.kingdee.messageCenter.common.MessageQueue;
import com.kingdee.messageCenter.common.MessageServer;
import java.util.concurrent.locks.ReentrantLock;
import nl.justobjects.pushlet.core.Config;
import nl.justobjects.pushlet.core.ConfigDefs;
import nl.justobjects.pushlet.util.PushletException;

public class ObjectFactory
implements ConfigDefs {
    private static ObjectFactory instance = null;
    private static ReentrantLock lock = new ReentrantLock();
    private IMessagePool pool = null;
    private IMessage messageServer = null;
    private IClientManager clientManager;
    private IAdapter adapter;
    private IMessageQueue queue;
    private IMessageDAO messageDAO;
    private IClientManagerDAO clientDAO;

    private ObjectFactory() {
    }

    protected void setMessagePool(IMessagePool pool) {
        this.pool = pool;
    }

    protected void setMessageServer(IMessage messageServer) {
        this.messageServer = messageServer;
    }

    protected void setClientManager(IClientManager clientManager) {
        this.clientManager = clientManager;
    }

    protected void setAdapter(IAdapter adapter) {
        this.adapter = adapter;
    }

    protected void setMessageQueue(IMessageQueue queue) {
        this.queue = queue;
    }

    protected void setMessageDAO(IMessageDAO messageDAO) {
        this.messageDAO = messageDAO;
    }

    protected void setClientDAO(IClientManagerDAO clientDAO) {
        this.clientDAO = clientDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectFactory getInstance() {
        block6: {
            if (instance == null) {
                try {
                    lock.lock();
                    if (instance != null) break block6;
                    instance = new ObjectFactory();
                    IAdapter adapter = null;
                    IMessageDAO messageDAO = null;
                    IClientManagerDAO clientDAO = null;
                    try {
                        adapter = (IAdapter)Config.createObject("adapter.class", null);
                        messageDAO = (IMessageDAO)Config.createObject("messagedao.class", null);
                        clientDAO = (IClientManagerDAO)Config.createObject("clientdao.class", null);
                    }
                    catch (PushletException pushletException) {
                        // empty catch block
                    }
                    instance.setAdapter(adapter);
                    instance.setMessageDAO(messageDAO);
                    instance.setClientDAO(clientDAO);
                    instance.setMessagePool(new MessagePool());
                    instance.setMessageServer(new MessageServer());
                    instance.setMessageQueue(new MessageQueue());
                    instance.setClientManager(new ClientManager());
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return instance;
    }

    public IMessagePool getMessagePool() {
        return this.pool;
    }

    public IMessage getMessageServer() {
        return this.messageServer;
    }

    public IClientManager getClientManager() {
        return this.clientManager;
    }

    public IAdapter getAdapter() {
        return this.adapter;
    }

    public IMessageQueue getQueue() {
        return this.queue;
    }

    public IMessageDAO getMessageDAO() {
        return this.messageDAO;
    }

    public IClientManagerDAO getClientDAO() {
        return this.clientDAO;
    }
}

