/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter.server;

import com.kingdee.messageCenter.IClientManager;
import com.kingdee.messageCenter.IMessage;
import com.kingdee.messageCenter.IMessagePool;
import com.kingdee.messageCenter.IMessageQueue;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.MessageException;
import com.kingdee.messageCenter.common.ObjectFactory;
import com.kingdee.messageCenter.utils.SecretKeyUtil;
import java.util.List;
import nl.justobjects.pushlet.core.Command;
import nl.justobjects.pushlet.core.Controller;
import nl.justobjects.pushlet.core.Event;
import nl.justobjects.pushlet.util.PushletException;

public class MyController
extends Controller {
    private IMessagePool getMessagePool() {
        return ObjectFactory.getInstance().getMessagePool();
    }

    private IClientManager getClientManager() {
        return ObjectFactory.getInstance().getClientManager();
    }

    private IMessage getMessageServer() {
        return ObjectFactory.getInstance().getMessageServer();
    }

    private IMessageQueue getMessageQueue() {
        return ObjectFactory.getInstance().getQueue();
    }

    @Override
    protected void doJoinBefore(Command aCommand) throws PushletException {
        String enterpriseId = aCommand.reqEvent.getField("ENTERPRISEID");
        String r = aCommand.reqEvent.getField("r");
        String t = aCommand.reqEvent.getField("t");
        long l_t = Long.parseLong(t);
        String secretKey = this.getClientManager().getSecretKey(enterpriseId);
        try {
            SecretKeyUtil.verifyData(enterpriseId, secretKey, l_t, r);
        }
        catch (MessageException e) {
            this.createErrorEvent(aCommand, e);
            throw new PushletException(e);
        }
        this.session.setEnterpriseId(enterpriseId);
    }

    protected Event createErrorEvent(Command aCommand, MessageException err) {
        Event responseEvent = new Event("nack");
        responseEvent.setField("p_id", this.session.getId());
        responseEvent.setField("p_reason", "unexpected error: " + err.getMessage());
        responseEvent.setField("p_errorcode", err.getErrorCode());
        aCommand.setResponseEvent(responseEvent);
        this.sendControlResponse(aCommand);
        return responseEvent;
    }

    @Override
    protected void dolistenAfter(Command aCommand) throws PushletException {
        String enterpriseId = this.session.getEnterpriseId();
        List<Message> messageList = this.getMessagePool().getUnPushedMessage(enterpriseId);
        for (Message message : messageList) {
            this.getMessageServer().pushMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPublish(Command aCommand) {
        Event responseEvent = null;
        try {
            String subject = aCommand.reqEvent.getField("p_subject");
            if (subject == null) {
                responseEvent = new Event("nack");
                responseEvent.setField("p_id", this.session.getId());
                responseEvent.setField("p_reason", "no subject provided");
            } else {
                aCommand.reqEvent.setField("p_from", this.session.getId());
                aCommand.reqEvent.setField("p_event", "data");
                responseEvent = new Event("publish-ack");
                this.getMessageQueue().receive(Message.fromEvent(aCommand.reqEvent));
            }
            aCommand.setResponseEvent(responseEvent);
        }
        catch (Throwable t) {
            try {
                responseEvent = new Event("nack");
                responseEvent.setField("p_id", this.session.getId());
                responseEvent.setField("p_reason", "unexpected error: " + t);
                this.warn("doPublish() error: " + t);
                aCommand.setResponseEvent(responseEvent);
            }
            catch (Throwable throwable) {
                aCommand.setResponseEvent(responseEvent);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGetData(Command aCommand) {
        Event responseEvent = null;
        try {
            String subject = aCommand.reqEvent.getField("p_subject");
            if (subject == null) {
                responseEvent = new Event("nack");
                responseEvent.setField("p_id", this.session.getId());
                responseEvent.setField("p_reason", "no subject provided");
            } else {
                aCommand.reqEvent.setField("p_from", this.session.getId());
                aCommand.reqEvent.setField("p_event", "data");
                Message retData = this.getMessageQueue().execute(Message.fromEvent(aCommand.reqEvent));
                responseEvent = retData.toServerEvent();
                responseEvent.setField("p_event", "data");
            }
            aCommand.setResponseEvent(responseEvent);
        }
        catch (MessageException t) {
            try {
                responseEvent = new Event("nack");
                responseEvent.setField("p_id", this.session.getId());
                responseEvent.setField("p_reason", "unexpected error: " + t);
                responseEvent.setField("p_errorcode", t.getErrorCode());
                this.warn("doPublish() error: " + t);
                aCommand.setResponseEvent(responseEvent);
            }
            catch (Throwable throwable) {
                aCommand.setResponseEvent(responseEvent);
                throw throwable;
            }
        }
    }
}

