/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter.server;

import com.kingdee.messageCenter.IAdapter;
import com.kingdee.messageCenter.IMessage;
import com.kingdee.messageCenter.Message;
import com.kingdee.messageCenter.MessageException;
import java.util.HashMap;
import java.util.Map;
import nl.justobjects.pushlet.core.Dispatcher;
import nl.justobjects.pushlet.core.Event;

public class ServerAdapter
implements IAdapter {
    private static Map<String, Message> needRespMessage = new HashMap<String, Message>();

    private static synchronized void putMap(String id, Message m) {
        needRespMessage.put(id, m);
    }

    public static void changeNeedRespMessageStatus(String id) {
        if (needRespMessage.containsKey(id)) {
            Message sendMessage = new Message();
            sendMessage.setStatus(90);
            ServerAdapter.putMap(id, sendMessage);
        }
    }

    @Override
    public void start(IMessage messageServer) throws MessageException {
    }

    @Override
    public void pushMessage(Message message) throws MessageException {
        Event event = message.toEvent();
        event.setField("p_event", "data");
        Dispatcher.getInstance().multicast(event);
    }

    @Override
    public void receive(Message message) throws MessageException {
        String sourceID = message.getField("SOURCEID");
        if (sourceID != null && needRespMessage.containsKey(sourceID)) {
            ServerAdapter.putMap(sourceID, message);
        }
    }

    @Override
    public String processSubject(String subject) throws MessageException {
        return subject;
    }

    @Override
    public Message getMessage(Message message) throws MessageException {
        String messageId = message.getId();
        ServerAdapter.putMap(message.getId(), null);
        this.pushMessage(message);
        try {
            Thread.sleep(50L);
            Message retMsg = needRespMessage.get(messageId);
            if (retMsg == null || retMsg.getStatus() != 90) {
                return null;
            }
        }
        catch (InterruptedException e) {
            return null;
        }
        for (int tryCount = 5; tryCount > 0; --tryCount) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                return null;
            }
            Message retMsg = needRespMessage.get(messageId);
            if (retMsg == null || retMsg.getStatus() == 90) continue;
            needRespMessage.remove(messageId);
            return retMsg;
        }
        return null;
    }
}

