/*
 * Decompiled with CFR 0.152.
 */
package nl.justobjects.pushlet.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URLDecoder;
import java.util.HashMap;
import nl.justobjects.pushlet.core.Event;

public class EventParser {
    private EventParser() {
    }

    public static Event parse(File aFile) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(aFile));
        return EventParser.parse(br);
    }

    public static Event parse(Reader aReader) throws IOException {
        char nextChar;
        StringBuffer preparsedString = new StringBuffer(24);
        while ((nextChar = (char)aReader.read()) != '<') {
        }
        preparsedString.append(nextChar);
        int len = 0;
        do {
            nextChar = (char)aReader.read();
            preparsedString.append(nextChar);
        } while (nextChar != '>' && ++len < 65535);
        return EventParser.parse(preparsedString.toString());
    }

    public static Event parse(String aString) throws IOException {
        int index;
        if (!(aString = aString.trim()).startsWith("<") || !aString.endsWith("/>")) {
            throw new IOException("No start or end tag found while parsing event [" + aString + "]");
        }
        HashMap<String, String> properties = new HashMap<String, String>(3);
        aString = aString.substring(1, aString.length() - 2).trim();
        for (index = 0; !Character.isWhitespace(aString.charAt(index)) && index < aString.length(); ++index) {
        }
        aString = aString.substring(index).trim();
        index = 0;
        while (index < aString.length()) {
            while (aString.charAt(index) != '=' && index < aString.length()) {
                ++index;
            }
            String attrName = aString.substring(0, index).trim();
            aString = aString.substring(index + 1).trim();
            for (index = 1; aString.charAt(index) != '\"' && index < aString.length(); ++index) {
                if (aString.charAt(index) != '\\') continue;
                aString = aString.substring(0, index) + aString.substring(index + 1);
            }
            String attrValue = aString.substring(1, index);
            attrValue = URLDecoder.decode(attrValue, "UTF-8");
            properties.put(attrName, attrValue);
            aString = aString.substring(index + 1).trim();
            index = 0;
        }
        return new Event(properties);
    }

    public static void main(String[] args) {
        try {
            Event event = EventParser.parse(new File(args[0]));
            System.out.println("OK parsed Event file " + args[0]);
            System.out.println(event.toXML());
            event = EventParser.parse(event.toXML());
            System.out.println("OK parsed Event string");
            System.out.println(event.toXML());
        }
        catch (Throwable t) {
            System.out.println("Error parsing event file: " + args[0]);
            t.printStackTrace();
        }
    }
}

