/*
 * Decompiled with CFR 0.152.
 */
package nl.justobjects.pushlet.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.server.UID;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import nl.justobjects.pushlet.core.Config;
import nl.justobjects.pushlet.core.ConfigDefs;
import nl.justobjects.pushlet.core.Event;
import nl.justobjects.pushlet.core.Session;
import nl.justobjects.pushlet.util.Log;
import nl.justobjects.pushlet.util.PushletException;
import nl.justobjects.pushlet.util.Rand;
import nl.justobjects.pushlet.util.Sys;

public class SessionManager
implements ConfigDefs {
    private static SessionManager instance;
    private Timer timer;
    private final long TIMER_INTERVAL_MILLIS = 60000L;
    private Map sessions = new HashMap(13);
    private Session[] sessionCache = new Session[0];
    private boolean sessionCacheDirty = false;
    private final Object mutex = new Object();

    protected SessionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Object visitor, Method method, Object[] args) {
        Object object = this.mutex;
        synchronized (object) {
            Session nextSession;
            if (this.sessionCacheDirty) {
                for (int i = 0; i < this.sessionCache.length; ++i) {
                    this.sessionCache[i] = null;
                }
                this.sessionCache = this.sessions.values().toArray(this.sessionCache);
                this.sessionCacheDirty = false;
            }
            for (int i = 0; i < this.sessionCache.length && (nextSession = this.sessionCache[i]) != null; ++i) {
                try {
                    args[0] = nextSession;
                    method.invoke(visitor, args);
                    continue;
                }
                catch (IllegalAccessException e) {
                    Log.warn("apply: illegal method access: ", e);
                    continue;
                }
                catch (InvocationTargetException e) {
                    Log.warn("apply: method invoke: ", e);
                }
            }
        }
    }

    public Session createSession(Event anEvent) throws PushletException {
        return Session.create(this.createSessionId());
    }

    public static SessionManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String anId) {
        Object object = this.mutex;
        synchronized (object) {
            return (Session)this.sessions.get(anId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] getSessions() {
        Object object = this.mutex;
        synchronized (object) {
            return this.sessions.values().toArray(new Session[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionCount() {
        Object object = this.mutex;
        synchronized (object) {
            return this.sessions.size();
        }
    }

    public String getStatus() {
        Session[] sessions = this.getSessions();
        StringBuffer statusBuffer = new StringBuffer();
        statusBuffer.append("SessionMgr: " + sessions.length + " sessions \\n");
        for (int i = 0; i < sessions.length; ++i) {
            statusBuffer.append(sessions[i] + "\\n");
        }
        return statusBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSession(String anId) {
        Object object = this.mutex;
        synchronized (object) {
            return this.sessions.containsKey(anId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(Session session) {
        Object object = this.mutex;
        synchronized (object) {
            this.sessions.put(session.getId(), session);
            this.sessionCacheDirty = true;
        }
        this.info(session.getId() + " at " + session.getAddress() + " added ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session removeSession(Session aSession) {
        Object object = this.mutex;
        synchronized (object) {
            Session session = (Session)this.sessions.remove(aSession.getId());
            if (session != null) {
                this.info(session.getId() + " at " + session.getAddress() + " removed ");
            }
            this.sessionCacheDirty = true;
            return session;
        }
    }

    public void start() throws PushletException {
        if (this.timer != null) {
            this.stop();
        }
        this.timer = new Timer(false);
        this.timer.schedule((TimerTask)new AgingTimerTask(), 60000L, 60000L);
        this.info("started; interval=60000ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.sessions.clear();
        }
        this.info("stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createSessionId() {
        if (Config.hasProperty("session.id.generation") && Config.getProperty("session.id.generation").equals("uuid")) {
            return new UID().toString();
        }
        Object object = this.mutex;
        synchronized (object) {
            String id;
            while (this.hasSession(id = Rand.randomName(Config.getIntProperty("session.id.size")))) {
            }
            return id;
        }
    }

    protected void info(String s) {
        Log.info("SessionManager: " + new Date() + " " + s);
    }

    protected void warn(String s) {
        Log.warn("SessionManager: " + s);
    }

    protected void debug(String s) {
        Log.debug("SessionManager: " + s);
    }

    static {
        try {
            instance = (SessionManager)Config.getClass("sessionmanager.class", "nl.justobjects.pushlet.core.SessionManager").newInstance();
            Log.info("SessionManager created className=" + instance.getClass());
        }
        catch (Throwable t) {
            Log.fatal("Cannot instantiate SessionManager from config", t);
        }
    }

    private class AgingTimerTask
    extends TimerTask {
        private long lastRun = Sys.now();
        private long delta;
        private Method visitMethod;

        public AgingTimerTask() throws PushletException {
            try {
                Class[] argsClasses = new Class[]{Session.class};
                this.visitMethod = this.getClass().getMethod("visit", argsClasses);
            }
            catch (NoSuchMethodException e) {
                throw new PushletException("Failed to setup AgingTimerTask", e);
            }
        }

        @Override
        public void run() {
            long now = Sys.now();
            this.delta = now - this.lastRun;
            this.lastRun = now;
            SessionManager.this.debug("AgingTimerTask: tick");
            SessionManager.getInstance().apply(this, this.visitMethod, new Object[1]);
        }

        public void visit(Session aSession) {
            try {
                aSession.age(this.delta);
                SessionManager.this.debug("AgingTimerTask: visit: " + aSession);
                if (aSession.isExpired()) {
                    SessionManager.this.info("AgingTimerTask: Session expired: " + aSession);
                    aSession.stop();
                }
            }
            catch (Throwable t) {
                SessionManager.this.warn("AgingTimerTask: Error in timer task : " + t);
            }
        }
    }
}

