/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.el.rec.ArchSysLogServiceFacadeFactory;
import com.kingdee.eas.el.rec.app.AbstractEASArchInterFaceControllerBean;
import com.kingdee.eas.el.rec.app.util.ArchConfigUtil;
import com.kingdee.eas.el.rec.app.util.ArchConstant;
import com.kingdee.eas.el.rec.outputmodule.archsys.helper.NoticeArchSysHelperFactory;
import com.kingdee.eas.el.rec.tool.ArchRecordUtils;
import com.kingdee.eas.el.rec.tool.ParseXMLUtils;
import com.kingdee.eas.el.rec.tool.RECStringUtil;
import com.kingdee.eas.el.rec.tool.ResultsUtils;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class EASArchInterFaceControllerBean
extends AbstractEASArchInterFaceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.app.EASArchInterFaceControllerBean");
    private static ThreadPoolExecutor executor = null;

    private static synchronized void initThreadPool() {
        if (executor == null) {
            executor = new ThreadPoolExecutor(6, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(8000), new ThreadPoolExecutor.CallerRunsPolicy());
        }
    }

    private static void execute(Runnable runnable) {
        if (executor == null) {
            EASArchInterFaceControllerBean.initThreadPool();
        }
        executor.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _readyToReadResult(final Context ctx, final String resultFullPath, final String extParamJson) throws BOSException {
        String addressLog = "";
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (StringUtils.isEmpty((String)resultFullPath) || StringUtils.isEmpty((String)extParamJson)) {
                        return;
                    }
                    String[] filePaths = resultFullPath.split(";");
                    String address = "";
                    String port = "";
                    try {
                        Map<String, Object> map = ParseXMLUtils.parseXMLToMap(extParamJson);
                        address = (String)map.get("address");
                        port = (String)map.get("port");
                    }
                    catch (Exception e) {
                        logger.error((Object)("\u89e3\u6790extParamJson\u5931\u8d25\uff01" + e.getMessage()));
                    }
                    boolean flag = false;
                    try {
                        String arch_type = ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_TYPE);
                        flag = NoticeArchSysHelperFactory.getInstance(ctx, arch_type).getResultFiles(ctx, filePaths, address, port);
                    }
                    catch (Exception e) {
                        logger.error((Object)("\u83b7\u53d6\u7ed3\u679c\u6587\u4ef6\u5931\u8d25\uff01" + e.getMessage()));
                    }
                }
            };
            EASArchInterFaceControllerBean.execute(runnable);
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                try {
                    Map<String, Object> map = ParseXMLUtils.parseXMLToMap(extParamJson);
                    addressLog = map.get("address") + ":" + map.get("port");
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeInterfaceLog(addressLog, "readyToReadResult", resultFullPath + ", " + extParamJson, true, "true", "");
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _writeBackArchResults(Context ctx, String params, String otherParams) throws BOSException {
        String address = "";
        String api = "writeBackArchResults";
        String param = "";
        boolean success = true;
        String result = "";
        String stack = "";
        param = params;
        if (StringUtils.isEmpty((String)params)) {
            String string = result = ResultsUtils.ERROR("\u5f52\u6863\u7ed3\u679c\u4fe1\u606f\u4e3a\u7a7a\uff01");
            return string;
        }
        List<Object> list = null;
        try {
            list = ParseXMLUtils.parseXMLToList(params);
        }
        catch (Exception e) {
            logger.error((Object)("\u89e3\u6790params\u5931\u8d25\uff01" + e.getMessage()));
            success = false;
            result = ResultsUtils.ERROR("\u89e3\u6790params\u5931\u8d25\uff01" + e.getMessage());
            stack = RECStringUtil.exception2String(e);
            String string = result;
            try {
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeInterfaceLog(address, api, param, success, result, stack);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }
        try {
            ArchRecordUtils.updateRecordData(ctx, null, list, null);
        }
        catch (Exception e) {
            logger.error((Object)("\u66f4\u65b0\u8bb0\u5f55\u5931\u8d25\uff01" + e.getMessage()));
            success = false;
            result = ResultsUtils.ERROR("\u66f4\u65b0\u8bb0\u5f55\u5931\u8d25\uff01" + e.getMessage());
            stack = RECStringUtil.exception2String(e);
            String string = result;
            try {
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeInterfaceLog(address, api, param, success, result, stack);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }
        String string = result = ResultsUtils.SUCCESS("\u66f4\u65b0\u6210\u529f\uff01");
        return string;
        finally {
            try {
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeInterfaceLog(address, api, param, success, result, stack);
            }
            catch (Exception exception) {}
        }
    }
}

