/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.app;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.ArcContentTypeEnum;
import com.kingdee.eas.el.rec.ArcRecordCollection;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.app.AbstractFilingInstanceFacadeControllerBean;
import com.kingdee.eas.el.rec.filing.IFilingInstance;
import com.kingdee.eas.el.rec.filing.instance.FilingBill;
import com.kingdee.eas.el.rec.filing.instance.FilingOtherReport;
import com.kingdee.eas.el.rec.filing.instance.FilingQmsReport;
import com.kingdee.eas.el.rec.filing.instance.FilingReport;
import com.kingdee.eas.el.rec.filing.instance.FilingRptsReport;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FilingInstanceFacadeControllerBean
extends AbstractFilingInstanceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.app.FilingInstanceFacadeControllerBean");
    protected static Cache<String, ArcRecordInfo> cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build();

    @Override
    protected IFilingInstance _getFilingInstance(Context ctx, ArcRecordInfo recordInfo) throws BOSException, EASBizException {
        if (recordInfo == null || recordInfo.getId() == null) {
            throw new EASBizException(new NumericExceptionSubItem("XX", "\u5f52\u6863\u8bb0\u5f55\u4e3a\u7a7a"));
        }
        String recordId = recordInfo.getId().toString();
        ArcRecordInfo recordCache = (ArcRecordInfo)cache.getIfPresent((Object)recordId);
        if (recordCache != null) {
            recordInfo = recordCache;
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)recordId));
            view.setFilter(filter);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("contentType");
            view.setSelector(selectorItemCollection);
            view.setBaseOnSelector(true);
            ArcRecordCollection arcRecordCollection = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection(view);
            if (arcRecordCollection.size() > 0) {
                recordInfo = arcRecordCollection.get(0);
                cache.put((Object)recordId, (Object)recordInfo);
            }
        }
        ArcContentTypeEnum arcContentTypeEnum = recordInfo.getContentType();
        if ("bill".equalsIgnoreCase(arcContentTypeEnum.getValue())) {
            return new FilingBill();
        }
        if ("rptsReport".equalsIgnoreCase(arcContentTypeEnum.getValue())) {
            return new FilingRptsReport();
        }
        if ("qmsReport".equalsIgnoreCase(arcContentTypeEnum.getValue())) {
            return new FilingQmsReport();
        }
        if ("report".equalsIgnoreCase(arcContentTypeEnum.getValue())) {
            return new FilingReport();
        }
        if ("otherReport".equalsIgnoreCase(arcContentTypeEnum.getValue())) {
            return new FilingOtherReport();
        }
        return null;
    }
}

