/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.app.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.app.util.WSSCCacheManager;
import com.kingdee.eas.el.rec.ArchConfigKeyCollection;
import com.kingdee.eas.el.rec.ArchConfigKeyFactory;
import com.kingdee.eas.el.rec.ArchConfigKeyInfo;
import com.kingdee.eas.el.rec.ArchConfigValueCollection;
import com.kingdee.eas.el.rec.ArchConfigValueFactory;
import com.kingdee.eas.el.rec.ArchConfigValueInfo;
import com.kingdee.eas.el.rec.app.util.RECCacheManager;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoadArchConfig {
    private static Logger logger = Logger.getLogger((String)LoadArchConfig.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties loadProperties(Context ctx) {
        Properties properties;
        if (ctx == null) {
            throw new IllegalArgumentException("LoadArchConfig ctx is null");
        }
        String dbId = ctx.getAIS();
        if (StringUtils.isEmpty((String)dbId)) {
            throw new IllegalArgumentException("ctx[" + ctx + "]\u4e2d\u83b7\u53d6dbId\u4e3a\u7a7a");
        }
        String clusterLastUpdateTimeCache = "";
        try {
            Object value = WSSCCacheManager.getValue((String)"el_rec_lastupdatetime");
            if (value != null) {
                clusterLastUpdateTimeCache = (String)value;
            } else {
                ArchConfigKeyCollection coll = ArchConfigKeyFactory.getLocalInstance(ctx).getArchConfigKeyCollection("select *  where key = 'arch.config.lastupdatetime' ");
                ArchConfigKeyInfo lastUpdate = coll.get(0);
                WSSCCacheManager.put((String)"el_rec_lastupdatetime", (Object)lastUpdate.getDefaultValue());
                clusterLastUpdateTimeCache = lastUpdate.getDefaultValue();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("LoadArchConfig get lastupdate time error " + e);
        }
        Object cacheObj = RECCacheManager.recCacheService.get("arch_system_properties");
        Properties cfgMap = new Properties();
        if (cacheObj != null && (cfgMap = (Properties)cacheObj).get(dbId) != null) {
            properties = (Properties)cfgMap.get(dbId);
            String serverLastUpdateTimeCache = (String)properties.get("arch.config.lastupdatetime");
            if (clusterLastUpdateTimeCache.equals(serverLastUpdateTimeCache)) {
                return properties;
            }
            cfgMap.remove(dbId);
        }
        properties = LoadArchConfig.loadDBProperties(ctx);
        if (cfgMap.containsKey(dbId)) return properties;
        Class<LoadArchConfig> clazz = LoadArchConfig.class;
        synchronized (LoadArchConfig.class) {
            cfgMap.put(dbId, properties);
            RECCacheManager.recCacheService.put("arch_system_properties", cfgMap);
            WSSCCacheManager.put((String)"el_rec_lastupdatetime", (Object)properties.getProperty("arch.config.lastupdatetime"));
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return properties;
        }
    }

    private static Properties loadDBProperties(Context ctx) {
        Properties properties = new Properties();
        try {
            ArchConfigKeyCollection archCfgKeyColl = ArchConfigKeyFactory.getLocalInstance(ctx).getArchConfigKeyCollection();
            for (int i = 0; i < archCfgKeyColl.size(); ++i) {
                ArchConfigKeyInfo keyInfo = archCfgKeyColl.get(i);
                if (StringUtils.isEmpty((String)keyInfo.getKey()) || StringUtils.isEmpty((String)keyInfo.getDefaultValue())) continue;
                properties.put(keyInfo.getKey(), keyInfo.getDefaultValue());
            }
            ArchConfigValueCollection archCfgColl = ArchConfigValueFactory.getLocalInstance(ctx).getArchConfigValueCollection();
            for (int i = 0; i < archCfgColl.size(); ++i) {
                String value;
                ArchConfigValueInfo cfgValue = archCfgColl.get(i);
                ArchConfigKeyInfo keyInfo = cfgValue.getLinkKey();
                if (keyInfo != null) {
                    String value2;
                    String key = cfgValue.getKey() != null ? cfgValue.getKey() : keyInfo.getKey();
                    String string = value2 = cfgValue.getValue() != null ? cfgValue.getValue() : cfgValue.getDefaultValue();
                    if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value2) && StringUtils.isEmpty((String)(value2 = keyInfo.getDefaultValue()))) continue;
                    properties.put(key, value2);
                    continue;
                }
                if (cfgValue.getKey() == null) continue;
                String string = value = cfgValue.getValue() != null ? cfgValue.getValue() : cfgValue.getDefaultValue();
                if (StringUtils.isEmpty((String)value)) continue;
                properties.put(cfgValue.getKey(), cfgValue.getValue() != null ? cfgValue.getValue() : cfgValue.getDefaultValue());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u83b7\u53d6ArchConfigValueCollection Exception" + e);
        }
        try {
            StringBuffer buffer = new StringBuffer();
            Set<Object> set = properties.keySet();
            Iterator<Object> it = set.iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                if (key.equals("arch.ftp.password") || key.equals("arch.sys.invo.client.secret") || key.equals("arch.sys.xh.appsecret")) continue;
                buffer.append("{key:" + key + "--value:" + properties.get(key) + "}");
            }
            logger.error((Object)("\u7535\u5b50\u5f52\u6863\u52a0\u8f7d\u7f13\u5b58\u952e\u503c\u5bf9\u4e3a[" + buffer.toString() + "]"));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return properties;
    }
}

