/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.ctrl.print.io;

import com.kingdee.bos.ctrl.print.io.KDFontMapper;
import com.lowagie.text.pdf.BaseFont;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class RecFontCache
extends Enum<RecFontCache> {
    public static final /* enum */ RecFontCache INSTANCE;
    private static Map<String, String> aliases;
    private static Map<String, KDFontMapper.BaseFontParameters> mapper;
    private static ConcurrentHashMap<String, BaseFont> fontCache;
    public static BaseFont defaultFont;
    private static final /* synthetic */ RecFontCache[] $VALUES;

    public static RecFontCache[] values() {
        return (RecFontCache[])$VALUES.clone();
    }

    public static RecFontCache valueOf(String name) {
        return Enum.valueOf(RecFontCache.class, name);
    }

    public static Map getAliases() {
        return aliases;
    }

    public static Map getMapper() {
        return mapper;
    }

    public static ConcurrentHashMap<String, BaseFont> getFontCache() {
        return fontCache;
    }

    private static int insertDirectory(String dir) {
        File file = new File(dir);
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            int count = 0;
            for (int k = 0; k < files.length; ++k) {
                file = files[k];
                if (file.isDirectory()) {
                    RecFontCache.insertDirectory(file.getPath());
                    continue;
                }
                String name = file.getPath().toLowerCase();
                try {
                    if (!(name.endsWith(".ttf") || name.endsWith(".otf") || name.endsWith(".afm"))) {
                        if (!name.endsWith(".ttc")) continue;
                        String[] ttcs = BaseFont.enumerateTTCNames((String)file.getPath());
                        for (int j = 0; j < ttcs.length; ++j) {
                            String nt = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(file.getPath()))).append(",").append(j)));
                            String[][] names = BaseFont.getFullFontName((String)nt, (String)"Cp1252", (byte[])null);
                            RecFontCache.insertNames(names, nt);
                        }
                        ++count;
                        continue;
                    }
                    String[][] names = BaseFont.getFullFontName((String)file.getPath(), (String)"Cp1252", (byte[])null);
                    RecFontCache.insertNames(names, file.getPath());
                    ++count;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return count;
        }
        return 0;
    }

    private static void insertNames(String[][] names, String path) {
        String main = null;
        for (int k = 0; k < names.length; ++k) {
            String[] name = names[k];
            if (!name[2].equals("1033")) continue;
            main = name[3];
            break;
        }
        if (main == null) {
            main = names[0][3];
        }
        KDFontMapper.BaseFontParameters p = new KDFontMapper.BaseFontParameters(path);
        mapper.put(main, p);
        for (int k = 0; k < names.length; ++k) {
            aliases.put(names[k][3], main);
        }
    }

    public static KDFontMapper.BaseFontParameters getBaseFontParameters(String name) {
        String alias = aliases.get(name);
        if (alias == null) {
            return mapper.get(name);
        }
        KDFontMapper.BaseFontParameters p = mapper.get(alias);
        return p == null ? mapper.get(name) : p;
    }

    public static RecFontCache getInstance() {
        return INSTANCE;
    }

    static {
        String userHome;
        String windir;
        String easHome;
        INSTANCE = new RecFontCache();
        $VALUES = new RecFontCache[]{INSTANCE};
        aliases = new HashMap<String, String>();
        mapper = new HashMap<String, KDFontMapper.BaseFontParameters>();
        fontCache = new ConcurrentHashMap();
        String prop = System.getProperty("eas.properties.dir");
        if (prop != null) {
            RecFontCache.insertDirectory(prop);
        }
        if ((easHome = System.getProperty("EAS_HOME")) != null) {
            RecFontCache.insertDirectory(easHome + "/client/bin");
        }
        if ((windir = System.getenv("windir")) != null && !windir.isEmpty()) {
            windir = !windir.endsWith("\\") && !windir.endsWith("/") ? windir + File.separator : windir;
            RecFontCache.insertDirectory(windir + "Fonts");
        }
        if ((userHome = System.getProperty("user.home")) != null && !userHome.isEmpty()) {
            userHome = !userHome.endsWith("\\") && !userHome.endsWith("/") ? userHome + File.separator : userHome;
            RecFontCache.insertDirectory(userHome + ".fonts");
        }
        RecFontCache.insertDirectory("/usr/share/fonts");
        RecFontCache.insertDirectory("/usr/local/share/fonts");
        RecFontCache.insertDirectory("/usr/X/lib/X11/fonts/TrueType");
        RecFontCache.insertDirectory("/usr/openwin/lib/X11/fonts/TrueType");
        RecFontCache.insertDirectory("/usr/share/fonts/default/TrueType");
        RecFontCache.insertDirectory("/usr/X11R6/lib/X11/fonts/ttf");
        RecFontCache.insertDirectory("/usr/lpp/X11/lib/X11/fonts");
        RecFontCache.insertDirectory("/usr/lib/X11/fonts");
        RecFontCache.insertDirectory("/usr/lpp/X11/lib/X11");
        RecFontCache.insertDirectory("/usr/X11R6/lib/X11/fonts");
        RecFontCache.insertDirectory("/System/Library/Fonts");
        RecFontCache.insertDirectory("/Library/Fonts");
        try {
            KDFontMapper.BaseFontParameters p = RecFontCache.getBaseFontParameters("SimSun");
            defaultFont = BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, (byte[])p.ttfAfm, (byte[])p.pfb);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

