/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.ctrl.reportone.r1.print.browser;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.form2.ui.INotePageProvider;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.control.PaperInfo;
import com.kingdee.bos.ctrl.print.printjob.IEconomizePrint;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.LabelCell;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.print.util.SyncPageList;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintInfo;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.DelayVarProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IR1PrintEngineListener;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.R1PrintEngine;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.RuntimeModel;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.PWPage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class RecR1PrintPageProvider
implements INotePageProvider,
IEconomizePrint {
    private static final Logger log = LogUtil.getPackageLogger(RecR1PrintPageProvider.class);
    private SyncPageList _logicPageList;
    private R1PrintEngine _engine;
    private boolean _isVerEconomizePage;
    private boolean _isHorEconomizePage;
    private int _verDistance = 0;
    private int _horDistance = 0;
    private int _forceStopPages = 0;
    private boolean _isCrossPrint = false;
    private DelayVarProvider _delayVarProvider;
    private INotePageProvider.INotePageProviderListener _listener;

    public SyncPageList getLogicList() {
        if (this._logicPageList == null) {
            try {
                this._logicPageList = new SyncPageList(10);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return this._logicPageList;
    }

    public void generate(RuntimeModel runtimeModel, int pageWidth, int pageHeight) {
        long time = System.currentTimeMillis();
        R1PrintInfo r1Info = R1PrintModelHelper.getPrintInfo((ReportModel)runtimeModel.getReportModel());
        this._isVerEconomizePage = r1Info.isVerEconomizePaper();
        if (this._isVerEconomizePage) {
            this._verDistance = Util.lom2Pixel((int)r1Info.getVerPageSpace());
        }
        this._isHorEconomizePage = r1Info.isHorEconomizePaper();
        if (this._isHorEconomizePage) {
            this._horDistance = Util.lom2Pixel((int)r1Info.getHorPageSpace());
        }
        EngineListener engineListener = new EngineListener(pageHeight, pageWidth);
        this._engine = new R1PrintEngine(runtimeModel, (IR1PrintEngineListener)engineListener);
        this._engine.setPagesOfForceStop(this._forceStopPages);
        this._engine.setDelayVarProvider(this.getDelayVarProvider());
        try {
            this._engine.execute(pageWidth, pageHeight);
        }
        catch (Exception e) {
            log.error((Object)"Generate R1-Print Execption. ", (Throwable)e);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bos));
            this.addExceptionPromptPage(pageWidth, pageHeight, bos.toString());
            engineListener.endOutput();
            throw new RuntimeException(e);
        }
        time = System.currentTimeMillis() - time;
        log.info((Object)("Generate R1-Print used time:" + time));
        this._engine = null;
    }

    public void errorForceStopped() {
        this.finish();
    }

    public void forceStop() {
        if (this._engine != null) {
            this._engine.forceStop();
        }
    }

    public void setPagesOfForceStop(int n) {
        this._forceStopPages = n;
    }

    public void setCrossPrint(boolean isCrossPrint) {
        this._isCrossPrint = isCrossPrint;
    }

    private void addExceptionPromptPage(int pageWidth, int pageHeight, String prompt) {
        int w = Util.lom2Pixel((int)pageWidth);
        int h = Util.lom2Pixel((int)pageHeight);
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        sa.setVerticalAlign(Styles.VerticalAlignment.TOP);
        sa.setWrapText(true);
        Style style = Styles.getStyle((ShareStyleAttributes)sa);
        LabelCell labelCell = new LabelCell();
        labelCell.setText(new StringBuffer(MultiLanguageUtil.getMLS((String)"browser.R1PrintPageProvider.info", (String)"\u6267\u884c\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002\u5177\u4f53\u4fe1\u606f\u8bf7\u67e5\u770b\u5ba2\u6237\u7aef\u65e5\u5fd7\uff0c\u5fc5\u8981\u65f6\u8bf7\u4e0e\u5f00\u53d1\u4eba\u5458\u8054\u7cfb\u3002") + StringUtil.RETURN + new Date() + StringUtil.RETURN + prompt).toString());
        labelCell.setStyle(style);
        labelCell.setPainterBounds(0.0f, 0.0f, (float)w, (float)h);
        Page page = new Page();
        page.setPainterBounds(0.0f, 0.0f, (float)w, (float)h);
        page.addPainter((IPainter)labelCell);
        this.addPage(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page get(int index, PaperInfo info) {
        SyncPageList pageList = this.getLogicList();
        log.debug((Object)("Request get page, index: " + index));
        SyncPageList syncPageList = pageList;
        synchronized (syncPageList) {
            if (index >= pageList.getPageCount() && pageList.isCompleted()) {
                log.debug((Object)"No more pages, return null.");
                return null;
            }
            return pageList.getPage(index);
        }
    }

    public DelayVarProvider getDelayVarProvider() {
        if (this._delayVarProvider == null) {
            this._delayVarProvider = new DelayVarProvider();
        }
        return this._delayVarProvider;
    }

    public void setListener(INotePageProvider.INotePageProviderListener l) {
        this._listener = l;
    }

    private void addPage(Page page) {
        this.getLogicList().addPage(page);
        if (this._listener != null && this.getLogicList().size() == 1) {
            this._listener.firstPagePrepared();
        }
    }

    private void finish() {
        this.getLogicList().close();
        if (this._listener != null && this.getLogicList().size() == 0) {
            this._listener.cancelBeforeOutput();
        }
    }

    public int getHorSpace() {
        return this._horDistance;
    }

    public int getVerSpace() {
        return this._verDistance;
    }

    public boolean isEconomizePaper() {
        return this._isCrossPrint && (this._isVerEconomizePage || this._isHorEconomizePage);
    }

    public boolean isHorEconomizePaper() {
        return this._isHorEconomizePage;
    }

    public boolean isVerEconomizePaper() {
        return this._isVerEconomizePage;
    }

    private class EngineListener
    implements IR1PrintEngineListener {
        private float bodyHeight;
        private float bodyWidth;
        private ArrayList tempPages = new ArrayList();
        private float remainHeight;
        private float remainWidth;

        public EngineListener(int bodyHeight, int bodyWidth) {
            this.bodyHeight = (float)KDPrinterUtils.lomToPrintPoint((double)bodyHeight);
            this.bodyWidth = (float)KDPrinterUtils.lomToPrintPoint((double)bodyWidth);
        }

        private ArrayList getTempPages() {
            return this.tempPages;
        }

        public void beginOutput() {
            log.info((Object)"Begin R1Print Engine.");
        }

        public void beginPageOutput(String id, int idx) {
            log.info((Object)("Begin page output, id:" + id + " , index: " + idx));
        }

        public void endPageOutput(String id, int idx) {
            Page pg = RecR1PrintPageProvider.this._engine.getOutputPage(idx);
            PWPage pwPage = RecR1PrintPageProvider.this._engine.getExecutedPage(idx);
            if (!RecR1PrintPageProvider.this._isCrossPrint && (RecR1PrintPageProvider.this._isVerEconomizePage || RecR1PrintPageProvider.this._isHorEconomizePage)) {
                int index;
                this.cutPageBlankTail(pg);
                this.getTempPages().add(pg);
                log.debug((Object)("\u8282\u7eb8\u6253\u5370\uff0c\u5c1d\u8bd5\u62fc\u7eb8\u5f20\u5927\u91cc\u5c0f\u7684\u9875\u3002\u4e34\u65f6\u5217\u8868\u9875\u6570\uff1a" + this.getTempPages().size()));
                this.remainHeight = this.bodyHeight;
                this.remainWidth = this.bodyWidth;
                boolean isOutput = false;
                float maxHeight = 0.0f;
                int c = this.getTempPages().size();
                for (index = 0; index < c; ++index) {
                    Page page = (Page)this.getTempPages().get(index);
                    maxHeight = Math.max(maxHeight, page.getHeight());
                    if (index == 0) {
                        this.remainWidth -= page.getWidth() + (float)RecR1PrintPageProvider.this._horDistance;
                        this.remainHeight -= page.getHeight() + (float)RecR1PrintPageProvider.this._verDistance;
                    }
                    this.remainWidth = RecR1PrintPageProvider.this._isHorEconomizePage ? (this.remainWidth -= page.getWidth()) : -1.0f;
                    if (this.remainWidth < 0.0f) {
                        if (RecR1PrintPageProvider.this._isVerEconomizePage) {
                            this.remainHeight -= maxHeight;
                            if (this.remainHeight < 0.0f) {
                                isOutput = true;
                                break;
                            }
                            maxHeight = 0.0f;
                            this.remainHeight -= (float)RecR1PrintPageProvider.this._verDistance;
                            this.remainWidth = this.bodyWidth - page.getWidth();
                        } else {
                            isOutput = true;
                            break;
                        }
                    }
                    this.remainWidth -= (float)RecR1PrintPageProvider.this._horDistance;
                }
                if (isOutput) {
                    log.debug((Object)"\u8282\u7eb8\u6253\u5370\uff0c\u62fc\u7eb8\u5f20\u5927\u5c0f\u7684\u9875\u6210\u529f\u3002");
                    RecR1PrintPageProvider.this.addPage(this.togetherPage(++index));
                } else if (pwPage.isPaginationByGroupDiffs()) {
                    RecR1PrintPageProvider.this.addPage(this.togetherPage(index));
                }
            } else {
                RecR1PrintPageProvider.this.addPage(pg);
            }
            log.info((Object)("End page " + idx + " output."));
        }

        public void endOutput() {
            if ((RecR1PrintPageProvider.this._isVerEconomizePage || RecR1PrintPageProvider.this._isHorEconomizePage) && this.getTempPages().size() > 0) {
                log.debug((Object)"R1Print\u6267\u884c\u7ed3\u675f\uff0c\u8282\u7eb8\u6253\u5370\uff0c\u6240\u6709\u5269\u4f59\u7684\u9875\u62fc\u6210\u7eb8\u5f20\u5927\u5c0f\u7684\u9875\u8f93\u51fa\u3002");
                RecR1PrintPageProvider.this.addPage(this.togetherPage(this.getTempPages().size()));
            }
            log.info((Object)"End R1Print Engine.");
            RecR1PrintPageProvider.this.finish();
        }

        private void cutPageBlankTail(Page page) {
            float maxBottom = 0.0f;
            float maxRight = 0.0f;
            for (IPainter child : page.getAllPainter()) {
                float bottom = child.getY() + child.getHeight();
                float right = child.getX() + child.getWidth();
                if (maxBottom < bottom) {
                    maxBottom = bottom;
                }
                if (!(maxRight < right)) continue;
                maxRight = right;
            }
            if (maxBottom < page.getHeight()) {
                page.setHeight(maxBottom);
            }
            if (maxRight < page.getWidth()) {
                page.setWidth(maxRight);
            }
        }

        private Page togetherPage(int pageCounts) {
            Page page1 = (Page)this.getTempPages().remove(0);
            Page pageNow = new Page();
            pageNow.setHeight(page1.getHeight());
            pageNow.setWidth(page1.getWidth());
            float addedX = page1.getWidth() + (float)RecR1PrintPageProvider.this._horDistance;
            float addedY = page1.getY();
            float maxHeight = page1.getHeight();
            page1.setWidth(this.bodyWidth);
            page1.setHeight(this.bodyHeight);
            for (int i = 1; i < pageCounts; ++i) {
                Page pageN = (Page)this.getTempPages().remove(0);
                maxHeight = Math.max(maxHeight, pageNow.getHeight());
                page1.addPainter((IPainter)pageN);
                if (RecR1PrintPageProvider.this._isHorEconomizePage && addedX + pageN.getWidth() < this.bodyWidth) {
                    pageN.setX(addedX);
                }
                if (RecR1PrintPageProvider.this._isVerEconomizePage && (!RecR1PrintPageProvider.this._isHorEconomizePage || addedX + pageNow.getWidth() > this.bodyWidth)) {
                    addedX = page1.getX();
                    addedY += maxHeight + (float)RecR1PrintPageProvider.this._verDistance;
                    maxHeight = 0.0f;
                }
                pageN.setY(addedY);
                addedX += pageNow.getWidth() + (float)RecR1PrintPageProvider.this._horDistance;
                pageNow = pageN;
            }
            return page1;
        }
    }
}

