/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.evs;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.app.util.ArchConfigUtil;
import com.kingdee.eas.el.rec.app.util.ArchConstant;
import com.kingdee.eas.el.rec.evs.FilingEvsUtils;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.model.FileInfo;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.outputmodule.archsys.helper.NoticeArchSysHelper;
import com.kingdee.eas.el.rec.outputmodule.archsys.helper.NoticeArchSysHelperFactory;
import com.kingdee.eas.el.rec.outputmodule.archsys.pojo.ArchFormatInfo;
import com.kingdee.util.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class IEvsService {
    public abstract Map getDataStandards(Context var1, CompanyOrgUnitInfo var2, PeriodInfo var3, List<String> var4, ArchFormatInfo var5) throws Exception;

    public void uploadXbrlDependEvs(Context ctx, ArchFormatInfo archFormatInfo, List<XmlBase> xmlBases) throws Exception {
        if (xmlBases == null || xmlBases.size() == 0 || !((ArchInfo)xmlBases.get(0)).getIsMainBill().booleanValue() || !FilingEvsUtils.canArchXbrl(ctx, archFormatInfo.getContent().getId().toString(), ((ArchInfo)xmlBases.get(0)).getCompany().getId().toString()).booleanValue()) {
            return;
        }
        if (!FilingEvsUtils.hasBeenEvsPatch().booleanValue()) {
            throw new RecException(RecException.UNKNOWN, new Object[]{"\u7cfb\u7edf\u672a\u68c0\u6d4b\u5230 \u7535\u5b50\u51ed\u8bc1\u4f1a\u8ba1\u6570\u636e\u6807\u51c6\uff08evs\uff09\u6a21\u5757\u8865\u4e01\uff0c\u8bf7\u5148\u6253\u8865\u4e01\uff01\uff01"});
        }
        PeriodInfo periodInfo = archFormatInfo.getPeriodInfo();
        CompanyOrgUnitInfo companyOrgUnitInfo = ((ArchInfo)xmlBases.get(0)).getCompany();
        ArrayList<String> billPks = new ArrayList<String>(xmlBases.size());
        for (XmlBase xmlBase : xmlBases) {
            billPks.add(((ArchInfo)xmlBase).getBillId());
        }
        Map dataStandards = this.getDataStandards(ctx, companyOrgUnitInfo, periodInfo, billPks, archFormatInfo);
        this.dealXbrlDataStandards(ctx, dataStandards, archFormatInfo, xmlBases);
    }

    private void dealXbrlDataStandards(Context ctx, Map dataStandards, ArchFormatInfo archFormatInfo, List<XmlBase> xmlBases) throws Exception {
        for (int i = 0; i < xmlBases.size(); ++i) {
            ArchInfo archInfo = (ArchInfo)xmlBases.get(i);
            Map dataStandard = (Map)dataStandards.get(archInfo.getBillId());
            if (dataStandard == null || dataStandard.size() == 0) continue;
            for (Map.Entry xbrlFileInfo : dataStandard.entrySet()) {
                Map file = (Map)xbrlFileInfo.getValue();
                this.fileUpLoad(ctx, archFormatInfo, (InputStream)file.get("file"), (String)file.get("fileName"));
                archInfo.getFileInfos().add(new FileInfo("", (String)file.get("fileName"), (String)file.get("fileName")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileUpLoad(Context ctx, ArchFormatInfo archFormatInfo, InputStream is, String fileName) throws Exception {
        if (null != is) {
            String arch_type = ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_TYPE);
            NoticeArchSysHelper noticeArchSysHelper = NoticeArchSysHelperFactory.getInstance(ctx, arch_type);
            String businessType = noticeArchSysHelper.getbusinessType(ctx, archFormatInfo.getContent(), archFormatInfo.getContent().getXmlDocType());
            if (!StringUtils.isEmpty((String)businessType) && !StringUtils.isEmpty((String)fileName) && fileName.endsWith(".xml")) {
                if ("2".equals(businessType)) {
                    businessType = "1";
                } else if ("4".equals(businessType)) {
                    businessType = "3";
                }
            }
            archFormatInfo.setXmlName(fileName.endsWith(".xml") ? fileName : "");
            String tempFilePath = (String)ctx.get((Object)"tempFile");
            if (("null".equals(tempFilePath) || StringUtils.isEmpty((String)tempFilePath)) && is.available() > Integer.parseInt(ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_TEMPFILE_LENGTH))) {
                is = FilingUtils.createTempFile(ctx, is, fileName);
            }
            try {
                noticeArchSysHelper.fileUpLoad(ctx, archFormatInfo, archFormatInfo.getPeriodInfo(), is, archFormatInfo.getJobInfo().getFileFlag(), businessType, fileName, archFormatInfo.getRecordInfo().getOrg());
            }
            finally {
                FilingUtils.deleteTempFile(ctx);
            }
        }
    }
}

