/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.filing.instance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.el.rec.AchRecordDetailCollection;
import com.kingdee.eas.el.rec.AchRecordDetailFactory;
import com.kingdee.eas.el.rec.AchRecordDetailHisFactory;
import com.kingdee.eas.el.rec.AchRecordDetailInfo;
import com.kingdee.eas.el.rec.ArcRecordCollection;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArcStateEnum;
import com.kingdee.eas.el.rec.ArchFlagEnum;
import com.kingdee.eas.el.rec.ArchSchemeInfo;
import com.kingdee.eas.el.rec.ArchSchemeScopeOrgEntryCollection;
import com.kingdee.eas.el.rec.ArchSysLogServiceFacadeFactory;
import com.kingdee.eas.el.rec.ArcheSchemeContentEntryCollection;
import com.kingdee.eas.el.rec.AttachBillAchDetailCollection;
import com.kingdee.eas.el.rec.AttachBillAchDetailFactory;
import com.kingdee.eas.el.rec.AttachBillAchDetailInfo;
import com.kingdee.eas.el.rec.FilingInstanceFacadeFactory;
import com.kingdee.eas.el.rec.JobCollection;
import com.kingdee.eas.el.rec.JobEntryCollection;
import com.kingdee.eas.el.rec.JobEntryFactory;
import com.kingdee.eas.el.rec.JobEntryInfo;
import com.kingdee.eas.el.rec.JobFactory;
import com.kingdee.eas.el.rec.JobInfo;
import com.kingdee.eas.el.rec.OperationEnum;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.TaskStateEnum;
import com.kingdee.eas.el.rec.app.util.ArchConfigUtil;
import com.kingdee.eas.el.rec.app.util.ArchConstant;
import com.kingdee.eas.el.rec.evs.EvsServiceFactory;
import com.kingdee.eas.el.rec.filing.instance.AbstractFilingStrategy;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.model.ArchInfos;
import com.kingdee.eas.el.rec.model.FileInfo;
import com.kingdee.eas.el.rec.model.IXmlSrcObj;
import com.kingdee.eas.el.rec.model.RecordInfo;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.model.dataprovider.AbstractBatchDataProvider;
import com.kingdee.eas.el.rec.model.dataprovider.IBatchDataProvider;
import com.kingdee.eas.el.rec.outputmodule.archsys.helper.NoticeArchSysHelperFactory;
import com.kingdee.eas.el.rec.outputmodule.archsys.pojo.ArchFormatInfo;
import com.kingdee.eas.el.rec.tool.ArchRecordUtils;
import com.kingdee.eas.el.rec.tool.ArchUtils;
import com.kingdee.eas.el.rec.tool.DateUtil;
import com.kingdee.eas.el.rec.tool.FormatUtils;
import com.kingdee.eas.el.rec.tool.IBillHandler;
import com.kingdee.eas.el.rec.tool.IDUtils;
import com.kingdee.eas.el.rec.tool.PeriodUtil;
import com.kingdee.eas.el.rec.tool.RecordBaseUtils;
import com.kingdee.eas.el.rec.tool.ThreadPoolInitFactory;
import com.kingdee.eas.el.rec.tool.engine.BillParsingEngineUtil;
import com.kingdee.eas.el.rec.tool.engine.ParsingEngineUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FilingBill
extends AbstractFilingStrategy {
    private static Logger logger = Logger.getLogger(FilingBill.class);

    @Override
    protected void checkScheme(Context ctx, ArchSchemeInfo asInfo) throws EASBizException {
        ArchSchemeScopeOrgEntryCollection orgs = asInfo.getSchemeOrg();
        if (null == orgs || orgs.size() == 0) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"\u5f52\u6863\u7ec4\u7ec7\u8303\u56f4"});
        }
        ArcheSchemeContentEntryCollection archemeContent = asInfo.getArchemeContent();
        for (int i = 0; i < archemeContent.size(); ++i) {
            RecordBaseInfo archContent = archemeContent.get(i).getArchContent();
            if (!StringUtils.isEmpty((String)archContent.getPrintTemplate()) || !archContent.isIsCustomPrint()) continue;
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"\u7ec4\u7ec7[" + archContent.getOrg().getName() + "]\u4e0b\u914d\u7f6e\u5f52\u6863\u5185\u5bb9[" + archContent.getNumber() + "]\u7684\u5957\u6253\u6a21\u677f"});
        }
        this.checkPrint(ctx, asInfo, orgs, archemeContent);
    }

    private void checkPrint(Context ctx, ArchSchemeInfo asInfo, ArchSchemeScopeOrgEntryCollection orgs, ArcheSchemeContentEntryCollection archemeContent) throws RecException {
        CompanyOrgUnitCollection companyOrgs;
        HashMap<String, RecordBaseInfo> contentMap = new HashMap<String, RecordBaseInfo>();
        RecordBaseInfo mainContent = null;
        ArrayList<RecordBase> checkList = new ArrayList<RecordBase>();
        for (int i = 0; i < archemeContent.size(); ++i) {
            RecordBaseInfo archContent = archemeContent.get(i).getArchContent();
            if (!archContent.isIsRefBill()) {
                mainContent = archContent;
            }
            checkList.add(new RecordBase(archContent.getOrg(), archContent));
            contentMap.put(archContent.getId().toString(), archContent);
        }
        try {
            companyOrgs = FilingUtils.getCompanyOrgs(ctx, orgs, true, asInfo.getLastUpdateUser().getId() + "", "el_rec_ArchSchemeList_addNew");
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u65b9\u6848[" + asInfo.getNumber() + "]\u83b7\u53d6\u5f52\u6863\u7ec4\u7ec7\u5f02\u5e38"});
        }
        for (int i = 0; i < companyOrgs.size(); ++i) {
            CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgs.get(i);
            RecordBaseInfo newMainContent = FilingUtils.getContent(ctx, mainContent, companyOrgUnitInfo);
            Map<String, RecordBaseInfo> contents = this.getContents(ctx, archemeContent, mainContent, companyOrgUnitInfo);
            if (null != mainContent) {
                contents.put(mainContent.getId().toString(), newMainContent);
            }
            for (RecordBaseInfo next : contents.values()) {
                if (!next.isIsCustomPrint() || next.getPrintTemplate().equals(((RecordBaseInfo)contentMap.get(next.getId().toString())).getPrintTemplate())) continue;
                checkList.add(new RecordBase(companyOrgUnitInfo, next));
            }
        }
        this.checkPrint(ctx, checkList, archemeContent.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPrint(Context ctx, List<RecordBase> checkList, int corePoolSize) throws RecException {
        ThreadPoolExecutor execute = new ThreadPoolExecutor(corePoolSize, 2 * corePoolSize, 25L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(corePoolSize));
        ArrayList<Future<Exception>> futureList = new ArrayList<Future<Exception>>();
        for (int i = 0; i < checkList.size(); ++i) {
            if (execute.isShutdown()) continue;
            try {
                Future<Exception> submit = execute.submit(new CheckPrintThread(ctx, checkList.get(i), execute));
                futureList.add(submit);
                continue;
            }
            catch (RejectedExecutionException e) {
                // empty catch block
            }
        }
        StringBuilder sb = new StringBuilder();
        Throwable case_one = null;
        try {
            for (int i = 0; i < futureList.size(); ++i) {
                Future exceptionFuture = (Future)futureList.get(i);
                Exception exception = null;
                try {
                    exception = (Exception)exceptionFuture.get();
                }
                catch (InterruptedException e) {
                    throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u591a\u7ebf\u7a0b\u6821\u9a8c\u5957\u6253\u6a21\u677f\u5f02\u5e38"});
                }
                catch (ExecutionException e) {
                    throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u591a\u7ebf\u7a0b\u6821\u9a8c\u5957\u6253\u6a21\u677f\u5f02\u5e38"});
                }
                if (null != exception) {
                    sb.append(exception.getMessage()).append(";");
                }
                if (exception == null || exception.getCause() == null) continue;
                case_one = exception.getCause();
            }
        }
        finally {
            execute.shutdown();
        }
        String sbStr = sb.toString();
        if (!StringUtils.isEmpty((String)sbStr)) {
            sbStr = sbStr + "\u8bf7\u5230\u5f52\u6863\u5185\u5bb9\u914d\u7f6e\u754c\u9762\u8fdb\u884c\u9a8c\u8bc1";
            throw new RecException(RecException.UNKNOWN, case_one, new Object[]{sbStr});
        }
    }

    @Override
    protected void doExecute(Context ctx, ArchSchemeInfo asInfo, ArcheSchemeContentEntryCollection contents, ArchSchemeScopeOrgEntryCollection orgs) throws Exception {
        CompanyOrgUnitCollection companyOrgs;
        try {
            companyOrgs = FilingUtils.getCompanyOrgs(ctx, orgs, true, asInfo.getLastUpdateUser().getId() + "", "el_rec_ArchSchemeList_addNew");
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u65b9\u6848[" + asInfo.getNumber() + "]\u83b7\u53d6\u5f52\u6863\u7ec4\u7ec7\u5f02\u5e38"});
        }
        for (int k = 0; k < contents.size(); ++k) {
            if (contents.get(k).getArchContent().isIsRefBill()) continue;
            RecordBaseInfo content = contents.get(k).getArchContent();
            for (int i = 0; i < companyOrgs.size(); ++i) {
                PeriodCollection periods;
                CompanyOrgUnitInfo org = companyOrgs.get(i);
                try {
                    periods = PeriodUtil.getPeriods(ctx, asInfo, content, org);
                }
                catch (Exception e) {
                    throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u65b9\u6848[" + asInfo.getNumber() + "]\u83b7\u53d6\u5f52\u6863\u671f\u95f4\u5f02\u5e38"});
                }
                for (int j = 0; j < periods.size(); ++j) {
                    content = FilingUtils.getContent(ctx, content, org);
                    PeriodInfo periodInfo = periods.get(j);
                    ArcRecordInfo baseArcRecordInfo = this.createBaseArcRecordInfo(ctx, asInfo, content, org, periodInfo);
                    baseArcRecordInfo.setFailNum(0);
                    baseArcRecordInfo.setAttachFailNum(0);
                    StringBuffer arcRecordNum = FilingUtils.getArcRecordNum(ctx, content, org.getNumber(), periodInfo.getNumber() + "");
                    baseArcRecordInfo.setArcRecordNum(arcRecordNum.toString());
                    FilingInstanceFacadeFactory.getLocalInstance(ctx).getFilingInstance(baseArcRecordInfo).arch(ctx, baseArcRecordInfo, periodInfo);
                }
            }
        }
    }

    @Override
    public void arch(Context ctx, ArcRecordInfo recordInfo, PeriodInfo periodInfo) throws Exception {
        PeriodInfo lastPeriodInfo = this.getLastPeriodInfo(ctx, recordInfo, periodInfo);
        ArcRecordInfo lastRecordInfo = this.getLastRecordInfo(ctx, recordInfo, lastPeriodInfo);
        if (null != lastRecordInfo && this.isCurrentPeriod(ctx, recordInfo, periodInfo)) {
            this.handleLastRecordInfo(ctx, recordInfo, lastPeriodInfo, lastRecordInfo);
        }
        super.arch(ctx, recordInfo, periodInfo);
    }

    private void handleLastRecordInfo(Context ctx, ArcRecordInfo recordInfo, PeriodInfo lastPeriodInfo, ArcRecordInfo lastRecordInfo) throws BOSException, EASBizException {
        boolean exists = ArcRecordFactory.getLocalInstance(ctx).exists("where arcRecordNum = '" + recordInfo.getArcRecordNum() + "'");
        try {
            if (!exists) {
                this.doArch(ctx, lastRecordInfo, lastPeriodInfo);
                this.reArchReports(ctx, lastRecordInfo.getId().toString());
                this.saveArchRecordInfo(ctx, recordInfo);
            } else if (ArcStateEnum.ARC_FAIL.equals((Object)lastRecordInfo.getState())) {
                this.doArch(ctx, lastRecordInfo, lastPeriodInfo);
            }
        }
        catch (Exception e) {
            this.handleArchException(ctx, lastRecordInfo, e);
        }
    }

    private void reArchReports(Context ctx, String recordId) throws Exception {
        ArcRecordInfo recordInfo = this.getRecordInfo(ctx, recordId, false);
        ArcRecordCollection reportRecordInfos = this.getRlReportRecords(ctx, recordInfo);
        for (int i = 0; i < reportRecordInfos.size(); ++i) {
            ArcRecordInfo arcRecordInfo = reportRecordInfos.get(i);
            FilingInstanceFacadeFactory.getLocalInstance(ctx).getFilingInstance(arcRecordInfo).fullReArch(ctx, arcRecordInfo.getId().toString());
        }
    }

    private ArcRecordInfo getLastRecordInfo(Context ctx, ArcRecordInfo recordInfo, PeriodInfo periodInfo) throws Exception {
        if (periodInfo == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("content", (Object)recordInfo.getContent().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("org", (Object)recordInfo.getOrg().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("periodNum", (Object)periodInfo.getNumber()));
        return this.getRecordInfo(ctx, filter, null);
    }

    private PeriodInfo getLastPeriodInfo(Context ctx, ArcRecordInfo recordInfo, PeriodInfo periodInfo) throws Exception {
        String sysNmae = recordInfo.getContent().getBillType().getPeriodSys();
        PeriodInfo cPd = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(Integer.parseInt(sysNmae), recordInfo.getOrg().getId().toString());
        if (null == cPd) {
            return null;
        }
        PeriodInfo pPd = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)cPd);
        return pPd;
    }

    @Override
    protected ArchInfos prepareData(Context ctx, ArcRecordInfo recordInfo, PeriodInfo periodInfo) throws Exception {
        PeriodInfo upStartTimePeriodInfo = this.getUpSTimePeriodInfo(recordInfo, periodInfo);
        recordInfo.setLastGetBillTime(new Timestamp(System.currentTimeMillis()));
        Map<String, IObjectValue> mainBillInfos = ArchUtils.getMainBills(ctx, recordInfo.getContent(), upStartTimePeriodInfo, recordInfo.getOrg());
        ArchSchemeInfo archSchemeInfo = this.getArchemeInfo(ctx, recordInfo.getArcSchemeId());
        Map<String, RecordBaseInfo> contents = this.getContents(ctx, archSchemeInfo.getArchemeContent(), recordInfo.getContent(), recordInfo.getOrg());
        ArchInfos archInfos = new ArchInfos(ctx, archSchemeInfo, recordInfo.getContent(), recordInfo.getOrg(), periodInfo, contents);
        this.handleDeletedData(ctx, archInfos, recordInfo);
        List<XmlBase> mainArchInfos = archInfos.getMainBills();
        if (mainBillInfos != null && mainBillInfos.size() > 0) {
            for (String billID : mainBillInfos.keySet()) {
                ArchInfo info = ArchUtils.getArchInfo(ctx, billID, mainBillInfos.get(billID), recordInfo.getLastGetBillTime(), archInfos);
                info.setDocType(recordInfo.getContent().getXmlDocType());
                info.setBillNumber(mainBillInfos.get(billID).getString("number"));
                mainArchInfos.add(info);
            }
            if (contents.size() != 0) {
                ArchUtils.mutilSetRefArchInfos(ctx, recordInfo, mainArchInfos, contents, OperationEnum.FIRST_ARC);
            }
        }
        this.classificationBill(archInfos, mainArchInfos);
        archInfos.increaseNumber(ctx, recordInfo);
        SelectorItemCollection selectorItem = new SelectorItemCollection();
        selectorItem.add(new SelectorItemInfo("lastGetBillTime"));
        this.updateArchRecordInfo(ctx, recordInfo, selectorItem);
        logger.error((Object)("prepareData this.mainBills:" + archInfos.getMainBills().size()));
        return archInfos;
    }

    private void prepareInterrputData(Context ctx, ArcRecordInfo recordInfo, ArchInfos archInfos, PeriodInfo periodInfo) throws Exception {
        Map<String, IObjectValue> mainBillInfos = ArchUtils.getMainBills(ctx, recordInfo.getContent(), periodInfo, recordInfo.getOrg());
        if (mainBillInfos == null || mainBillInfos.size() == 0) {
            return;
        }
        List<XmlBase> mainArchInfos = archInfos.getMainBills();
        for (String billID : mainBillInfos.keySet()) {
            ArchInfo info = ArchUtils.getArchInfoExists(ctx, billID, mainBillInfos.get(billID), recordInfo.getLastGetBillTime(), archInfos);
            info.setDocType(recordInfo.getContent().getXmlDocType());
            info.setBillNumber(mainBillInfos.get(billID).getString("number"));
            mainArchInfos.add(info);
        }
        if (archInfos.getContents().size() != 0) {
            ArchUtils.mutilSetRefArchInfos(ctx, recordInfo, mainArchInfos, archInfos.getContents(), OperationEnum.FAIL_ARC);
        }
        this.classificationBill(archInfos, mainArchInfos);
        logger.error((Object)("prepareInterrputData this.mainBills:" + mainArchInfos.size()));
    }

    private void classificationBill(ArchInfos archInfos, List<XmlBase> mainArchInfos) {
        for (int i = mainArchInfos.size() - 1; i >= 0; --i) {
            ArchInfo mainArchInfo = (ArchInfo)mainArchInfos.get(i);
            for (ArchInfo refInfo : mainArchInfo.getRefInfo()) {
                archInfos.setRefBill(refInfo.getRecordBaseId(), refInfo);
                if (refInfo.getArchInfos() != null) continue;
                refInfo.setArchInfos(archInfos);
            }
        }
    }

    @Override
    protected ArcRecordInfo getRecordInfo(Context ctx, String recorId, SelectorItemCollection selectorItemCollection) throws RecException {
        return this.getRecordInfo(ctx, recorId, selectorItemCollection, true);
    }

    @Override
    protected ArcRecordInfo getRecordInfo(Context ctx, String recorId, SelectorItemCollection selector, boolean queryChildRelation) throws RecException {
        ArcRecordInfo recordInfo = super.getRecordInfo(ctx, recorId, selector, queryChildRelation);
        RecordBaseInfo content = FilingUtils.getContent(ctx, recordInfo.getContent(), recordInfo.getOrg());
        recordInfo.setContent(content);
        return recordInfo;
    }

    private ArchInfos prepareAddNewUpdateData(Context ctx, ArcRecordInfo recordInfo, PeriodInfo periodInfo) throws Exception {
        ArchInfos archInfos = this.prepareData(ctx, recordInfo, periodInfo);
        if (null == archInfos) {
            return null;
        }
        ArchUtils.saveAchRecordDetail2Reverse(ctx, archInfos.getMainBills(), recordInfo.getId().toString());
        Map<String, List<XmlBase>> refBills = archInfos.getRefBills();
        Map<String, RecordBaseInfo> contents = archInfos.getContents();
        if (contents.size() != 0) {
            for (String refBosType : refBills.keySet()) {
                RecordBaseInfo refContent = contents.get(refBosType);
                ArchUtils.saveAttachBillAchDetail2reverse(ctx, refContent, refBills.get(refBosType), recordInfo);
            }
        }
        logger.error((Object)("this.mainBills:" + archInfos.getMainBills().size()));
        return archInfos;
    }

    @Deprecated
    private void doArchFailed(Context ctx, ArcRecordInfo recordInfo) throws Exception {
        block13: {
            String recordId = recordInfo.getId().toString();
            PeriodInfo periodInfo = this.getPeriodInfo(ctx, recordInfo);
            if (recordInfo.getVoucherNum() == 0) {
                this.doArch(ctx, recordInfo, periodInfo);
                return;
            }
            recordInfo.setFailNum(0);
            recordInfo.setAttachFailNum(0);
            recordInfo.setState(ArcStateEnum.ARC_LOADING);
            SelectorItemCollection selectorItem = new SelectorItemCollection();
            selectorItem.add(new SelectorItemInfo("failNum"));
            selectorItem.add(new SelectorItemInfo("attachFailNum"));
            selectorItem.add(new SelectorItemInfo("state"));
            this.updateArchRecordInfo(ctx, recordInfo, selectorItem);
            this.updateState2Failed(ctx, recordId);
            AchRecordDetailCollection achRecordDetails = this.getAchRecordDetailCollection(ctx, recordId);
            logger.error((Object)("achRecordDetails:" + achRecordDetails.size()));
            int allMainBillNum = achRecordDetails.size();
            int allSubBillNum = 0;
            for (int i = 0; i < achRecordDetails.size(); ++i) {
                AchRecordDetailInfo info = achRecordDetails.get(i);
                AttachBillAchDetailCollection attachBillAchDetails = info.getAttachBillAchDetails();
                allSubBillNum += attachBillAchDetails.size();
            }
            int allActualBillNum = allMainBillNum + allSubBillNum;
            ArchSchemeInfo archSchemeInfo = this.getArchemeInfo(ctx, recordInfo.getArcSchemeId());
            Map<String, RecordBaseInfo> contents = this.getContents(ctx, archSchemeInfo.getArchemeContent(), recordInfo.getContent(), recordInfo.getOrg());
            if (0 == allActualBillNum) {
                recordInfo.setVoucherNum(0);
                recordInfo.setOriginVcNum(0);
                recordInfo.setLastGetBillTime(null);
                selectorItem = new SelectorItemCollection();
                selectorItem.add(new SelectorItemInfo("voucherNum"));
                selectorItem.add(new SelectorItemInfo("originVcNum"));
                selectorItem.add(new SelectorItemInfo("lastGetBillTime"));
                this.updateArchRecordInfo(ctx, recordInfo, selectorItem);
                this.doArch(ctx, recordInfo, periodInfo);
                break block13;
            }
            if (allMainBillNum < recordInfo.getVoucherNum()) {
                this.doFullReArch(ctx, recordInfo);
                return;
            }
            if (allMainBillNum == recordInfo.getVoucherNum() && allSubBillNum == 0 && recordInfo.getOriginVcNum() != 0) {
                this.doFullReArch(ctx, recordInfo);
                return;
            }
            if (allMainBillNum == recordInfo.getVoucherNum()) {
                ArchInfos archInfos = new ArchInfos(ctx, archSchemeInfo, recordInfo.getContent(), recordInfo.getOrg(), periodInfo, contents);
                if (allSubBillNum < recordInfo.getOriginVcNum()) {
                    if (1.0 * (double)allSubBillNum / (double)recordInfo.getOriginVcNum() < 0.6) {
                        this.doFullReArch(ctx, recordInfo);
                        return;
                    }
                    this.handleDeletedData(ctx, archInfos, recordInfo);
                    this.prepareInterrputData(ctx, recordInfo, archInfos, periodInfo);
                } else if (allSubBillNum == recordInfo.getOriginVcNum()) {
                    ArchInfos archInfos1 = this.prepareAddNewUpdateData(ctx, recordInfo, periodInfo);
                    if (null != archInfos1) {
                        achRecordDetails = this.getAchRecordDetailCollection(ctx, recordId);
                    }
                    this.initArchInfosData(ctx, recordInfo, achRecordDetails, contents, archInfos);
                }
                recordInfo.setVoucherNum(archInfos.voucherSize());
                recordInfo.setOriginVcNum(archInfos.originVcSize());
                recordInfo.setTotalNum(archInfos.arcSize());
                selectorItem = new SelectorItemCollection();
                selectorItem.add(new SelectorItemInfo("voucherNum"));
                selectorItem.add(new SelectorItemInfo("originVcNum"));
                selectorItem.add(new SelectorItemInfo("totalNum"));
                this.updateArchRecordInfo(ctx, recordInfo, selectorItem);
                this.processData(ctx, recordInfo, archInfos);
                break block13;
            }
            this.releaseMutex(ctx, recordInfo);
            String s = "arcFailed\u6ca1\u6709\u6ee1\u8db3\u7684\u60c5\u51b5: allBIllNum" + allActualBillNum + ";info.getVoucherNum():" + recordInfo.getVoucherNum() + ";info.getOriginVcNum():" + recordInfo.getOriginVcNum();
            logger.error((Object)s);
            throw new RecException(RecException.UNKNOWN, new Object[]{s});
        }
    }

    private void initArchInfosData(Context ctx, ArcRecordInfo recordInfo, AchRecordDetailCollection achRecordDetails, Map<String, RecordBaseInfo> contents, ArchInfos archInfos) throws EASDBException, EASBizException, BOSException {
        List<XmlBase> mainBills = archInfos.getMainBills();
        IBillHandler billHandler = FilingUtils.getBillHandler(ctx, recordInfo.getContent());
        for (int i = 0; i < achRecordDetails.size(); ++i) {
            boolean existsBill;
            AchRecordDetailInfo info = achRecordDetails.get(i);
            ArchInfo archInfo = new ArchInfo(ctx, info.getId().toString(), info.getBillId(), true, null, archInfos);
            archInfo.setDocType(archInfos.getContent().getXmlDocType());
            archInfo.setBillNumber(info.getBillNumber());
            boolean bl = existsBill = !info.getState().equals((Object)ArcStateEnum.ARC_2BE_DELETED);
            if (existsBill) {
                existsBill = billHandler.existsBill(ctx, info.getBillId());
            }
            if (!existsBill) {
                archInfo.setReArchFlag(ArchFlagEnum.DELETE);
            } else if (info.getState().equals((Object)ArcStateEnum.ARC_FAIL)) {
                archInfo.setReArchFlag(ArchFlagEnum.ADDNEW);
            } else if (info.getState().equals((Object)ArcStateEnum.REVERSE_ARC)) {
                archInfo.setReArchFlag(ArchFlagEnum.UPDATE);
            }
            mainBills.add(archInfo);
            AttachBillAchDetailCollection attachBillAchDetails = info.getAttachBillAchDetails();
            for (int j = 0; j < attachBillAchDetails.size(); ++j) {
                AttachBillAchDetailInfo aInfo = attachBillAchDetails.get(j);
                ArchInfo refInfo = new ArchInfo(ctx, aInfo.getId().toString(), aInfo.getBillId(), false, null, archInfos);
                archInfo.addRefBill(refInfo);
                archInfo.setDataCenter(ctx.getAIS());
                refInfo.setRecordBaseId(aInfo.getArcContent().getId().toString());
                refInfo.setDocType(contents.get(aInfo.getArcContent().getId().toString()).getXmlDocType());
                refInfo.setBillNumber(aInfo.getBillNumber());
                refInfo.setMainBillID(archInfo.getBillId());
                refInfo.setMainBillNumber(archInfo.getBillNumber());
                if (!existsBill) {
                    refInfo.setReArchFlag(ArchFlagEnum.DELETE);
                } else if (aInfo.getState().equals((Object)ArcStateEnum.ARC_FAIL)) {
                    refInfo.setReArchFlag(ArchFlagEnum.ADDNEW);
                } else if (aInfo.getState().equals((Object)ArcStateEnum.REVERSE_ARC)) {
                    refInfo.setReArchFlag(ArchFlagEnum.UPDATE);
                }
                refInfo.addRefBill(archInfo);
                archInfos.setRefBill(aInfo.getArcContent().getId().toString(), refInfo);
            }
        }
    }

    private AchRecordDetailCollection getAchRecordDetailCollection(Context ctx, String recordId) throws BOSException {
        FilterItemCollection filterItem = new FilterItemCollection();
        filterItem.add(new FilterItemInfo("arcRecord", (Object)recordId));
        SelectorItemCollection selectorItem = new SelectorItemCollection();
        selectorItem.add("state");
        selectorItem.add("billNumber");
        selectorItem.add("billId");
        selectorItem.add("attachBillAchDetails.id");
        selectorItem.add("attachBillAchDetails.state");
        selectorItem.add("attachBillAchDetails.billNumber");
        selectorItem.add("attachBillAchDetails.billId");
        selectorItem.add("attachBillAchDetails.arcContent.*");
        return ArchUtils.getAchRecordDetailCollectionLimit(ctx, selectorItem, filterItem, "where a.FArcRecordID = '" + recordId + "'  ");
    }

    private void updateState2Failed(Context ctx, String recordId) throws RecException {
        String detail;
        try {
            String attach = "UPDATE T_REC_AttachBillAchDetail SET FState = 0 WHERE  FState = 3 and FAchRecordDetailID in(SELECT FID FROM T_REC_AchRecordDetail where FArcRecordID = '" + recordId + "')";
            DbUtil.execute((Context)ctx, (String)attach);
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u5931\u8d25\u518d\u5f52\u6863--\u9644\u5c5e\u5355\u636e\u72b6\u6001\u4e3a\u5f52\u6863\u4e2d\u7684\u6539\u4e3a\u5931\u8d25"});
        }
        try {
            detail = "UPDATE T_REC_AchRecordDetail SET FState = 0 WHERE FState = 3 and FArcRecordID = '" + recordId + "'";
            DbUtil.execute((Context)ctx, (String)detail);
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u5931\u8d25\u518d\u5f52\u6863--\u4e3b\u5355\u636e\u72b6\u6001\u4e3a\u5f52\u6863\u4e2d\u7684\u6539\u4e3a\u5931\u8d25"});
        }
        try {
            detail = "UPDATE T_REC_AchRecordDetail SET FOriginBillState = 3 WHERE FOriginBillState = 0 and FArcRecordID = '" + recordId + "'";
            DbUtil.execute((Context)ctx, (String)detail);
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u5931\u8d25\u518d\u5f52\u6863--\u51ed\u8bc1\u4e0a\u9644\u5c5e\u5355\u636e\u72b6\u6001\u4e3a\u5931\u8d25\u7684\u6539\u4e3a\u5f52\u6863\u4e2d"});
        }
    }

    private PeriodInfo getUpSTimePeriodInfo(ArcRecordInfo recordInfo, PeriodInfo periodInfo) {
        if (null != recordInfo.getLastGetBillTime()) {
            PeriodInfo newPeriodInfo = (PeriodInfo)periodInfo.clone();
            Date startDateTime = new Date(recordInfo.getLastGetBillTime().getTime());
            newPeriodInfo.setBeginDate(startDateTime);
            return newPeriodInfo;
        }
        periodInfo.setBeginDate(null);
        return periodInfo;
    }

    @Override
    protected void handleDeletedData(Context ctx, ArchInfos archInfos, ArcRecordInfo recordInfo) throws Exception {
        archInfos = ArchUtils.handDelteArchInfo(ctx, archInfos, archInfos.getContents(), recordInfo.getContent());
        logger.error((Object)("handleDeletedData this.mainBills:" + archInfos.getMainBills().size()));
    }

    @Override
    protected void doUploadData(Context ctx, ArcRecordInfo recordInfo, RecordBaseInfo content, List<XmlBase> xmlBaseList, String subName, String taskFlag) throws Exception {
        PeriodInfo periodInfo = this.getPeriodInfo(ctx, recordInfo);
        if (content.isIsRefBill()) {
            content.setRefMainBill(recordInfo.getContent());
        }
        ((BillParsingEngineUtil)ParsingEngineUtil.getInstance(ctx, content)).fillXmlBaseData(BOSObjectType.create((String)content.getBillType().getBosType()), xmlBaseList, content, periodInfo);
        if (content.isIsRefBill()) {
            ArchUtils.saveAttachBillAchDetail(ctx, content, xmlBaseList, recordInfo);
        }
        StringBuilder xmlName = new StringBuilder(recordInfo.getArcRecordNum());
        xmlName.append("_").append(subName).append("_").append(DateUtil.format(new Date(), "yyyyMMddHHmmss")).append(".xml");
        logger.error((Object)("UploadBillArchInfosThread," + Thread.currentThread().getName() + ":" + xmlName.toString()));
        taskFlag = this.getTaskFlag();
        ArchFormatInfo formatInfo = this.getArchFormatInfo(ctx, recordInfo, periodInfo, content, taskFlag);
        formatInfo.setXmlName(xmlName.toString());
        formatInfo.setXmlBases(xmlBaseList);
        this.upload(ctx, recordInfo.getOrg(), periodInfo, formatInfo);
    }

    @Override
    protected void processData(Context ctx, ArcRecordInfo recordInfo, ArchInfos archInfos) throws Exception {
        if (null == archInfos || archInfos.size() == 0 || recordInfo.getTotalNum() == 0) {
            this.handleNoData(ctx, recordInfo);
            return;
        }
        ArchUtils.saveAchRecordDetail(ctx, archInfos.getMainBills(), recordInfo.getId().toString());
        String taskFlag = this.getTaskFlag();
        this.uploadByCategory(ctx, recordInfo, archInfos.getMainBills(), taskFlag, recordInfo.getContent());
        Map<String, List<XmlBase>> refBills = archInfos.getRefBills();
        Map<String, RecordBaseInfo> contents = archInfos.getContents();
        if (contents.size() != 0) {
            for (String refBosType : refBills.keySet()) {
                RecordBaseInfo refContent = contents.get(refBosType);
                this.uploadByCategory(ctx, recordInfo, refBills.get(refBosType), taskFlag, refContent);
            }
        }
    }

    private void uploadByCategory(Context ctx, ArcRecordInfo recordInfo, List<XmlBase> bills, String taskFlag, RecordBaseInfo content) {
        if (null == bills) {
            logger.error((Object)("\u5355\u636e\u6570\u76ee:" + content.getNumber() + ":\u65e0\u5355\u636e"));
            return;
        }
        logger.error((Object)("\u5355\u636e\u6570\u76ee:" + content.getNumber() + ":" + bills.size()));
        ArrayList<XmlBase> addNewArchInfos = new ArrayList<XmlBase>();
        ArrayList<XmlBase> updateArchInfos = new ArrayList<XmlBase>();
        ArrayList<XmlBase> deleteArchInfos = new ArrayList<XmlBase>();
        for (int i = 0; i < bills.size(); ++i) {
            ArchInfo arch = (ArchInfo)bills.get(i);
            if (ArchFlagEnum.ADDNEW.equals((Object)arch.getReArchFlag())) {
                addNewArchInfos.add(arch);
            }
            if (ArchFlagEnum.UPDATE.equals((Object)arch.getReArchFlag())) {
                updateArchInfos.add(arch);
            }
            if (!ArchFlagEnum.DELETE.equals((Object)arch.getReArchFlag())) continue;
            deleteArchInfos.add(arch);
        }
        if (deleteArchInfos.size() > 0) {
            this.processDataThread(ctx, recordInfo, content, deleteArchInfos, "DELETE", taskFlag);
        }
        if (addNewArchInfos.size() > 0) {
            this.processDataThread(ctx, recordInfo, content, addNewArchInfos, "ADDNEW", taskFlag);
        }
        if (updateArchInfos.size() > 0) {
            this.processDataThread(ctx, recordInfo, content, updateArchInfos, "UPDATE", taskFlag);
        }
    }

    @Override
    protected void deleteArchedData(Context ctx, ArcRecordInfo recordInfo) throws RecException {
        try {
            recordInfo.setTotalNum(0);
            recordInfo.setVoucherNum(0);
            recordInfo.setOriginVcNum(0);
            recordInfo.setFailNum(0);
            recordInfo.setAttachFailNum(0);
            SelectorItemCollection selectorItem = new SelectorItemCollection();
            selectorItem.add(new SelectorItemInfo("totalNum"));
            selectorItem.add(new SelectorItemInfo("voucherNum"));
            selectorItem.add(new SelectorItemInfo("originVcNum"));
            selectorItem.add(new SelectorItemInfo("failNum"));
            selectorItem.add(new SelectorItemInfo("attachFailNum"));
            this.updateArchRecordInfo(ctx, recordInfo, selectorItem);
            String sql = "DELETE FROM T_REC_AttachBillAchDetail T1 where exists (SELECT 1 FROM T_REC_AchRecordDetail T2 where T2.FArcRecordID = '" + recordInfo.getId().toString() + "' and T2.FID = T1.FAchRecordDetailID) ";
            DbUtil.execute((Context)ctx, (String)sql);
            AchRecordDetailFactory.getLocalInstance(ctx).delete("where arcRecord = '" + recordInfo.getId().toString() + "'");
            String sql1 = "DELETE FROM T_REC_AttachBillAchDetailHis T1 where exists (SELECT 1 FROM T_REC_AchRecordDetailHis T2 where T2.FArcRecordID = '" + recordInfo.getId().toString() + "' and T2.FID = T1.FAchRecordDetailID) ";
            DbUtil.execute((Context)ctx, (String)sql1);
            AchRecordDetailHisFactory.getLocalInstance(ctx).delete("where arcRecord = '" + recordInfo.getId().toString() + "'");
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u5220\u9664\u5355\u636e\u5931\u8d25"});
        }
    }

    @Override
    public String reverseArch(Context ctx, String recordId) throws Exception {
        super.reverseArch(ctx, recordId);
        ArcRecordInfo recordInfo = this.getRecordInfo(ctx, recordId, false);
        ArcRecordCollection reportRecordInfos = this.getRlReportRecords(ctx, recordInfo);
        if (reportRecordInfos.isEmpty()) {
            return "";
        }
        StringBuilder retStr = new StringBuilder(recordInfo.getArcRecordNum());
        retStr.append("\u53cd\u5f52\u6863\u65f6\u7cfb\u7edf\u81ea\u52a8\u53cd\u5f52\u6863\u76f8\u5173");
        for (int i = 0; i < reportRecordInfos.size(); ++i) {
            ArcRecordInfo arcRecordInfo = reportRecordInfos.get(i);
            if (ArcStateEnum.ARC_SUCCESS.equals((Object)arcRecordInfo.getState())) {
                FilingInstanceFacadeFactory.getLocalInstance(ctx).getFilingInstance(arcRecordInfo).reverseArch(ctx, arcRecordInfo.getId().toString());
            }
            retStr.append(",").append(arcRecordInfo.getArcRecordNum());
        }
        retStr.append("\u62a5\u8868;");
        return retStr.toString();
    }

    @Override
    public void fullReArch(Context ctx, String recordId) throws Exception {
        super.fullReArch(ctx, recordId);
        this.reArchReverseReports(ctx, recordId);
    }

    private void reArchReverseReports(Context ctx, String recordId) throws Exception {
        ArcRecordInfo recordInfo = this.getRecordInfo(ctx, recordId, false);
        ArcRecordCollection reportRecordInfos = this.getRlReportRecords(ctx, recordInfo);
        for (int i = 0; i < reportRecordInfos.size(); ++i) {
            ArcRecordInfo arcRecordInfo = reportRecordInfos.get(i);
            if (!ArcStateEnum.REVERSE_ARC.equals((Object)arcRecordInfo.getState())) continue;
            FilingInstanceFacadeFactory.getLocalInstance(ctx).getFilingInstance(arcRecordInfo).fullReArch(ctx, arcRecordInfo.getId().toString());
        }
    }

    @Override
    public void increReArch(Context ctx, String recordId) throws Exception {
        ArcRecordInfo recordInfo = this.getRecordInfo(ctx, recordId, null, false);
        if (ArcStateEnum.ARC_LOADING.equals((Object)recordInfo.getState())) {
            String arch_type = ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_TYPE);
            if (ArchConstant.ARCH_SYS_TYPE_GXHC.equals(arch_type)) {
                if (recordInfo.getLastUpdateTime().before(new Date(System.currentTimeMillis() - 86400000L))) {
                    PeriodInfo periodInfo = this.getPeriodInfo(ctx, recordInfo);
                    JobCollection jobCollection = JobFactory.getLocalInstance(ctx).getJobCollection("where record = '" + recordId + "' and (state = '" + "uploaded" + "' or state = '" + (Object)((Object)TaskStateEnum.NOTICED) + "')");
                    for (int i = 0; i < jobCollection.size(); ++i) {
                        JobInfo jobInfo = jobCollection.get(i);
                        ArchFormatInfo archFormatInfo = this.getArchFormatInfo(ctx, recordInfo, periodInfo, jobInfo.getContent(), jobInfo.getFileFlag());
                        List<XmlBase> xmlBaseList = this.getXmlBaseList(ctx, recordInfo, jobInfo);
                        archFormatInfo.setXmlBases(xmlBaseList);
                        String xmlSuffix = (jobInfo.getFailNum() > 0 ? "_" + jobInfo.getFailNum() : "") + ".xml";
                        archFormatInfo.setXmlName(jobInfo.getXmlName() + xmlSuffix);
                        this.noticeSysArchBatch(ctx, archFormatInfo);
                        jobInfo.setState("noticed");
                        JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"state"});
                    }
                }
            } else {
                boolean jobUloaded = this.jobUloaded(ctx, recordInfo);
                if (jobUloaded && recordInfo.getLastUpdateTime().before(new Date(System.currentTimeMillis() - 86400000L))) {
                    JobCollection jobCollection = JobFactory.getLocalInstance(ctx).getJobCollection("where record = '" + recordId + "' and state = '" + "uploaded" + "'");
                    while (!jobCollection.isEmpty()) {
                        ArchFormatInfo archFormatInfo = this.getArchFormatInfo(ctx, recordInfo, this.getPeriodInfo(ctx, recordInfo), null, jobCollection.get(0).getFileFlag());
                        this.noticeSysArch(ctx, archFormatInfo);
                        this.updateJob2Completed(ctx, recordId, jobCollection.get(0).getFileFlag());
                        jobCollection = JobFactory.getLocalInstance(ctx).getJobCollection("where record = '" + recordId + "' and state = '" + "uploaded" + "'");
                    }
                    this.processFinalStateTx(ctx, recordId);
                }
            }
        }
        super.increReArch(ctx, recordId);
        this.reArchReverseReports(ctx, recordId);
    }

    private ArcRecordCollection getRlReportRecords(Context ctx, ArcRecordInfo recordInfo) throws EASBizException {
        ArcRecordCollection reportRecordInfos = new ArcRecordCollection();
        if (recordInfo.getContent().isIsUpdateReport()) {
            CompanyOrgUnitCollection allParentCompanyOrgs;
            PeriodInfo periodInfo = this.getPeriodInfo(ctx, recordInfo);
            EntityViewInfo evInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("periodStartTime", (Object)periodInfo.getEndDate(), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodEndTime", (Object)periodInfo.getEndDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodStartTime", (Object)periodInfo.getBeginDate(), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodEndTime", (Object)periodInfo.getBeginDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("contentType", (Object)"report", CompareType.EQUALS));
            HashSet<String> orgSet = new HashSet<String>();
            try {
                allParentCompanyOrgs = FilingUtils.getAllParentCompanyOrgs(ctx, recordInfo.getOrg().getId().toString(), true);
            }
            catch (Exception e) {
                throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u83b7\u53d6\u4e0a\u7ea7\u7ec4\u7ec7\u5f02\u5e38"});
            }
            for (int i = 0; i < allParentCompanyOrgs.size(); ++i) {
                orgSet.add(allParentCompanyOrgs.get(i).getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("org.id", orgSet, CompareType.INCLUDE));
            filter.setMaskString("((#0 and #1) or (#2 and #3)) and #4 and #5");
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("id");
            selectorItemCollection.add("arcRecordNum");
            selectorItemCollection.add("state");
            evInfo.setSelector(selectorItemCollection);
            evInfo.setFilter(filter);
            try {
                reportRecordInfos = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection(evInfo);
            }
            catch (Exception e) {
                throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u83b7\u53d6\u5f52\u6863\u8bb0\u5f55\u5f02\u5e38"});
            }
        }
        return reportRecordInfos;
    }

    @Override
    protected void doBusinessReverse(Context ctx, ArcRecordInfo recordInfo) throws RecException {
        try {
            IBillHandler billHandler = FilingUtils.getBillHandler(ctx, recordInfo.getContent());
            billHandler.revokeArch(ctx, recordInfo);
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u4e1a\u52a1\u53cd\u5f52\u6863\u5f02\u5e38\uff1a" + e.getMessage()});
        }
    }

    private void saveDataAndJob(RecordInfo recordInfo) throws Exception {
        if (recordInfo.chgNum() == 0) {
            return;
        }
        ArchInfos archInfos = recordInfo.getArchInfos();
        Context ctx = recordInfo.getCtx();
        String taskFlag = this.getTaskFlag();
        ArchUtils.saveAchRecordDetail(ctx, archInfos.getMainBills(), recordInfo.getArcRecordInfo().getId().toString());
        this.categorySaveJob(recordInfo, archInfos.getMainBills(), taskFlag, recordInfo.getArcRecordInfo().getContent());
        Map<String, List<XmlBase>> refBills = archInfos.getRefBills();
        Map<String, RecordBaseInfo> contents = archInfos.getContents();
        if (contents.size() != 0) {
            for (String refBosType : refBills.keySet()) {
                RecordBaseInfo refContent = contents.get(refBosType);
                ArchUtils.saveAttachBillAchDetail(ctx, refContent, refBills.get(refBosType), recordInfo.getArcRecordInfo());
                this.categorySaveJob(recordInfo, refBills.get(refBosType), taskFlag, refContent);
            }
        }
        ArcRecordInfo arcRecordInfo = recordInfo.getArcRecordInfo();
        int totalNum = recordInfo.getAddnewNum().getMainBillNum() + recordInfo.getAddnewNum().getRefBIllNum() + recordInfo.getUpdateNum().getMainBillNum() + recordInfo.getUpdateNum().getRefBIllNum();
        StringBuilder sqlBuilder = new StringBuilder("update t_rec_ArcRecord set FTotalNum = ");
        if (arcRecordInfo.getTotalNum() != 0) {
            sqlBuilder.append("FTotalNum +");
        }
        sqlBuilder.append(totalNum).append(", FVoucherNum = ");
        if (arcRecordInfo.getVoucherNum() != 0) {
            sqlBuilder.append("FVoucherNum +");
        }
        sqlBuilder.append(recordInfo.getAddnewNum().getMainBillNum()).append(", FOriginVcNum = ");
        if (arcRecordInfo.getOriginVcNum() != 0) {
            sqlBuilder.append("FOriginVcNum +");
        }
        sqlBuilder.append(recordInfo.getAddnewNum().getRefBIllNum()).append(" where  FID = '").append(arcRecordInfo.getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sqlBuilder.toString());
    }

    private void categorySaveJob(RecordInfo recordInfo, List<XmlBase> bills, String taskFlag, RecordBaseInfo content) throws Exception {
        if (null == bills || bills.size() == 0) {
            return;
        }
        logger.error((Object)(recordInfo.getArcRecordInfo().getArcRecordNum() + " \u5355\u636e\u6570\u76ee:" + content.getNumber() + ":" + bills.size()));
        ArrayList<XmlBase> addNewArchInfos = new ArrayList<XmlBase>();
        ArrayList<XmlBase> updateArchInfos = new ArrayList<XmlBase>();
        ArrayList<XmlBase> deleteArchInfos = new ArrayList<XmlBase>();
        for (int i = 0; i < bills.size(); ++i) {
            ArchInfo arch = (ArchInfo)bills.get(i);
            if (ArchFlagEnum.ADDNEW.equals((Object)arch.getReArchFlag())) {
                addNewArchInfos.add(arch);
            }
            if (ArchFlagEnum.UPDATE.equals((Object)arch.getReArchFlag())) {
                updateArchInfos.add(arch);
            }
            if (!ArchFlagEnum.DELETE.equals((Object)arch.getReArchFlag())) continue;
            deleteArchInfos.add(arch);
        }
        if (deleteArchInfos.size() > 0) {
            this.saveJob(recordInfo, content, deleteArchInfos, taskFlag, ArchFlagEnum.DELETE);
        }
        if (addNewArchInfos.size() > 0) {
            this.saveJob(recordInfo, content, addNewArchInfos, taskFlag, ArchFlagEnum.ADDNEW);
        }
        if (updateArchInfos.size() > 0) {
            this.saveJob(recordInfo, content, updateArchInfos, taskFlag, ArchFlagEnum.UPDATE);
        }
    }

    private void saveJob(RecordInfo recordInfo, RecordBaseInfo content, List<XmlBase> bills, String taskFlag, ArchFlagEnum archFlagEnum) throws BOSException, EASBizException {
        int size = ThreadPoolInitFactory.getThreadPoolParam(recordInfo.getCtx(), "thread.upload.billsize", 100);
        int times = bills.size() / size;
        int forTime = 0;
        forTime = bills.size() % size == 0 ? times : times + 1;
        int i = 0;
        StringBuilder xmlNamePrefix = new StringBuilder(recordInfo.getArcRecordNum());
        if (content.isIsRefBill()) {
            xmlNamePrefix.append("_").append(content.getNumber());
        }
        xmlNamePrefix.append("_").append(archFlagEnum.getValue());
        CoreBaseCollection jobCollection = new CoreBaseCollection();
        while (i < forTime) {
            ArrayList<XmlBase> taskBills = new ArrayList<XmlBase>(bills.subList(size * i, Math.min(bills.size(), size * (i + 1))));
            JobInfo jobInfo = new JobInfo();
            jobInfo.setScheme(recordInfo.getArcRecordInfo().getArcSchemeId());
            jobInfo.setRecord(recordInfo.getArcRecordInfo().getId().toString());
            jobInfo.setContent(content);
            jobInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            jobInfo.setFileFlag(taskFlag);
            jobInfo.setXmlName(xmlNamePrefix + "_" + i + "_" + DateUtil.format(new Date(), "yyyyMMddHHmmss"));
            jobInfo.setFailNum(0);
            jobInfo.setState("wating");
            jobInfo.setTaskType(archFlagEnum.getValue());
            jobInfo.setTaskNo(i);
            this.setJobEntry(jobInfo, taskBills);
            jobCollection.add((CoreBaseInfo)jobInfo);
            ++i;
            if (jobCollection.size() != 100) continue;
            JobFactory.getLocalInstance(recordInfo.getCtx()).addnewBatchData(jobCollection);
            jobCollection.clear();
        }
        if (jobCollection.size() > 0) {
            JobFactory.getLocalInstance(recordInfo.getCtx()).addnewBatchData(jobCollection);
        }
    }

    private void setJobEntry(JobInfo jobInfo, List<XmlBase> taskBills) {
        JobEntryCollection jobEntryCollection = new JobEntryCollection();
        for (int i = 0; i < taskBills.size(); ++i) {
            JobEntryInfo jobEntryInfo = new JobEntryInfo();
            jobEntryInfo.setParent(jobInfo);
            jobEntryInfo.setRecordDetail(taskBills.get(i).getId());
            jobEntryCollection.add(jobEntryInfo);
        }
        jobInfo.put("entry", (Object)jobEntryCollection);
    }

    @Deprecated
    private void handleFailedData(RecordInfo recordInfo, ArcStateEnum stateEnum) throws EASBizException, BOSException {
        ArcRecordInfo arcRecordInfo = recordInfo.getArcRecordInfo();
        if (!ArcStateEnum.ARC_FAIL.equals((Object)stateEnum)) {
            return;
        }
        Context ctx = recordInfo.getCtx();
        boolean existsFailJob = JobFactory.getLocalInstance(ctx).exists("where record = '" + recordInfo.getArcRecordInfo().getId() + "' and state = '" + "fail" + "'");
        if (existsFailJob) {
            return;
        }
        try {
            AchRecordDetailCollection achRecordDetails = this.getAchRecordDetailCollection(ctx, arcRecordInfo.getId().toString());
            ArchInfos archInfos = recordInfo.getArchInfos();
            Map<String, RecordBaseInfo> contents = archInfos.getContents();
            this.getContents(ctx, recordInfo.getArchSchemeInfo().getArchemeContent(), arcRecordInfo.getContent(), arcRecordInfo.getOrg());
            for (int i = 0; i < achRecordDetails.size(); ++i) {
                AchRecordDetailInfo info = achRecordDetails.get(i);
                ArchInfo archInfo = new ArchInfo(ctx, info.getId().toString(), info.getBillId(), true, null, archInfos);
                archInfo.setDocType(archInfos.getContent().getXmlDocType());
                archInfo.setBillNumber(info.getBillNumber());
                if (info.getState().equals((Object)ArcStateEnum.ARC_FAIL)) {
                    archInfo.setReArchFlag(ArchFlagEnum.ADDNEW);
                } else if (info.getState().equals((Object)ArcStateEnum.REVERSE_ARC)) {
                    archInfo.setReArchFlag(ArchFlagEnum.UPDATE);
                }
                archInfo.setOldState(info.getState());
                if (null != archInfo.getReArchFlag()) {
                    archInfos.setMainBill(archInfo);
                }
                AttachBillAchDetailCollection attachBillAchDetails = info.getAttachBillAchDetails();
                for (int j = 0; j < attachBillAchDetails.size(); ++j) {
                    AttachBillAchDetailInfo aInfo = attachBillAchDetails.get(j);
                    ArchInfo refInfo = new ArchInfo(ctx, aInfo.getId().toString(), aInfo.getBillId(), false, null, archInfos);
                    archInfo.addRefBill(refInfo);
                    archInfo.setDataCenter(ctx.getAIS());
                    refInfo.setRecordBaseId(aInfo.getArcContent().getId().toString());
                    refInfo.setDocType(contents.get(aInfo.getArcContent().getId().toString()).getXmlDocType());
                    refInfo.setBillNumber(aInfo.getBillNumber());
                    refInfo.setMainBillID(archInfo.getBillId());
                    refInfo.setMainBillNumber(archInfo.getBillNumber());
                    if (aInfo.getState().equals((Object)ArcStateEnum.ARC_FAIL)) {
                        refInfo.setReArchFlag(ArchFlagEnum.ADDNEW);
                    } else if (aInfo.getState().equals((Object)ArcStateEnum.REVERSE_ARC)) {
                        refInfo.setReArchFlag(ArchFlagEnum.UPDATE);
                    }
                    refInfo.setOldState(aInfo.getState());
                    refInfo.addRefBill(archInfo);
                    if (null == recordInfo) continue;
                    archInfos.setRefBill(aInfo.getArcContent().getId().toString(), refInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u5904\u7406\u5931\u8d25\u6570\u636e\u5f02\u5e38"});
        }
    }

    private void handleDeletedData(RecordInfo recordInfo) throws RecException {
        try {
            Context ctx = recordInfo.getCtx();
            AchRecordDetailCollection arcRecordDetailcols = this.getAchRecordDetailCollection(ctx, recordInfo.getArcRecordInfo().getId().toString());
            IBillHandler billHandler = FilingUtils.getBillHandler(ctx, recordInfo.getArcRecordInfo().getContent());
            ArchInfos archInfos = recordInfo.getArchInfos();
            for (int i = 0; i < arcRecordDetailcols.size(); ++i) {
                AchRecordDetailInfo achRecordDetailInfo = arcRecordDetailcols.get(i);
                String oribillId = achRecordDetailInfo.getBillId();
                boolean existsBill = billHandler.existsBill(ctx, oribillId);
                if (existsBill) continue;
                ArchInfo info = new ArchInfo(ctx, achRecordDetailInfo.getId().toString(), oribillId, true, ArchFlagEnum.DELETE, archInfos);
                info.setDocType(recordInfo.getArcRecordInfo().getContent().getXmlDocType());
                archInfos.setMainBill(info);
                AttachBillAchDetailCollection attachBillCol = AttachBillAchDetailFactory.getLocalInstance(ctx).getAttachBillAchDetailCollection("select * ,arcContent.xmlDocType where originsBillId ='" + oribillId + "'");
                for (int j = 0; j < attachBillCol.size(); ++j) {
                    AttachBillAchDetailInfo attachBillAchDetailInfo = attachBillCol.get(j);
                    String attachBill = attachBillAchDetailInfo.getBillId();
                    ArchInfo refInfo = new ArchInfo(ctx, attachBillAchDetailInfo.getId().toString(), attachBill, false, ArchFlagEnum.DELETE, archInfos);
                    refInfo.addRefBill(info);
                    info.addRefBill(refInfo);
                    refInfo.setDocType(attachBillAchDetailInfo.getArcContent().getXmlDocType());
                    refInfo.setRecordBaseId(attachBillAchDetailInfo.getArcContent().getId().toString());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u5904\u7406\u5220\u9664\u6570\u636e\u5f02\u5e38"});
        }
    }

    @Override
    public void prepareData(Context ctx, RecordInfo recordInfo) throws Exception {
        ArcRecordInfo arcRecordInfo = this.getRecordInfo(ctx, recordInfo.getArcRecordInfo().getId().toString(), false);
        recordInfo.setArcRecordInfo(arcRecordInfo);
        ArcStateEnum state = recordInfo.getArcRecordInfo().getState();
        String archType = ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_TYPE);
        if (ArchConstant.ARCH_SYS_TYPE_INVO.equals(archType)) {
            this.updateTaskFlag(ctx, recordInfo.getArcRecordInfo(), state);
        }
        this.updateRecordState(ctx, recordInfo.getArcRecordInfo(), ArcStateEnum.WAITING);
        ArchSchemeInfo archSchemeInfo = this.getArchemeInfo(ctx, recordInfo.getArcRecordInfo().getArcSchemeId());
        recordInfo.setArchSchemeInfo(archSchemeInfo);
        Map<String, RecordBaseInfo> contents = this.getContents(recordInfo.getCtx(), archSchemeInfo.getArchemeContent(), recordInfo.getArcRecordInfo().getContent(), recordInfo.getOrg());
        ArchInfos archInfos = new ArchInfos(recordInfo.getCtx(), archSchemeInfo, recordInfo.getArcRecordInfo().getContent(), recordInfo.getOrg(), recordInfo.getPeriodInfo(), contents);
        recordInfo.setArchInfos(archInfos);
        if (!this.isCurrentPeriod(ctx, recordInfo.getArcRecordInfo(), recordInfo.getPeriodInfo())) {
            this.handleDeletedData(recordInfo);
        }
        this.handelAddnewUpdateData(recordInfo);
        this.classificationBill(recordInfo);
        SelectorItemCollection selectorItem = new SelectorItemCollection();
        selectorItem.add(new SelectorItemInfo("lastGetBillTime"));
        this.updateArchRecordInfo(ctx, recordInfo.getArcRecordInfo(), selectorItem);
        this.saveDataAndJob(recordInfo);
        ArcStateEnum operatinState = ArcStateEnum.WAITING;
        if (ArcStateEnum.WAITING.equals((Object)state) && recordInfo.chgNum() == 0 && recordInfo.getArcRecordInfo().getVoucherNum() == 0) {
            operatinState = ArcStateEnum.ARC_NODATA;
            this.updateRecordState(ctx, recordInfo.getArcRecordInfo(), ArcStateEnum.ARC_NODATA);
        }
        if (ArcStateEnum.ARC_NODATA.equals((Object)state) && recordInfo.chgNum() == 0) {
            operatinState = ArcStateEnum.ARC_NODATA;
            this.updateRecordState(ctx, recordInfo.getArcRecordInfo(), ArcStateEnum.ARC_NODATA);
        }
        if ((ArcStateEnum.ARC_SUCCESS.equals((Object)state) || ArcStateEnum.REVERSE_ARC.equals((Object)state)) && recordInfo.chgNum() == 0) {
            operatinState = ArcStateEnum.ARC_SUCCESS;
            this.updateRecordState(ctx, recordInfo.getArcRecordInfo(), ArcStateEnum.ARC_SUCCESS);
        }
        if (ArcStateEnum.ARC_LOADING.equals((Object)state) && recordInfo.chgNum() == 0) {
            operatinState = ArcStateEnum.ARC_LOADING;
            this.updateRecordState(ctx, recordInfo.getArcRecordInfo(), ArcStateEnum.ARC_LOADING);
        }
        if (ArcStateEnum.ARC_FAIL.equals((Object)state)) {
            boolean exists;
            if (recordInfo.chgNum() == 0 && !(exists = JobFactory.getLocalInstance(ctx).exists("where record = '" + recordInfo.getArcRecordInfo().getId() + "'"))) {
                if (recordInfo.getArcRecordInfo().getVoucherNum() == 0) {
                    operatinState = ArcStateEnum.ARC_NODATA;
                    this.updateRecordState(ctx, recordInfo.getArcRecordInfo(), ArcStateEnum.ARC_NODATA);
                } else {
                    this.processFinalStateTx(ctx, recordInfo.getArcRecordInfo().getId().toString());
                }
            }
            StringBuilder sqlBuilderJob = new StringBuilder("update t_rec_job set FailNum = ").append(0).append(", FState = ?, FileFlag = '").append(this.getTaskFlag()).append("' ");
            sqlBuilderJob.append("where FrecordID = '").append(recordInfo.getArcRecordInfo().getId().toString()).append("' and  FailNum >= ").append(3);
            DbUtil.execute((Context)ctx, (String)sqlBuilderJob.toString(), (Object[])new Object[]{"wating"});
            StringBuilder sqlBuilder = new StringBuilder("update t_rec_ArcRecord set FTotalNum = FTotalNum +FailNum +FAttachFailNum, FailNum = 0, FAttachFailNum =0 where FID = '" + recordInfo.getArcRecordInfo().getId() + "'");
            DbUtil.execute((Context)ctx, (String)sqlBuilder.toString());
        }
        ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeArcSchLog(recordInfo.getArcRecordInfo().getId().toString(), operatinState, recordInfo.getOperateDesc(), "");
    }

    private void updateTaskFlag(Context ctx, ArcRecordInfo arcRecordInfo, ArcStateEnum state) throws BOSException {
        if (System.currentTimeMillis() - arcRecordInfo.getLastUpdateTime().getTime() < 259200000L) {
            return;
        }
        if (!ArcStateEnum.ARC_LOADING.equals((Object)state) && !ArcStateEnum.ARC_FAIL.equals((Object)state)) {
            return;
        }
        StringBuilder sqlBuilder = new StringBuilder("update t_rec_job set FileFlag = '").append(IDUtils.getId()).append("' ");
        if (ArcStateEnum.ARC_LOADING.equals((Object)arcRecordInfo.getState())) {
            sqlBuilder.append(", Fstate = '").append("wating").append("' ");
        }
        sqlBuilder.append("where  FRecordID = '").append(arcRecordInfo.getId().toString()).append("' ");
        DbUtil.execute((Context)ctx, (String)sqlBuilder.toString());
    }

    private void handelAddnewUpdateData(RecordInfo recordInfo) throws Exception {
        ArcRecordInfo arcRecordInfo = recordInfo.getArcRecordInfo();
        PeriodInfo periodInfo = recordInfo.getPeriodInfo();
        PeriodInfo upStartTimePeriodInfo = this.getUpSTimePeriodInfo(arcRecordInfo, periodInfo);
        Map<String, IObjectValue> mainBillInfos = ArchUtils.getMainBills(recordInfo.getCtx(), arcRecordInfo.getContent(), upStartTimePeriodInfo, recordInfo.getOrg());
        ArchInfos archInfos = recordInfo.getArchInfos();
        List<XmlBase> mainArchInfos = archInfos.getMainBills();
        Map<String, RecordBaseInfo> contents = archInfos.getContents();
        if (mainBillInfos != null && mainBillInfos.size() > 0) {
            for (String billID : mainBillInfos.keySet()) {
                IObjectValue billInfo = mainBillInfos.get(billID);
                ArchInfo info = ArchUtils.getArchInfo(recordInfo.getCtx(), billID, billInfo, arcRecordInfo.getLastGetBillTime(), archInfos);
                info.setDocType(arcRecordInfo.getContent().getXmlDocType());
                info.setBillNumber(billInfo.getString("number"));
                mainArchInfos.add(info);
            }
            if (contents.size() != 0) {
                ArchUtils.mutilSetRefArchInfos(recordInfo.getCtx(), arcRecordInfo, mainArchInfos, contents, OperationEnum.FIRST_ARC);
            }
        }
        arcRecordInfo.setLastGetBillTime(new Timestamp(new Date().getTime()));
        recordInfo.setArchInfos(archInfos);
    }

    private void classificationBill(RecordInfo recordInfo) {
        ArchInfos archInfos = recordInfo.getArchInfos();
        List<XmlBase> mainArchInfos = archInfos.getMainBills();
        for (int i = mainArchInfos.size() - 1; i >= 0; --i) {
            ArchInfo mainArchInfo = (ArchInfo)mainArchInfos.get(i);
            for (ArchInfo refInfo : mainArchInfo.getRefInfo()) {
                archInfos.setRefBill(refInfo.getRecordBaseId(), refInfo);
                if (refInfo.getArchInfos() != null) continue;
                refInfo.setArchInfos(archInfos);
            }
            recordInfo.setNum(mainArchInfo.getReArchFlag(), mainArchInfo.getRefInfo().size());
        }
    }

    @Override
    protected ArchFormatInfo getArchFormatInfo(Context ctx, ArcRecordInfo recordInfo, PeriodInfo periodInfo, RecordBaseInfo recordBaseInfo, JobInfo jobInfo) throws RecException {
        ArchFormatInfo archFormatInfo = super.getArchFormatInfo(ctx, recordInfo, periodInfo, recordBaseInfo, jobInfo);
        RecordBaseInfo content = FilingUtils.getContent(ctx, archFormatInfo.getJobInfo().getContent(), archFormatInfo.getRecordInfo().getOrg());
        archFormatInfo.setContent(content);
        try {
            IBillHandler billHandler = FilingUtils.getBillHandler(ctx, recordInfo.getContent());
            Map<String, byte[]> receiptPdfs = billHandler.getReceiptPdfs(ctx, archFormatInfo.getContent(), archFormatInfo.getXmlBases());
            archFormatInfo.setBillHandler(billHandler);
            archFormatInfo.setReceiptPdfs(receiptPdfs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return archFormatInfo;
    }

    @Override
    protected void processXmlBase(Context ctx, ArchFormatInfo archFormatInfo, XmlBase xmlBase, int index) throws Exception {
        if (ArchFlagEnum.DELETE.equals((Object)((ArchInfo)xmlBase).getReArchFlag())) {
            return;
        }
        this.setXmlBaseProperties(ctx, archFormatInfo, xmlBase, index);
        this.uploadPdf(ctx, archFormatInfo, xmlBase);
        this.uploadAttach(ctx, archFormatInfo, xmlBase);
    }

    private void setXmlBaseProperties(Context ctx, ArchFormatInfo archFormatInfo, XmlBase xmlBase, int index) throws Exception {
        archFormatInfo.getBillHandler().setXmlBaseProperties(ctx, xmlBase, archFormatInfo.getContent(), index);
    }

    private void uploadPdf(Context ctx, ArchFormatInfo archFormatInfo, XmlBase xmlBase) throws Exception {
        ArchInfo info = (ArchInfo)xmlBase;
        Set<FileInfo> fileInfos = info.getFileInfos();
        if (null != fileInfos) {
            for (FileInfo fileInfo : fileInfos) {
                if (!StringUtils.isEmpty((String)fileInfo.getId())) continue;
                long t1 = System.currentTimeMillis();
                byte[] bytes = archFormatInfo.getReceiptPdfs().get(info.getBillId());
                InputStream billPdfIs = null != bytes ? new ByteArrayInputStream(bytes) : archFormatInfo.getBillHandler().getBillPdfIs(ctx, archFormatInfo.getContent(), info, fileInfo);
                long t2 = System.currentTimeMillis();
                this.fileUpLoad(ctx, archFormatInfo, billPdfIs, fileInfo.getName());
                long t3 = System.currentTimeMillis();
                archFormatInfo.setPreparePdfTime(t2 - t1);
                archFormatInfo.setUploadPdfTime(t3 - t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadAttach(Context ctx, ArchFormatInfo archFormatInfo, XmlBase xmlBase) throws Exception {
        ArchInfo info = (ArchInfo)xmlBase;
        Set<FileInfo> fileInfos = info.getFileInfos();
        boolean failJobFlag = false;
        for (FileInfo fileInfo : fileInfos) {
            if (StringUtils.isEmpty((String)fileInfo.getId())) continue;
            InputStream billAttachmentIs = null;
            try {
                long t1 = System.currentTimeMillis();
                billAttachmentIs = archFormatInfo.getBillHandler().getBillAttachmentIs(ctx, info, fileInfo);
                long t2 = System.currentTimeMillis();
                archFormatInfo.setPrepareAttaTime(t2 - t1);
            }
            catch (Exception e) {
                fileInfo.setException("\u9644\u4ef6[" + fileInfo.getSrcname() + "]\u5b58\u5728\u5f02\u5e38");
                ArchRecordUtils.writeLog(ctx, info, archFormatInfo.getRecordId(), (Exception)((Object)new RecException(RecException.UNKNOWN, e, new Object[]{"\u9644\u4ef6[" + fileInfo.getSrcname() + "]\u5b58\u5728\u5f02\u5e38:" + e.getMessage()})));
                failJobFlag = true;
            }
            try {
                if (null == billAttachmentIs) continue;
                long t2 = System.currentTimeMillis();
                this.fileUpLoad(ctx, archFormatInfo, billAttachmentIs, fileInfo.getName());
                long t3 = System.currentTimeMillis();
                archFormatInfo.setUploadAttaTime(t3 - t2);
            }
            finally {
                FilingUtils.safeClose(billAttachmentIs);
            }
        }
        if (failJobFlag) {
            this.createFailJob(ctx, xmlBase, archFormatInfo.getJobInfo());
            archFormatInfo.addAttachFailXmlBase(xmlBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doUploadXml(Context ctx, ArchFormatInfo archFormatInfo) throws Exception {
        String arch_type = ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_TYPE);
        int size = archFormatInfo.getXmlBases().size();
        int afterSize = 0;
        List<XmlBase> xmlBases = archFormatInfo.getXmlBases();
        try {
            boolean existsWJob;
            JobInfo jobInfo = archFormatInfo.getJobInfo();
            if (archFormatInfo.isHasFail()) {
                this.createFailJob(ctx, xmlBases, jobInfo);
            }
            if (xmlBases.size() > 0) {
                if (EvsServiceFactory.getInstance(xmlBases.get(0).getDocType()) != null) {
                    EvsServiceFactory.getInstance(xmlBases.get(0).getDocType()).uploadXbrlDependEvs(ctx, archFormatInfo, xmlBases);
                }
                ArcRecordInfo recordInfo = archFormatInfo.getRecordInfo();
                if (jobInfo.getTaskType().equals("DELETE") && ArchConstant.ARCH_SYS_TYPE_XH.equals(arch_type)) {
                    HashMap<String, String> otherParams = new HashMap<String, String>();
                    StringBuilder sb = new StringBuilder();
                    for (XmlBase xmlBase : xmlBases) {
                        sb.append(xmlBase.getDataId()).append(",");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    otherParams.put("billids", sb.toString());
                    ArrayList<ArcRecordInfo> recordInfos = new ArrayList<ArcRecordInfo>();
                    recordInfos.add(recordInfo);
                    NoticeArchSysHelperFactory.getInstance(ctx, arch_type).reverseArch(ctx, recordInfos, otherParams);
                } else {
                    InputStream inputStream = this.generateXml(ctx, archFormatInfo.getContent(), xmlBases);
                    String xmlSuffix = (jobInfo.getFailNum() > 0 ? "_" + jobInfo.getFailNum() : "") + ".xml";
                    this.fileUpLoad(ctx, archFormatInfo, inputStream, jobInfo.getXmlName() + xmlSuffix);
                    archFormatInfo.setXmlName(jobInfo.getXmlName() + xmlSuffix);
                }
                jobInfo.setState("uploaded");
                JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"state"});
                this.noticeSysArchBatch(ctx, archFormatInfo);
                afterSize = xmlBases.size();
                if (ArchConstant.ARCH_SYS_TYPE_GXHC.equals(arch_type)) {
                    jobInfo.setState("noticed");
                    JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"state"});
                }
            }
            boolean bl = !(existsWJob = JobFactory.getLocalInstance(ctx).exists("where record = '" + archFormatInfo.getRecordInfo().getId() + "' and fileFlag = '" + jobInfo.getFileFlag() + "' and (state = '" + "wating" + "' or state = '" + "running" + "')"));
            return bl;
        }
        finally {
            if (!ArchConstant.ARCH_SYS_TYPE_GXHC.equals(arch_type)) {
                FilingUtils.updateProgress(ctx, archFormatInfo.getRecordInfo().getId().toString(), size);
            }
            if (size - afterSize > 0) {
                FilingUtils.updateFailNum(ctx, archFormatInfo.getRecordInfo().getContent(), archFormatInfo.getRecordInfo().getId().toString(), size - afterSize);
            }
        }
    }

    private void createFailJob(Context ctx, List<XmlBase> xmlBases, JobInfo jobInfo) throws BOSException, EASBizException {
        JobInfo failJobInfo = (JobInfo)jobInfo.clone();
        CoreBaseCollection failJobEntryCollection = new CoreBaseCollection();
        for (int i = xmlBases.size() - 1; i >= 0; --i) {
            if (null == xmlBases.get(i).getException()) continue;
            JobEntryInfo failJobEntryInfo = this.getFailJobEntryInfo(xmlBases.get(i).getId(), jobInfo.getEntry());
            failJobEntryInfo.setParent(failJobInfo);
            failJobEntryCollection.add((CoreBaseInfo)failJobEntryInfo);
            xmlBases.remove(i);
        }
        if (xmlBases.isEmpty()) {
            jobInfo.setState("fail");
            jobInfo.setFailNum(jobInfo.getFailNum() + 1);
            JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"state", "failNum"});
            return;
        }
        failJobInfo.put("entry", null);
        failJobInfo.setId(BOSUuid.create((String)"3439BEB0"));
        failJobInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        failJobInfo.setFailNum(failJobInfo.getFailNum() + 1);
        failJobInfo.setState("fail");
        String oldXmlName = failJobInfo.getXmlName();
        int i = oldXmlName.lastIndexOf("_");
        failJobInfo.setXmlName(oldXmlName.replace(oldXmlName.substring(i + 1), DateUtil.format(new Date(), "yyyyMMddHHmmss")));
        JobFactory.getLocalInstance(ctx).addnew(failJobInfo);
        JobEntryFactory.getLocalInstance(ctx).save(failJobEntryCollection);
        JobFactory.getLocalInstance(ctx).save(jobInfo);
    }

    private void createFailJob(Context ctx, XmlBase xmlBase, JobInfo jobInfo) throws BOSException, EASBizException {
        JobInfo failJobInfo = (JobInfo)jobInfo.clone();
        CoreBaseCollection failJobEntryCollection = new CoreBaseCollection();
        JobEntryInfo failJobEntryInfo = new JobEntryInfo();
        failJobEntryInfo.setId(BOSUuid.create((String)"F08207A2"));
        failJobEntryInfo.setRecordDetail(xmlBase.getId());
        failJobEntryInfo.setParent(failJobInfo);
        failJobEntryCollection.add((CoreBaseInfo)failJobEntryInfo);
        failJobInfo.put("entry", failJobEntryCollection);
        failJobInfo.setId(BOSUuid.create((String)"3439BEB0"));
        failJobInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        failJobInfo.setFailNum(failJobInfo.getFailNum() + 1);
        failJobInfo.setState("fail");
        String oldXmlName = failJobInfo.getXmlName();
        int i = oldXmlName.lastIndexOf("_");
        failJobInfo.setXmlName(oldXmlName.replace(oldXmlName.substring(i + 1), DateUtil.format(new Date(), "yyyyMMddHHmmss")));
        JobFactory.getLocalInstance(ctx).addnew(failJobInfo);
    }

    private JobEntryInfo getFailJobEntryInfo(String recordDetailId, JobEntryCollection entry) {
        for (int i = entry.size() - 1; i >= 0; --i) {
            JobEntryInfo jobEntryInfo = entry.get(i);
            if (!jobEntryInfo.getRecordDetail().equals(recordDetailId)) continue;
            entry.remove(jobEntryInfo);
            return jobEntryInfo;
        }
        return null;
    }

    @Deprecated
    private boolean jobUloaded(Context ctx, ArcRecordInfo recordInfo, JobInfo jobInfo) throws Exception {
        try {
            boolean existsUJob;
            boolean existsWJob = JobFactory.getLocalInstance(ctx).exists("where record = '" + recordInfo.getId() + "' and fileFlag = '" + jobInfo.getFileFlag() + "' and (state = '" + "wating" + "' or state = '" + "running" + "')");
            if (!existsWJob && (existsUJob = JobFactory.getLocalInstance(ctx).exists("where record = '" + recordInfo.getId() + "' and fileFlag = '" + jobInfo.getFileFlag() + "' and state = '" + "uploaded" + "'"))) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{e.getMessage()});
        }
        return false;
    }

    private boolean jobUloaded(Context ctx, ArcRecordInfo recordInfo) throws Exception {
        try {
            boolean existsUJob;
            boolean existsWJob = JobFactory.getLocalInstance(ctx).exists("where record = '" + recordInfo.getId() + "' and (state = '" + "wating" + "' or state = '" + "running" + "')");
            if (!existsWJob && (existsUJob = JobFactory.getLocalInstance(ctx).exists("where record = '" + recordInfo.getId() + "' and state = '" + "uploaded" + "'"))) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{e.getMessage()});
        }
        return false;
    }

    @Override
    protected List<XmlBase> getXmlBaseList(Context ctx, ArcRecordInfo recordInfo, JobInfo jobInfo) throws Exception {
        JobEntryCollection entry = jobInfo.getEntry();
        HashSet<String> idSet = new HashSet<String>();
        ArrayList<XmlBase> xmlBaseList = new ArrayList<XmlBase>();
        for (int i = 0; i < entry.size(); ++i) {
            idSet.add(entry.get(i).getRecordDetail());
        }
        if (idSet.isEmpty()) {
            return xmlBaseList;
        }
        ArchInfos archInfos = new ArchInfos(ctx);
        archInfos.setOrg(recordInfo.getOrg());
        AttachBillAchDetailCollection attachBillAchDetailCollection = null;
        boolean isRefBill = jobInfo.getContent().isIsRefBill();
        try {
            if (isRefBill) {
                attachBillAchDetailCollection = this.getAttachBillAchDetailCollection(ctx, recordInfo, jobInfo, idSet, archInfos, xmlBaseList);
            } else {
                this.setAchRecordDetail(ctx, jobInfo, idSet, archInfos, xmlBaseList);
            }
        }
        catch (Exception e) {
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"getXmlBaseList \u5f02\u5e38"});
        }
        RecordBaseInfo content = jobInfo.getContent();
        ((BillParsingEngineUtil)ParsingEngineUtil.getInstance(ctx, recordInfo.getContent())).fillXmlBaseData(BOSObjectType.create((String)content.getBillType().getBosType()), xmlBaseList, content, this.getPeriodInfo(ctx, recordInfo));
        this.updateBillNumber(ctx, jobInfo, xmlBaseList, attachBillAchDetailCollection);
        return xmlBaseList;
    }

    private void setAchRecordDetail(Context ctx, JobInfo jobInfo, Set<String> idSet, ArchInfos archInfos, List<XmlBase> xmlBaseList) throws BOSException {
        FilterItemCollection filterItem = new FilterItemCollection();
        filterItem.add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection selectorItem = new SelectorItemCollection();
        selectorItem.add("state");
        selectorItem.add("billNumber");
        selectorItem.add("billId");
        selectorItem.add("attachBillAchDetails.id");
        selectorItem.add("attachBillAchDetails.state");
        selectorItem.add("attachBillAchDetails.billNumber");
        selectorItem.add("attachBillAchDetails.billId");
        selectorItem.add("attachBillAchDetails.arcContent.*");
        AchRecordDetailCollection achRecordDetailCollection = ArchUtils.getAchRecordDetailCollectionLimit(ctx, selectorItem, filterItem, "where a.fid in " + FormatUtils.list2Sql(idSet) + " ");
        for (int i = 0; i < achRecordDetailCollection.size(); ++i) {
            AchRecordDetailInfo aDInfo = achRecordDetailCollection.get(i);
            ArchInfo archInfo = new ArchInfo(ctx, aDInfo.getId().toString(), aDInfo.getBillId(), true, ArchFlagEnum.getEnum(jobInfo.getTaskType()), archInfos);
            archInfo.setDocType(jobInfo.getContent().getXmlDocType());
            archInfo.setBillNumber(aDInfo.getBillNumber());
            archInfo.setRecordBaseId(jobInfo.getContent().getId().toString());
            for (int j = 0; j < aDInfo.getAttachBillAchDetails().size(); ++j) {
                AttachBillAchDetailInfo atDInfo = aDInfo.getAttachBillAchDetails().get(j);
                ArchInfo info = new ArchInfo(ctx, atDInfo.getId().toString(), atDInfo.getBillId(), false, ArchFlagEnum.getEnum(jobInfo.getTaskType()), archInfos);
                info.setRecordBaseId(atDInfo.getArcContent().getId().toString());
                info.setDocType(atDInfo.getArcContent().getXmlDocType());
                info.setCompany(archInfos.getOrg());
                archInfo.addRefBill(info);
            }
            xmlBaseList.add(archInfo);
        }
    }

    private AttachBillAchDetailCollection getAttachBillAchDetailCollection(Context ctx, ArcRecordInfo recordInfo, JobInfo jobInfo, Set<String> idSet, ArchInfos archInfos, List<XmlBase> xmlBaseList) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        entityViewInfo.setSelector(selectorItemCollection);
        selectorItemCollection.add("id");
        selectorItemCollection.add("state");
        selectorItemCollection.add("billNumber");
        selectorItemCollection.add("billId");
        selectorItemCollection.add("achRecordDetail.id");
        selectorItemCollection.add("achRecordDetail.state");
        selectorItemCollection.add("achRecordDetail.billNumber");
        selectorItemCollection.add("achRecordDetail.billId");
        AttachBillAchDetailCollection attachBillAchDetailCollection = AttachBillAchDetailFactory.getLocalInstance(ctx).getAttachBillAchDetailCollection(entityViewInfo);
        for (int i = 0; i < attachBillAchDetailCollection.size(); ++i) {
            AttachBillAchDetailInfo atDInfo = attachBillAchDetailCollection.get(i);
            ArchInfo archInfo = new ArchInfo(ctx, atDInfo.getId().toString(), atDInfo.getBillId(), false, ArchFlagEnum.getEnum(jobInfo.getTaskType()), archInfos);
            archInfo.setDocType(jobInfo.getContent().getXmlDocType());
            AchRecordDetailInfo aDInfo = atDInfo.getAchRecordDetail();
            archInfo.setMainBillNumber(aDInfo.getBillNumber());
            ArchInfo info = new ArchInfo(ctx, aDInfo.getId().toString(), aDInfo.getBillId(), true, ArchFlagEnum.getEnum(jobInfo.getTaskType()), archInfos);
            info.setDocType(recordInfo.getContent().getXmlDocType());
            info.setCompany(recordInfo.getOrg());
            archInfo.addRefBill(info);
            archInfo.setMainBillNumber(aDInfo.getBillNumber());
            archInfo.setMainBillID(aDInfo.getBillId());
            archInfo.setRecordBaseId(jobInfo.getContent().getId().toString());
            xmlBaseList.add(archInfo);
        }
        return attachBillAchDetailCollection;
    }

    private void updateBillNumber(Context ctx, JobInfo jobInfo, List<XmlBase> xmlBaseList, AttachBillAchDetailCollection attachBillAchDetailCollection) throws BOSException, EASBizException {
        if (null != attachBillAchDetailCollection && "ADDNEW".equals(jobInfo.getTaskType())) {
            ArrayList<Object[]> param = new ArrayList<Object[]>();
            for (int i = 0; i < attachBillAchDetailCollection.size(); ++i) {
                AttachBillAchDetailInfo attachBillAchDetailInfo = attachBillAchDetailCollection.get(i);
                IXmlSrcObj data = this.getBillNumber(attachBillAchDetailInfo.getId().toString(), xmlBaseList);
                if (null != data) {
                    attachBillAchDetailInfo.setBillNumber((String)data.get("number"));
                    param.add(new Object[]{attachBillAchDetailInfo.getBillNumber(), attachBillAchDetailInfo.getId().toString()});
                    continue;
                }
                attachBillAchDetailInfo.setBillNumber("no_bill");
                attachBillAchDetailInfo.setState(ArcStateEnum.ARC_SUCCESS);
                SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add("billNumber");
                selectorItemCollection.add("state");
                AttachBillAchDetailFactory.getLocalInstance(ctx).updatePartial(attachBillAchDetailInfo, selectorItemCollection);
            }
            if (!param.isEmpty()) {
                String sql = "update T_REC_AttachBillAchDetail set FBillNumber = ? where fid = ?";
                DbUtil.executeBatch((Context)ctx, (String)sql, param);
            }
            if (xmlBaseList.isEmpty()) {
                String arch_type = ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_TYPE);
                TaskStateEnum stateEnum = TaskStateEnum.UPLOADED;
                if (ArchConstant.ARCH_SYS_TYPE_GXHC.equals(arch_type)) {
                    stateEnum = TaskStateEnum.NOTICED;
                }
                jobInfo.setState(stateEnum.getValue());
                JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"state"});
            }
        }
    }

    private IXmlSrcObj getBillNumber(String id, List<XmlBase> xmlBaseList) {
        for (int i = 0; i < xmlBaseList.size(); ++i) {
            if (!id.equals(xmlBaseList.get(i).getId())) continue;
            if (null == xmlBaseList.get(i).getData()) {
                xmlBaseList.remove(i--);
                return null;
            }
            return xmlBaseList.get(i).getData();
        }
        return null;
    }

    @Override
    protected void handleArchXmlbaseException(Context ctx, ArchFormatInfo archFormatInfo, XmlBase xmlBase, Throwable e) {
        archFormatInfo.setHasFail(true);
        xmlBase.setException(e);
        ArchRecordUtils.writeLog(ctx, (ArchInfo)xmlBase, archFormatInfo.getRecordId(), (Exception)((Object)new RecException(RecException.UNKNOWN, e, new Object[]{e.getMessage()})));
    }

    @Override
    public void processArcSysNotice(Context ctx, String recorId, String jobId, List<Object> fileList) throws Exception {
        int beforeSize = fileList.size();
        JobInfo jobInfo = JobFactory.getLocalInstance(ctx).getJobInfo("select * ,entry.*, content.isRefBill where id = '" + jobId + "'");
        this.noticedJob2Fail(ctx, fileList, jobInfo);
        if (fileList.size() > 0) {
            jobInfo.setState("completed");
            JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"state"});
        } else {
            jobInfo.setState("fail");
            jobInfo.setFailNum(jobInfo.getFailNum() + 1);
            JobFactory.getLocalInstance(ctx).updatePartial(jobInfo, new String[]{"state", "failNum"});
        }
        FilingUtils.updateProgress(ctx, jobInfo.getRecord(), beforeSize);
        if (beforeSize - fileList.size() > 0) {
            FilingUtils.updateFailNum(ctx, jobInfo.getContent(), jobInfo.getRecord(), beforeSize - fileList.size());
        }
        this.processFinalStateTx(ctx, recorId);
    }

    private void noticedJob2Fail(Context ctx, List<Object> fileList, JobInfo jobInfo) throws BOSException, EASBizException {
        JobInfo failJobInfo = (JobInfo)jobInfo.clone();
        CoreBaseCollection failJobEntryCollection = new CoreBaseCollection();
        for (int i = 0; i < fileList.size(); ++i) {
            if (!"0".equals(((Map)fileList.get(i)).get("return"))) continue;
            String id = (String)((Map)fileList.get(i)).get("id");
            JobEntryInfo failJobEntryInfo = this.getFailJobEntryInfo(id, jobInfo.getEntry());
            failJobEntryInfo.setParent(failJobInfo);
            failJobEntryCollection.add((CoreBaseInfo)failJobEntryInfo);
            ArchInfo archInfo = new ArchInfo(id, "", !jobInfo.getContent().isIsRefBill(), null, null);
            ArchRecordUtils.writeLog(ctx, archInfo, jobInfo.getRecord(), (Exception)((Object)new RecException(RecException.UNKNOWN, new Object[]{"\u6863\u6848\u7cfb\u7edf\u8fd4\u56de\uff1a" + ((Map)fileList.get(i)).get("desc")})));
            fileList.remove(i--);
        }
        if (!failJobEntryCollection.isEmpty() && !fileList.isEmpty()) {
            failJobInfo.setId(BOSUuid.create((BOSObjectType)new JobInfo().getBOSType()));
            failJobInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            failJobInfo.setFailNum(failJobInfo.getFailNum() + 1);
            failJobInfo.setState("fail");
            failJobInfo.put("entry", null);
            JobFactory.getLocalInstance(ctx).addnew(failJobInfo);
            JobEntryFactory.getLocalInstance(ctx).save(failJobEntryCollection);
            JobFactory.getLocalInstance(ctx).save(jobInfo);
        }
    }

    @Override
    protected void setBatchData(Context ctx, List<XmlBase> xmlBaseList, ArcRecordInfo arcRecordInfo, JobInfo jobInfo) {
        String dataProviderName = jobInfo.getContent().getBillType().getDataProvider();
        if (StringUtils.isEmpty((String)dataProviderName)) {
            return;
        }
        try {
            Object o = clz.get(dataProviderName);
            if (o == null) {
                Class<?> clazz = Class.forName(dataProviderName);
                if (!IBatchDataProvider.class.isAssignableFrom(clazz)) {
                    clz.putIfAbsent(dataProviderName, "noSupport");
                    return;
                }
                Constructor<?>[] constructors = clazz.getDeclaredConstructors();
                if (constructors != null && constructors.length > 0) {
                    Arrays.sort(constructors, new Comparator<Constructor>(){

                        @Override
                        public int compare(Constructor o1, Constructor o2) {
                            return o2.getParameterTypes().length - o1.getParameterTypes().length;
                        }
                    });
                    Constructor<?> constructor = null;
                    for (int i = 0; i < constructors.length; ++i) {
                        if (constructors[i].getParameterTypes().length == 0) {
                            constructor = constructors[i];
                            break;
                        }
                        if (constructors[i].getParameterTypes().length != 1 || !constructors[i].getParameterTypes()[0].getName().equals("java.lang.String")) continue;
                        constructor = constructors[i];
                        break;
                    }
                    if (constructor == null) {
                        clz.putIfAbsent(dataProviderName, "noSupport");
                        return;
                    }
                    int length = constructor.getParameterTypes().length;
                    constructor.setAccessible(true);
                    Object o1 = null;
                    if (length == 0) {
                        o1 = constructor.newInstance(new Object[0]);
                    } else {
                        Object[] param = new Object[length];
                        for (int i = 0; i < length; ++i) {
                            param[i] = "";
                        }
                        o1 = constructor.newInstance(param);
                    }
                    clz.putIfAbsent(dataProviderName, o1);
                } else {
                    logger.error((Object)(dataProviderName + "\uff1a\u6784\u9020\u5b9e\u4f8b\u5931\u8d25\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u6784\u9020\u51fd\u6570\uff0c\u4e00\u822c\u4e0d\u4f1a\u8d70\u5230\u8fd9"));
                }
            }
            if ((o = clz.get(dataProviderName)) != null && o instanceof IBatchDataProvider) {
                IBatchDataProvider dataProvider = (IBatchDataProvider)o;
                ArrayList<String> billIds = new ArrayList<String>(xmlBaseList.size());
                for (int i = 0; i < xmlBaseList.size(); ++i) {
                    billIds.add(((ArchInfo)xmlBaseList.get(i)).getBillId());
                }
                Map batchData = dataProvider.getBatchData(ctx, billIds, arcRecordInfo.getOrg().getId().toString(), "", null);
                logger.error((Object)("jobId:" + jobInfo.getId().toString() + "\uff0cbatchData.size:" + (batchData == null ? "null" : Integer.valueOf(batchData.size()))));
                AbstractBatchDataProvider.batchData.put((Object)jobInfo.getId().toString(), batchData);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private class RecordBase {
        private CompanyOrgUnitInfo companyOrgUnitInfo;
        private RecordBaseInfo recordBaseInfo;

        public RecordBase(CompanyOrgUnitInfo companyOrgUnitInfo, RecordBaseInfo recordBaseInfo) {
            this.companyOrgUnitInfo = companyOrgUnitInfo;
            this.recordBaseInfo = recordBaseInfo;
        }

        public CompanyOrgUnitInfo getCompanyOrgUnitInfo() {
            return this.companyOrgUnitInfo;
        }

        public RecordBaseInfo getRecordBaseInfo() {
            return this.recordBaseInfo;
        }
    }

    private class CheckPrintThread
    implements Callable<Exception> {
        private Context ctx;
        private RecordBase recordBase;
        ExecutorService execute;

        public CheckPrintThread(Context ctx, RecordBase recordBase, ExecutorService execute) {
            this.ctx = ctx;
            this.recordBase = recordBase;
            this.execute = execute;
        }

        @Override
        public Exception call() {
            RecException exception = null;
            try {
                Context newCtx = (Context)FilingBill.this.deeplyCopy((Serializable)this.ctx);
                WebContextUtil.initRpcConfig((Context)newCtx);
                RecordBaseUtils.checkPrint(newCtx, this.recordBase.getRecordBaseInfo());
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                if (!this.execute.isShutdown()) {
                    // empty if block
                }
                exception = new RecException(RecException.UNKNOWN, e, new Object[]{"\u7ec4\u7ec7[" + this.recordBase.getCompanyOrgUnitInfo().getName() + "]\u4e0b\u914d\u7f6e\u7684\u5f52\u6863\u5185\u5bb9[" + this.recordBase.getRecordBaseInfo().getNumber() + "]\u5957\u6253\u6709\u8bef"});
            }
            return exception;
        }
    }
}

