/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.license;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.Coder;
import com.kingdee.eas.base.license.file.LicenseCodeManagerFactory;
import com.kingdee.eas.base.license.file.MD5Helper;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.license.BJDES;
import com.kingdee.eas.el.rec.license.LoadLicenseFile;
import com.kingdee.eas.el.rec.license.RSA;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import sun.misc.BASE64Encoder;

public class RecLicenseUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean checkLicense(Context ctx) {
        try {
            Date serverData = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getLicenseBaseInfo().getServiceDate();
            String productNo = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getProductNo();
            String user = RecLicenseUtil.getUser(ctx);
            StringBuffer buffer = new StringBuffer();
            buffer.append(" select fkey,fvalue from t_rec_license where fkey = 'license' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
            String encryptMd5 = "";
            if (rs.next()) {
                encryptMd5 = rs.getString("fvalue");
                if (RecLicenseUtil.buyOut(encryptMd5)) {
                    return true;
                }
            } else {
                Class<RecLicenseUtil> clazz = RecLicenseUtil.class;
                // MONITORENTER : com.kingdee.eas.el.rec.license.RecLicenseUtil.class
                rs = DbUtil.executeQuery((Context)ctx, (String)" select fkey,fvalue from t_rec_license where fkey in ('serverData','productNo','user') ");
                if (rs == null || rs.size() == 0) {
                    String insertSql = " insert into t_rec_license(fkey,fvalue)values(?,?)";
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                    paramsList.add(new Object[]{"serverData", serverData.getTime() + ""});
                    paramsList.add(new Object[]{"productNo", productNo});
                    paramsList.add(new Object[]{"user", user});
                    DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
                }
                // MONITOREXIT : clazz
            }
            StringBuffer sb = new StringBuffer();
            sb.append(serverData.getTime() + productNo + user);
            String checkMd5 = MD5Helper.getStringMD5((String)sb.toString());
            String encrypt = Coder.hexStr2Str((String)encryptMd5);
            byte[] base64 = Coder.decryptBASE64((String)encrypt);
            byte[] srcMd5 = RSA.getInstance().decrypt(base64);
            if (RecLicenseUtil.compareBytes(checkMd5.getBytes(), srcMd5)) {
                return true;
            }
        }
        catch (Throwable e) {
            try {
                String encryptMd5;
                StringBuffer buffer = new StringBuffer();
                buffer.append(" select fkey,fvalue from t_rec_license where fkey = 'license' ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
                if (rs.next() && RecLicenseUtil.buyOut(encryptMd5 = rs.getString("fvalue"))) {
                    return true;
                }
            }
            catch (Throwable buffer) {
                // empty catch block
            }
        }
        try {
            String user = RecLicenseUtil.getUser(ctx);
            Properties prop = LoadLicenseFile.loadProperties(ctx);
            String licenseValue = (String)prop.get("licenseKey");
            String licensePwd = (String)prop.get("privatePwd");
            if (StringUtils.isEmpty((String)licenseValue) || StringUtils.isEmpty((String)licensePwd)) {
                throw new RecException(RecException.UNKNOWN, new Object[]{"\u65e0license!\u8bf7\u5411\u628a\u82b1\u62ec\u53f7\u4e2d\u7684\u5185\u5bb9\u63d0\u4f9b\u7ed9\u7ba1\u7406\u5458\u7533\u8bf7license! {" + new BASE64Encoder().encode(("user:" + user).getBytes()) + "}"});
            }
            String license = BJDES.jdkDes(licenseValue, licensePwd);
            String[] str = license.split("\\^_\\^");
            if (RecLicenseUtil.getDBTime(ctx).getTime() > Long.parseLong(str[0]) || System.currentTimeMillis() > Long.parseLong(str[0])) throw new RecException(RecException.UNKNOWN, new Object[]{"\u7535\u5b50\u6863\u6848license\u5df2\u8fc7\u671f!\u8bf7\u5411\u628a\u82b1\u62ec\u53f7\u4e2d\u7684\u5185\u5bb9\u63d0\u4f9b\u7ed9\u7ba1\u7406\u5458\u66f4\u6362license! {" + new BASE64Encoder().encode(("user:" + user + " license.user:" + str[2]).getBytes()) + "}"});
            if (str[2].equals(user)) return true;
            if (user.indexOf(str[2]) >= 0) return true;
            throw new RecException(RecException.UNKNOWN, new Object[]{"license\u4e0d\u5408\u6cd5!\u8bf7\u5411\u628a\u82b1\u62ec\u53f7\u4e2d\u7684\u5185\u5bb9\u63d0\u4f9b\u7ed9\u7ba1\u7406\u5458\u66f4\u6362license! {" + new BASE64Encoder().encode(("user:" + user + " license.user:" + str[2]).getBytes()) + "}"});
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static String getUser(Context ctx) throws LicenseException {
        List ipList;
        String user = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getLicenseBaseInfo().getUser();
        int userSize = user.length() / 16;
        if (userSize == (ipList = LicenseCodeManagerFactory.getInstance().getIpList()).size()) {
            return user;
        }
        String newUser = "";
        for (int i = 0; i < ipList.size(); ++i) {
            String softCode = LicenseCodeManagerFactory.getInstance().getSoftCode((String)ipList.get(i));
            newUser = newUser + softCode;
        }
        return newUser;
    }

    private static Timestamp getDBTime(Context ctx) {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)" SELECT now() ");
            if (rs.next()) {
                return rs.getTimestamp(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Timestamp(System.currentTimeMillis());
    }

    private static boolean buyOut(String encryptMd5) {
        try {
            String checkMd5 = MD5Helper.getStringMD5((String)RecLicenseUtil.getEncryptMd5());
            String encrypt = Coder.hexStr2Str((String)encryptMd5);
            byte[] base64 = Coder.decryptBASE64((String)encrypt);
            byte[] srcMd5 = RSA.getInstance().decrypt(base64);
            if (RecLicenseUtil.compareBytes(checkMd5.getBytes(), srcMd5)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static String getEncryptMd5() throws Exception {
        Date forEver = new Date(0L);
        return forEver.getTime() + "";
    }

    private static boolean compareBytes(byte[] desBytes, byte[] srcBtyes) {
        if (desBytes == null && srcBtyes == null) {
            return true;
        }
        if (desBytes != null && srcBtyes != null) {
            if (desBytes.length != srcBtyes.length) {
                return false;
            }
            for (int i = 0; i < desBytes.length; ++i) {
                if (desBytes[i] == srcBtyes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

