/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.ofd;

import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.RecordBaseConfigCollection;
import com.kingdee.eas.el.rec.RecordBaseFactory;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.ofd.bizInvoke.BizServiceInvoke;
import com.kingdee.eas.el.rec.ofd.handler.InvoiceInfoHandler;
import com.kingdee.eas.el.rec.ofd.vo.EreceiptXU;
import com.kingdee.eas.el.rec.ofd.vo.Invoice;
import com.kingdee.eas.el.rec.ofd.vo.XBRLParam;
import com.kingdee.eas.el.rec.ofd.vo.XbrlUnitI;
import com.kingdee.eas.el.rec.ofd.xbrlJSON.InvoiceJSON;
import com.kingdee.eas.el.rec.ofd.xbrlJSON.JSONFactory;
import com.kingdee.eas.el.rec.outputmodule.archsys.pojo.ArchFormatInfo;
import com.kingdee.eas.el.rec.tool.FormatUtils;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class FilingOfdUtils {
    private static Logger logger = Logger.getLogger((String)FilingOfdUtils.class.getName());
    public static List<String> billTypes = new ArrayList<String>(2);
    public static String EReceiptCode;
    private static LoadingCache<String, RecordBaseInfo> recordBaseCache;
    private static LoadingCache<String, InvoiceInfoHandler> invoiceInfoHandlerLoadingCache;

    public static Boolean canArchXbrl(Context ctx, String recordBaseId, String orgId) throws EASBizException {
        Boolean result = false;
        RecordBaseInfo info = null;
        try {
            info = (RecordBaseInfo)recordBaseCache.get((Object)recordBaseId);
            if (!billTypes.contains(info.getBillType().getBosType())) {
                return result;
            }
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(H.PK(orgId));
            CompanyOrgUnitInfo createOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(H.PK(info.getOrg().getId()));
            String archLongNumber = companyOrgUnitInfo.getLongNumber();
            String creatorLongNumber = createOrg.getLongNumber();
            HashSet<String> set = new HashSet<String>();
            set.add(archLongNumber);
            while (archLongNumber.indexOf(creatorLongNumber) > -1 && !creatorLongNumber.equals(archLongNumber) && archLongNumber.lastIndexOf("!") > -1) {
                archLongNumber = archLongNumber.substring(0, archLongNumber.lastIndexOf("!"));
                set.add(archLongNumber);
            }
            set.add(creatorLongNumber);
            String sql = "SELECT T1.FelCertificate, T2.FLONGNUMBER, T2.FLEVEL, T1.FID, T1.FORGID FROM T_REC_RECORDBASEEXTEND  T1 inner join T_ORG_COMPANY T2 on T1.FRecordBaseId = ? and T2.FID = T1.FORGID and T2.FLONGNUMBER IN " + FormatUtils.list2Sql(set) + " and T1.FelCertificate is not null order by T2.FLEVEL desc";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{recordBaseId});
            if (executeQuery.next()) {
                result = executeQuery.getBoolean(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u5f52\u6863\u5185\u5bb9\u6269\u5c55\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("00", "\u83b7\u53d6\u5f52\u6863\u5185\u5bb9\u6269\u5c55\u4fe1\u606f\u51fa\u9519"), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u5f52\u6863\u5185\u5bb9\u6269\u5c55\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("00", "\u83b7\u53d6\u5f52\u6863\u5185\u5bb9\u6269\u5c55\u4fe1\u606f\u51fa\u9519"), (Throwable)e);
        }
        return result;
    }

    public static Boolean hasBeenEvsPatch() {
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.base.evs.app.apiservice.EvsServiceFacadeFactory");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static String getConfig(String recordBaseId, String configKey) {
        RecordBaseInfo info = null;
        try {
            info = (RecordBaseInfo)recordBaseCache.get((Object)recordBaseId);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        String value = (String)info.get(configKey);
        if ("invoiceHandler".equals(configKey) && StringUtils.isEmpty((String)value)) {
            return SingletonHolder.handlerMap.get(info.getBillType().getBosType());
        }
        return value;
    }

    private static List<XbrlUnitI> getInvoiceInfos(Context ctx, String billId, String recordBaseId) throws Exception {
        String clzName = FilingOfdUtils.getConfig(recordBaseId, "invoiceHandler");
        if (StringUtils.isEmpty((String)clzName)) {
            return null;
        }
        InvoiceInfoHandler invoiceInfoHandler = (InvoiceInfoHandler)invoiceInfoHandlerLoadingCache.get((Object)recordBaseId);
        List<XbrlUnitI> invoiceInfos = invoiceInfoHandler.getInvoiceByBillId(ctx, billId);
        return invoiceInfos;
    }

    public static void addRefBill(Context ctx, String billId, ArchInfo archInfo, String recordBaseId) throws Exception {
        boolean archEVoucher;
        String isev = FilingOfdUtils.getConfig(recordBaseId, "elCertificate");
        boolean bl = archEVoucher = StringUtils.isEmpty((String)isev) ? false : Boolean.parseBoolean(isev);
        if (!archEVoucher) {
            return;
        }
        List<XbrlUnitI> invoiceInfos = FilingOfdUtils.getInvoiceInfos(ctx, billId, recordBaseId);
        if (invoiceInfos == null || invoiceInfos.size() == 0) {
            logger.error((Object)"invoiceInfos\u4e3a\u7a7a");
            return;
        }
        List<XbrlUnitI> invoiceList = archInfo.getInvoiceList();
        if (invoiceList == null) {
            invoiceList = new ArrayList<XbrlUnitI>();
        }
        invoiceList.addAll(invoiceInfos);
        archInfo.setInvoiceList(invoiceList);
    }

    public static XBRLParam getXBRLParam(Context ctx, ArchFormatInfo archFormatInfo, List<XmlBase> xmlBases) throws Exception {
        ArrayList<XbrlUnitI> invoiceList = new ArrayList<XbrlUnitI>();
        boolean isEleBankStatement = false;
        HashMap<String, List<Invoice>> mainBillInvoice = new HashMap<String, List<Invoice>>();
        for (int i = 0; i < xmlBases.size(); ++i) {
            ArchInfo mainArchInfo = (ArchInfo)xmlBases.get(i);
            if ("eleBankStatement".equals(mainArchInfo.getDocType())) {
                isEleBankStatement = true;
                FilingOfdUtils.addRefBill(ctx, mainArchInfo.getBillId(), mainArchInfo, mainArchInfo.getRecordBaseId());
            } else {
                for (ArchInfo archInfo : mainArchInfo.getRefInfo()) {
                    FilingOfdUtils.addRefBill(ctx, archInfo.getBillId(), archInfo, archInfo.getRecordBaseId());
                    if (null == archInfo.getInvoiceList() || archInfo.getInvoiceList().isEmpty()) continue;
                    if (mainArchInfo.getInvoiceList() == null) {
                        mainArchInfo.setInvoiceList(new ArrayList<XbrlUnitI>());
                    }
                    mainArchInfo.getInvoiceList().addAll(archInfo.getInvoiceList());
                }
            }
            if (mainArchInfo.getInvoiceList() == null) continue;
            mainBillInvoice.put(mainArchInfo.getBillId(), new ArrayList<XbrlUnitI>(mainArchInfo.getInvoiceList()));
            invoiceList.addAll(mainArchInfo.getInvoiceList());
        }
        if (invoiceList.isEmpty()) {
            return null;
        }
        if (isEleBankStatement) {
            return FilingOfdUtils.getEleBankStatementXBRLParam(ctx, xmlBases);
        }
        ArrayList vchIds = new ArrayList(mainBillInvoice.keySet());
        Map voucherMap = BizServiceInvoke.getVoucherInfo(ctx, vchIds);
        ArrayList<Map> invoiceParamList = new ArrayList<Map>();
        for (XbrlUnitI invoice : invoiceList) {
            if (!(invoice instanceof Invoice)) continue;
            invoiceParamList.add(((Invoice)invoice).info2Map());
        }
        Map map = BizServiceInvoke.getCasInfo(ctx, vchIds);
        FilingOfdUtils.paymentMapAdaptor(ctx, map, vchIds);
        List<String> bkerIds = FilingOfdUtils.getBkerIdsRemoveOther(mainBillInvoice);
        Map bkerPaymentMap = BizServiceInvoke.getERValidCode(ctx, bkerIds);
        if (null != map && null != bkerPaymentMap) {
            map.putAll(bkerPaymentMap);
        }
        Map taxMap = BizServiceInvoke.getTaxInfo(ctx, invoiceParamList);
        Map invoiceMap = BizServiceInvoke.getInvoiceInfo(ctx, mainBillInvoice);
        Map companyMap = FilingOfdUtils.getCompanyMap(ctx, archFormatInfo.getRecordInfo().getOrg().getName(), archFormatInfo.getRecordInfo().getOrg().getTaxNumber());
        return new XBRLParam(voucherMap, null == map ? new HashMap() : map, null == taxMap ? new HashMap() : taxMap, null == invoiceMap ? new HashMap() : invoiceMap, companyMap);
    }

    private static XBRLParam getEleBankStatementXBRLParam(Context ctx, List<XmlBase> xmlBases) {
        XBRLParam xbrlParam = new XBRLParam();
        HashMap<String, Map<String, Object>> paymentMap = new HashMap<String, Map<String, Object>>();
        xbrlParam.setPaymentMap(paymentMap);
        HashSet<String> ids = new HashSet<String>(xmlBases.size());
        for (XmlBase xmlBase : xmlBases) {
            if (!"eleBankStatement".equals(xmlBase.getDocType())) continue;
            ids.add(((ArchInfo)xmlBase).getBillId());
        }
        IObjectCollection eleStatementBillColls = FilingOfdUtils.getEleStatementBillColls(ctx, ids);
        if (eleStatementBillColls == null) {
            return xbrlParam;
        }
        for (int i = 0; i < eleStatementBillColls.size(); ++i) {
            Map<String, Object> objectMap = FilingOfdUtils.eleBankStatement2Map(eleStatementBillColls.getObject(i));
            paymentMap.put(eleStatementBillColls.getObject(i).getString("id"), objectMap);
        }
        return xbrlParam;
    }

    private static Map<String, Object> eleBankStatement2Map(IObjectValue object) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("authority", object.get("authority"));
        objectMap.put("networkSalesNum", object.get("networksalesnum"));
        objectMap.put("currency", object.get("currency") == null ? null : ((IObjectValue)object.get("currency")).get("isocode"));
        objectMap.put("bankAccountNumber", object.get("bankaccount") == null ? null : ((IObjectValue)object.get("bankaccount")).get("bankaccountnumber"));
        objectMap.put("bankAcctName", object.get("bankacctname"));
        objectMap.put("bankClientCode", object.get("bankclientcode"));
        objectMap.put("transDate", object.get("transdate"));
        objectMap.put("printCount", object.get("printcount"));
        objectMap.put("printDate", object.get("printdate"));
        objectMap.put("endBalance", object.get("endbalance"));
        objectMap.put("endRetainedAmt", object.get("endretainedamt"));
        objectMap.put("endFrezonAmt", object.get("endfrezonamt"));
        objectMap.put("endOverdraftAmt", object.get("endoverdraftamt"));
        objectMap.put("endAvailableAmt", object.get("endavailableamt"));
        IObjectCollection entry = (IObjectCollection)object.get("entry");
        ArrayList list = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
        SimpleDateFormat sdf1 = new SimpleDateFormat("HH:mm:ss");
        objectMap.put("entry", list);
        for (int i = 0; i < entry.size(); ++i) {
            IObjectValue value = entry.getObject(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bookDate", value.get("bookdate") == null ? "" : sdf.format((Date)value.get("bookdate")));
            map.put("bizProductType", value.get("bizproducttype"));
            map.put("vourcherType", value.get("vourchertype"));
            map.put("businessNum", value.get("businessnum"));
            map.put("creditAmount", value.get("creditamount"));
            map.put("debitAmount", value.get("debitamount"));
            map.put("vourcherNum", value.get("vourchernum"));
            map.put("decreption", value.get("decreption"));
            map.put("debitStatus", value.get("debitstatus"));
            map.put("acctBalance", value.get("acctbalance"));
            map.put("tradeCode", value.get("tradecode"));
            map.put("oppBankNumber", value.get("oppbanknumber"));
            map.put("oppBankName", value.get("oppbankname"));
            map.put("oppBank", value.get("oppbank"));
            map.put("bookKeeper", value.get("bookkeeper"));
            map.put("bookTime", value.get("booktime") == null ? "" : sdf1.format((Timestamp)value.get("booktime")));
            map.put("bookDetail", value.get("bookdetail"));
            map.put("otherBookMsg", value.get("otherbookmsg"));
            map.put("ereceiptNum", value.get("ereceiptnum"));
            list.add(map);
        }
        return objectMap;
    }

    private static List<String> getBkerIdsRemoveOther(Map<String, List<XbrlUnitI>> voucherInvoice) {
        ArrayList<String> bkerIds = new ArrayList<String>();
        for (String key : voucherInvoice.keySet()) {
            List<XbrlUnitI> xbrlUnitIs = voucherInvoice.get(key);
            for (int i = xbrlUnitIs.size() - 1; i >= 0; --i) {
                if (xbrlUnitIs.get(i) instanceof Invoice) continue;
                if (xbrlUnitIs.get(i) instanceof EreceiptXU) {
                    bkerIds.add(((EreceiptXU)xbrlUnitIs.get(i)).getBillId());
                }
                xbrlUnitIs.remove(i);
            }
        }
        return bkerIds;
    }

    public static Object[] getXbrlInfo(Context ctx, ArchFormatInfo archFormatInfo, XbrlUnitI xbrlUnit, XBRLParam xbrlParam, ArchInfo archInfo) {
        InvoiceJSON instance = null;
        instance = "eleBankStatement".equals(archInfo.getDocType()) ? JSONFactory.getInstance(ctx, JSONFactory.InvoiceType.BKRS.name()) : JSONFactory.getInstance(ctx, xbrlUnit instanceof Invoice ? ((Invoice)xbrlUnit).getInvoiceType() : JSONFactory.InvoiceType.BKER.name());
        if (null == instance) {
            return null;
        }
        JSONObject invoiceXBRLJSON = instance.initXBRLJson(ctx, xbrlUnit, xbrlParam, archInfo.getBillId());
        if (invoiceXBRLJSON == null) {
            return null;
        }
        StringBuilder xbrlNameSb = new StringBuilder(archFormatInfo.getRecordInfo().getOrg().getTaxNumber());
        xbrlNameSb.append("_").append(archFormatInfo.getRecordInfo().getPeriodNum()).append("_").append(xbrlUnit instanceof Invoice ? ((Invoice)xbrlUnit).getUniqueCodeOfInvoice() : ("eleBankStatement".equals(archInfo.getDocType()) ? "" : ((EreceiptXU)xbrlUnit).getIdentifyingCode())).append("_").append(archInfo.getBillNumber()).append(".xml");
        String json2Xbrl = FilingOfdUtils.json2Xbrl(invoiceXBRLJSON, instance.getCinfigId());
        ByteArrayInputStream bais = new ByteArrayInputStream(json2Xbrl.getBytes());
        return new Object[]{xbrlNameSb.toString(), bais, json2Xbrl};
    }

    private static String json2Xbrl(JSONObject jsonObject, String configId) {
        try {
            Assert.notNull((Object)SingletonHolder.json2XbrlMethod, (String)"json2XbrlMethod");
            Assert.notNull((Object)SingletonHolder.jsonToXbrlInstance, (String)"jsonToXbrlInstance");
            return (String)SingletonHolder.json2XbrlMethod.invoke(SingletonHolder.jsonToXbrlInstance, jsonObject, configId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map getCompanyMap(Context ctx, String nameOfAccountingEntity, String unifiedSocialCreditCodeOfAccountingEntity) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("NameOfAccountingEntity", nameOfAccountingEntity);
        map.put("UnifiedSocialCreditCodeOfAccountingEntity", unifiedSocialCreditCodeOfAccountingEntity);
        return map;
    }

    private static void paymentMapAdaptor(Context ctx, Map paymentMap, List vchIds) {
        for (int i = 0; i < vchIds.size(); ++i) {
            String voucherId = (String)vchIds.get(i);
            List paymentNumList = (List)paymentMap.get(voucherId);
            if (null == paymentNumList) continue;
            paymentMap.put(voucherId, FilingOfdUtils.getPaymentMap(ctx, paymentNumList));
        }
    }

    public static Map getPaymentMap(Context ctx, List paymentNumList) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        for (Object obj : paymentNumList) {
            builder.append(obj).append(",");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        map.put(EReceiptCode, builder.toString());
        return map;
    }

    private static IObjectCollection getEleStatementBillColls(Context ctx, Set<String> ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        EntityViewInfo elStatementView = new EntityViewInfo();
        SelectorItemCollection elStatementSic = new SelectorItemCollection();
        elStatementSic.add(new SelectorItemInfo("*"));
        elStatementSic.add(new SelectorItemInfo("entry.*"));
        elStatementSic.add(new SelectorItemInfo("currency.*"));
        elStatementSic.add(new SelectorItemInfo("bankAccount.*"));
        elStatementView.setSelector(elStatementSic);
        FilterInfo elStatementFilter = new FilterInfo();
        elStatementFilter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        elStatementView.setFilter(elStatementFilter);
        logger.error((Object)("elStatementView's SQL:" + elStatementView.toString()));
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.fm.be.ElStatementBillFactory");
            Method method = clazz.getMethod("getLocalInstance", Context.class);
            Object iobj = method.invoke(null, ctx);
            method = iobj.getClass().getMethod("getElStatementBillCollection", EntityViewInfo.class);
            IObjectCollection coll = (IObjectCollection)method.invoke(iobj, elStatementView);
            return coll;
        }
        catch (Exception e) {
            logger.error((Object)"getEleStatementBillColls \u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    static {
        billTypes.add("2652E01E");
        billTypes.add("B76C5DF9");
        EReceiptCode = "EReceiptCode";
        recordBaseCache = CacheBuilder.newBuilder().maximumSize(40L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, RecordBaseInfo>(){

            public RecordBaseInfo load(String key) throws Exception {
                RecordBaseInfo recordBaseInfo;
                RecordBaseConfigCollection configs;
                Context ctx = ContextUtils.getContextFromSessionNoException();
                if (null == ctx) {
                    ctx = ContextManager.getContext();
                }
                if (ctx != null && ctx.getCaller() == null) {
                    Map currentServiceEnv = GeniusBOSFactory.getCurrentServiceEnv();
                    ctx = (Context)currentServiceEnv.get("BOSCTX");
                }
                if ((configs = (recordBaseInfo = null != ctx && null != ctx.getCaller() ? RecordBaseFactory.getLocalInstance(ctx).getRecordBaseInfo("select id, billType.bosType, org.id, configs.* where id ='" + key + "'") : RecordBaseFactory.getRemoteInstance().getRecordBaseInfo("select id, billType.bosType, org.id, configs.* where id ='" + key + "'")).getConfigs()) != null && configs.size() > 0) {
                    for (int i = 0; i < configs.size(); ++i) {
                        recordBaseInfo.put(configs.get(i).getNumber(), configs.get(i).getValue());
                    }
                }
                return recordBaseInfo;
            }
        });
        invoiceInfoHandlerLoadingCache = CacheBuilder.newBuilder().maximumSize(20L).expireAfterWrite(180L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, InvoiceInfoHandler>(){

            public InvoiceInfoHandler load(String recordBaseId) throws Exception {
                RecordBaseInfo info = (RecordBaseInfo)recordBaseCache.get((Object)recordBaseId);
                String clzName = FilingOfdUtils.getConfig(recordBaseId, "invoiceHandler");
                if (StringUtils.isEmpty((String)clzName)) {
                    logger.error((Object)("\u5f52\u6863\u5185\u5bb9[" + info.getName() + "]\u6ca1\u6709\u914d\u7f6e\u83b7\u53d6\u53d1\u7968handler"));
                    throw new NullPointerException("\u5f52\u6863\u5185\u5bb9[" + recordBaseId + "]\u6ca1\u6709\u914d\u7f6e\u83b7\u53d6\u53d1\u7968handler");
                }
                Class<?> aClass = Class.forName(clzName);
                return (InvoiceInfoHandler)aClass.newInstance();
            }
        });
    }

    private static class SingletonHolder {
        public static Map<String, String> handlerMap = new HashMap<String, String>();
        private static Class jsonToXbrlClz = null;
        public static Method json2XbrlMethod = null;
        public static Object jsonToXbrlInstance = null;

        private SingletonHolder() {
        }

        static {
            try {
                handlerMap.put("4A44F49F", "com.kingdee.eas.el.rec.ofd.handler.BizAccountInvoiceInfoHandler");
                handlerMap.put("C57003BC", "com.kingdee.eas.el.rec.ofd.handler.BizTraAccountInvoiceInfoHandler");
                handlerMap.put("30BD2798", "com.kingdee.eas.el.rec.ofd.handler.BizDPInvoiceInfoHandler");
                handlerMap.put("92F938DD", "com.kingdee.eas.el.rec.ofd.handler.BizOutInvoiceInfoHandler");
                handlerMap.put("48DA3A71", "com.kingdee.eas.el.rec.ofd.handler.ApOtherInvoiceInfoHandler");
                handlerMap.put("F8FF7C09", "com.kingdee.eas.el.rec.ofd.handler.EReceiptInvoiceInfoHandler");
                handlerMap.put("B76C5DF9", "com.kingdee.eas.el.rec.ofd.handler.EleStatementBillInfoHandler");
                jsonToXbrlClz = Class.forName("com.pansoft.xbrl.xbrljson.convert.JsonToXbrl");
                jsonToXbrlInstance = jsonToXbrlClz.newInstance();
                json2XbrlMethod = jsonToXbrlClz.getMethod("convertXbrlXml", JSONObject.class, String.class);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e);
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
            }
            catch (InstantiationException e) {
                logger.error((Object)e);
            }
        }
    }
}

