/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.ofd.elecertificate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.wssc.ImmediateSubmitFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.ArchFlagEnum;
import com.kingdee.eas.el.rec.EleCertificateCollection;
import com.kingdee.eas.el.rec.EleCertificateFactory;
import com.kingdee.eas.el.rec.EleCertificateInfo;
import com.kingdee.eas.el.rec.ofd.elecertificate.CertificateEntryInfo;
import com.kingdee.eas.el.rec.ofd.elecertificate.CertificateInfo;
import com.kingdee.eas.el.rec.outputmodule.archsys.pojo.ArchFormatInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CertificateUtils {
    private static Logger logger = Logger.getLogger((String)CertificateUtils.class.getName());
    static Map<String, String> tableNameMap = new HashMap<String, String>();

    public static void handleEleCertificateEntry(Context ctx, ArchFormatInfo archFormatInfo, Map<String, CertificateInfo> certificateList) throws BOSException, EASBizException {
        if (certificateList.isEmpty()) {
            return;
        }
        String companyId = archFormatInfo.getRecordInfo().getOrg().getId().toString();
        int periodNum = archFormatInfo.getRecordInfo().getPeriodNum();
        EleCertificateCollection eleCertificateCollection = EleCertificateFactory.getLocalInstance(ctx).getEleCertificateCollection("select * where companyId = '" + companyId + "' and periodNumber = '" + periodNum + "'");
        if (eleCertificateCollection != null && eleCertificateCollection.size() > 0) {
            EleCertificateInfo eleCertificateInfo = eleCertificateCollection.get(0);
            HashSet<String> addTableNameSet = new HashSet<String>();
            for (Map.Entry<String, CertificateInfo> entry : certificateList.entrySet()) {
                String bosType = entry.getKey();
                CertificateInfo certificateInfo = entry.getValue();
                logger.error((Object)("bosType:" + bosType));
                if (tableNameMap.containsKey(bosType)) {
                    String tableName = tableNameMap.get(bosType);
                    addTableNameSet.add(tableName);
                    CertificateUtils.handleData(ctx, eleCertificateInfo.getId().toString(), tableName, certificateInfo);
                    continue;
                }
                logger.error((Object)(bosType + "\u4e0d\u5728\u652f\u6301\u5217\u8868\u4e2d"));
            }
            String tableName = eleCertificateInfo.getTableName();
            if (StringUtils.isEmpty((String)tableName)) {
                tableName = CertificateUtils.mergeTableName(tableName, addTableNameSet);
                logger.error((Object)("addTableNameSet:" + addTableNameSet.size() + ";" + ((Object)addTableNameSet).toString() + "tableName:" + tableName));
                if (!StringUtils.isEmpty((String)tableName) && !tableName.equals(eleCertificateInfo.getTableName())) {
                    ImmediateSubmitFacadeFactory.getLocalInstance((Context)ctx).executeSql("update T_REC_EleCertificate set FTableName = '" + tableName + "' where fid = '" + eleCertificateInfo.getId().toString() + "'");
                }
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("If not exists (select 1 from T_REC_EleCertificate where FCompanyId = '").append(companyId).append("' and FPeriodNumber = '").append(periodNum).append("')");
            sb.append("insert into T_REC_EleCertificate(FID, FCompanyId, FPeriodNumber)");
            sb.append("values('" + BOSUuid.create((String)"FB050946") + "','" + companyId + "','" + periodNum + "')");
            try {
                ImmediateSubmitFacadeFactory.getLocalInstance((Context)ctx).executeSql(sb.toString());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            CertificateUtils.handleEleCertificateEntry(ctx, archFormatInfo, certificateList);
        }
    }

    private static void handleData(Context ctx, String parentId, String tableName, CertificateInfo info) throws BOSException {
        List<CertificateEntryInfo> entryInfos = info.getEntryInfos();
        if (entryInfos.isEmpty()) {
            return;
        }
        String addSql = "insert into " + tableName + "(FParentId,FvoucerId,FsrcBillId,FJson,FInvoceSerial,FInvoceCode,FInvoceNumber,FInvoceType) values(?,?,?,?,?,?,?,?)";
        String deleteSql = "delete from " + tableName + " where FsrcBillId = ? ";
        String updateSql = "update " + tableName + " set FvoucerId = ?,FJson = ?,FInvoceSerial = ?,FInvoceCode = ?,FInvoceNumber = ?,FInvoceType = ? where FsrcBillId = ? ";
        ArrayList<Object[]> paramsAddList = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsDeleteList = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsUpdateList = new ArrayList<Object[]>();
        for (CertificateEntryInfo entryInfo : entryInfos) {
            if (ArchFlagEnum.ADDNEW.equals((Object)entryInfo.getArchFlag())) {
                paramsAddList.add(new Object[]{parentId, entryInfo.getVoucerId(), entryInfo.getSrcBillId(), entryInfo.getJson(), entryInfo.getInvoceSerial(), entryInfo.getInvoceCode(), entryInfo.getInvoceNumber(), entryInfo.getInvoceType()});
                continue;
            }
            if (ArchFlagEnum.DELETE.equals((Object)entryInfo.getArchFlag())) {
                paramsDeleteList.add(new Object[]{entryInfo.getSrcBillId()});
                continue;
            }
            if (!ArchFlagEnum.UPDATE.equals((Object)entryInfo.getArchFlag())) continue;
            paramsUpdateList.add(new Object[]{entryInfo.getVoucerId(), entryInfo.getJson(), entryInfo.getInvoceSerial(), entryInfo.getInvoceCode(), entryInfo.getInvoceNumber(), entryInfo.getInvoceType(), entryInfo.getSrcBillId()});
        }
        DbUtil.executeBatch((Context)ctx, (String)addSql, paramsAddList);
        DbUtil.executeBatch((Context)ctx, (String)deleteSql, paramsDeleteList);
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramsUpdateList);
    }

    public static void deleteData(Context ctx, String companyId, String periodNumber) throws BOSException, EASBizException {
        String tableName;
        EleCertificateInfo certificateInfo = EleCertificateFactory.getLocalInstance(ctx).getEleCertificateInfo("select * where periodNumber = '" + periodNumber + "' and companyId = '" + companyId + "'");
        if (certificateInfo != null && !StringUtils.isEmpty((String)(tableName = certificateInfo.getTableName()))) {
            String[] names;
            for (String name : names = tableName.split(",")) {
                DbUtil.execute((Context)ctx, (String)("delete from " + name + " where fparentid = '" + certificateInfo.getId().toString() + "' "));
            }
        }
    }

    private static String mergeTableName(String tableName, Set<String> tableNameSet) {
        if (tableNameSet.isEmpty()) {
            return "";
        }
        if (!StringUtils.isEmpty((String)tableName)) {
            String[] names = tableName.split(",");
            tableNameSet.addAll(Arrays.asList(names));
        }
        StringBuilder sb = new StringBuilder();
        for (String name : tableNameSet) {
            sb.append(name).append(",");
        }
        sb.setCharAt(sb.length() - 1, ' ');
        return sb.toString();
    }

    static {
        tableNameMap.put("FC910EF3", "T_REC_Ele_FC910EF3");
        tableNameMap.put("FA44FD5B", "T_REC_Ele_FA44FD5B");
        tableNameMap.put("30BD2798", "T_REC_Ele_30BD2798");
        tableNameMap.put("8110AAB2", "T_REC_Ele_8110AAB2");
        tableNameMap.put("0B104F5C", "T_REC_Ele_0B104F5C");
        tableNameMap.put("40284E81", "T_REC_Ele_40284E81");
        tableNameMap.put("E76173AD", "T_REC_Ele_E76173AD");
        tableNameMap.put("4A44F49F", "T_REC_Ele_4A44F49F");
        tableNameMap.put("92F938DD", "T_REC_Ele_92F938DD");
        tableNameMap.put("C57003BC", "T_REC_Ele_C57003BC");
    }
}

