/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.ofd.xbrlJSON;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.el.rec.ofd.util.AS;
import com.kingdee.eas.el.rec.ofd.vo.EleBankStatementXU;
import com.kingdee.eas.el.rec.ofd.vo.XBRLParam;
import com.kingdee.eas.el.rec.ofd.xbrlJSON.InvoiceJSON;
import com.kingdee.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class BkrsInvoiceJSON
implements InvoiceJSON<EleBankStatementXU> {
    private static String IdentificationCodeOfIssuer = "IdentificationCodeOfIssuer";
    private static String NumberOfBankBranch = "NumberOfBankBranch";
    private static String Currency = "Currency";
    private static String CustomerSettlementBankAccount = "CustomerSettlementBankAccount";
    private static String NameOfCustomerAccount = "NameOfCustomerAccount";
    private static String CodeOfBankCustomer = "CodeOfBankCustomer";
    private static String YearOfBankReconciliationStatement = "YearOfBankReconciliationStatement";
    private static String MonthOfBankReconciliationStatement = "MonthOfBankReconciliationStatement";
    private static String PrintTimes = "PrintTimes";
    private static String PrintDate = "PrintDate";
    private static String AccountBalanceAtTheEndOfReconciliationCycleAmount = "AccountBalanceAtTheEndOfReconciliationCycleAmount";
    private static String ReserveBalanceAtTheEndOfReconciliationCycle = "ReserveBalanceAtTheEndOfReconciliationCycle";
    private static String FrozenBalanceAtTheEndOfReconciliationCycle = "FrozenBalanceAtTheEndOfReconciliationCycle";
    private static String OverdraftBalanceAtEndOfReconciliationCycle = "OverdraftBalanceAtEndOfReconciliationCycle";
    private static String AvailableBalanceAtTheEndOfReconciliationCycleAmount = "AvailableBalanceAtTheEndOfReconciliationCycleAmount";
    private static String InformationOfReconcileDetailsTuple = "InformationOfReconcileDetailsTuple";
    private static String DateOfBookkeeping = "DateOfBookkeeping";
    private static String TypesOfBusinessProducts = "TypesOfBusinessProducts";
    private static String BusinessSerialNumber = "BusinessSerialNumber";
    private static String TypeOfSourceDocument = "TypeOfSourceDocument";
    private static String NumberOfSourceDocument = "NumberOfSourceDocument";
    private static String NotesOfBankElectronicReceipt = "NotesOfBankElectronicReceipt";
    private static String IdentificationOfCreditOrDebit = "IdentificationOfCreditOrDebit";
    private static String TransactionAmount = "TransactionAmount";
    private static String DebitOrCreditOfBalance = "DebitOrCreditOfBalance";
    private static String AccountBalance = "AccountBalance";
    private static String TransactionCode = "TransactionCode";
    private static String AccountOfCounterparty = "AccountOfCounterparty";
    private static String NameOfCounterparty = "NameOfCounterparty";
    private static String DepositoryBankOfCounterparty = "DepositoryBankOfCounterparty";
    private static String Bookkeeper = "Bookkeeper";
    private static String TimeOfBookkeeping = "TimeOfBookkeeping";
    private static String JournalAccountOfBookkeeping = "JournalAccountOfBookkeeping";
    private static String OtherAccountingInformation = "OtherAccountingInformation";
    private static String NumberOfBankElectronicReceipt = "NumberOfBankElectronicReceipt";

    @Override
    public JSONObject initXBRLJson(Context ctx, EleBankStatementXU xbrlunit, XBRLParam xbrlParam, String voucherId) {
        Map map = (Map)xbrlParam.getPaymentMap().get(voucherId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(IdentificationCodeOfIssuer, (Object)AS.valueOf(map.get("authority")));
        jsonObject.put(NumberOfBankBranch, (Object)AS.valueOf(map.get("networkSalesNum")));
        jsonObject.put(Currency, (Object)AS.valueOf(map.get("currency")));
        jsonObject.put(CustomerSettlementBankAccount, (Object)AS.valueOf(map.get("bankAccountNumber")));
        jsonObject.put(NameOfCustomerAccount, (Object)AS.valueOf(map.get("bankAcctName")));
        jsonObject.put(CodeOfBankCustomer, (Object)AS.valueOf(map.get("bankClientCode")));
        Calendar instance = Calendar.getInstance();
        instance.setTime((Date)map.get("transDate"));
        jsonObject.put(YearOfBankReconciliationStatement, (Object)instance.get(1));
        int month = instance.get(2) + 1;
        jsonObject.put(MonthOfBankReconciliationStatement, month >= 10 ? Integer.valueOf(month) : "0" + month);
        jsonObject.put(PrintTimes, (Object)AS.valueOf(map.get("printCount")));
        jsonObject.put(PrintDate, (Object)AS.valueOf(map.get("printDate")));
        jsonObject.put(AccountBalanceAtTheEndOfReconciliationCycleAmount, (Object)AS.valueOf(map.get("endBalance")));
        jsonObject.put(ReserveBalanceAtTheEndOfReconciliationCycle, (Object)AS.valueOf(map.get("endRetainedAmt")));
        jsonObject.put(FrozenBalanceAtTheEndOfReconciliationCycle, (Object)AS.valueOf(map.get("endFrezonAmt")));
        jsonObject.put(OverdraftBalanceAtEndOfReconciliationCycle, (Object)AS.valueOf(map.get("endOverdraftAmt")));
        jsonObject.put(AvailableBalanceAtTheEndOfReconciliationCycleAmount, (Object)AS.valueOf(map.get("endAvailableAmt")));
        List entry = (List)map.get("entry");
        JSONArray tuples = new JSONArray();
        for (int i = 0; i < entry.size(); ++i) {
            Map entryMap = (Map)entry.get(i);
            JSONObject entryJson = new JSONObject();
            entryJson.put(DateOfBookkeeping, (Object)AS.valueOf(entryMap.get("bookDate")));
            entryJson.put(TypesOfBusinessProducts, (Object)AS.valueOf(entryMap.get("bizProductType")));
            entryJson.put(BusinessSerialNumber, (Object)AS.valueOf(entryMap.get("businessNum")));
            entryJson.put(TypeOfSourceDocument, (Object)AS.valueOf(entryMap.get("vourcherType")));
            entryJson.put(NumberOfSourceDocument, (Object)AS.valueOf(entryMap.get("vourcherNum")));
            entryJson.put(NotesOfBankElectronicReceipt, (Object)AS.valueOf(entryMap.get("decreption")));
            String creditAmount = AS.valueOf(entryMap.get("creditAmount"));
            String debitAmount = AS.valueOf(entryMap.get("debitAmount"));
            entryJson.put(TransactionAmount, (Object)(StringUtils.isEmpty((String)debitAmount) ? creditAmount : debitAmount));
            entryJson.put(IdentificationOfCreditOrDebit, (Object)(StringUtils.isEmpty((String)debitAmount) ? "1" : "0"));
            entryJson.put(DebitOrCreditOfBalance, (Object)AS.valueOf(entryMap.get("debitStatus")));
            entryJson.put(AccountBalance, (Object)AS.valueOf(entryMap.get("acctBalance")));
            entryJson.put(TransactionCode, (Object)AS.valueOf(entryMap.get("tradeCode")));
            entryJson.put(AccountOfCounterparty, (Object)AS.valueOf(entryMap.get("oppBankNumber")));
            entryJson.put(NameOfCounterparty, (Object)AS.valueOf(entryMap.get("oppBankName")));
            entryJson.put(DepositoryBankOfCounterparty, (Object)AS.valueOf(entryMap.get("oppBank")));
            entryJson.put(Bookkeeper, (Object)AS.valueOf(entryMap.get("bookKeeper")));
            entryJson.put(TimeOfBookkeeping, (Object)AS.valueOf(entryMap.get("bookTime")));
            entryJson.put(JournalAccountOfBookkeeping, (Object)AS.valueOf(entryMap.get("bookDetail")));
            entryJson.put(OtherAccountingInformation, (Object)AS.valueOf(entryMap.get("otherBookMsg")));
            entryJson.put(NumberOfBankElectronicReceipt, (Object)AS.valueOf(entryMap.get("ereceiptNum")));
            tuples.add((Object)entryJson);
        }
        jsonObject.put(InformationOfReconcileDetailsTuple, (Object)tuples);
        return jsonObject;
    }

    @Override
    public String getCinfigId() {
        return "bkrs";
    }
}

