/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.outputmodule.archsys.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArcStateEnum;
import com.kingdee.eas.el.rec.ArchSysLogServiceFacadeFactory;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.app.util.ArchConfigUtil;
import com.kingdee.eas.el.rec.app.util.ArchConstant;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.outputmodule.archsys.exception.ArchSystemException;
import com.kingdee.eas.el.rec.outputmodule.archsys.helper.NoticeArchSysHelper_INVO;
import com.kingdee.eas.el.rec.outputmodule.archsys.pojo.ArchFormatInfo;
import com.kingdee.eas.el.rec.outputmodule.archsys.util.DkwsUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

public class NoticeArchSysHelper_DKWS
extends NoticeArchSysHelper_INVO {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.outputmodule.archsys.helper.NoticeArchSysHelper_DKWS");

    @Override
    public boolean getResultFiles(Context ctx, String[] filePaths, String address, String port) throws BOSException, ArchSystemException {
        throw new ArchSystemException(ArchSystemException.NOT_ACHIEVE_EXCEPTION);
    }

    @Override
    public String reverseArch(Context ctx, List<ArcRecordInfo> arcRecordInfos, Map<String, String> otherParams) throws Exception {
        HashMap<String, Boolean> retMap = new HashMap<String, Boolean>();
        for (ArcRecordInfo arcRecordInfo : arcRecordInfos) {
            JSONObject logparam = new JSONObject();
            String result = "";
            String stack = "";
            String url = "";
            boolean res = false;
            try {
                String ip = this.getIpPort(ctx);
                String notic_arch_sys = ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_WSDL_TAIL_DKWS_DELETE);
                url = ip + notic_arch_sys;
                JSONObject param = new JSONObject();
                try {
                    RecordBaseInfo content = arcRecordInfo.getContent();
                    content.setReportCycleType(arcRecordInfo.getReportCycleType());
                    String businessType = this.getbusinessType(ctx, content, content.getXmlDocType());
                    if ("2".equals(businessType)) {
                        businessType = "1";
                    } else if ("4".equals(businessType)) {
                        businessType = "3";
                    }
                    String period = arcRecordInfo.getPeriodNum() / 100 + "-" + String.format("%02d", arcRecordInfo.getPeriodNum() % 100);
                    param.put((Object)"archivesCode", (Object)ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_INVO_ARCHIVESCODE));
                    param.put((Object)"businessType", (Object)businessType);
                    param.put((Object)"accountBookNo", (Object)arcRecordInfo.getOrg().getNumber());
                    param.put((Object)"accountBookName", (Object)arcRecordInfo.getOrg().getName());
                    param.put((Object)"period", (Object)period);
                    param.put((Object)"reportType", (Object)arcRecordInfo.getContent().getName());
                    param.put((Object)"currency", (Object)(null == arcRecordInfo.getCurrency() ? "" : arcRecordInfo.getCurrency().getName()));
                    param.put((Object)"dataSource", (Object)DATASOURCE);
                    logparam = param;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    stack = e.getMessage();
                    throw new EASBizException(new NumericExceptionSubItem("00", "\u7535\u5b50\u5f52\u6863\u901a\u77e5DKWS\u5220\u9664\u5931\u8d25\uff01" + e.getMessage()));
                }
                try {
                    result = DkwsUtil.postInterface(url, param.toString()).toString();
                    JSONObject json = JSONObject.fromObject((Object)result);
                    if (!"0000".equalsIgnoreCase(json.getString("errcode"))) {
                        throw new EASBizException(new NumericExceptionSubItem("00", "\u901a\u77e5\u7535\u5b50\u5f52\u6863DKWS\u5220\u9664\u5931\u8d25\uff01" + json.getString("description")));
                    }
                    res = true;
                }
                catch (Exception e) {
                    logger.error((Object)"\u7535\u5b50\u5f52\u6863\u901a\u77e5DKWS\u5220\u9664\u5931\u8d25", (Throwable)e);
                    stack = e.getMessage();
                    throw new EASBizException(new NumericExceptionSubItem("00", "\u901a\u77e5\u7535\u5b50\u5f52\u6863DKWS\u5220\u9664\u5931\u8d25\uff01" + e.getMessage()));
                }
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("00", e.getMessage()));
            }
            finally {
                retMap.put(arcRecordInfo.getId().toString(), res);
                try {
                    ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeInterfaceLog(url, "delete", logparam.toString(), res, result, stack);
                }
                catch (Exception exception) {}
            }
        }
        return JSONUtils.convertObjectToJson((Context)ctx, retMap);
    }

    @Override
    public String markFail(Context ctx, List<ArcRecordInfo> arcRecordInfos, Map<String, String> otherParams) throws Exception {
        return null;
    }

    @Override
    public void noticeArchSys(Context ctx, PeriodInfo periodInfo, CompanyOrgUnitInfo orgUnitInfo, String batchNumber) throws BOSException, EASBizException {
        JSONObject logparam = new JSONObject();
        String result = "";
        String stack = "";
        String url = "";
        boolean res = false;
        try {
            String ip = this.getIpPort(ctx);
            String notic_arch_sys = ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_WSDL_TAIL_DKWS_NOTICE);
            url = ip + notic_arch_sys;
            JSONObject param = new JSONObject();
            try {
                param.put((Object)"archivesCode", (Object)ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_INVO_ARCHIVESCODE));
                param.put((Object)"accountBookNo", (Object)orgUnitInfo.getNumber());
                param.put((Object)"accountBookName", (Object)orgUnitInfo.getName());
                param.put((Object)"period", (Object)periodInfo.getLogInfo());
                param.put((Object)"batchNumber", (Object)batchNumber);
                param.put((Object)"archivist", (Object)ctx.getUserName());
                param.put((Object)"dataSource", (Object)DATASOURCE);
                logparam = param;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                stack = e.getMessage();
                throw new EASBizException(new NumericExceptionSubItem("00", "\u7535\u5b50\u5f52\u6863\u901a\u77e5DKWS\u5931\u8d25\uff01" + e.getMessage()));
            }
            try {
                result = DkwsUtil.postInterface(url, param.toString()).toString();
                JSONObject json = JSONObject.fromObject((Object)result);
                if (!"0000".equalsIgnoreCase(json.getString("errcode"))) {
                    throw new EASBizException(new NumericExceptionSubItem("00", "\u901a\u77e5\u7535\u5b50\u5f52\u6863DKWS\u5931\u8d25\uff01" + json.getString("description")));
                }
                res = true;
            }
            catch (Exception e) {
                logger.error((Object)"\u7535\u5b50\u5f52\u6863\u901a\u77e5DKWS\u5931\u8d25", (Throwable)e);
                stack = e.getMessage();
                throw new EASBizException(new NumericExceptionSubItem("00", "\u901a\u77e5\u7535\u5b50\u5f52\u6863DKWS\u5931\u8d25\uff01" + e.getMessage()));
            }
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("00", e.getMessage()));
        }
        finally {
            try {
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeInterfaceLog(url, "noticeArchSys", logparam.toString(), res, result, stack);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public String fileUpLoad(Context ctx, ArchFormatInfo archFormatInfo, PeriodInfo periodInfo, InputStream is, String batchNumber, String businessType, String fileName, CompanyOrgUnitInfo orgUnitInfo) throws EASBizException {
        JSONObject logparam = new JSONObject();
        String result = "";
        String stack = "";
        String url = "";
        boolean res = false;
        try {
            String ip = this.getIpPort(ctx);
            String upload_arch_sys = ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_WSDL_TAIL_DKWS_UPLOAD);
            url = ip + upload_arch_sys;
            JSONObject param = new JSONObject();
            try {
                param.put((Object)"archivesCode", (Object)ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_INVO_ARCHIVESCODE));
                param.put((Object)"accountBookNo", (Object)orgUnitInfo.getNumber());
                param.put((Object)"accountBookName", (Object)orgUnitInfo.getName());
                param.put((Object)"period", (Object)periodInfo.getLogInfo());
                param.put((Object)"batchNumber", (Object)batchNumber);
                param.put((Object)"businessType", (Object)businessType);
                param.put((Object)"fileName", (Object)fileName);
                byte[] date = new byte[is.available()];
                is.read(date);
                is.close();
                BASE64Encoder base64Encoder = new BASE64Encoder();
                String filebase64 = base64Encoder.encodeBuffer(date);
                param.put((Object)"filebase64", (Object)filebase64);
                logparam.put((Object)"filebase64", (Object)"ABCD...");
                logparam.put((Object)"archivesCode", (Object)ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_INVO_ARCHIVESCODE));
                logparam.put((Object)"accountBookNo", (Object)orgUnitInfo.getNumber());
                logparam.put((Object)"accountBookName", (Object)orgUnitInfo.getName());
                logparam.put((Object)"period", (Object)periodInfo.getLogInfo());
                logparam.put((Object)"batchNumber", (Object)batchNumber);
                logparam.put((Object)"businessType", (Object)businessType);
                logparam.put((Object)"fileName", (Object)fileName);
                logparam.put((Object)"filebase64", (Object)"ABCD...");
            }
            catch (Exception e) {
                logger.error((Object)("\u7535\u5b50\u5f52\u6863\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25" + e.getMessage()), (Throwable)e);
                stack = e.getMessage();
                throw new EASBizException(new NumericExceptionSubItem("00", "\u7535\u5b50\u5f52\u6863\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01" + e.getMessage()));
            }
            try {
                result = DkwsUtil.postInterface(url, param.toString()).toString();
                JSONObject json = JSONObject.fromObject((Object)result);
                if (!"0000".equalsIgnoreCase(json.getString("errcode"))) {
                    throw new EASBizException(new NumericExceptionSubItem("00", "\u7535\u5b50\u5f52\u6863\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01" + json.getString("description")));
                }
                res = true;
                String string = "1";
                return string;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"\u7535\u5b50\u5f52\u6863\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
                    stack = e.getMessage();
                    throw new EASBizException(new NumericExceptionSubItem("00", "\u7535\u5b50\u5f52\u6863\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01" + e.getMessage()));
                }
                catch (Exception e2) {
                    throw new EASBizException(new NumericExceptionSubItem("00", e2.getMessage()));
                }
            }
        }
        finally {
            FilingUtils.safeClose(is);
            try {
                ArchSysLogServiceFacadeFactory.getLocalInstance(ctx).writeInterfaceLog(url, "fileUpLoad", logparam.toString(), res, result, stack);
            }
            catch (Exception exception) {}
        }
    }

    private String getIpPort(Context ctx) throws RecException {
        return this.getUrl(ctx, "");
    }

    @Override
    public void checkService(Context ctx) throws Exception {
        this.getAccessToken(ctx);
    }

    @Override
    protected String getAccessToken(Context ctx) throws BOSException, JSONException, EASBizException {
        return "token";
    }

    @Override
    public ArcStateEnum archProgress(Context ctx, ArcRecordInfo arcRecordInfo, Map<String, String> otherParams) throws Exception {
        return null;
    }
}

