/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.app.util.ArchConfigUtil;
import com.kingdee.eas.el.rec.app.util.ArchConstant;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.model.FileInfo;
import com.kingdee.eas.el.rec.model.ReverseBillMsgInfo;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.tool.IBillHandler;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BillHandlerProxy
implements IBillHandler {
    protected static Logger logger = Logger.getLogger(BillHandlerProxy.class);
    private IBillHandler billHandler;
    private boolean logFlag;

    public BillHandlerProxy(Context ctx, IBillHandler billHandler) {
        this.billHandler = billHandler;
        String logFlagStr = ArchConfigUtil.getPropertiesValue(ctx, ArchConstant.ARCH_SYS_LOG_BILLHANDLER);
        this.logFlag = Boolean.valueOf(logFlagStr);
    }

    @Override
    public Boolean canArch(Context ctx, String bosType, PeriodInfo period, CompanyOrgUnitInfo org) throws BOSException {
        return this.billHandler.canArch(ctx, bosType, period, org);
    }

    @Override
    public Map<String, IObjectValue> getCurrentPeriodCanArchMainBills(Context ctx, String bosType, PeriodInfo period, CompanyOrgUnitInfo org, Timestamp beginTime, Timestamp lastUpdateTime) throws BOSException {
        return this.billHandler.getCurrentPeriodCanArchMainBills(ctx, bosType, period, org, beginTime, lastUpdateTime);
    }

    @Override
    public Map<String, IObjectValue> getMainBills(Context ctx, String bosType, PeriodInfo period, CompanyOrgUnitInfo org) throws Exception {
        long t0 = System.currentTimeMillis();
        Map<String, IObjectValue> mainBills = this.billHandler.getMainBills(ctx, bosType, period, org);
        if (this.logFlag) {
            long t1 = System.currentTimeMillis();
            logger.error((Object)(this.billHandler.getClass().getName() + " getMainBills size:" + mainBills.size() + " time:" + (t1 - t0)));
        }
        return mainBills;
    }

    @Override
    public Boolean archSuccess(Context ctx, List<String> billIds) {
        return this.billHandler.archSuccess(ctx, billIds);
    }

    @Override
    public ReverseBillMsgInfo revokeArch(Context ctx, List<String> billIds) {
        return this.billHandler.revokeArch(ctx, billIds);
    }

    @Override
    public ArrayList<String> getAllRelationBill(Context ctx, String destObjId, Map<String, RecordBaseInfo> contents) throws Exception {
        long t0 = System.currentTimeMillis();
        ArrayList<String> allRelationBill = this.billHandler.getAllRelationBill(ctx, destObjId, contents);
        if (this.logFlag) {
            long t1 = System.currentTimeMillis();
            logger.error((Object)(this.billHandler.getClass().getName() + " getAllRelationBill size:" + allRelationBill.size() + " time:" + (t1 - t0)));
        }
        return allRelationBill;
    }

    @Override
    public ArrayList<String> getAllRelationBill(Context ctx, IObjectValue billInfo, Map<String, RecordBaseInfo> contents) throws Exception {
        long t0 = System.currentTimeMillis();
        ArrayList<String> allRelationBill = this.billHandler.getAllRelationBill(ctx, billInfo, contents);
        if (this.logFlag) {
            long t1 = System.currentTimeMillis();
            logger.error((Object)(this.billHandler.getClass().getName() + " getAllRelationBill_new size:" + allRelationBill.size() + " time:" + (t1 - t0)));
        }
        return allRelationBill;
    }

    @Override
    public IObjectCollection getObjectCollection(Context ctx, BOSObjectType bosType, EntityViewInfo viewInfo) throws Exception {
        long t0 = System.currentTimeMillis();
        IObjectCollection objectCollection = this.billHandler.getObjectCollection(ctx, bosType, viewInfo);
        if (this.logFlag) {
            long t1 = System.currentTimeMillis();
            logger.error((Object)(this.billHandler.getClass().getName() + " getObjectCollection size:" + objectCollection.size() + " time:" + (t1 - t0)));
        }
        return objectCollection;
    }

    @Override
    public boolean existsBill(Context ctx, String billId) throws BOSException {
        return this.billHandler.existsBill(ctx, billId);
    }

    @Override
    public void setXmlBaseProperties(Context ctx, XmlBase xmlBase, RecordBaseInfo content, int index) throws Exception {
        long t0 = System.currentTimeMillis();
        this.billHandler.setXmlBaseProperties(ctx, xmlBase, content, index);
        if (this.logFlag) {
            long t1 = System.currentTimeMillis();
            logger.error((Object)(this.billHandler.getClass().getName() + " setXmlBaseProperties time:" + (t1 - t0)));
        }
    }

    @Override
    public InputStream getBillAttachmentIs(Context ctx, ArchInfo archInfo, FileInfo fileInfo) throws Exception {
        long t0 = System.currentTimeMillis();
        InputStream billAttachmentIs = this.billHandler.getBillAttachmentIs(ctx, archInfo, fileInfo);
        if (this.logFlag) {
            long t1 = System.currentTimeMillis();
            logger.error((Object)(this.billHandler.getClass().getName() + " getBillAttachmentIs recordbaseId:" + archInfo.getRecordBaseId() + " time:" + (t1 - t0)));
        }
        return billAttachmentIs;
    }

    @Override
    public InputStream getBillPdfIs(Context ctx, RecordBaseInfo content, ArchInfo info, FileInfo fileInfo) throws Exception {
        long t0 = System.currentTimeMillis();
        InputStream billPdfIs = this.billHandler.getBillPdfIs(ctx, content, info, fileInfo);
        if (this.logFlag) {
            long t1 = System.currentTimeMillis();
            logger.error((Object)(this.billHandler.getClass().getName() + " getBillPdfIs recordbaseId:" + content.getId() + " recordbaseNumber:" + content.getNumber() + " time:" + (t1 - t0)));
        }
        return billPdfIs;
    }

    @Override
    public Map<String, byte[]> getReceiptPdfs(Context ctx, RecordBaseInfo content, List<XmlBase> xmlBaseList) throws Exception {
        long t0 = System.currentTimeMillis();
        Map<String, byte[]> receiptPdfs = this.billHandler.getReceiptPdfs(ctx, content, xmlBaseList);
        if (this.logFlag) {
            long t1 = System.currentTimeMillis();
            logger.error((Object)(this.billHandler.getClass().getName() + " getReceiptPdfs recordbaseId:" + content.getId() + " recordbaseNumber:" + content.getNumber() + " xmlBaseList size:" + xmlBaseList.size() + " time:" + (t1 - t0)));
        }
        if (null == receiptPdfs) {
            return new HashMap<String, byte[]>();
        }
        return receiptPdfs;
    }

    @Override
    public void revokeArch(Context ctx, ArcRecordInfo info) throws Exception {
        long t0 = System.currentTimeMillis();
        this.billHandler.revokeArch(ctx, info);
        if (this.logFlag) {
            long t1 = System.currentTimeMillis();
            logger.error((Object)(this.billHandler.getClass().getName() + " revokeArch1 : time:" + (t1 - t0)));
        }
    }
}

