/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.el.rec.model.OtherReportFilter;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.engine.HasTemplateReportParsingEngineUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.rpt.IReportBase;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.ReportBaseCollection;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SingleReportParsingEngineUtil
extends HasTemplateReportParsingEngineUtil {
    @Override
    protected ReportBaseInfo getReportBaseInfo(Context ctx, OtherReportFilter orFilter, SelectorItemCollection selector) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = this.getReportBaseFilterCsl(ctx, orFilter);
        view.setFilter(filter);
        view.setSelector(selector);
        IReportBase reportBase = this.getIReportBaseCsl(ctx);
        if (reportBase.exists(filter)) {
            ReportBaseCollection coll = reportBase.getReportBaseCollection(view);
            for (int i = 0; coll != null && i < coll.size(); ++i) {
                if (coll.get(i).get("isCommitReport") == null || !Boolean.parseBoolean(coll.get(i).get("isCommitReport") + "")) continue;
                return coll.get(i);
            }
            logger.error((Object)" has no commitreport");
            return reportBase.getReportBaseCollection(view).get(0);
        }
        filter = this.getReportBaseFilterRpt(ctx, orFilter);
        reportBase = this.getIReportBaseRpt(ctx);
        if (reportBase.exists(filter)) {
            ReportBaseCollection coll = reportBase.getReportBaseCollection(view);
            for (int i = 0; coll != null && i < coll.size(); ++i) {
                if (coll.get(i).get("isSupportGroup") == null || IsSupportGroupReportEnum.getEnum((String)(coll.get(i).get("isSupportGroup") + "")).getValue() != 1) continue;
                return coll.get(i);
            }
            logger.error((Object)" has no isSupportGroup");
            return reportBase.getReportBaseCollection(view).get(0);
        }
        return null;
    }

    private IReportBase getIReportBaseCsl(Context ctx) throws BOSException {
        return CslReportFactory.getLocalInstance((Context)ctx);
    }

    private IReportBase getIReportBaseRpt(Context ctx) throws BOSException {
        return ReportFactory.getLocalInstance((Context)ctx);
    }

    protected FilterInfo getReportBaseFilterRpt(Context ctx, OtherReportFilter orFilter) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("committedStatus", (Object)3));
        TemplateInfo templateInfo = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo(H.PK(orFilter.getTemplateId()));
        filter.getFilterItems().add(new FilterItemInfo("template.number", (Object)templateInfo.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("template.templateType", (Object)templateInfo.getTemplateType().getValue()));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)orFilter.getPeriodType().getValue()));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)orFilter.getYear()));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)orFilter.getPeriod()));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orFilter.getOrgId()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)orFilter.getCurrencyInfo().getId().toString()));
        return filter;
    }

    private FilterInfo getReportBaseFilterCsl(Context ctx, OtherReportFilter orFilter) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("committedStatus", (Object)3));
        TemplateInfo templateInfo = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo(H.PK(orFilter.getTemplateId()));
        filter.getFilterItems().add(new FilterItemInfo("template.number", (Object)templateInfo.getNumber()));
        if (templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT)) {
            HashSet<Integer> types = new HashSet<Integer>();
            types.add(templateInfo.getTemplateType().getValue());
            types.add(RptTmpTypeEnum.GROUPREPORT.getValue());
            filter.getFilterItems().add(new FilterItemInfo("template.templateType", types, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("template.templateType", (Object)templateInfo.getTemplateType().getValue()));
        }
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)orFilter.getPeriodType().getValue()));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)orFilter.getYear()));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)orFilter.getPeriod()));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orFilter.getOrgId()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)orFilter.getCurrencyInfo().getId().toString()));
        return filter;
    }

    @Override
    public List<Map<String, Object>> supportExportFileType() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("name", "EXCEL");
        map1.put("value", "xlsx");
        list.add(map1);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("name", "PDF");
        map2.put("value", "pdf");
        list.add(map2);
        return list;
    }

    @Override
    protected String getDefaultExportFileType() {
        return "xlsx";
    }
}

