/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.assets;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.BillTypeFactory;
import com.kingdee.eas.el.rec.BillTypeInfo;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.model.ReverseReportMsgInfo;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.PeriodUtil;
import com.kingdee.eas.el.rec.tool.engine.WithoutEntityReportParsingEngineUtil;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.FaListRptObject;
import com.kingdee.eas.fi.fa.rpt.IFaList;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class AssetsReportParsingEngineUtil
extends WithoutEntityReportParsingEngineUtil {
    private final String filePath;
    protected static Logger logger = Logger.getLogger(AssetsReportParsingEngineUtil.class);

    public AssetsReportParsingEngineUtil() {
        this.filePath = null;
    }

    private Object fillData(Context ctx, ReportFilter info, PeriodCollection perCol, String billTypeNumber) throws Exception {
        Object print = null;
        if ("GDAssetsDiscard".equals(billTypeNumber)) {
            print = this.GDAssetsClear(ctx, info);
        } else if ("GDAssets".equals(billTypeNumber)) {
            print = this.getGDAssets(ctx, info);
        }
        return print;
    }

    private Object GDAssetsClear(Context ctx, ReportFilter info) throws BOSException, EASBizException, SQLException, IOException {
        String whereSql = this.getWhereSql(info);
        String countSql = this.getClearBillCountSql(whereSql);
        String querySql = this.getClearBillSql(whereSql);
        logger.error((Object)("GDAssetsDiscard--sql:" + querySql));
        SXSSFWorkbook returnWb = this.export2excel(countSql, querySql, this.filePath);
        if (returnWb == null) {
            logger.error((Object)"GDAssetsDiscard--returnWb:null");
            return null;
        }
        InputStream returnInputStream = this.workbook2InputStream(returnWb);
        logger.error((Object)"GDAssetsClear success");
        return returnInputStream;
    }

    private Object getGDAssets(Context ctxx, ReportFilter info) throws BOSException, EASBizException, SQLException, IOException {
        IFaList manager = FaListFactory.getLocalInstance((Context)this.ctx);
        Map map = manager.buildData(this.getEntityViewInfo(info), "com.kingdee.eas.fi.fa.rpt.app.dao.FaListDao");
        String tempTableName = map.get("tempTableName").toString();
        SXSSFWorkbook returnWb = this.export2excel(tempTableName, this.filePath);
        if (returnWb == null) {
            logger.error((Object)"getGDAssets--returnWb:null");
            return null;
        }
        InputStream returnInputStream = this.workbook2InputStream(returnWb);
        logger.error((Object)"getGDAssets success");
        return returnInputStream;
    }

    private Object GDAssetsReportClear() {
        Object assetsReportClear = null;
        return assetsReportClear;
    }

    @Override
    public List<ReverseReportMsgInfo> revokeArch(Context ctx, List<ReportFilter> filterList) throws Exception {
        return null;
    }

    @Override
    public WithoutEntityReportParsingEngineUtil.WithoutEntityXmlSrcobj fillReportDataSources(Context ctx, ReportFilter info, WithoutEntityReportParsingEngineUtil.WithoutEntityXmlSrcobj xmlObj) throws Exception {
        RecordBaseInfo reInfo = info.getRecordBaseInfo();
        BillTypeInfo billType = reInfo.getBillType();
        String billTypeNumber = null;
        if (billType.getNumber() == null) {
            billType = BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo(H.PK(billType.getId()));
            reInfo.setBillType(billType);
            billTypeNumber = billType.getNumber();
        } else {
            billTypeNumber = billType.getNumber();
        }
        String oql = "select *, baseCurrency.id,baseCurrency.number, baseCurrency.name where id = '" + info.getOrgId() + "'";
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(oql);
        PeriodInfo periodInfo = new PeriodInfo();
        int periodYear = Integer.parseInt(info.getYear());
        int periodNumber = Integer.parseInt(info.getPeriod());
        periodInfo.setPeriodYear(periodYear);
        periodInfo.setPeriodNumber(periodNumber);
        periodInfo.setNumber(periodYear * 100 + periodNumber);
        PeriodCollection perCol = PeriodUtil.transformToPeriods(ctx, periodInfo, info.getReportCycleType(), company);
        xmlObj.put("id", BOSUuid.create((String)billTypeNumber));
        HashMap<String, String> orgMap = new HashMap<String, String>();
        FullOrgUnitInfo org = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(H.PK(info.getOrgId()));
        orgMap.put("number", org.getNumber());
        orgMap.put("name", org.getName());
        orgMap.put("id", info.getOrgId());
        xmlObj.put("reportType", info.getRecordBaseInfo().getName());
        Object obj = this.fillData(ctx, info, perCol, billTypeNumber);
        if (null == obj) {
            return null;
        }
        xmlObj.put("fileOutPutIO", obj);
        xmlObj.put("currency", info.getCurrency() == null ? company.getBaseCurrency().getName() : info.getCurrency().getName());
        return xmlObj;
    }

    protected IRowSet queryData4excel(Context ctx, String querySql, Map map) throws BOSException, EASBizException {
        if ("excute".equals(map.get("excute"))) {
            DbUtil.execute((Context)ctx, (String)querySql);
            return null;
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
        return rowSet;
    }

    public SXSSFWorkbook export2excel(String[] columnKeysCh, String[] columnKeysEn, String querySql, String countSql, String filePath) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("count", "count");
        IRowSet countRowSet = this.queryData4excel(this.ctx, countSql, map);
        int count = 0;
        SXSSFWorkbook wb = null;
        try {
            if (countRowSet.next()) {
                count = countRowSet.getInt("count");
                if (0 == count) {
                    logger.error((Object)"countRowSet:0");
                    return null;
                }
                int SHEET_SIZE = 1000000;
                int INSERT_SIZE = 1000000;
                int remainder = count % 1000000;
                int sheetCount = count / 1000000;
                if (remainder > 0) {
                    ++sheetCount;
                }
                int FRESH_SIZE = 5000;
                wb = new SXSSFWorkbook(5000);
                HashMap map2 = new HashMap();
                IRowSet queryRowSet = this.queryData4excel(this.ctx, querySql, map2);
                for (int sheetAmount = 1; sheetAmount <= sheetCount; ++sheetAmount) {
                    SXSSFSheet sh = wb.createSheet("\u5bfc\u51faexcel\u8868" + sheetAmount);
                    Row row0 = sh.createRow(0);
                    for (int i = 0; i < columnKeysCh.length; ++i) {
                        Cell newCell = row0.createCell(i);
                        newCell.setCellValue(columnKeysCh[i]);
                    }
                }
                int rowNum = 1;
                int fromRow = 1;
                int sheetNum = 0;
                while (queryRowSet.next()) {
                    SXSSFSheet sh = wb.getSheetAt(sheetNum);
                    Row row = sh.createRow(rowNum);
                    for (int j = 0; j < columnKeysEn.length; ++j) {
                        String newColumnKey = columnKeysEn[j];
                        String queryColumn = queryRowSet.getString(newColumnKey);
                        queryColumn = this.changeNum2Str(newColumnKey, queryColumn);
                        Cell newCell = row.createCell(j);
                        newCell.setCellValue(queryColumn);
                    }
                    if (rowNum == 1000000) {
                        ++sheetNum;
                        rowNum = fromRow;
                        continue;
                    }
                    ++rowNum;
                }
                queryRowSet.close();
                return wb;
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)"----------------------------export2excel\u62a5\u9519  ");
            logger.error((Object)e, (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String changeNum2Str(String key, String value) {
        if ("ISOVERAGED".equals(key)) {
            if ("1".equals(value)) {
                value = "\u662f";
            } else if ("0".equals(value)) {
                value = "\u5426";
            }
        } else if ("effectedStatus".equals(key)) {
            if ("1".equals(value)) {
                value = "\u6682\u5b58";
            } else if ("2".equals(value)) {
                value = "\u751f\u6548";
            }
        } else if ("checkedStatus".equals(key)) {
            if ("1".equals(value)) {
                value = "\u672a\u5ba1\u6838";
            } else if ("2".equals(value)) {
                value = "\u5df2\u5ba1\u6838";
            }
        } else if ("deletedStatus".equals(key)) {
            if ("1".equals(value)) {
                value = "\u666e\u901a";
            } else if ("2".equals(value)) {
                value = "\u4f5c\u5e9f";
            }
        } else if ("FIVOUCHERED".equals(key)) {
            if ("1".equals(value)) {
                value = "\u662f";
            } else if ("0".equals(value)) {
                value = "\u5426";
            }
        } else if ("BIZCARD.ISEVALEDBEFORE".equals(key)) {
            if ("1".equals(value)) {
                value = "\u662f";
            } else if ("0".equals(value)) {
                value = "\u5426";
            }
        }
        return value;
    }

    public InputStream workbook2InputStream(SXSSFWorkbook workbook) throws BOSException {
        ByteArrayInputStream in = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] bookByteAry = out.toByteArray();
            ByteArrayInputStream byteArrayInputStream = in = new ByteArrayInputStream(bookByteAry);
            return byteArrayInputStream;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private SXSSFWorkbook export2excel(String tempTableName, String filePath) throws BOSException, EASBizException {
        String countSql = "select count(1) as count from " + tempTableName;
        String querySql = "select * from " + tempTableName + " where assetnumber != '\u5408\u8ba1'  union all select * from " + tempTableName + " where assetnumber = '\u5408\u8ba1' ";
        String[] columnKeysCh = new String[]{"\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u522b", "\u56fa\u5b9a\u8d44\u4ea7\u7f16\u7801", "\u539f\u8d44\u4ea7\u7f16\u7801", "\u6761\u5f62\u7801", "\u56fa\u5b9a\u8d44\u4ea7\u540d\u79f0", "\u89c4\u683c", "\u8ba1\u91cf\u5355\u4f4d", "\u8d44\u4ea7\u6570\u91cf", "\u7ba1\u7406\u90e8\u95e8", "\u4f7f\u7528\u90e8\u95e8", "\u4f7f\u7528\u4eba", "\u4fdd\u7ba1\u4eba", "\u4f7f\u7528\u5730\u70b9", "\u6298\u65e7\u5206\u644a\u4fe1\u606f", "\u5b9e\u7269\u5165\u8d26\u65e5\u671f", "\u8d22\u52a1\u5165\u8d26\u65e5\u671f", "\u5e01\u522b", "\u539f\u5e01\u91d1\u989d", "\u8d44\u4ea7\u539f\u503c", "\u8fdb\u9879\u7a0e\u989d", "\u9884\u8ba1\u5904\u7f6e\u6536\u5165", "\u9884\u8ba1\u5f03\u7f6e\u8d39\u7528", "\u8bc4\u4f30\u4ef7\u503c", "\u5df2\u6298\u65e7\u671f\u95f4\u6570", "\u9884\u8ba1\u4f7f\u7528\u671f\u95f4\u6570", "\u8bc4\u4f30\u5269\u4f59\u671f\u95f4\u6570", "\u672c\u671f\u5b9e\u63d0\u6298\u65e7\u989d", "\u672c\u671f\u6298\u65e7\u7387", "\u7d2f\u8ba1\u6298\u65e7", "\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7", "\u9884\u8ba1\u51c0\u6b8b\u503c", "\u51c0\u6b8b\u503c\u7387%", "\u51cf\u503c\u51c6\u5907", "\u51c0\u503c", "\u6765\u6e90\u65b9\u5f0f", "\u903e\u9f84\u8d44\u4ea7", "\u6298\u65e7\u65b9\u6cd5", "\u56fa\u5b9a\u8d44\u4ea7\u79d1\u76ee", "\u7d2f\u8ba1\u6298\u65e7\u79d1\u76ee", "\u51cf\u503c\u51c6\u5907\u79d1\u76ee", "\u516c\u53f8", "\u5907\u6ce8", "\u4fdd\u4fee\u671f\u9650\uff08\u5e74\uff09", "\u4fdd\u4fee\u53f7"};
        String[] columnKeysEn = new String[]{"ASSETCAT_NAME", "ASSETNUMBER", "OLDERNUMBER", "BARCODE", "ASSETNAME", "SPECS", "MEASUREUNIT_NAME", "ASSETAMT", "DEPT_NAME", "USEDEPARTMENT", "USEPERSON", "KEEPER_NAME", "STORECITY_NAME", "COSTCENTER", "ACCOUNTDATE", "FIACCOUNTDATE", "CURRENCY_NAME", "ORIGINAMT", "ASSETVALUE", "INPUTTAX", "TREATMENTINCOME", "ADDONS", "INITEVALVALUE", "DEPRTERMCOUNT", "USETERMCOUNT", "EVALLEFTPERIOD", "DEPRTTERM", "MONTHDEPRERATE", "ACCUDEPR", "ACCUDEPRTYEAR", "NEATREMVALUE", "NEATLEFTRATE", "DECVALUE", "NEATVALUE", "ORIGINMETHOD_NAME", "ISOVERAGED", "DEPRMETHOD_NAME", "ACNTASSET_NAME", "ACNTACCDEPR_NAME", "ACNTDECVAL", "COMPANY_NAME", "REMARK", "WRTYPERIOD", "WRTYNUMBER"};
        return this.export2excel(columnKeysCh, columnKeysEn, querySql, countSql, filePath);
    }

    private SXSSFWorkbook export2excel(String countSql, String querySql, String filePath) throws BOSException, EASBizException {
        String[] columnKeysEn = new String[]{"FaClearBill.number", "FaClearBill.clearDate", "clearMode.name", "FaClearBill.description", "bizCard.number", "bizCard.oldNumber", "BIZCARD.GROUPNUMBER", "bizCard.barCode", "bizCard.assetName", "assetCat.name", "bizCard.specs", "measureUnit.name", "bizCard.assetAmt", "clearBillEntry.clrQty", "clearBillEntry.clrOriginal", "clearBillEntry.clrAddupDep", "clearBillEntry.clrDecPrep", "clearBillEntry.clrFare", "clearBillEntry.clrEvalValue", "clearBillEntry.splithDeal", "clearBillEntry.spilthMoveIn", "clearBillEntry.price", "clearBillEntry.spilthIncome", "effectedStatus", "checkedStatus", "deletedStatus", "FIVOUCHERED", "handler.name", "auditor.name", "clearBillEntry.comment", "BIZCARD.ISEVALEDBEFORE", "clearBillEntry.seq"};
        String[] columnKeysCh = new String[]{"\u5355\u636e\u7f16\u53f7", "\u6e05\u7406\u65e5\u671f", "\u6e05\u7406\u65b9\u5f0f", "\u6458\u8981", "\u56fa\u5b9a\u8d44\u4ea7\u7f16\u7801", "\u539f\u8d44\u4ea7\u7f16\u7801", "\u96c6\u56e2\u8d44\u4ea7\u7f16\u7801", "\u6761\u5f62\u7801", "\u56fa\u5b9a\u8d44\u4ea7\u540d\u79f0", "\u8d44\u4ea7\u7c7b\u522b", "\u89c4\u683c\u578b\u53f7", "\u8ba1\u91cf\u5355\u4f4d", "\u8d44\u4ea7\u6570\u91cf", "\u6e05\u7406\u6570\u91cf", "\u6e05\u7406\u539f\u503c", "\u6e05\u7406\u7d2f\u8ba1\u6298\u65e7", "\u6e05\u7406\u51cf\u503c\u51c6\u5907", "\u5f03\u7f6e\u8d39\u7528", "\u6e05\u7406\u8bc4\u4f30\u4ef7\u503c", "\u6b8b\u6599\u5904\u7406\u65b9\u5f0f", "\u6b8b\u6599\u5165\u5e93\u6210\u672c", "\u51fa\u552e\u91d1\u989d", "\u5904\u7f6e\u6536\u5165", "\u751f\u6548\u72b6\u6001", "\u5ba1\u6838\u72b6\u6001", "\u4f5c\u5e9f\u72b6\u6001", "\u5df2\u751f\u6210\u51ed\u8bc1", "\u7ecf\u624b\u4eba", "\u5ba1\u6838\u4eba", "\u5907\u6ce8", "\u5df2\u8bc4\u4f30", "\u6e05\u7406\u5206\u5f55\u5355\u5e8f\u53f7"};
        return this.export2excel(columnKeysCh, columnKeysEn, querySql, countSql, filePath);
    }

    private String getClearBillCountSql(String whereSql) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT count(DISTINCT CLEARBILLENTRY.fid) as count ");
        sb.append("FROM T_FA_ClearBill AS \"FACLEARBILL\" ");
        sb.append(" LEFT OUTER JOIN T_FA_AlterMode AS \"CLEARMODE\" ON \"FACLEARBILL\".FClearModeID = \"CLEARMODE\".FID");
        sb.append(" LEFT OUTER JOIN T_PM_User AS \"HANDLER\" ON \"FACLEARBILL\".FHandlerID = \"HANDLER\".FID");
        sb.append(" LEFT OUTER JOIN T_PM_User AS \"AUDITOR\" ON \"FACLEARBILL\".FAuditorID = \"AUDITOR\".FID");
        sb.append(" LEFT OUTER JOIN T_ORG_Company AS \"COMPANY\" ON \"FACLEARBILL\".FCompanyID = \"COMPANY\".FID");
        sb.append(" LEFT OUTER JOIN T_FA_ClearBillEntry AS \"CLEARBILLENTRY\" ON \"FACLEARBILL\".FID = \"CLEARBILLENTRY\".FEntryID");
        sb.append(" LEFT OUTER JOIN T_FA_FaBizCard AS \"BIZCARD\" ON \"CLEARBILLENTRY\".FBizCardID = \"BIZCARD\".FID");
        sb.append(" LEFT OUTER JOIN T_FA_FaBakCard AS \"FABAKCARD\" ON \"BIZCARD\".FFaBakCardID = \"FABAKCARD\".FID");
        sb.append(" LEFT OUTER JOIN T_FA_FaBizCostCenter AS \"FABIZCOSTCENTER\" ON \"CLEARBILLENTRY\".FBizCardID = \"FABIZCOSTCENTER\".FFaBizCardID");
        sb.append(" LEFT OUTER JOIN T_FA_Cat AS \"ASSETCAT1\" ON \"FABAKCARD\".FAssetCatID = \"ASSETCAT1\".FID");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS \"MEASUREUNIT1\" ON \"FABAKCARD\".FMeasureUnitID = \"MEASUREUNIT1\".FID");
        sb.append(" LEFT OUTER JOIN T_BD_AsstActType AS \"ASSTACTTYPE\" ON \"FABIZCOSTCENTER\".FAsstActTypeID = \"ASSTACTTYPE\".FID");
        sb.append(" LEFT OUTER JOIN T_FA_AssistActItem AS \"ASSTACTITEM\" ON \"FABIZCOSTCENTER\".FAsstActItem = \"ASSTACTITEM\".FID");
        sb.append(" LEFT OUTER JOIN T_FA_FaBizAsstActComposit AS \"FABIZASSTACTCOMPOSIT\" ON \"FABIZCOSTCENTER\".FID = \"FABIZASSTACTCOMPOSIT\".FFaBizCostCenterID");
        sb.append(" LEFT OUTER JOIN T_BD_AsstActType AS \"ASSTACTTYPE_COMPOSIT\" ON \"FABIZASSTACTCOMPOSIT\".FAsstActType = \"ASSTACTTYPE_COMPOSIT\".FID");
        sb.append(" LEFT OUTER JOIN T_FA_AssistActItem AS \"ASSTACTITEM_COMPOSIT\" ON \"FABIZASSTACTCOMPOSIT\".FAsstActItem = \"ASSTACTITEM_COMPOSIT\".FID");
        sb.append(" inner join t_bd_period p on p.fid = FACLEARBILL.FPeriodID ");
        sb.append(whereSql);
        sb.append(" and CLEARMODE.FName_l2 = '\u62a5\u5e9f' ");
        return sb.toString();
    }

    private String getClearBillSql(String whereSql) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT DISTINCT \"FACLEARBILL\".FClearDate AS \"FACLEARBILL.CLEARDATE\" ,");
        sb.append("\"CLEARMODE\".FName_l2 AS \"CLEARMODE.NAME\", ");
        sb.append("\"FACLEARBILL\".FDescription AS \"FACLEARBILL.DESCRIPTION\", ");
        sb.append("\"FACLEARBILL\".FNumber AS \"FACLEARBILL.NUMBER\", ");
        sb.append("\"FABAKCARD\".FNumber AS \"BIZCARD.NUMBER\", ");
        sb.append("\"FABAKCARD\".FAssetName AS \"BIZCARD.ASSETNAME\", ");
        sb.append("\"ASSETCAT1\".FName_l2 AS \"ASSETCAT.NAME\", ");
        sb.append("\"FABAKCARD\".FSpecs AS \"BIZCARD.SPECS\", ");
        sb.append("\"MEASUREUNIT1\".FName_l2 AS \"MEASUREUNIT.NAME\", ");
        sb.append("\"FABAKCARD\".FAssetAmt AS \"BIZCARD.ASSETAMT\", ");
        sb.append("\"CLEARBILLENTRY\".FClrQty AS \"CLEARBILLENTRY.CLRQTY\", ");
        sb.append("\"CLEARBILLENTRY\".FClrOriginal AS \"CLEARBILLENTRY.CLRORIGINAL\", ");
        sb.append("\"CLEARBILLENTRY\".FClrAddupDep AS \"CLEARBILLENTRY.CLRADDUPDEP\", ");
        sb.append("\"CLEARBILLENTRY\".FClrDecPrep AS \"CLEARBILLENTRY.CLRDECPREP\", ");
        sb.append("\"CLEARBILLENTRY\".FClrFare AS \"CLEARBILLENTRY.CLRFARE\", ");
        sb.append("\"CLEARBILLENTRY\".FClrEvalValue AS \"CLEARBILLENTRY.CLREVALVALUE\",");
        sb.append("\"CLEARBILLENTRY\".FSplithDeal AS \"CLEARBILLENTRY.SPLITHDEAL\", ");
        sb.append("\"CLEARBILLENTRY\".FSpilthMoveIn AS \"CLEARBILLENTRY.SPILTHMOVEIN\", ");
        sb.append("\"CLEARBILLENTRY\".FSpilthIncome AS \"CLEARBILLENTRY.SPILTHINCOME\", ");
        sb.append("\"FACLEARBILL\".FEffectedStatus AS \"EFFECTEDSTATUS\", ");
        sb.append("\"FACLEARBILL\".FCheckedStatus AS \"CHECKEDSTATUS\", ");
        sb.append("\"FACLEARBILL\".FDeletedStatus AS \"DELETEDSTATUS\", ");
        sb.append("\"FACLEARBILL\".FFiVouchered AS \"FIVOUCHERED\", ");
        sb.append("\"HANDLER\".FName_l2 AS \"HANDLER.NAME\", ");
        sb.append("\"AUDITOR\".FName_l2 AS \"AUDITOR.NAME\", ");
        sb.append("\"CLEARBILLENTRY\".FComment AS \"CLEARBILLENTRY.COMMENT\", ");
        sb.append("\"FACLEARBILL\".FCompanyID AS \"COMPANY.ID\",");
        sb.append("\"COMPANY\".FName_l2 AS \"COMPANY.NAME\", ");
        sb.append("\"CLEARBILLENTRY\".FID AS \"CLEARBILLENTRY.ID\", ");
        sb.append("\"CLEARBILLENTRY\".FBizCardID AS \"BIZCARD.ID\", ");
        sb.append("\"FACLEARBILL\".FID AS \"ID\", ");
        sb.append("\"BIZCARD\".FGroupNumber AS \"BIZCARD.GROUPNUMBER\", ");
        sb.append("\"BIZCARD\".FIsEvaledBefore AS \"BIZCARD.ISEVALEDBEFORE\", ");
        sb.append("\"BIZCARD\".FOldNumber AS \"BIZCARD.OLDNUMBER\", ");
        sb.append("\"BIZCARD\".FBarCode AS \"BIZCARD.BARCODE\", ");
        sb.append("\"CLEARBILLENTRY\".FPrice AS \"CLEARBILLENTRY.PRICE\", ");
        sb.append("\"CLEARBILLENTRY\".FSeq AS \"CLEARBILLENTRY.SEQ\", ");
        sb.append("\"FACLEARBILL\".FSourceBillID AS \"SOURCEBILLID\" ");
        sb.append("FROM T_FA_ClearBill AS \"FACLEARBILL\" ");
        sb.append(" LEFT OUTER JOIN T_FA_AlterMode AS \"CLEARMODE\" ON \"FACLEARBILL\".FClearModeID = \"CLEARMODE\".FID");
        sb.append(" LEFT OUTER JOIN T_PM_User AS \"HANDLER\" ON \"FACLEARBILL\".FHandlerID = \"HANDLER\".FID");
        sb.append(" LEFT OUTER JOIN T_PM_User AS \"AUDITOR\" ON \"FACLEARBILL\".FAuditorID = \"AUDITOR\".FID");
        sb.append(" LEFT OUTER JOIN T_ORG_Company AS \"COMPANY\" ON \"FACLEARBILL\".FCompanyID = \"COMPANY\".FID");
        sb.append(" LEFT OUTER JOIN T_FA_ClearBillEntry AS \"CLEARBILLENTRY\" ON \"FACLEARBILL\".FID = \"CLEARBILLENTRY\".FEntryID");
        sb.append(" LEFT OUTER JOIN T_FA_FaBizCard AS \"BIZCARD\" ON \"CLEARBILLENTRY\".FBizCardID = \"BIZCARD\".FID");
        sb.append(" LEFT OUTER JOIN T_FA_FaBakCard AS \"FABAKCARD\" ON \"BIZCARD\".FFaBakCardID = \"FABAKCARD\".FID");
        sb.append(" LEFT OUTER JOIN T_FA_FaBizCostCenter AS \"FABIZCOSTCENTER\" ON \"CLEARBILLENTRY\".FBizCardID = \"FABIZCOSTCENTER\".FFaBizCardID");
        sb.append(" LEFT OUTER JOIN T_FA_Cat AS \"ASSETCAT1\" ON \"FABAKCARD\".FAssetCatID = \"ASSETCAT1\".FID");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS \"MEASUREUNIT1\" ON \"FABAKCARD\".FMeasureUnitID = \"MEASUREUNIT1\".FID");
        sb.append(" LEFT OUTER JOIN T_BD_AsstActType AS \"ASSTACTTYPE\" ON \"FABIZCOSTCENTER\".FAsstActTypeID = \"ASSTACTTYPE\".FID");
        sb.append(" LEFT OUTER JOIN T_FA_AssistActItem AS \"ASSTACTITEM\" ON \"FABIZCOSTCENTER\".FAsstActItem = \"ASSTACTITEM\".FID");
        sb.append(" LEFT OUTER JOIN T_FA_FaBizAsstActComposit AS \"FABIZASSTACTCOMPOSIT\" ON \"FABIZCOSTCENTER\".FID = \"FABIZASSTACTCOMPOSIT\".FFaBizCostCenterID");
        sb.append(" LEFT OUTER JOIN T_BD_AsstActType AS \"ASSTACTTYPE_COMPOSIT\" ON \"FABIZASSTACTCOMPOSIT\".FAsstActType = \"ASSTACTTYPE_COMPOSIT\".FID");
        sb.append(" LEFT OUTER JOIN T_FA_AssistActItem AS \"ASSTACTITEM_COMPOSIT\" ON \"FABIZASSTACTCOMPOSIT\".FAsstActItem = \"ASSTACTITEM_COMPOSIT\".FID");
        sb.append(" inner join t_bd_period p on p.fid = FACLEARBILL.FPeriodID ");
        sb.append(whereSql);
        sb.append(" and CLEARMODE.FName_l2 = '\u62a5\u5e9f' ");
        return sb.toString();
    }

    private String getWhereSql(ReportFilter info) {
        String orgId = info.getOrgId();
        String orgInSql = " ( '" + orgId + "' )";
        String mounth = null;
        mounth = info.getPeriod().length() == 1 ? "0" + info.getPeriod() : info.getPeriod();
        String periodNumber = info.getYear() + mounth;
        String periodInSql = " ( '" + periodNumber + "' )";
        String whereSql = " where FACLEARBILL.FCompanyID in " + orgInSql + " and p.fnumber in " + periodInSql;
        return whereSql;
    }

    private EntityViewInfo getEntityViewInfo(ReportFilter info) throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        SorterItemCollection coll = new SorterItemCollection();
        ev.setSorter(coll);
        HashMap<String, Object> conMap = new HashMap<String, Object>();
        conMap.put("isSumStyle", false);
        conMap.put("defCompanyLevel", 1);
        conMap.put("change", false);
        conMap.put("def_company_id", info.getOrgId());
        conMap.put("completeclean", false);
        conMap.put("isIncludeAllClear", true);
        conMap.put("partclean", false);
        conMap.put("new", false);
        conMap.put("isShowNotAudit", false);
        conMap.put("month", Integer.parseInt(info.getPeriod()));
        conMap.put("year", Integer.parseInt(info.getYear()));
        String companyId = info.getOrgId();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)companyId));
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
        CompanyOrgUnitInfo[] companyIds = new CompanyOrgUnitInfo[]{companyOrgUnitInfo};
        conMap.put("company", companyIds);
        conMap.put("IsUserDefineSort", false);
        conMap.put("initperiod", false);
        ArrayList sumItemList = new ArrayList();
        conMap.put("sumOption", sumItemList);
        HashMap<String, ArrayList<FaListRptObject>> map = new HashMap<String, ArrayList<FaListRptObject>>();
        map.put("selOption", this.getSelOption());
        ev.put("selectfield", map);
        ev.put("customcond", conMap);
        return ev;
    }

    private ArrayList<FaListRptObject> getSelOption() {
        ArrayList<FaListRptObject> list = new ArrayList<FaListRptObject>();
        String[] selOptionArray = new String[]{"DEPRMETHOD_NAME", "MEASUREUNITWL_NAME", "KEEPER_NAME", "DEPT_NAME", "MEASUREUNIT_NAME", "STORECITY_NAME", "assetAccount.fnumber", "accDeprAccount.fnumber", "decAccount.fnumber", "ASSETCAT_NAME", "ORIGINMETHOD_NAME", "USESTATUS_NAME", "ECONOMICPURP_NAME", "EvalDeprMethod.fnumber", "EvalMeasureUnit.fnumber", "CostCenter", "USEDEPARTMENT", "usePerson"};
        for (int i = 0; i < selOptionArray.length; ++i) {
            FaListRptObject flo = new FaListRptObject();
            flo.setColumnKey(selOptionArray[i]);
            flo.setSelected(true);
            list.add(flo);
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> supportExportFileType() {
        List<Map<String, Object>> list = super.supportExportFileType();
        HashMap<String, String> mapPdf = new HashMap<String, String>(1);
        mapPdf.put("name", "PDF");
        mapPdf.put("value", "pdf");
        list.add(mapPdf);
        return list;
    }

    @Override
    protected String getDefaultExportFileType() {
        return "xlsx";
    }
}

