/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.tool.engine.cas.CASRptBaseService;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.IBankStatement;
import com.kingdee.eas.fm.common.ConvertUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CASBankStatementService
extends CASRptBaseService {
    private Logger logger = Logger.getLogger(this.getClass());

    @Override
    protected Set getAllData() throws BOSException {
        HashSet<BankStatementCollection> set = new HashSet<BankStatementCollection>();
        try {
            BankStatementCollection tempColl = new BankStatementCollection();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection filterItems = filter.getFilterItems();
            filterItems.add(new FilterItemInfo("accountBank.id", (Object)this.accountBankSet, CompareType.INCLUDE));
            filterItems.add(new FilterItemInfo("accountView.id", (Object)this.accountSet, CompareType.INCLUDE));
            filterItems.add(new FilterItemInfo("company.id", (Object)this.company.getId(), CompareType.EQUALS));
            filterItems.add(new FilterItemInfo("period.id", (Object)this.periodSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("accountBank.*"));
            sic.add(new SelectorItemInfo("accountView.*"));
            view.setSelector(sic);
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("accountBank.id"));
            sorter.add(new SorterItemInfo("createDate"));
            sorter.add(new SorterItemInfo("createTime"));
            sorter.add(new SorterItemInfo("lineNo"));
            view.setSorter(sorter);
            BankStatementCollection coll = BankStatementFactory.getLocalInstance((Context)this.ctx).getBankStatementCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                if (i == 0) {
                    tempColl.add(coll.get(i));
                }
                if (i > 0 && coll.get(i).getAccountBank().getId().toString().equals(coll.get(i - 1).getAccountBank().getId().toString())) {
                    tempColl.add(coll.get(i));
                } else if (i > 0) {
                    BankStatementCollection realTempColl = (BankStatementCollection)tempColl.clone();
                    set.add(realTempColl);
                    tempColl.clear();
                    tempColl.add(coll.get(i));
                }
                if (i != coll.size() - 1) continue;
                set.add(tempColl);
            }
        }
        catch (BOSException e) {
            this.logger.error((Object)e);
        }
        return set;
    }

    @Override
    protected InputStream getPrint(Set data) {
        if (data == null || data.size() == 0) {
            return null;
        }
        String[] BankStatementHead = new String[]{"\u65e5\u671f", "\u6458\u8981", "\u501f\u65b9\u91d1\u989d", "\u8d37\u65b9\u91d1\u989d", "\u4f59\u989d", "\u52fe\u5bf9", "\u6765\u6e90"};
        Iterator it = data.iterator();
        int index = 0;
        XSSFRow xssfRow = null;
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        ByteArrayInputStream inputStream = null;
        while (it.hasNext()) {
            BankStatementCollection coll = (BankStatementCollection)it.next();
            String accountbank = coll.get(0).getAccountBank().getName();
            String number = coll.get(0).getAccountBank().getNumber();
            if (index > 0) {
                this.currentSheet = this.workbook.createSheet(index + 1 + accountbank + number);
            } else {
                this.workbook = new XSSFWorkbook();
                this.currentSheet = this.workbook.createSheet(index + 1 + accountbank + number);
            }
            xssfRow = this.currentSheet.createRow(0);
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.CreateFirstRow(xssfRow, BankStatementHead);
            BigDecimal balance = new BigDecimal(0);
            BigDecimal debitAmount = new BigDecimal(0);
            BigDecimal creditAmount = new BigDecimal(0);
            BigDecimal countDebitAmount = new BigDecimal(0);
            BigDecimal countCreditAmount = new BigDecimal(0);
            BigDecimal dayDebitAmount = new BigDecimal(0);
            BigDecimal dayCreditAmount = new BigDecimal(0);
            try {
                BankStatementInfo startinfo = this.getStartAmts(coll.get(0).getAccountBank().getId().toString(), coll.get(0).getCurrency().getId().toString(), coll.get(0).getAccountView().getId().toString(), this.company.getId().toString(), this.perCol.get(0), this.perCol.get(this.perCol.size() - 1), coll.get(0).getAccountView().getAccountTableID().getId().toString());
                BigDecimal startBalance = startinfo.getBigDecimal("balance");
                int rowIndex = 1;
                for (int i = 0; i < coll.size(); ++i) {
                    BankStatementInfo info = coll.get(i);
                    if (i == 0) {
                        map.put("balance", startBalance.setScale(2, 4).toString());
                        map.put("date", this.perCol.get(0).getBeginDate());
                        map.put("description", "\u671f\u521d\u4f59\u989d");
                        map.put("debitAmount", " ");
                        map.put("creditAmount", " ");
                        xssfRow = this.currentSheet.createRow(rowIndex++);
                        this.CreateCountRow(xssfRow, map, "CAS_BankStatement", null);
                    }
                    debitAmount = info.getDebitAmount();
                    countDebitAmount = countDebitAmount.add(debitAmount);
                    dayDebitAmount = dayDebitAmount.add(debitAmount).setScale(2, 4);
                    creditAmount = info.getCreditAmount();
                    countCreditAmount = countCreditAmount.add(creditAmount);
                    dayCreditAmount = dayCreditAmount.add(creditAmount).setScale(2, 4);
                    balance = startBalance.add(countCreditAmount.subtract(countDebitAmount)).setScale(2, 4);
                    xssfRow = this.currentSheet.createRow(rowIndex++);
                    this.CreateRow(xssfRow, null, info, balance, null);
                    if (i < coll.size() - 1 && !coll.get(i).getCreateDate().equals(coll.get(i + 1).getCreateDate())) {
                        map.put("balance", balance.toString());
                        map.put("date", coll.get(i).getCreateDate());
                        map.put("description", "\u672c\u65e5\u5408\u8ba1");
                        map.put("debitAmount", dayDebitAmount.toString());
                        map.put("creditAmount", dayCreditAmount.toString());
                        xssfRow = this.currentSheet.createRow(rowIndex++);
                        this.CreateCountRow(xssfRow, map, "CAS_BankStatement", null);
                        dayDebitAmount = new BigDecimal(0);
                        dayCreditAmount = new BigDecimal(0);
                    }
                    if (i != coll.size() - 1) continue;
                    map.put("balance", balance.setScale(2, 4).toString());
                    map.put("date", coll.get(i).getCreateDate());
                    map.put("description", "\u672c\u65e5\u5408\u8ba1");
                    map.put("debitAmount", dayDebitAmount.toString());
                    map.put("creditAmount", dayCreditAmount.toString());
                    xssfRow = this.currentSheet.createRow(rowIndex++);
                    this.CreateCountRow(xssfRow, map, "CAS_BankStatement", null);
                    map.put("date", this.perCol.get(0).getEndDate());
                    map.put("description", "\u672c\u671f\u5408\u8ba1");
                    map.put("debitAmount", countDebitAmount.setScale(2, 4).toString());
                    map.put("creditAmount", countCreditAmount.setScale(2, 4).toString());
                    xssfRow = this.currentSheet.createRow(rowIndex);
                    this.CreateCountRow(xssfRow, map, "CAS_BankStatement", null);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
            ++index;
        }
        XSSFWorkbook workbook = this.currentSheet.getWorkbook();
        try {
            workbook.write((OutputStream)boas);
            inputStream = new ByteArrayInputStream(boas.toByteArray());
            boas.close();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        return inputStream;
    }

    private BankStatementInfo getStartAmts(String bankId, String currencyId, String accountId, String companyId, PeriodInfo beginPeriodInfo, PeriodInfo endPeriodInfo, String AcctTableId) throws BOSException, EASBizException {
        IBankStatement iStmt = BankStatementFactory.getLocalInstance((Context)this.ctx);
        return iStmt.getDateStartData(ConvertUtils.PK((Object)companyId), ConvertUtils.PK((Object)bankId), ConvertUtils.PK((Object)currencyId), beginPeriodInfo.getBeginDate(), (Date)endPeriodInfo.getEndDate(), ConvertUtils.PK((Object)beginPeriodInfo), ConvertUtils.PK((Object)endPeriodInfo), ConvertUtils.PK((Object)accountId), ConvertUtils.PK((Object)AcctTableId));
    }

    @Override
    protected Object getPdfPrint(Set data, String printTemplate) {
        return null;
    }
}

