/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.BillTypeFactory;
import com.kingdee.eas.el.rec.BillTypeInfo;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.model.FileStreamInfo;
import com.kingdee.eas.el.rec.model.IXmlSrcObj;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.model.ReverseReportMsgInfo;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.KDNoteWebServerHelper;
import com.kingdee.eas.el.rec.tool.PeriodUtil;
import com.kingdee.eas.el.rec.tool.customer.CustomerFunction;
import com.kingdee.eas.el.rec.tool.engine.WithoutEntityReportParsingEngineUtil;
import com.kingdee.eas.el.rec.tool.engine.gl.GLReportGeneralLedgerService;
import com.kingdee.eas.el.rec.tool.engine.gl.GLRptAccountBalanceService;
import com.kingdee.eas.el.rec.tool.engine.gl.GLRptAsstactGDService;
import com.kingdee.eas.el.rec.tool.engine.gl.GLRptAsstactGGService;
import com.kingdee.eas.el.rec.tool.engine.gl.GLRptBaseService;
import com.kingdee.eas.el.rec.tool.engine.gl.GLRptSubLedgerService;
import com.kingdee.eas.el.rec.tool.engine.gl.SXSSFWorkbookUtils;
import com.kingdee.eas.el.rec.tool.engine.gl.provider.GlReportGeneralLedgerProvider;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGDCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGGCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class GLReportParsingEngineUtil
extends WithoutEntityReportParsingEngineUtil {
    private static Logger loggerNew = Logger.getLogger(GLReportParsingEngineUtil.class);
    private Object asstAct_fzzlx = "";
    private String dataSourceTable = "";
    public static final String RESOURCE_NAME = "com.kingdee.eas.fi.gl.rpt.GLRptCommonQueryResource";
    private int maxAccountLevel = 0;
    Map<String, Boolean> accountShowLongNameMap = new HashMap<String, Boolean>();
    Map<String, String> accountLongName = new HashMap<String, String>();

    private Object fillData(Context ctx, ReportFilter info, PeriodCollection perCol, String billTypeNumber) throws Exception {
        Object print = null;
        if ("GeneralLedger".equals(billTypeNumber)) {
            print = this.fillReportGeneralLedgerData(ctx, info, perCol, billTypeNumber);
        } else if ("Subledger".equals(billTypeNumber)) {
            print = this.fillSubLedgerData(ctx, info, perCol, billTypeNumber);
        } else if ("AuxiliaryGL".equals(billTypeNumber)) {
            print = this.fillAsstactGGData(ctx, info, perCol, billTypeNumber);
        } else if ("AuxiliarySubledger".equals(billTypeNumber)) {
            print = this.fillAsstactGDData(ctx, info, perCol, billTypeNumber);
            try {
                if (!"".equals(this.dataSourceTable)) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(this.dataSourceTable);
                }
            }
            catch (Exception exception) {}
        } else if ("AuxiliaryAccountBalance".equals(billTypeNumber)) {
            print = this.fillAccountBalanceData(ctx, info, perCol, billTypeNumber);
        }
        return print;
    }

    private Object fillAccountBalanceData(Context ctx, ReportFilter info, PeriodCollection perCol, String billTypeNumber) throws Exception {
        Map<String, Object> commonParams = this.getCommonParams(ctx, info, perCol);
        commonParams.put("showQty", true);
        HashMap<String, Object> rptCond = new HashMap<String, Object>();
        rptCond.putAll(commonParams);
        rptCond.put("chkDisplayAsstDetail", true);
        rptCond.put("OptionAmountAndBalZero", true);
        rptCond.put("AccountLevelEnd", this.maxAccountLevel > 0 ? this.maxAccountLevel : 1);
        GLRptAccountBalanceService glRptSubService = new GLRptAccountBalanceService();
        return this.getPrint(ctx, rptCond, glRptSubService, billTypeNumber);
    }

    private Map<String, Object> getCommonParams(Context ctx, ReportFilter info, PeriodCollection perCol) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(H.PK(info.getOrgId()));
        CurrencyInfo currencyInfo = info.getCurrency();
        String currencyId = null;
        String currencyName = null;
        if (currencyInfo != null) {
            currencyId = currencyInfo.getId().toString();
            currencyName = currencyInfo.getName();
        } else {
            CurrencyInfo curInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo(H.PK("11111111-1111-1111-1111-111111111111DEB58FDC"));
            currencyId = "11111111-1111-1111-1111-111111111111DEB58FDC";
            currencyName = curInfo.getName();
        }
        String periodTypeId = perCol.get(0).getPeriodType().getId().toString();
        Object[] formatParams = new Object[]{"{" + perCol.get(0).getPeriodNumber() + "}", "{nn}"};
        Object formatNumber = CustomerFunction.getFunctionByName("formatStr").execute(null, formatParams);
        String periodStart = perCol.get(0).getPeriodYear() + formatNumber.toString();
        formatParams[0] = "{" + perCol.get(perCol.size() - 1).getPeriodNumber() + "}";
        formatNumber = CustomerFunction.getFunctionByName("formatStr").execute(null, formatParams);
        String periodEnd = perCol.get(perCol.size() - 1).getPeriodYear() + formatNumber.toString();
        int periodYearStart = perCol.get(0).getPeriodYear();
        int periodYearEnd = perCol.get(perCol.size() - 1).getPeriodYear();
        int periodNumberStart = perCol.get(0).getPeriodNumber();
        int periodNumberEnd = perCol.get(perCol.size() - 1).getPeriodNumber();
        String templatePath = info.getRecordBaseInfo().getPrintTemplate();
        ArrayList<String> asstTypeIds = new ArrayList<String>();
        Object accountCodeStart = null;
        Object accountCodeEnd = null;
        Object accountViewStart = null;
        Object accountViewEnd = null;
        Set<String> accountIds = null;
        accountIds = null != info.getAcIdSet() ? info.getAcIdSet() : this.getAccountIdByOrg(company);
        ArrayList<AsstAccountInfo> asstActList = new ArrayList<AsstAccountInfo>();
        if (info.getAsstAccountInfo() != null) {
            this.asstAct_fzzlx = info.getAsstAccountInfo().getName() == null ? info.getAsstAccountInfo().getNumber() : info.getAsstAccountInfo().getName();
            asstActList.add(info.getAsstAccountInfo());
            String actTypeSql = "select fasstacttypeid  from T_BD_AsstActGroupDetail where FASSTACCOUNTID = ?";
            IRowSet rowdata = DbUtil.executeQuery((Context)ctx, (String)actTypeSql, (Object[])new Object[]{info.getAsstAccountInfo().getId().toString()});
            try {
                while (rowdata.next()) {
                    asstTypeIds.add(rowdata.getString("fasstacttypeid"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList asstTypeObjs = this.getAsstTypeColByIds(asstTypeIds);
        HashMap<String, Object> commonParams = new HashMap<String, Object>();
        commonParams.put("company", company);
        commonParams.put("periodTypeId", periodTypeId);
        commonParams.put("periodStart", periodStart);
        commonParams.put("periodEnd", periodEnd);
        commonParams.put("PeriodYearStart", periodYearStart);
        commonParams.put("PeriodYearEnd", periodYearEnd);
        commonParams.put("PeriodNumberStart", periodNumberStart);
        commonParams.put("PeriodNumberEnd", periodNumberEnd);
        commonParams.put("CurrencyID", currencyId);
        commonParams.put("CurrencyName", currencyName);
        commonParams.put("accountTableId", null);
        commonParams.put("AccountID", null);
        commonParams.put("AccountCodeStart", accountCodeStart);
        commonParams.put("AccountCodeEnd", accountCodeEnd);
        commonParams.put("AccountViewStart", accountViewStart);
        commonParams.put("AccountViewEnd", accountViewEnd);
        commonParams.put("asstActList", asstTypeObjs == null ? new ArrayList() : asstTypeObjs);
        commonParams.put("asstTypeList", asstTypeObjs == null ? new ArrayList() : asstTypeObjs);
        commonParams.put("templatePath", templatePath);
        commonParams.put("hashAccountIdSet", accountIds);
        commonParams.put("AccountLevelStart", 1);
        commonParams.put("AccountLevelEnd", 1);
        commonParams.put("exportFileType", this.getExportFileType(info.getRecordBaseInfo()));
        if (StringUtils.isNotBlank((CharSequence)info.getAccountName())) {
            commonParams.put("accountName", info.getAccountName());
        }
        if (StringUtils.isNotBlank((CharSequence)info.getAccountNumber())) {
            commonParams.put("accountNumber", info.getAccountNumber());
        }
        if (info.getAcIdSet() != null) {
            commonParams.put("accountIds", info.getAcIdSet());
        }
        if (asstActList.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("company", company);
            param.put("info", info);
            param.put("asstTypeObjs", asstTypeObjs);
            param.put("asstActList", asstActList);
            this.buildData(param);
            commonParams.put("dataSourceTable", this.dataSourceTable);
        }
        return commonParams;
    }

    private Set<String> getAccountIdByOrg(CompanyOrgUnitInfo company) throws BOSException {
        String companyId = company.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("level"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("companyId", (Object)companyId));
        view.setFilter(fi);
        HashSet<String> acIds = null;
        AccountViewCollection acs = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewCollection(view);
        if (acs != null && acs.size() > 0) {
            acIds = new HashSet<String>();
            int size = acs.size();
            for (int i = 0; i < size; ++i) {
                AccountViewInfo ac = acs.get(i);
                acIds.add(ac.getId().toString());
                int level = ac.getLevel();
                if (level <= this.maxAccountLevel) continue;
                this.maxAccountLevel = level;
            }
        }
        return acIds;
    }

    private List<Object> getAsstTypeColByIds(List<String> asstTypesIds) throws BOSException {
        if (asstTypesIds == null || asstTypesIds.isEmpty()) {
            return null;
        }
        if (asstTypesIds.size() == 1 && "".equals(asstTypesIds.get(0))) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        ArrayList<Object> asstactTypeEntitys = new ArrayList<Object>();
        for (String id : asstTypesIds) {
            AsstActTypeInfo asstTypeInfo = new AsstActTypeInfo();
            try {
                asstTypeInfo = AsstActTypeFactory.getLocalInstance((Context)this.ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(id));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            if (asstTypeInfo == null && asstTypeInfo.getId() == null) continue;
            asstactTypeEntitys.add(GLReportParsingEngineUtil.createAsstactTypeEntity(asstTypeInfo));
        }
        if (asstactTypeEntitys.size() == 0) {
            return null;
        }
        return asstactTypeEntitys;
    }

    public static AsstactTypeEntity createAsstactTypeEntity(AsstActTypeInfo info) {
        AsstactTypeEntity at = new AsstactTypeEntity();
        at.setId(info.getId().toString());
        at.setNumber(info.getNumber());
        at.setName(info.getName());
        at.setQueryName(info.getDefaultQueryName());
        at.setTableName(info.getRealtionDataObject());
        at.setForCompany(info.isIsForCompany());
        if (info.getGlAsstActTypeGrp() != null) {
            at.setGeneralAsstactGroupId(info.getGlAsstActTypeGrp().getId().toString());
        }
        at.setHgField(info.getMappingFieldName());
        at.setHgAttribute(info.getAsstHGAttribute());
        at.setGroupTable(info.getGroupTableName());
        at.setGroupField(info.getGroupMappingFieldName());
        at.setMultilevel(info.isIsMultilevel());
        at.setEnabledPermissionLimit(true);
        at.setPermissionItem(info.getPermissionItem());
        at.setUseLongNumber(info.isUseLongNumber());
        at.setSelected(true);
        at.setQtyAsst(info.isIsQty());
        if (info.getMeasureUnitGroup() != null) {
            at.setAsstMeasureUnitGroupId(info.getMeasureUnitGroup().getId().toString());
        }
        return at;
    }

    private Object fillAsstactGGData(Context ctx, ReportFilter info, PeriodCollection perCol, String billTypeNumber) throws Exception {
        Object returnObj = null;
        try {
            Map<String, Object> commonParams = this.getCommonParams(ctx, info, perCol);
            commonParams.put("hashAccountIdSet", null);
            commonParams.put("accountLevel", -1);
            HashMap<String, Object> rptCond = new HashMap<String, Object>();
            rptCond.putAll(commonParams);
            rptCond.put("OptionAmountAndBalZero", true);
            GLRptAsstactGGService glRptSubService = new GLRptAsstactGGService();
            returnObj = this.getPrint(ctx, rptCond, glRptSubService, billTypeNumber);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            loggerNew.error((Object)sw.getBuffer().toString());
            throw new Exception(e);
        }
        finally {
            if (!"".equals(this.dataSourceTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(this.dataSourceTable);
                this.dataSourceTable = "";
            }
        }
        return returnObj;
    }

    private Object fillAsstactGDData(Context ctx, ReportFilter info, PeriodCollection perCol, String billTypeNumber) throws Exception {
        Object returnObj = null;
        try {
            Map<String, Object> commonParams = this.getCommonParams(ctx, info, perCol);
            if (commonParams.get("asstTypeList") == null) {
                Object var7_8 = null;
                return var7_8;
            }
            List asstTypeList = (List)commonParams.get("asstTypeList");
            if (asstTypeList.size() == 0) {
                Object var8_10 = null;
                return var8_10;
            }
            HashMap<String, Object> rptCond = new HashMap<String, Object>();
            rptCond.putAll(commonParams);
            rptCond.put("OptionAmountAndBalZero", true);
            rptCond.put("recFlag", true);
            GLRptAsstactGDService glRptSubService = new GLRptAsstactGDService();
            returnObj = this.getPrint(ctx, rptCond, glRptSubService, billTypeNumber);
        }
        catch (Exception e) {
            loggerNew.error((Object)e.getMessage());
            throw new Exception(e);
        }
        finally {
            if (!"".equals(this.dataSourceTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(this.dataSourceTable);
                this.dataSourceTable = "";
            }
        }
        return returnObj;
    }

    private Object fillSubLedgerData(Context ctx, ReportFilter info, PeriodCollection perCol, String billTypeNumber) throws Exception {
        Map<String, Object> commonParams = this.getCommonParams(ctx, info, perCol);
        HashMap<String, Object> rptCond = new HashMap<String, Object>();
        rptCond.putAll(commonParams);
        rptCond.put("OptionOnlyAsst", true);
        rptCond.put("OptionAmountZero", false);
        rptCond.put("OptionOnlyLeaf", true);
        rptCond.put("OptionAmountAndBalZero", true);
        Set<String> accountIds = info.getAcIdSet();
        if (accountIds != null && accountIds.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("isLeaf"));
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", accountIds, CompareType.INCLUDE));
            view.setFilter(fi);
            AccountViewCollection acs = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
            accountIds = new HashSet<String>();
            for (int i = 0; i < acs.size(); ++i) {
                AccountViewInfo accountViewInfo = acs.get(i);
                if (!accountViewInfo.isIsLeaf()) continue;
                accountIds.add(accountViewInfo.getId().toString());
            }
        }
        if (accountIds == null || accountIds.size() <= 0) {
            return null;
        }
        rptCond.put("accountIds", accountIds);
        boolean accountShowLongName = false;
        CompanyOrgUnitInfo companyOrgInfo = (CompanyOrgUnitInfo)rptCond.get("company");
        String accountId = accountIds.toArray(new String[0])[0];
        String companyOrgId = companyOrgInfo.getId().toString();
        if (!this.accountShowLongNameMap.containsKey(companyOrgId)) {
            Object obj = GlUtils.getParamByKey((Context)ctx, (String)companyOrgId, (String)"GL_012");
            accountShowLongName = obj == null ? false : Boolean.valueOf(obj.toString());
            this.accountShowLongNameMap.put(companyOrgId, accountShowLongName);
        } else {
            accountShowLongName = this.accountShowLongNameMap.get(companyOrgId);
        }
        if (accountShowLongName) {
            AccountViewInfo accountviewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId));
            rptCond.put("accountName", accountviewInfo.getDisplayName());
            this.accountLongName.put(accountId, accountviewInfo.getDisplayName());
        }
        GLRptSubLedgerService glRptSubService = new GLRptSubLedgerService();
        return this.getPrint(ctx, rptCond, glRptSubService, billTypeNumber);
    }

    private Object fillReportGeneralLedgerData(Context ctx, ReportFilter info, PeriodCollection perCol, String billTypeNumber) throws Exception {
        Map<String, Object> rptCond = this.getCommonParams(ctx, info, perCol);
        rptCond.put("AccountLevelEnd", this.maxAccountLevel > 0 ? this.maxAccountLevel : 1);
        GLReportGeneralLedgerService glReportGenService = new GLReportGeneralLedgerService();
        EntityViewInfo view = glReportGenService.buildQueryCondition(rptCond);
        Map<String, Object> data = glReportGenService.getAllData(ctx, view, (CompanyOrgUnitInfo)rptCond.get("company"));
        if (null == data) {
            return null;
        }
        if (null == rptCond.get("exportFileType") || ((String)rptCond.get("exportFileType")).equals("xlsx") || ((String)rptCond.get("exportFileType")).equals("xls")) {
            return this.getExcelInputStreamRGL(data, billTypeNumber);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(data);
        String[] cols = new String[]{"FAccountNumber", "FAccountName", "FCompany", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriod", "FDescOfVoucher", "FDebitQty", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQty", "FCreditFor", "FCreditLocal", "FCreditRpt", "FQty", "FPrice", "FBalanceOritention", "FBalanceAmountFor", "FBalanceAmountLocal", "FBalanceAmountRpt"};
        params.put("strGetColumnName", cols);
        params.put("bBF", false);
        params.put("printByAccount", false);
        params.put("iScal", new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 2, 2, 2, 0, 2, 2, 0, 2, 2, 0});
        params.put("alPeriods", GLReportParsingEngineUtil.getPeriods(ctx, (Integer)rptCond.get("PeriodYearStart"), (Integer)rptCond.get("PeriodYearEnd")));
        params.put("currency", rptCond.get("CurrencyName"));
        params.put("period", this.getPeriodDisplay(ctx, rptCond).replace("\u671f\u95f4:", ""));
        params.put("yearBegin", rptCond.get("PeriodYearStart"));
        params.put("numberBegin", rptCond.get("PeriodNumberStart"));
        params.put("yearEnd", rptCond.get("PeriodYearEnd"));
        params.put("numberEnd", rptCond.get("PeriodNumberEnd"));
        params.put("company", ((CompanyOrgUnitInfo)rptCond.get("company")).getName());
        GlReportGeneralLedgerProvider provider = new GlReportGeneralLedgerProvider(ctx, params);
        KDNoteWebServerHelper kdNoteHelper = new KDNoteWebServerHelper();
        InputStream reStream = kdNoteHelper.exportPDF(ctx, rptCond.get("templatePath").toString(), provider);
        return reStream;
    }

    private Object getPrint(Context ctx, Map<String, Object> rptCond, GLRptBaseService glRptSubService, String billTypeNumber) throws Exception {
        Map<String, Object> data;
        GLRptAsstactGDCondition condition;
        EntityViewInfo view = glRptSubService.buildQueryCondition(ctx, rptCond);
        if (glRptSubService instanceof GLRptAsstactGDService) {
            condition = (GLRptAsstactGDCondition)view.get("GLFixCondition");
            condition.setDataSourceTable(this.dataSourceTable);
            view.put("GLFixCondition", (Object)condition);
            view.put("isFromElRec", (Object)true);
        }
        if (glRptSubService instanceof GLRptAsstactGGService) {
            condition = (GLRptAsstactGGCondition)view.get("GLFixCondition");
            condition.setDataSourceTable(this.dataSourceTable);
            view.put("GLFixCondition", (Object)condition);
            view.put("isFromElRec", (Object)true);
        }
        if (null == (data = glRptSubService.getAllData(ctx, view))) {
            return null;
        }
        if (null == rptCond.get("exportFileType") || ((String)rptCond.get("exportFileType")).equals("xlsx") || ((String)rptCond.get("exportFileType")).equals("xls")) {
            return this.getExcelInputStream(data, billTypeNumber, rptCond);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ctx", ctx);
        params.putAll(data);
        params.put("cond", rptCond.get("rptCond"));
        params.put("setting", glRptSubService.getPrintSetting(ctx, rptCond));
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("qtyScale", 2);
        vars.put("priceScale", 2);
        vars.put("currencyId", rptCond.get("CurrencyID"));
        vars.put("currency", rptCond.get("CurrencyName"));
        vars.put("currencyName", rptCond.get("CurrencyName"));
        vars.put("Period", this.getPeriodDisplay(ctx, rptCond));
        vars.put("company", (CompanyOrgUnitInfo)rptCond.get("company"));
        vars.put("asstTypeList", rptCond.get("asstTypeList"));
        vars.put("AsstAct", this.asstAct_fzzlx.toString());
        if (null != rptCond.get("accountName")) {
            vars.put("accountName", rptCond.get("accountName"));
        }
        if (null != rptCond.get("accountNumber")) {
            vars.put("accountNumber", rptCond.get("accountNumber"));
        }
        params.put("vars", vars);
        Class clazz = glRptSubService.getRptPrintProvider(ctx);
        Constructor constructor = clazz.getConstructor(Map.class);
        Object provider = constructor.newInstance(params);
        KDNoteWebServerHelper kdNoteHelper = new KDNoteWebServerHelper();
        InputStream[] reStream = kdNoteHelper.exportPDFs(ctx, rptCond.get("templatePath").toString(), provider);
        return reStream;
    }

    private Object getExcelInputStreamRGL(Map<String, Object> data, String billTypeNumber) throws Exception {
        ArrayList datasArray = (ArrayList)data.get("rowSet");
        Object[] dataNew = null;
        ExcelPrintConfigs excelPrintConfigs = new ExcelPrintConfigs(billTypeNumber);
        String[] name = excelPrintConfigs.getName();
        String[] name0 = excelPrintConfigs.getReportGeneralLedgerName0();
        SXSSFWorkbookUtils sxssfWorkbookUtils = SXSSFWorkbookUtils.createSXSSFWorkbookInstance();
        Sheet createSheet = sxssfWorkbookUtils.createSheet();
        sxssfWorkbookUtils.setSheetHeader(createSheet, name, 1);
        sxssfWorkbookUtils.setSheetHeader(createSheet, name0, 0);
        createSheet.addMergedRegion(new CellRangeAddress(0, 1, 0, 0));
        createSheet.addMergedRegion(new CellRangeAddress(0, 1, 1, 1));
        createSheet.addMergedRegion(new CellRangeAddress(0, 1, 2, 2));
        createSheet.addMergedRegion(new CellRangeAddress(0, 1, 3, 3));
        createSheet.addMergedRegion(new CellRangeAddress(0, 1, 4, 4));
        createSheet.addMergedRegion(new CellRangeAddress(0, 1, 5, 5));
        createSheet.addMergedRegion(new CellRangeAddress(0, 0, 6, 7));
        ArrayList<List<Object>> rowDatas = new ArrayList<List<Object>>();
        ArrayList<Object> sheetRowData = null;
        InputStream inputStream = null;
        try {
            for (int i = 0; i < datasArray.size(); ++i) {
                dataNew = (Object[])datasArray.get(i);
                sheetRowData = new ArrayList<Object>();
                sheetRowData.add(dataNew[0]);
                sheetRowData.add(dataNew[1]);
                sheetRowData.add(dataNew[6]);
                sheetRowData.add(dataNew[7]);
                sheetRowData.add(dataNew[10]);
                sheetRowData.add(dataNew[14]);
                sheetRowData.add(dataNew[18]);
                sheetRowData.add(dataNew[20]);
                rowDatas.add(sheetRowData);
            }
            sxssfWorkbookUtils.createSheetRows(createSheet, rowDatas);
            inputStream = sxssfWorkbookUtils.toInputStream();
        }
        catch (Exception e) {
            loggerNew.error((Object)e.getMessage());
            throw new Exception(e);
        }
        return inputStream;
    }

    private int getAsstActCount(String[] cols) {
        int count = 0;
        for (String col : cols) {
            if (!col.matches("FAsstAccountName\\d+")) continue;
            ++count;
        }
        return count;
    }

    private Object getExcelInputStream(Map<String, Object> data, String billTypeNumber, Map<String, Object> rptCond) throws BOSException, IOException {
        GLRptRowSet datasSet = (GLRptRowSet)data.get("rowSet");
        SXSSFWorkbookUtils sxssfWorkbookUtils = SXSSFWorkbookUtils.createSXSSFWorkbookInstance();
        Sheet createSheet = sxssfWorkbookUtils.createSheet();
        ExcelPrintConfigs excelPrintConfigs = null;
        String[] number = null;
        String[] name = null;
        String[] cols = datasSet.getColumKeys();
        int actCount = this.getAsstActCount(cols);
        if ("AuxiliaryAccountBalance".equals(billTypeNumber) || "Subledger".equals(billTypeNumber)) {
            excelPrintConfigs = new ExcelPrintConfigs(billTypeNumber, datasSet, true);
            number = excelPrintConfigs.getNumberByCols(cols);
            name = excelPrintConfigs.getNameByCols(cols, excelPrintConfigs.config1);
        } else {
            excelPrintConfigs = new ExcelPrintConfigs(billTypeNumber, datasSet);
            number = excelPrintConfigs.getNumber();
            name = excelPrintConfigs.getName();
        }
        if ("AuxiliaryAccountBalance".equals(billTypeNumber)) {
            String[] name0 = excelPrintConfigs.getNameByCols(cols, excelPrintConfigs.config0);
            sxssfWorkbookUtils.setSheetHeader(createSheet, name0, 0);
            sxssfWorkbookUtils.setSheetHeader(createSheet, name, 1);
        } else {
            sxssfWorkbookUtils.setSheetHeader(createSheet, name);
        }
        if ("AuxiliaryAccountBalance".equals(billTypeNumber)) {
            createSheet.addMergedRegion(new CellRangeAddress(0, 1, 0, 0));
            createSheet.addMergedRegion(new CellRangeAddress(0, 1, 1, 1));
            if (actCount > 0) {
                createSheet.addMergedRegion(new CellRangeAddress(0, 1, 2, 1 + actCount));
            }
            createSheet.addMergedRegion(new CellRangeAddress(0, 0, 2 + actCount, 3 + actCount));
            createSheet.addMergedRegion(new CellRangeAddress(0, 0, 4 + actCount, 5 + actCount));
            createSheet.addMergedRegion(new CellRangeAddress(0, 0, 6 + actCount, 7 + actCount));
            createSheet.addMergedRegion(new CellRangeAddress(0, 0, 8 + actCount, 9 + actCount));
            createSheet.addMergedRegion(new CellRangeAddress(0, 0, 10 + actCount, 11 + actCount));
        } else if ("Subledger".equals(billTypeNumber)) {
            if (actCount > 0 && 6 + actCount > 7) {
                createSheet.addMergedRegion(new CellRangeAddress(0, 0, 7, 6 + actCount));
            }
            createSheet.addMergedRegion(new CellRangeAddress(0, 0, 9 + actCount, 10 + actCount));
        }
        ArrayList<List<Object>> rowDatas = new ArrayList<List<Object>>();
        ArrayList<Object> sheetRowData = null;
        InputStream inputStream = null;
        if (datasSet.size() < 1) {
            return null;
        }
        datasSet.beforeFirst();
        try {
            while (datasSet.next()) {
                sheetRowData = new ArrayList<Object>();
                if ("Subledger".equals(billTypeNumber)) {
                    sheetRowData.add(rptCond.get("accountNumber"));
                    sheetRowData.add(rptCond.get("accountName"));
                }
                for (int j = 0; j < number.length; ++j) {
                    sheetRowData.add(datasSet.getObject(number[j]));
                }
                rowDatas.add(sheetRowData);
            }
            sxssfWorkbookUtils.createSheetRows(createSheet, rowDatas);
            inputStream = sxssfWorkbookUtils.toInputStream();
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw e;
        }
        return inputStream;
    }

    @Override
    public List<Map<String, Object>> supportExportFileType() {
        List<Map<String, Object>> list = super.supportExportFileType();
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("name", "PDF");
        map.put("value", "pdf");
        list.add(map);
        return list;
    }

    private String getPeriodDisplay(Context ctx, Map modelMap) {
        String period = "";
        String YEAR = this.getLocaleStr(ctx, "YEAR");
        String PERIODNUM = this.getLocaleStr(ctx, "PERIOD");
        String TO = this.getLocaleStr(ctx, "TO");
        if (modelMap == null || modelMap.isEmpty()) {
            return period;
        }
        String periodStart = String.valueOf(modelMap.get("periodStart"));
        String periodEnd = String.valueOf(modelMap.get("periodEnd"));
        period = periodStart.substring(0, 4) + YEAR;
        if (periodStart.equals(periodEnd)) {
            period = period + periodStart.substring(4) + PERIODNUM;
        } else {
            period = period + periodStart.substring(4) + PERIODNUM;
            period = period + TO;
            if (periodStart.substring(0, 4).equals(periodEnd.substring(0, 4))) {
                period = period + periodEnd.substring(4) + PERIODNUM;
            } else {
                period = period + periodEnd.substring(0, 4) + YEAR;
                period = period + periodEnd.substring(4) + PERIODNUM;
            }
        }
        return period;
    }

    private String getLocaleStr(Context ctx, String resName) {
        Locale locale = ctx.getLocale();
        return ResourceBase.getString((String)RESOURCE_NAME, (String)resName, (Locale)locale);
    }

    @Override
    public List<ReverseReportMsgInfo> revokeArch(Context ctx, List<ReportFilter> filterList) throws Exception {
        return null;
    }

    private static PeriodCollection getPeriodCollection(Context ctx, String strPeriodId, int PeriodYear) throws BOSException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        FilterInfo i = new FilterInfo();
        if (strPeriodId != null) {
            i.getFilterItems().add(new FilterItemInfo("periodType", (Object)strPeriodId, CompareType.EQUALS));
        }
        if (PeriodYear != -1) {
            i.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(PeriodYear), CompareType.EQUALS));
        } else if (PeriodYear == 0) {
            i.getFilterItems().add(new FilterItemInfo("periodYear", (Object)"", CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("periodYear"));
        evi.getSelector().add(new SelectorItemInfo("periodQuarter"));
        evi.getSelector().add(new SelectorItemInfo("periodNumber"));
        evi.getSelector().add(new SelectorItemInfo("beginDate"));
        evi.getSelector().add(new SelectorItemInfo("endDate"));
        evi.getSelector().add(new SelectorItemInfo("isAdjustPeriod"));
        evi.getSelector().add(new SelectorItemInfo("CU"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        return iPeriod.getPeriodCollection(evi);
    }

    protected static ArrayList getPeriods(Context ctx, int periodYearStart, int periodYearEnd) throws Exception {
        int i;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        CompanyOrgUnitInfo conpany = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
        String strPeriodId = conpany.getAccountPeriodType().getId().toString();
        int periodYear = 0;
        int periodNumber = 0;
        String periodStart = null;
        String periodEnd = null;
        PeriodCollection c = null;
        PeriodCollection pc = null;
        PeriodInfo info = null;
        ArrayList<PeriodCollection> alPeriodCollection = new ArrayList<PeriodCollection>();
        ArrayList<Object[]> alPeriods = new ArrayList<Object[]>();
        Object[] objPeriod = null;
        for (i = periodYearStart; i <= periodYearEnd; ++i) {
            c = GLReportParsingEngineUtil.getPeriodCollection(ctx, strPeriodId, i);
            alPeriodCollection.add(c);
        }
        int n = alPeriodCollection.size();
        for (i = 0; i < n; ++i) {
            pc = (PeriodCollection)alPeriodCollection.get(i);
            if (pc == null) continue;
            int m = pc.size();
            for (int j = 0; j < m; ++j) {
                info = pc.get(j);
                objPeriod = new Object[4];
                if (info == null) continue;
                periodYear = info.getPeriodYear();
                periodNumber = info.getPeriodNumber();
                periodStart = GlUtils.formatDate((DateFormat)format, (Date)info.getBeginDate());
                periodEnd = GlUtils.formatDate((DateFormat)format, (Date)info.getEndDate());
                objPeriod[0] = new Integer(periodYear);
                objPeriod[1] = new Integer(periodNumber);
                objPeriod[2] = periodStart;
                objPeriod[3] = periodEnd;
                alPeriods.add(objPeriod);
            }
        }
        return alPeriods;
    }

    @Override
    public WithoutEntityReportParsingEngineUtil.WithoutEntityXmlSrcobj createReportDataSources(Context ctx, ReportFilter info) throws Exception {
        GLWithoutEntityXmlSrcobj glWithoutEntityXmlSrcobj = new GLWithoutEntityXmlSrcobj();
        glWithoutEntityXmlSrcobj.put("exportFileType", info.getRecordBaseInfo().getExportFileType());
        glWithoutEntityXmlSrcobj.put("hasTemplate", !StringUtils.isEmpty((CharSequence)info.getRecordBaseInfo().getPrintTemplate()));
        return glWithoutEntityXmlSrcobj;
    }

    @Override
    public WithoutEntityReportParsingEngineUtil.WithoutEntityXmlSrcobj fillReportDataSources(Context ctx, ReportFilter info, WithoutEntityReportParsingEngineUtil.WithoutEntityXmlSrcobj xmlObj) throws Exception {
        RecordBaseInfo reInfo = info.getRecordBaseInfo();
        BillTypeInfo billType = reInfo.getBillType();
        String billTypeNumber = null;
        if (billType.getNumber() == null) {
            billType = BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo(H.PK(billType.getId()));
            reInfo.setBillType(billType);
            billTypeNumber = billType.getNumber();
        } else {
            billTypeNumber = billType.getNumber();
        }
        String oql = "select *, baseCurrency.id,baseCurrency.number, baseCurrency.name where id = '" + info.getOrgId() + "'";
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(oql);
        PeriodInfo periodInfo = new PeriodInfo();
        int periodYear = Integer.parseInt(info.getYear());
        int periodNumber = Integer.parseInt(info.getPeriod());
        periodInfo.setPeriodYear(periodYear);
        periodInfo.setPeriodNumber(periodNumber);
        periodInfo.setNumber(periodYear * 100 + periodNumber);
        PeriodCollection perCol = PeriodUtil.transformToPeriods(ctx, periodInfo, info.getReportCycleType(), company);
        xmlObj.put("id", BOSUuid.create((String)billTypeNumber));
        HashMap<String, String> orgMap = new HashMap<String, String>();
        FullOrgUnitInfo org = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(H.PK(info.getOrgId()));
        orgMap.put("number", org.getNumber());
        orgMap.put("name", org.getName());
        orgMap.put("id", info.getOrgId());
        xmlObj.put("reportType", info.getRecordBaseInfo().getName());
        Object obj = this.fillData(ctx, info, perCol, billTypeNumber);
        if (null == obj) {
            return null;
        }
        xmlObj.put("fileOutPutIO", obj);
        xmlObj.put("currency", info.getCurrency() == null ? company.getBaseCurrency().getName() : info.getCurrency().getName());
        if ("Subledger".equals(billTypeNumber) && this.accountShowLongNameMap.get(company.getId().toString()).booleanValue()) {
            xmlObj.put("subj", this.accountLongName.get(info.getAcIdSet().toArray()[0]) == null ? "" : this.accountLongName.get(info.getAcIdSet().toArray()[0]));
        } else {
            xmlObj.put("subj", info.getAccountName() == null ? "" : info.getAccountName());
        }
        if ("AuxiliarySubledger".equals(billTypeNumber)) {
            xmlObj.put("asstActType", info.getAsstAccountInfo().getNumber());
        }
        xmlObj.put("subjno", info.getAccountNumber() == null ? "" : info.getAccountNumber());
        xmlObj.put("reportCycleType", info.getReportCycleType() == null ? "" : info.getReportCycleType());
        return xmlObj;
    }

    @Override
    protected String getDefaultExportFileType() {
        return "xlsx";
    }

    @Override
    protected FileStreamInfo excel2pdf(IXmlSrcObj iXmlSrcObj, InputStream is) throws Exception {
        boolean hasTemplate = (Boolean)iXmlSrcObj.get("hasTemplate");
        if (hasTemplate) {
            return new FileStreamInfo(is);
        }
        return super.excel2pdf(iXmlSrcObj, is);
    }

    protected String createTempTable(Map param) {
        List asstTypeObjs = (List)param.get("asstTypeObjs");
        StringBuffer fieldStruct = new StringBuffer();
        int cnt = 0;
        for (Object obj : asstTypeObjs) {
            AsstactTypeEntity asstEntity = (AsstactTypeEntity)obj;
            fieldStruct.append(asstEntity.getHgField() + " VARCHAR(44)");
            if (++cnt == asstTypeObjs.size()) continue;
            fieldStruct.append(",");
        }
        String name = "assActTypeValueTree";
        String struct = "KSQL_SEQ INT IDENTITY (1, 1)," + fieldStruct;
        String createTableSql = "create table " + name + " (" + struct + ")";
        String temTableId = "";
        try {
            temTableId = TempTablePool.getInstance((Context)this.ctx).createTempTable(createTableSql);
        }
        catch (Exception e) {
            return null;
        }
        return temTableId;
    }

    protected void buildData(Map param) {
        this.dataSourceTable = this.createTempTable(param);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        ReportFilter info = (ReportFilter)param.get("info");
        List asstTypeObjs = (List)param.get("asstTypeObjs");
        List asstActList = (List)param.get("asstActList");
        AsstAccountInfo asstTypeInfo = (AsstAccountInfo)asstActList.get(0);
        String orgId = company.getId().toString();
        String period = info.getYear() + (info.getPeriod().length() == 1 ? "0" + info.getPeriod() : info.getPeriod());
        String currencyId = info.getCurrency() == null ? company.getBaseCurrency().getId().toString() : info.getCurrency().getId().toString();
        String accountTableId = company.getAccountTable().getId().toString();
        StringBuffer hgField = new StringBuffer();
        StringBuffer insertField = new StringBuffer();
        for (int i = 0; i < asstTypeObjs.size(); ++i) {
            AsstactTypeEntity entity = (AsstactTypeEntity)asstTypeObjs.get(i);
            hgField.append("hg." + entity.getHgField());
            insertField.append(entity.getHgField());
            if (i == asstTypeObjs.size() - 1) continue;
            hgField.append(",");
            insertField.append(",");
        }
        String zhCurr = "11111111-1111-1111-1111-111111111111DEB58FDC";
        String insertSql = "";
        insertSql = !currencyId.equals(zhCurr) ? "INSERT INTO " + this.dataSourceTable + "(" + insertField.toString() + ") \nSELECT " + hgField.toString() + " FROM T_GL_AssistBalance_1F B LEFT OUTER JOIN T_BD_AccountView AV ON av.FID = b.FAccountID LEFT OUTER JOIN T_BD_AssistantHG HG ON hg.FID = b.FAssistGrpId WHERE b.FOrgUnitID = '" + orgId + "' AND b.FPeriod IN (" + period + ") AND b.FCurrencyID = '" + currencyId + "' AND av.fcompanyid IN ('" + orgId + "') AND av.faccounttableid = '" + accountTableId + "' AND (av.fisProfitCenter <> '1') AND (av.fisProfitCenter <> 1) AND ((av.flevel >= 1) OR (b.FAccountID IS NULL)) AND hg.FAsstAccountID IN ('" + asstTypeInfo.getId().toString() + "') GROUP BY " + hgField.toString() : "INSERT INTO " + this.dataSourceTable + "(" + insertField.toString() + ") \nSELECT " + hgField.toString() + " FROM T_GL_AssistBalance_1F B LEFT OUTER JOIN T_BD_AccountView AV ON av.FID = b.FAccountID LEFT OUTER JOIN T_BD_AssistantHG HG ON hg.FID = b.FAssistGrpId WHERE b.FOrgUnitID = '" + orgId + "' AND b.FPeriod IN (" + period + ") AND av.fcompanyid IN ('" + orgId + "') AND av.faccounttableid = '" + accountTableId + "' AND (av.fisProfitCenter <> '1') AND (av.fisProfitCenter <> 1) AND ((av.flevel >= 1) OR (b.FAccountID IS NULL)) AND hg.FAsstAccountID IN ('" + asstTypeInfo.getId().toString() + "') GROUP BY " + hgField.toString();
        try {
            DbUtil.execute((Context)this.ctx, (String)insertSql.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class GLWithoutEntityXmlSrcobj
    extends WithoutEntityReportParsingEngineUtil.WithoutEntityXmlSrcobj {
        public GLWithoutEntityXmlSrcobj() {
            HashMap<String, Object> keyDefineMap = new HashMap<String, Object>(2);
            this.requireKeys.add("subjno");
            this.valueMap.put("subjno", null);
            this.keysMap.put("subjno", keyDefineMap);
            keyDefineMap.put("isRequire", true);
            keyDefineMap.put("desc", "\u79d1\u76ee\u7f16\u7801");
            keyDefineMap.put("emptyWarning", "\u4ea7\u751f\u7684\u62a5\u8868\u6570\u636e\u6e90GLWithoutEntityXmlSrcobj\u6ca1\u6709\u79d1\u76ee\u7f16\u7801.");
            keyDefineMap = new HashMap(2);
            this.requireKeys.add("subj");
            this.valueMap.put("subj", null);
            this.keysMap.put("subj", keyDefineMap);
            keyDefineMap.put("isRequire", true);
            keyDefineMap.put("desc", "\u79d1\u76ee\u540d\u79f0");
            keyDefineMap.put("emptyWarning", "\u4ea7\u751f\u7684\u62a5\u8868\u6570\u636e\u6e90GLWithoutEntityXmlSrcobj\u6ca1\u6709\u79d1\u76ee\u540d\u79f0.");
        }
    }

    public class ExcelPrintConfigs {
        public String billTypeNumber;
        public GLRptRowSet datasSet;
        public boolean dynamicGetCols;
        Map<String, String> config1;
        Map<String, String> config0;

        public ExcelPrintConfigs(String billTypeNumber, GLRptRowSet datasSet) {
            this(billTypeNumber, datasSet, false);
        }

        public ExcelPrintConfigs(String billTypeNumber, GLRptRowSet datasSet, boolean dynamicGetCols) {
            this.billTypeNumber = billTypeNumber;
            this.datasSet = datasSet;
            this.dynamicGetCols = dynamicGetCols;
            this.init();
        }

        private void init() {
            if (this.dynamicGetCols) {
                this.config1 = new HashMap<String, String>();
                this.config0 = new HashMap<String, String>();
                if ("GeneralLedger".equals(this.billTypeNumber)) {
                    this.initConfig(this.getReportGeneralLedgerNumber(), this.getReportGeneralLedgerName(), this.config1);
                    this.initConfig(this.getReportGeneralLedgerNumber(), this.getReportGeneralLedgerName0(), this.config0);
                } else if ("AuxiliaryAccountBalance".equals(this.billTypeNumber)) {
                    this.initConfig(this.getAccountBalanceNumber(), this.getAccountBalanceName(), this.config1);
                    this.initConfig(this.getAccountBalanceNumber(), this.getAccountBalanceName0(), this.config0);
                } else if ("AuxiliaryGL".equals(this.billTypeNumber)) {
                    this.initConfig(this.getAsstactGGNumber(), this.getAsstactGGName(), this.config1);
                } else if ("AuxiliarySubledger".equals(this.billTypeNumber)) {
                    this.initConfig(this.getAsstactGDNumber(), this.getAsstactGDName(), this.config1);
                } else if ("Subledger".equals(this.billTypeNumber)) {
                    this.initConfig(this.getSubLedgerNumber(), this.getSubLedgerName(), this.config1);
                }
            }
        }

        private void initConfig(String[] keys, String[] values, Map<String, String> config) {
            for (int i = 0; i < keys.length; ++i) {
                config.put(keys[i], values[i]);
            }
            config.put("FAsstAccountName", "\u6838\u7b97\u9879\u76ee");
        }

        public ExcelPrintConfigs(String billTypeNumber) {
            this.billTypeNumber = billTypeNumber;
        }

        public String[] getNumberByCols(String[] cols) {
            ArrayList<String> colNumList = new ArrayList<String>();
            for (int i = 0; i < cols.length; ++i) {
                if (this.config1.containsKey(cols[i])) {
                    colNumList.add(cols[i]);
                    continue;
                }
                if (!cols[i].contains("FAsstAccountName")) continue;
                colNumList.add(cols[i]);
            }
            return colNumList.toArray(new String[0]);
        }

        public String[] getNameByCols(String[] cols, Map<String, String> config) {
            ArrayList<String> colNameList = new ArrayList<String>();
            for (int i = 0; i < cols.length; ++i) {
                if (config.containsKey(cols[i])) {
                    colNameList.add(config.get(cols[i]));
                    continue;
                }
                if (!cols[i].contains("FAsstAccountName")) continue;
                colNameList.add(config.get("FAsstAccountName"));
            }
            if ("Subledger".equals(this.billTypeNumber)) {
                colNameList.add(0, config.get("accountNumber"));
                colNameList.add(1, config.get("accountName"));
            }
            return colNameList.toArray(new String[0]);
        }

        public String[] getNumber() {
            String[] result = null;
            result = this.billTypeNumber.equals("GeneralLedger") ? this.getReportGeneralLedgerNumber() : (this.billTypeNumber.equals("AuxiliaryAccountBalance") ? this.getAccountBalanceNumber() : (this.billTypeNumber.equals("AuxiliaryGL") ? this.getAsstactGGNumber() : (this.billTypeNumber.equals("AuxiliarySubledger") ? this.getAsstactGDNumber() : ("Subledger".equals(this.billTypeNumber) ? this.getSubLedgerNumber() : this.datasSet.getColumKeys()))));
            return result;
        }

        public String[] getName() {
            String[] result = null;
            result = this.billTypeNumber.equals("GeneralLedger") ? this.getReportGeneralLedgerName() : (this.billTypeNumber.equals("AuxiliaryAccountBalance") ? this.getAccountBalanceName() : (this.billTypeNumber.equals("AuxiliaryGL") ? this.getAsstactGGName() : (this.billTypeNumber.equals("AuxiliarySubledger") ? this.getAsstactGDName() : ("Subledger".equals(this.billTypeNumber) ? this.getSubLedgerName() : this.datasSet.getColumKeys()))));
            return result;
        }

        private String[] getReportGeneralLedgerNumber() {
            return new String[]{"FAccountNumber", "FAccountName", "FPeriod", "FDescOfVoucher", "FDebitLocal", "FCreditLocal", "FBalanceOritention", "FBalanceAmountLocal"};
        }

        private String[] getReportGeneralLedgerName() {
            return new String[]{"\u79d1\u76ee\u4ee3\u7801", "\u79d1\u76ee\u540d\u79f0", "\u671f\u95f4", "\u6458\u8981", "\u501f\u65b9", "\u8d37\u65b9", "\u65b9\u5411", "\u672c\u4f4d\u5e01"};
        }

        public String[] getReportGeneralLedgerName0() {
            return new String[]{"\u79d1\u76ee\u4ee3\u7801", "\u79d1\u76ee\u540d\u79f0", "\u671f\u95f4", "\u6458\u8981", "\u501f\u65b9", "\u8d37\u65b9", "\u4f59\u989d", "\u4f59\u989d"};
        }

        private String[] getAccountBalanceNumber() {
            return new String[]{"accountNumber", "accountName", "FYearBeginDebitBalanceLocal", "FYearBeginCreditBalanceLocal", "FBeginDebitBalanceLocal", "FBeginCreditBalanceLocal", "FDebitLocal", "FCreditLocal", "FYearDebitLocal", "FYearCreditLocal", "FEndDebitBalanceLocal", "FEndCreditBalanceLocal"};
        }

        private String[] getAccountBalanceName() {
            return new String[]{"\u79d1\u76ee\u4ee3\u7801", "\u79d1\u76ee\u540d\u79f0", "\u501f\u65b9", "\u8d37\u65b9", "\u501f\u65b9", "\u8d37\u65b9", "\u501f\u65b9", "\u8d37\u65b9", "\u501f\u65b9", "\u8d37\u65b9", "\u501f\u65b9", "\u8d37\u65b9"};
        }

        private String[] getAccountBalanceName0() {
            return new String[]{"\u79d1\u76ee\u4ee3\u7801", "\u79d1\u76ee\u540d\u79f0", "\u5e74\u521d\u4f59\u989d", "\u5e74\u521d\u4f59\u989d", "\u671f\u521d\u4f59\u989d", "\u671f\u521d\u4f59\u989d", "\u672c\u671f\u53d1\u751f\u989d", "\u672c\u671f\u53d1\u751f\u989d", "\u672c\u5e74\u7d2f\u8ba1", "\u672c\u5e74\u7d2f\u8ba1", "\u671f\u672b\u4f59\u989d", "\u671f\u672b\u4f59\u989d"};
        }

        private String[] getAsstactGGNumber() {
            return new String[]{"accountNumber", "accountName", "FPeriod", "beginAccountDC", "FBeginBalanceLocal", "FDebitLocal", "FCreditLocal", "FYearDebitLocal", "FYearCreditLocal", "endAccountDC", "FEndBalanceLocal"};
        }

        private String[] getAsstactGGName() {
            return new String[]{"\u79d1\u76ee\u4ee3\u7801", "\u79d1\u76ee\u540d\u79f0", "\u671f\u95f4", "\u671f\u521d\u4f59\u989d\u65b9\u5411", "\u671f\u521d\u4f59\u989d", "\u501f\u65b9", "\u8d37\u65b9", "\u672c\u5e74\u7d2f\u8ba1\u501f\u65b9", "\u672c\u5e74\u7d2f\u8ba1\u8d37\u65b9", "\u671f\u672b\u4f59\u989d\u65b9\u5411", "\u671f\u672b\u4f59\u989d"};
        }

        private String[] getAsstactGDNumber() {
            return new String[]{"accountNumber", "accountName", "FBookedDate", "FBizdate", "FPeriod", "voucherTypeName", "voucherNumber", "FDescription", "FSubDebitLocal", "FSubCreditLocal", "accountDC", "FEndBalanceLocal"};
        }

        private String[] getAsstactGDName() {
            return new String[]{"\u79d1\u76ee\u4ee3\u7801", "\u79d1\u76ee\u540d\u79f0", "\u8bb0\u8d26\u65e5\u671f", "\u4e1a\u52a1\u65e5\u671f", "\u671f\u95f4", "\u51ed\u8bc1\u7c7b\u578b", "\u51ed\u8bc1\u7f16\u53f7", "\u6458\u8981", "\u501f\u65b9", "\u8d37\u65b9", "\u4f59\u989d\u65b9\u5411", "\u4f59\u989d"};
        }

        private String[] getSubLedgerNumber() {
            return new String[]{"accountNumber", "accountName", "FBookedDate", "FBizdate", "voucherTypeName", "voucherNumber", "FDescription", "FSubDebitLocal", "FSubCreditLocal", "accountDC", "FEndBalanceLocal"};
        }

        private String[] getSubLedgerName() {
            return new String[]{"\u79d1\u76ee\u4ee3\u7801", "\u79d1\u76ee\u540d\u79f0", "\u8bb0\u8d26\u65e5\u671f", "\u4e1a\u52a1\u65e5\u671f", "\u51ed\u8bc1\u7c7b\u578b", "\u51ed\u8bc1\u7f16\u7801", "\u6458\u8981", "\u501f\u65b9", "\u8d37\u65b9", "\u4f59\u989d", "\u4f59\u989d"};
        }
    }
}

