/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.tool.engine.gl.GLRptSubLedgerService;
import com.kingdee.eas.el.rec.tool.engine.gl.setting.GLRptBasePrintSetting;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryResult;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class GLRptBaseService {
    private static Logger logger = Logger.getLogger(GLRptBaseService.class);

    protected abstract IGLRptBaseFacade getBizCtrl(Context var1) throws BOSException;

    protected abstract GLRptBaseCondition getRptCondition(Context var1, Map<String, Object> var2) throws CloneNotSupportedException;

    protected abstract Class getRptPrintProvider(Context var1);

    public EntityViewInfo buildQueryCondition(Context ctx, Map<String, Object> modelMap) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        GLRptBaseCondition rptCond = this.getRptCondition(ctx, modelMap);
        if (rptCond instanceof GLRptSubLedgerCondition) {
            rptCond.setLeafAccount(true);
            EntityViewInfo view1 = new EntityViewInfo();
            view1.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", modelMap.get("accountIds"), CompareType.INCLUDE));
            view1.setFilter(fi);
            AccountViewCollection acs = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view1);
            ((GLRptSubLedgerCondition)rptCond).setAccounts(acs);
        }
        rptCond.setExpandCompanyLevel(-1);
        modelMap.put("rptFilter", modelMap);
        modelMap.put("rptCond", rptCond);
        view.put("GLFixCondition", (Object)rptCond);
        view.put("PAGE_ROW_COUNT", (Object)0);
        String seqMaxCount = (String)modelMap.get("seqMaxCount");
        int iSeqMaxCount = 30;
        if (seqMaxCount != null && seqMaxCount.trim().length() > 0) {
            try {
                seqMaxCount = seqMaxCount.trim();
                iSeqMaxCount = Integer.parseInt(seqMaxCount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        view.put("CreateSeqTempTableMaxCount", (Object)iSeqMaxCount);
        return view;
    }

    public Map<String, Object> getAllData(Context ctx, EntityViewInfo view) throws BOSException, EASBizException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String queryId = "";
        try {
            GLRptQueryResult queryResult = this.getBizCtrl(ctx).query(view);
            queryId = queryResult.getQueryId();
            if (!StringUtils.isEmpty((String)queryId) && this instanceof GLRptSubLedgerService) {
                try {
                    String sql = "select 1 from " + queryId;
                    IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql);
                    if (!result.next()) {
                        Map<String, Object> map = null;
                        return map;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            int count = 0;
            GLRptRowSet rs = null;
            while (true) {
                GLRptRowSet rowSet = this.getBizCtrl(ctx).getData(queryId, count, 200);
                if (rs == null) {
                    rs = rowSet;
                } else {
                    rs.addRowSets(rowSet);
                }
                if (rowSet.size() < 200) break;
                count += 200;
            }
            GLRptRowSet sumRow = this.getBizCtrl(ctx).getSumData(queryId);
            if (sumRow != null) {
                while (sumRow.next()) {
                    int rowIndex = sumRow.getRowIndex();
                    String[] colKey = sumRow.getColumKeys();
                    for (int i = 0; i < colKey.length; ++i) {
                        rs.updateObject(rowIndex, colKey[i], sumRow.getObject(colKey[i]));
                    }
                }
            }
            this.getBizCtrl(ctx).releaseDataSource(queryId);
            if (null == rs || 0 == rs.size()) {
                Map<String, Object> map = null;
                return map;
            }
            data.put("rowSet", rs);
            data.put("head", queryResult.getTableHeadInfo());
        }
        catch (EASBizException e1) {
            throw e1;
        }
        catch (BOSException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new BOSException(e3.getMessage());
        }
        finally {
            this.getBizCtrl(ctx).releaseDataSource(queryId);
        }
        return data;
    }

    protected abstract GLRptBasePrintSetting getRptPrintSetting(Context var1);

    protected GLRptBasePrintSetting getPrintSetting(Context ctx, Map<String, Object> modelMap) throws EASBizException, BOSException {
        GLRptBasePrintSetting setting = this.getRptPrintSetting(ctx);
        try {
            setting.loadSetting(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return setting;
    }
}

